/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import java.util.HashMap;
import java.util.Map;

public enum WorkAreaSize {
    SMALL(16, "small"),
    MEDIUM(32, "medium"),
    LARGE(64, "large");

    private static final Map<Integer, WorkAreaSize> lookup;
    private static final String TRANSLATION_KEY_BASE = "enum.occultism.work_area_size";
    private final int value;
    private final String translationKey;

    private WorkAreaSize(int value, String translationKey) {
        this.value = value;
        this.translationKey = "enum.occultism.work_area_size." + translationKey;
    }

    public static WorkAreaSize get(int value) {
        return lookup.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDescriptionId() {
        return this.translationKey;
    }

    public WorkAreaSize next() {
        return WorkAreaSize.values()[(this.ordinal() + 1) % WorkAreaSize.values().length];
    }

    public boolean equals(int value) {
        return this.value == value;
    }

    static {
        lookup = new HashMap<Integer, WorkAreaSize>();
        for (WorkAreaSize workAreaSize : WorkAreaSize.values()) {
            lookup.put(workAreaSize.getValue(), workAreaSize);
        }
    }
}

