/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import java.util.HashMap;
import java.util.Map;

public enum OtherworldBlockTier {
    NONE(0),
    ONE(1),
    TWO(2);

    private static final Map<Integer, OtherworldBlockTier> lookup;
    private final int level;

    private OtherworldBlockTier(int level) {
        this.level = level;
    }

    public static OtherworldBlockTier get(int level) {
        return lookup.get(level);
    }

    public static OtherworldBlockTier max(OtherworldBlockTier a, OtherworldBlockTier b) {
        if (a.getLevel() > b.getLevel()) {
            return a;
        }
        return b;
    }

    public int getLevel() {
        return this.level;
    }

    static {
        lookup = new HashMap<Integer, OtherworldBlockTier>();
        for (OtherworldBlockTier tier : OtherworldBlockTier.values()) {
            lookup.put(tier.getLevel(), tier);
        }
    }
}

