/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.regions_unexplored.block.RegionsUnexploredBlocks;

public class ForestFarmBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public ForestFarmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSustainPlant(BlockState state, BlockGetter getter, BlockPos pos, Direction direction, IPlantable plantable) {
        BlockState plant = plantable.getPlant(getter, pos.m_121945_(direction));
        PlantType type = plantable.getPlantType(getter, pos.m_121945_(direction));
        if (PlantType.CROP.equals(type)) {
            return true;
        }
        return PlantType.PLAINS.equals(type);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos1) {
        if (direction == Direction.UP && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, state1, level, pos, pos1);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos.m_7494_());
        return !blockstate.m_60767_().m_76333_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)RegionsUnexploredBlocks.FOREST_DIRT.get()).m_49966_() : super.m_5573_(context);
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            ForestFarmBlock.turnToDirt(state, (Level)level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)MOISTURE);
        if (!ForestFarmBlock.isNearWater((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!ForestFarmBlock.isUnderCrops((BlockGetter)level, pos)) {
                ForestFarmBlock.turnToDirt(state, (Level)level, pos);
            }
        } else if (i < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float v) {
        if (!level.f_46443_ && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)((Block)RegionsUnexploredBlocks.FOREST_DIRT.get()).m_49966_(), (float)v, (Entity)entity)) {
            ForestFarmBlock.turnToDirt(state, level, pos);
        }
        super.m_142072_(level, state, pos, entity, v);
    }

    public static void turnToDirt(BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, ForestFarmBlock.m_49897_((BlockState)state, (BlockState)((Block)RegionsUnexploredBlocks.FOREST_DIRT.get()).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
    }

    private static boolean isUnderCrops(BlockGetter getter, BlockPos pos) {
        BlockState plant = getter.m_8055_(pos.m_7494_());
        BlockState state = getter.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(getter, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }
}

