/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.biome;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.regions_unexplored.config.RegionsUnexploredSecondaryRegionConfig;
import net.regions_unexplored.util.worldgen.CheckBiomeConfig;
import net.regions_unexplored.util.worldgen.VanillaFallbackBiome;

public class RegionSecondaryBiomeBuilder {
    private final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.45f), Climate.Parameter.m_186822_((float)-0.45f, (float)-0.15f), Climate.Parameter.m_186822_((float)-0.15f, (float)0.2f), Climate.Parameter.m_186822_((float)0.2f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.35f), Climate.Parameter.m_186822_((float)-0.35f, (float)-0.1f), Climate.Parameter.m_186822_((float)-0.1f, (float)0.1f), Climate.Parameter.m_186822_((float)0.1f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.78f), Climate.Parameter.m_186822_((float)-0.78f, (float)-0.375f), Climate.Parameter.m_186822_((float)-0.375f, (float)-0.2225f), Climate.Parameter.m_186822_((float)-0.2225f, (float)0.05f), Climate.Parameter.m_186822_((float)0.05f, (float)0.45f), Climate.Parameter.m_186822_((float)0.45f, (float)0.55f), Climate.Parameter.m_186822_((float)0.55f, (float)1.0f)};
    private final Climate.Parameter FULL_RANGE = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    private final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    private final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.m_186822_((float)-1.2f, (float)-1.05f);
    private final Climate.Parameter deepOceanContinentalness = Climate.Parameter.m_186822_((float)-1.05f, (float)-0.455f);
    private final Climate.Parameter oceanContinentalness = Climate.Parameter.m_186822_((float)-0.455f, (float)-0.19f);
    private final Climate.Parameter coastContinentalness = Climate.Parameter.m_186822_((float)-0.19f, (float)-0.11f);
    private final Climate.Parameter inlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.55f);
    private final Climate.Parameter nearInlandContinentalness = Climate.Parameter.m_186822_((float)-0.11f, (float)0.03f);
    private final Climate.Parameter midInlandContinentalness = Climate.Parameter.m_186822_((float)0.03f, (float)0.3f);
    private final Climate.Parameter farInlandContinentalness = Climate.Parameter.m_186822_((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.MID_VAR_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.PLT_VAR_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] SHATTERED_BIOMES = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHT_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] RIVER_BIOMES = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] RIVER_BIOMES_VARIANT = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.RVR_VAR_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] SWAMP_BIOMES = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_ICY_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_ICY_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_ICY_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_ICY_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_ICY_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_COOL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_COOL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_COOL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_COOL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_COOL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_NEUTRAL_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_NEUTRAL_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_NEUTRAL_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_NEUTRAL_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_NEUTRAL_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_WARM_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_WARM_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_WARM_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_WARM_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_WARM_HUMID.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_HOT_ARID.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_HOT_DRY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_HOT_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_HOT_WET.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SMP_HOT_HUMID.get())}};
    private final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_DEP_ICY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_DEP_COOL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_DEP_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_DEP_WARM.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_DEP_HOT.get())}, {RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_ICY.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_COOL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_NEUTRAL.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_WARM.get()), RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.OCA_HOT.get())}};

    protected void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addOffCoastBiomes(builder);
        this.addInlandBiomes(builder);
        this.addUndergroundBiomes(builder);
    }

    private void addOffCoastBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addSurfaceBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ISLAND_BIOME.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ISLAND_BIOME.get()) : Biomes.f_48215_);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter climate$parameter = this.temperatures[i];
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, CheckBiomeConfig.isBiomeEnabled(this.OCEANS[0][i]) ? this.OCEANS[0][i] : VanillaFallbackBiome.VANILLA_OCEANS[0][i]);
            this.addSurfaceBiome(builder, climate$parameter, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, CheckBiomeConfig.isBiomeEnabled(this.OCEANS[1][i]) ? this.OCEANS[1][i] : VanillaFallbackBiome.VANILLA_OCEANS[0][i]);
        }
    }

    private void addInlandBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(builder, Climate.Parameter.m_186822_((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(builder, Climate.Parameter.m_186822_((float)-0.26666668f, (float)-0.05f));
        this.addValleys(builder, Climate.Parameter.m_186822_((float)-0.05f, (float)0.05f));
        this.addLowSlice(builder, Climate.Parameter.m_186822_((float)0.05f, (float)0.26666668f));
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)0.26666668f, (float)0.4f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)0.4f, (float)0.56666666f));
        this.addPeaks(builder, Climate.Parameter.m_186822_((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(builder, Climate.Parameter.m_186822_((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(builder, Climate.Parameter.m_186822_((float)0.93333334f, (float)1.0f));
    }

    private void addPeaks(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, shatteredBiome);
                ResourceKey<Biome> peakBiomes = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomes);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addHighSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                ResourceKey<Biome> peakBiome = this.pickPeakBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addMidSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey<Biome> stoneBeachCold = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COLD_STONE_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COLD_STONE_BEACH.get()) : Biomes.f_186760_;
        ResourceKey<Biome> stoneBeachHot = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_STONE_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_STONE_BEACH.get()) : Biomes.f_186760_;
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[0], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachCold);
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachHot);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> plateauBiome = this.pickPlateauBiome(i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.pickShatteredBiome(i, j, weirdness);
                ResourceKey<Biome> swampBiome = this.pickSwampBiome(i, j);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(i);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                ResourceKey<Biome> slopeBiome = this.pickSlopeBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiome : plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiome);
                if (weirdness.f_186814_() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiome);
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                } else {
                    this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                if (weirdness.f_186814_() < 0L) {
                    this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                    continue;
                }
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiome);
            }
        }
    }

    private void addLowSlice(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey<Biome> stoneBeachCold = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COLD_STONE_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COLD_STONE_BEACH.get()) : Biomes.f_186760_;
        ResourceKey<Biome> stoneBeachHot = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_STONE_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_STONE_BEACH.get()) : Biomes.f_186760_;
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[0], (Climate.Parameter)this.temperatures[2]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachCold);
        this.addSurfaceBiome(builder, Climate.Parameter.m_186829_((Climate.Parameter)this.temperatures[3], (Climate.Parameter)this.temperatures[4]), this.FULL_RANGE, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stoneBeachHot);
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> middleBiomeOrCold = this.pickMiddleBiomeOrSlopeIfCold(i, j, weirdness);
                ResourceKey<Biome> swampBiome = this.pickSwampBiome(i, j);
                ResourceKey<Biome> beachBiome = this.pickBeachBiome(i);
                ResourceKey<Biome> maybePickToweringCliffs = this.maybePickToweringCliffsBiome(i, j, weirdness, middleBiome);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(i, j, weirdness);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeOrCold);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, maybePickToweringCliffs);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
            }
        }
    }

    private void addValleys(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter weirdness) {
        ResourceKey<Biome> stoneBeachCold = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COLD_STONE_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COLD_STONE_BEACH.get()) : Biomes.f_186760_;
        ResourceKey<Biome> stoneBeachHot = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_STONE_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_STONE_BEACH.get()) : Biomes.f_186760_;
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiome = this.pickMiddleBiome(i, j, weirdness);
                ResourceKey<Biome> swampBiome = this.pickSwampBiome(i, j);
                ResourceKey<Biome> riverBiome = this.pickRiverBiome(i, j, weirdness);
                ResourceKey<Biome> cliffBiome = (float)this.temperatures[i].f_186814_() <= -0.45f ? stoneBeachCold : stoneBeachHot;
                ResourceKey<Biome> maybePickCliff = weirdness.f_186814_() < 0L ? cliffBiome : riverBiome;
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, maybePickCliff);
                this.addSurfaceBiome(builder, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, riverBiome);
                this.addSurfaceBiome(builder, temperature, humidity, Climate.Parameter.m_186829_((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiome);
                this.addSurfaceBiome(builder, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiome);
            }
        }
    }

    private void addUndergroundBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder) {
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.79f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_2.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_2.get()) : Biomes.f_151785_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.79f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_7.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_7.get()) : Biomes.f_151784_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.775f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_6.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_6.get()) : Biomes.f_151784_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.775f, (float)1.0f), this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_7.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_7.get()) : Biomes.f_151784_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.69f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_1.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_1.get()) : Biomes.f_151785_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.69f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_5.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_5.get()) : Biomes.f_151785_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.65f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_4.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_4.get()) : Biomes.f_151785_);
        this.addUndergroundBiome(builder, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.65f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_5.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_5.get()) : Biomes.f_151785_);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), this.FULL_RANGE, 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_3.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_3.get()) : Biomes.f_220594_);
        this.addBottomBiome(builder, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.m_186829_((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), this.FULL_RANGE, 0.0f, CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_8.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.CAVE_8.get()) : Biomes.f_220594_);
    }

    private ResourceKey<Biome> pickMiddleBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            if (CheckBiomeConfig.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (this.MIDDLE_BIOMES_VARIANT[temperature][humidity] == null) {
            if (CheckBiomeConfig.isBiomeEnabled(this.MIDDLE_BIOMES[temperature][humidity])) {
                return this.MIDDLE_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES[temperature][humidity];
        }
        if (CheckBiomeConfig.isBiomeEnabled(this.MIDDLE_BIOMES_VARIANT[temperature][humidity])) {
            return this.MIDDLE_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_MIDDLE_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickMiddleBiomeOrSlopeIfCold(int temperature, int humidity, Climate.Parameter weirdness) {
        return temperature == 0 ? this.pickSlopeBiome(temperature, humidity, weirdness) : this.pickMiddleBiome(temperature, humidity, weirdness);
    }

    private ResourceKey<Biome> maybePickToweringCliffsBiome(int temperature, int humidity, Climate.Parameter weirdness, ResourceKey<Biome> fallbackBiome) {
        ResourceKey<Biome> resourceKey = CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHA_CLI.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.SHA_CLI.get()) : Biomes.f_186768_;
        return temperature > 1 && humidity < 4 && weirdness.f_186814_() >= 0L ? resourceKey : fallbackBiome;
    }

    private ResourceKey<Biome> pickShatteredCoastBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourceKey = weirdness.f_186814_() >= 0L ? this.pickMiddleBiome(temperature, humidity, weirdness) : this.pickBeachBiome(temperature);
        return this.maybePickToweringCliffsBiome(temperature, humidity, weirdness, resourceKey);
    }

    private ResourceKey<Biome> pickBeachBiome(int temperature) {
        if (temperature == 0) {
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_BEACH.get()) : Biomes.f_48148_;
        }
        if (temperature == 1) {
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_BEACH.get()) : Biomes.f_48217_;
        }
        if (temperature == 2) {
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_BEACH.get()) : Biomes.f_48217_;
        }
        if (temperature == 3) {
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_BEACH.get()) : Biomes.f_48217_;
        }
        return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_BEACH.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_BEACH.get()) : Biomes.f_48217_;
    }

    private ResourceKey<Biome> pickPlateauBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            if (CheckBiomeConfig.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (this.PLATEAU_BIOMES_VARIANT[temperature][humidity] == null) {
            if (CheckBiomeConfig.isBiomeEnabled(this.PLATEAU_BIOMES[temperature][humidity])) {
                return this.PLATEAU_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES[temperature][humidity];
        }
        if (CheckBiomeConfig.isBiomeEnabled(this.PLATEAU_BIOMES_VARIANT[temperature][humidity])) {
            return this.PLATEAU_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_PLATEAU_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickPeakBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_PEAK.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_PEAK.get()) : Biomes.f_186758_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_PEAK_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_PEAK_VAR.get()) : Biomes.f_186757_;
        }
        if (temperature == 1) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_PEAK.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_PEAK.get()) : Biomes.f_186758_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_PEAK_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_PEAK_VAR.get()) : Biomes.f_186757_;
        }
        if (temperature == 2) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_PEAK.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_PEAK.get()) : Biomes.f_186758_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_PEAK_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_PEAK_VAR.get()) : Biomes.f_186757_;
        }
        if (temperature == 3) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_PEAK.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_PEAK.get()) : Biomes.f_186759_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_PEAK_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_PEAK_VAR.get()) : Biomes.f_186759_;
        }
        if (weirdness.f_186814_() < 0L) {
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_PEAK.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_PEAK.get()) : Biomes.f_48159_;
        }
        return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_PEAK_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_PEAK_VAR.get()) : Biomes.f_186753_;
    }

    private ResourceKey<Biome> pickSlopeBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (temperature == 0) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_SLOPE.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_SLOPE.get()) : Biomes.f_186756_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_SLOPE_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.ICY_SLOPE_VAR.get()) : Biomes.f_186755_;
        }
        if (temperature == 1) {
            if (humidity < 2) {
                return this.pickPlateauBiome(temperature, humidity, weirdness);
            }
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_SLOPE.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_SLOPE.get()) : Biomes.f_186755_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_SLOPE_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.COOL_SLOPE_VAR.get()) : Biomes.f_186756_;
        }
        if (temperature == 2) {
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_SLOPE.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_SLOPE.get()) : Biomes.f_186755_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_SLOPE_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.NEUTRAL_SLOPE_VAR.get()) : Biomes.f_186756_;
        }
        if (temperature == 3) {
            if (humidity > 2) {
                return this.pickMiddleBiome(temperature, humidity, weirdness);
            }
            if (weirdness.f_186814_() < 0L) {
                return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_SLOPE.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_SLOPE.get()) : Biomes.f_186759_;
            }
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_SLOPE_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.WARM_SLOPE_VAR.get()) : Biomes.f_186759_;
        }
        if (humidity < 2) {
            return this.pickPlateauBiome(temperature, humidity, weirdness);
        }
        if (weirdness.f_186814_() < 0L) {
            return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_SLOPE.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_SLOPE.get()) : Biomes.f_48157_;
        }
        return CheckBiomeConfig.isBiomeEnabled(RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_SLOPE_VAR.get())) ? RegionSecondaryBiomeBuilder.getBiome((String)RegionsUnexploredSecondaryRegionConfig.HOT_SLOPE_VAR.get()) : Biomes.f_48157_;
    }

    private ResourceKey<Biome> pickShatteredBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourceKey = CheckBiomeConfig.isBiomeEnabled(this.SHATTERED_BIOMES[temperature][humidity]) ? this.SHATTERED_BIOMES[temperature][humidity] : VanillaFallbackBiome.VANILLA_SHATTERED_BIOMES[temperature][humidity];
        return resourceKey == null ? this.pickMiddleBiome(temperature, humidity, weirdness) : resourceKey;
    }

    private ResourceKey<Biome> pickRiverBiome(int temperature, int humidity, Climate.Parameter weirdness) {
        if (weirdness.f_186814_() < 0L) {
            if (CheckBiomeConfig.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (this.RIVER_BIOMES_VARIANT[temperature][humidity] == null) {
            if (CheckBiomeConfig.isBiomeEnabled(this.RIVER_BIOMES[temperature][humidity])) {
                return this.RIVER_BIOMES[temperature][humidity];
            }
            return VanillaFallbackBiome.VANILLA_RIVER_BIOMES[temperature][humidity];
        }
        if (CheckBiomeConfig.isBiomeEnabled(this.RIVER_BIOMES_VARIANT[temperature][humidity])) {
            return this.RIVER_BIOMES_VARIANT[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_RIVER_BIOMES_VARIANT[temperature][humidity];
    }

    private ResourceKey<Biome> pickSwampBiome(int temperature, int humidity) {
        if (CheckBiomeConfig.isBiomeEnabled(this.SWAMP_BIOMES[temperature][humidity])) {
            return this.SWAMP_BIOMES[temperature][humidity];
        }
        return VanillaFallbackBiome.VANILLA_SWAMP_BIOMES[temperature][humidity];
    }

    private void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addUndergroundBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186822_((float)0.2f, (float)0.9f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    private void addBottomBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> builder, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        builder.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.m_186820_((float)1.1f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    public static ResourceKey<Biome> getBiome(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(id));
    }
}

