/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RegionsUnexploredBlocks;

public class HangingEarlightFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public HangingEarlightFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        if (!level.m_46859_(pos)) {
            return false;
        }
        BlockState blockstate = level.m_8055_(pos.m_7494_());
        if (!blockstate.m_60713_(Blocks.f_50730_) && !blockstate.m_60713_((Block)RegionsUnexploredBlocks.COBALT_OBSIDIAN.get())) {
            return false;
        }
        this.placeRoofCobaltObsidian((LevelAccessor)level, random, pos);
        this.placeRoofHangingEarlight((LevelAccessor)level, random, pos);
        return true;
    }

    private void placeRoofCobaltObsidian(LevelAccessor level, RandomSource random, BlockPos pos) {
        level.m_7731_(pos, ((Block)RegionsUnexploredBlocks.COBALT_OBSIDIAN.get()).m_49966_(), 2);
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            pos1.m_122154_((Vec3i)pos, random.m_188503_(6) - random.m_188503_(6), random.m_188503_(2) - random.m_188503_(5), random.m_188503_(6) - random.m_188503_(6));
            if (!level.m_46859_((BlockPos)pos1)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = level.m_8055_((BlockPos)pos2.m_122159_((Vec3i)pos1, direction));
                if (blockstate.m_60713_(Blocks.f_50134_) || blockstate.m_60713_((Block)RegionsUnexploredBlocks.COBALT_OBSIDIAN.get())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            level.m_7731_((BlockPos)pos1, ((Block)RegionsUnexploredBlocks.COBALT_OBSIDIAN.get()).m_49966_(), 2);
        }
    }

    private void placeRoofHangingEarlight(LevelAccessor level, RandomSource random, BlockPos pos) {
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            pos1.m_122154_((Vec3i)pos, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(2) - random.m_188503_(7), random.m_188503_(8) - random.m_188503_(8));
            if (!level.m_46859_((BlockPos)pos1) || !(blockstate = level.m_8055_(pos1.m_7494_())).m_60713_(Blocks.f_50134_) && !blockstate.m_60713_((Block)RegionsUnexploredBlocks.COBALT_OBSIDIAN.get())) continue;
            int j = Mth.m_216271_((RandomSource)random, (int)1, (int)19);
            if (random.m_188503_(6) == 0) {
                j *= 2;
            }
            if (random.m_188503_(5) == 0) {
                j = 1;
            }
            HangingEarlightFeature.placeHangingEarlightColumn(level, random, pos1, j, 10, 19);
        }
    }

    public static void placeHangingEarlightColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length, int low, int high) {
        for (int i = 0; i <= length; ++i) {
            if (level.m_46859_((BlockPos)pos)) {
                if (i == length || !level.m_46859_(pos.m_7495_())) {
                    level.m_7731_((BlockPos)pos, (BlockState)((Block)RegionsUnexploredBlocks.HANGING_EARLIGHT.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)random, (int)low, (int)high))), 2);
                    break;
                }
                level.m_7731_((BlockPos)pos, ((Block)RegionsUnexploredBlocks.HANGING_EARLIGHT_PLANT.get()).m_49966_(), 2);
            }
            pos.m_122173_(Direction.DOWN);
        }
    }
}

