/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.AbstractTradingBlock;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BarteringBlockEntity
extends AbstractTradingBlockEntity {
    ItemStack currency = ItemStack.f_41583_;
    int currencyStored = 0;

    public BarteringBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ShoppyMod.BARTING_STATION_ENTITY, blockPos, blockState);
    }

    public BarteringBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.currency = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("currency"));
        this.currencyStored = compoundTag.m_128451_("storedCurrency");
    }

    @Override
    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128365_("currency", (Tag)this.currency.m_41739_(new CompoundTag()));
        compoundTag.m_128405_("storedCurrency", this.currencyStored);
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.currency = ItemStack.f_41583_;
        this.currencyStored = 0;
        this.markUpdated();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("currency", (Tag)this.currency.m_41739_(new CompoundTag()));
        tag.m_128365_("selling", (Tag)this.selling.m_41739_(new CompoundTag()));
        tag.m_128362_("owner", this.owner);
        return tag;
    }

    public void addCurrencyItem(ItemStack item) {
        this.currency = item;
        this.markUpdated();
    }

    @Override
    public void clearShop(BlockHitResult result) {
        super.clearShop(result);
        this.currency = ItemStack.f_41583_;
        this.currencyStored = 0;
        this.markUpdated();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean attemptPurchase(Player player, ItemStack currencyInHand, boolean creativeBlock) {
        block9: {
            int price;
            block10: {
                int amountToGive;
                ServerPlayer owner;
                block11: {
                    owner = this.f_58857_.m_7654_().m_6846_().m_11259_(this.owner);
                    if (!ItemStack.m_150942_((ItemStack)currencyInHand, (ItemStack)this.currency)) {
                        MutableComponent component = Component.m_237115_((String)"barter.purchase.no_held_item");
                        component.m_6270_(ShoppyMod.ERROR_STYLE);
                        player.m_213846_((Component)component);
                        this.markUpdated();
                        return false;
                    }
                    price = this.currency.m_41613_();
                    if (currencyInHand.m_41613_() < price) break block10;
                    amountToGive = this.selling.m_41613_();
                    if (amountToGive <= this.storedSellingItems) break block11;
                    MutableComponent buyerMsg = Component.m_237115_((String)"barter.purchase.shop_empty").m_6270_(ShoppyMod.ERROR_STYLE);
                    player.m_213846_((Component)buyerMsg);
                    if (owner != null) {
                        MutableComponent location = Component.m_237110_((String)"X: %s, Y: %s, Z: %s", (Object[])new Object[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()}).m_6270_(ShoppyMod.VARIABLE_STYLE);
                        MutableComponent ownerMsg = Component.m_237110_((String)"barter.purchase.owner.shop_empty", (Object[])new Object[]{location}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                        owner.m_213846_((Component)ownerMsg);
                    }
                    break block9;
                }
                if (this.remainingCurrencySpaces() <= 0 && !creativeBlock) {
                    MutableComponent buyerMsg = Component.m_237110_((String)"barter.purchase.currency_full", (Object[])new Object[]{this.currency.m_41611_()}).m_6270_(ShoppyMod.ERROR_STYLE);
                    player.m_213846_((Component)buyerMsg);
                    if (owner != null && !creativeBlock) {
                        MutableComponent location = Component.m_237110_((String)"X: %s, Y: %s, Z: %s", (Object[])new Object[]{this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_()}).m_6270_(ShoppyMod.VARIABLE_STYLE);
                        MutableComponent ownerMsg = Component.m_237110_((String)"barter.purchase.owner.currency_full", (Object[])new Object[]{location}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                        owner.m_213846_((Component)ownerMsg);
                    }
                    break block9;
                } else if (player.m_150109_().m_36062_() == -1) {
                    MutableComponent component = Component.m_237115_((String)"common.purchase.full_inventory").m_6270_(ShoppyMod.ERROR_STYLE);
                    player.m_213846_((Component)component);
                    break block9;
                } else {
                    currencyInHand.m_41774_(price);
                    player.m_36356_(this.selling.m_41777_());
                    MutableComponent buyer = Component.m_237110_((String)"barter.purchase.transaction_success", (Object[])new Object[]{this.selling.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
                    player.m_213846_((Component)buyer);
                    if (!creativeBlock) {
                        this.storedSellingItems -= amountToGive;
                        this.currencyStored += price;
                    }
                    if (owner != null) {
                        MutableComponent sellerMsg = Component.m_237110_((String)"barter.purchase.owner.transaction_success", (Object[])new Object[]{player.m_5446_(), this.selling.m_41611_()}).m_6270_(ShoppyMod.APPROVAL_STYLE);
                        owner.m_213846_((Component)sellerMsg);
                    }
                    this.markUpdated();
                    return true;
                }
            }
            MutableComponent required = Component.m_237113_((String)("x" + price)).m_6270_(ShoppyMod.VARIABLE_STYLE);
            MutableComponent had = Component.m_237113_((String)("x" + currencyInHand.m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
            MutableComponent component = Component.m_237110_((String)"barter.purchase.not_enough_items", (Object[])new Object[]{required, had});
            component.m_6270_(ShoppyMod.ERROR_STYLE);
            player.m_213846_((Component)component);
        }
        this.markUpdated();
        return false;
    }

    @Override
    public NonNullList<ItemStack> dropItems() {
        NonNullList list = NonNullList.m_122779_();
        list.addAll(super.dropItems());
        int currency = this.currencyStored;
        int maxStackSize = this.currency.m_41741_();
        while (currency != 0) {
            ItemStack copy = this.currency.m_41777_();
            if (currency >= maxStackSize) {
                copy.m_41764_(maxStackSize);
                list.add((Object)copy);
                currency -= maxStackSize;
                continue;
            }
            copy.m_41764_(currency);
            list.add((Object)copy);
            currency -= currency;
        }
        return list;
    }

    public int remainingCurrencySpaces() {
        return this.maxStorage - this.currencyStored;
    }

    @Override
    public int remainingItemStorage() {
        return this.maxStorage - this.storedSellingItems;
    }

    public ItemStack getCurrency() {
        return this.currency;
    }

    @Override
    public void sendInformationToOwner(Player player) {
        MutableComponent component = Component.m_237115_((String)"barter.information.owner.extraction").m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)component);
        MutableComponent profits = Component.m_237113_((String)("" + this.currencyStored)).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent translatedProfits = Component.m_237110_((String)"barter.information.owner.profits", (Object[])new Object[]{profits}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        MutableComponent storedItems = Component.m_237113_((String)("" + this.storedSellingItems)).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent toBeSold = Component.m_237110_((String)"barter.information.owner.barter", (Object[])new Object[]{storedItems}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)translatedProfits);
        player.m_213846_((Component)toBeSold);
    }

    @Override
    public InteractionResult interactWithTradingBlock(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        Vec3 hit = blockHitResult.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)blockPos));
        ItemStack item = player.m_21205_();
        if (player.m_6047_() && hit.m_7098_() > 0.5) {
            this.clearShop(blockHitResult);
            return InteractionResult.SUCCESS;
        }
        boolean sameItem = this.getCurrency().m_41656_(item);
        if (hit.m_7098_() <= 0.5 && (this.getCurrency().m_41619_() || sameItem)) {
            if (item.m_41613_() == 1 && sameItem) {
                if (this.currency.m_41613_() < this.currency.m_41741_()) {
                    this.currency.m_41764_(this.currency.m_41613_() + 1);
                }
                this.markUpdated();
                return InteractionResult.SUCCESS;
            }
            this.addCurrencyItem(item.m_41777_());
            MutableComponent setup = Component.m_237110_((String)"barter.setup.owner.add_currency", (Object[])new Object[]{item.m_41611_()}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
            player.m_213846_((Component)setup);
            return InteractionResult.SUCCESS;
        }
        if (hit.m_7098_() > 0.5) {
            if (this.getSelling().m_41619_()) {
                this.addSellingItem(item.m_41777_());
                MutableComponent setup = Component.m_237110_((String)"barter.setup.owner.add_selling", (Object[])new Object[]{item.m_41611_()}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
                player.m_213846_((Component)setup);
            } else if (ItemStack.m_150942_((ItemStack)item, (ItemStack)this.getSelling())) {
                this.putItemIntoShop(item);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void userLeftClickTradingBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        MutableComponent amountBeingSold = Component.m_237113_((String)("x" + this.getSelling().m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent itemBeingSold = this.getSelling().m_41611_().m_6881_().m_130938_(style -> {
            style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this.getSelling())));
            return style;
        });
        MutableComponent currencyAmount = Component.m_237113_((String)("x" + this.getCurrency().m_41613_())).m_6270_(ShoppyMod.VARIABLE_STYLE);
        MutableComponent itemBeingTraded = this.getCurrency().m_41611_().m_6881_().m_130938_(style -> {
            style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(this.getCurrency())));
            return style;
        });
        MutableComponent component = Component.m_237110_((String)"barter.information.user.selling_info", (Object[])new Object[]{amountBeingSold, itemBeingSold, currencyAmount, itemBeingTraded}).m_6270_(ShoppyMod.CONSTANTS_STYLE);
        player.m_213846_((Component)component);
    }

    @Override
    public void extractItemsFromShop(Level level, BlockPos pos) {
        if (this.remainingCurrencySpaces() != this.maxStorage) {
            int itemsToTake = Math.min(64, this.currencyStored);
            ItemStack currency = this.getCurrency().m_41777_();
            currency.m_41764_(itemsToTake);
            AbstractTradingBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)currency);
            this.currencyStored -= itemsToTake;
        } else {
            super.extractItemsFromShop(level, pos);
        }
    }
}

