/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy;

import com.epherical.octoecon.api.event.EconomyChangeEvent;
import com.epherical.shoppy.ForgeClient;
import com.epherical.shoppy.ShoppyMod;
import com.epherical.shoppy.block.BarteringBlock;
import com.epherical.shoppy.block.CreativeBarteringBlock;
import com.epherical.shoppy.block.CreativeShopBlock;
import com.epherical.shoppy.block.ShopBlock;
import com.epherical.shoppy.block.entity.AbstractTradingBlockEntity;
import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.block.entity.CreativeBarteringBlockEntity;
import com.epherical.shoppy.block.entity.CreativeShopBlockEntity;
import com.epherical.shoppy.block.entity.ShopBlockEntity;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;

@Mod(value="shoppy")
public class ForgeShoppy
extends ShoppyMod {
    public static final PermissionNode<Boolean> ADMIN_BREAK = new PermissionNode("shoppy", "admin.break_shop", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> player != null && player.m_20310_(4), new PermissionDynamicContextKey[0]);
    public static CreativeModeTab ITEM_GROUP;

    public ForgeShoppy() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ForgeClient::clientSetup);
        bus.addListener(ForgeClient::registerRenderers);
        ITEM_GROUP = new CreativeModeTab("shoppy"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ShoppyMod.BARTING_STATION_ITEM);
            }
        };
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void economyChange(EconomyChangeEvent event) {
        economyInstance = event.getEconomy();
        ADMIN = economyInstance.getOrCreatePlayerAccount(Util.f_137441_);
        if (ADMIN != null) {
            ADMIN.depositMoney(economyInstance.getDefaultCurrency(), 2.40204204E8, "admin account");
        }
    }

    @SubscribeEvent
    public void onChat(ServerChatEvent.Submitted event) {
        ServerPlayer player = event.getPlayer();
        String msg = event.getMessage().getString();
        if (awaitingResponse.containsKey(player.m_20148_())) {
            ShopBlockEntity shopBlock = (ShopBlockEntity)((Object)awaitingResponse.get(player.m_20148_()));
            try {
                int number = Integer.parseInt(msg);
                if (number >= 0) {
                    shopBlock.setPrice(number);
                    Component compText = economyInstance.getDefaultCurrency().format((double)number);
                    MutableComponent success = Component.m_237110_((String)"shop.pricing.owner.update_complete", (Object[])new Object[]{compText}).m_6270_(APPROVAL_STYLE);
                    player.m_213846_((Component)success);
                    awaitingResponse.remove(player.m_20148_());
                    event.setCanceled(true);
                }
            }
            catch (NumberFormatException ignored) {
                awaitingResponse.remove(player.m_20148_());
                MutableComponent message = Component.m_237110_((String)"shop.pricing.owner.update_fail", (Object[])new Object[]{msg}).m_6270_(ERROR_STYLE);
                MutableComponent error = Component.m_237113_((String)"");
                for (char c : msg.toCharArray()) {
                    if (Character.isDigit(c)) {
                        error.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(APPROVAL_STYLE));
                        continue;
                    }
                    error.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(ERROR_STYLE));
                }
                MutableComponent otherMessage = Component.m_237110_((String)"Errors Indicated in red: %s", (Object[])new Object[]{error}).m_6270_(CONSTANTS_STYLE);
                player.m_213846_((Component)message);
                player.m_213846_((Component)otherMessage);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shoppy").requires(commandSourceStack -> commandSourceStack.m_6761_(4))).then(Commands.m_82127_((String)"admin_shop").then(Commands.m_82129_((String)"block", (ArgumentType)BlockPosArgument.m_118239_()).executes(this::createAdminShop)))).then(Commands.m_82127_((String)"npc_shop").then(Commands.m_82129_((String)"block", (ArgumentType)BlockPosArgument.m_118239_()).executes(this::createNPCShop))));
    }

    @SubscribeEvent
    public void registerPermissions(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{ADMIN_BREAK});
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            AbstractTradingBlockEntity trading;
            Player player = event.getEntity();
            BlockPos pos = event.getPos();
            ServerLevel level = (ServerLevel)event.getEntity().m_9236_();
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof AbstractTradingBlockEntity && !(trading = (AbstractTradingBlockEntity)entity).getOwner().equals(player.m_20148_()) && (!player.m_20310_(4) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), ADMIN_BREAK, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue())) {
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEvent(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                ShoppyMod.BARTING_STATION_ITEM = new BlockItem((Block)ShoppyMod.BARTERING_STATION, new Item.Properties().m_41491_(ITEM_GROUP));
                ShoppyMod.SHOP_BLOCK_ITEM = new BlockItem((Block)ShoppyMod.SHOP_BLOCK, new Item.Properties().m_41491_(ITEM_GROUP));
                ShoppyMod.CREATIVE_BARTERING_STATION_ITEM = new BlockItem((Block)ShoppyMod.CREATIVE_BARTERING_STATION, new Item.Properties().m_41491_(ITEM_GROUP));
                ShoppyMod.CREATIVE_SHOP_BLOCK_ITEM = new BlockItem((Block)ShoppyMod.CREATIVE_SHOP_BLOCK, new Item.Properties().m_41491_(ITEM_GROUP));
                event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("shoppy", "bartering_station"), () -> ShoppyMod.BARTING_STATION_ITEM);
                event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("shoppy", "shop_block"), () -> ShoppyMod.SHOP_BLOCK_ITEM);
                event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("shoppy", "creative_bartering_station"), () -> ShoppyMod.CREATIVE_BARTERING_STATION_ITEM);
                event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("shoppy", "creative_shop_block"), () -> ShoppyMod.CREATIVE_SHOP_BLOCK_ITEM);
            } else if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                ShoppyMod.BARTERING_STATION = new BarteringBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.5f, 1200.0f).m_60918_(SoundType.f_56736_).m_60955_());
                ShoppyMod.SHOP_BLOCK = new ShopBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.5f, 1200.0f).m_60918_(SoundType.f_56736_).m_60955_(), false);
                ShoppyMod.CREATIVE_BARTERING_STATION = new CreativeBarteringBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.5f, 1200.0f).m_60918_(SoundType.f_56736_).m_60955_());
                ShoppyMod.CREATIVE_SHOP_BLOCK = new CreativeShopBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.5f, 1200.0f).m_60918_(SoundType.f_56736_).m_60955_(), true);
                event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation("shoppy", "bartering_station"), () -> ShoppyMod.BARTERING_STATION);
                event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation("shoppy", "shop_block"), () -> ShoppyMod.SHOP_BLOCK);
                event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation("shoppy", "creative_bartering_station"), () -> ShoppyMod.CREATIVE_BARTERING_STATION);
                event.register(ForgeRegistries.Keys.BLOCKS, new ResourceLocation("shoppy", "creative_shop_block"), () -> ShoppyMod.CREATIVE_SHOP_BLOCK);
            } else if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCK_ENTITY_TYPES)) {
                ShoppyMod.BARTING_STATION_ENTITY = BlockEntityType.Builder.m_155273_(BarteringBlockEntity::new, (Block[])new Block[]{ShoppyMod.BARTERING_STATION}).m_58966_(null);
                ShoppyMod.SHOP_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(ShopBlockEntity::new, (Block[])new Block[]{ShoppyMod.SHOP_BLOCK}).m_58966_(null);
                ShoppyMod.CREATIVE_BARTERING_STATION_ENTITY = BlockEntityType.Builder.m_155273_(CreativeBarteringBlockEntity::new, (Block[])new Block[]{ShoppyMod.CREATIVE_BARTERING_STATION}).m_58966_(null);
                ShoppyMod.CREATIVE_SHOP_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(CreativeShopBlockEntity::new, (Block[])new Block[]{ShoppyMod.CREATIVE_SHOP_BLOCK}).m_58966_(null);
                event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, new ResourceLocation("shoppy", "bartering_station_entity"), () -> ShoppyMod.BARTING_STATION_ENTITY);
                event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, new ResourceLocation("shoppy", "shop_block_entity"), () -> ShoppyMod.SHOP_BLOCK_ENTITY);
                event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, new ResourceLocation("shoppy", "creative_bartering_station_entity"), () -> ShoppyMod.CREATIVE_BARTERING_STATION_ENTITY);
                event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, new ResourceLocation("shoppy", "creative_shop_block_entity"), () -> ShoppyMod.CREATIVE_SHOP_BLOCK_ENTITY);
            }
        }
    }
}

