/*
 * Decompiled with CFR 0.152.
 */
package wolforce.simpleshops;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import wolforce.simpleshops.BlockEntityParent;
import wolforce.simpleshops.Registry;
import wolforce.simpleshops.SimpleShopBlock;
import wolforce.simpleshops.utils.Util;

public class SimpleShopTileEntity
extends BlockEntityParent {
    private static final int COST_SLOT = 1;
    private static final int RESULT_SLOT = 0;
    private static final int BAR_SLOT = 2;
    private UUID owner = new UUID(0L, 0L);
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private int invNr = 0;
    private int gainsNr = 0;
    private static final String NBT_INV = "inv";
    private static final String NBT_INV_NR = "inv_nr";
    private static final String NBT_GAINS_NR = "gains_nr";
    private static final String NBT_OWNER1 = "owner_part1";
    private static final String NBT_OWNER2 = "owner_part2";

    public SimpleShopTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registry.SIMPLE_SHOP_TILE.get(), pos, state);
    }

    public void setOwner(LivingEntity entity) {
        this.owner = entity.m_20148_();
        this.m_6596_();
    }

    public boolean isOwner(Block _block, LivingEntity entity) {
        if (!(_block instanceof SimpleShopBlock)) {
            return false;
        }
        SimpleShopBlock block = (SimpleShopBlock)_block;
        if (block.isCreative) {
            return entity instanceof Player && ((Player)entity).m_7500_();
        }
        return this.owner.equals(entity.m_20148_());
    }

    int getStockNr() {
        return this.getOutputStack().m_41613_() == 0 ? 0 : this.invNr / this.getOutputStack().m_41613_();
    }

    public ItemStack getCost() {
        return ((ItemStack)this.inventory.get(1)).m_41777_();
    }

    public void setCost(ItemStack stack) {
        this.inventory.set(1, (Object)stack.m_41777_());
        this.sendUpdate();
    }

    public void setBar(ItemStack stack) {
        this.inventory.set(2, (Object)stack.m_41777_());
        this.sendUpdate();
    }

    public ItemStack getBar() {
        return ((ItemStack)this.inventory.get(2)).m_41777_();
    }

    public ItemStack getOutputStack() {
        return ((ItemStack)this.inventory.get(0)).m_41777_();
    }

    public void setOutputStack(ItemStack stack) {
        this.inventory.set(0, (Object)stack.m_41777_());
        this.sendUpdate();
    }

    public void clearCostAndOutputStacks() {
        this.inventory.set(1, (Object)ItemStack.f_41583_);
        this.inventory.set(0, (Object)ItemStack.f_41583_);
        this.sendUpdate();
    }

    public ItemStack insertInv(Player player, ItemStack stackToInsert) {
        ItemStack output = this.getOutputStack();
        if (output.m_41619_()) {
            this.setOutputStack(stackToInsert);
            this.invNr += stackToInsert.m_41613_();
            return ItemStack.f_41583_;
        }
        int countToInsert = output.m_41613_();
        if (!stackToInsert.m_41656_(output) || !this.tagsEqualOrNull(stackToInsert, output) || stackToInsert.m_41613_() < countToInsert) {
            return stackToInsert;
        }
        this.invNr += countToInsert;
        this.sendUpdate();
        return Util.setCount(stackToInsert, stackToInsert.m_41613_() - countToInsert);
    }

    private boolean tagsEqualOrNull(ItemStack a1, ItemStack a2) {
        CompoundTag s1 = a1.m_41783_();
        CompoundTag s2 = a2.m_41783_();
        if (s1 == null && s2 != null || s2 == null && s1 != null) {
            return false;
        }
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1.equals((Object)s2);
    }

    public void tryBuy(Player player, ItemStack input, boolean isCreative) {
        ItemStack cost;
        if ((this.getStockNr() > 0 || isCreative) && input.m_41656_(cost = this.getCost()) && input.m_41613_() >= cost.m_41613_()) {
            ItemStack result = this.getOutputStack();
            ItemStack change = Util.setCount(input, input.m_41613_() - cost.m_41613_());
            if (!isCreative) {
                this.invNr -= result.m_41613_();
            }
            this.gainsNr += cost.m_41613_();
            this.spawn(player.f_19853_, player.m_20182_(), result);
            player.m_21008_(InteractionHand.MAIN_HAND, change);
            this.sendUpdate();
        }
    }

    public void dropShop(Player player, BlockPos pos) {
        this.dropAllInv(player);
        this.dropAllGains(player);
        if (!this.getCost().m_41619_()) {
            this.clearCostAndOutputStacks();
        } else {
            ItemStack bar = this.getBar();
            if (bar != null && !bar.m_41619_()) {
                this.spawn(this.f_58857_, player.m_20182_(), bar);
            }
            player.f_19853_.m_7471_(pos, true);
            this.spawn(this.f_58857_, player.m_20182_(), new ItemStack((ItemLike)Registry.SIMPLE_SHOP_ITEM.get()));
        }
    }

    public void popGains(Player player) {
        if (this.gainsNr <= 0) {
            return;
        }
        this.dropAllGains(player);
        this.sendUpdate();
    }

    private void dropAllInv(Player player) {
        ItemStack item = this.getOutputStack();
        while (this.invNr > 64) {
            this.invNr -= 64;
            this.spawn(player.f_19853_, player.m_20182_(), item, 64);
        }
        this.spawn(player.f_19853_, player.m_20182_(), item, this.invNr);
        this.invNr = 0;
    }

    private void dropAllGains(Player player) {
        ItemStack item = this.getCost();
        while (this.gainsNr > 64) {
            this.gainsNr -= 64;
            this.spawn(player.f_19853_, player.m_20182_(), item, 64);
        }
        this.spawn(player.f_19853_, player.m_20182_(), item, this.gainsNr);
        this.gainsNr = 0;
    }

    public void spawn(Level world, Vec3 pos, ItemStack stack, int amount) {
        this.spawn(world, pos, Util.setCount(stack, amount));
    }

    public void spawn(Level world, Vec3 pos, ItemStack stack) {
        world.m_7967_((Entity)new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack.m_41777_()));
    }

    @Override
    public void writePacketNBT(CompoundTag nbt) {
        CompoundTag invNbt = ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.inventory);
        nbt.m_128365_(NBT_INV, (Tag)invNbt);
        nbt.m_128405_(NBT_INV_NR, this.invNr);
        nbt.m_128405_(NBT_GAINS_NR, this.gainsNr);
        nbt.m_128356_(NBT_OWNER1, this.owner.getMostSignificantBits());
        nbt.m_128356_(NBT_OWNER2, this.owner.getLeastSignificantBits());
    }

    @Override
    public void readPacketNBT(CompoundTag nbt) {
        this.inventory = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_(NBT_INV), this.inventory);
        this.invNr = nbt.m_128451_(NBT_INV_NR);
        this.gainsNr = nbt.m_128451_(NBT_GAINS_NR);
        this.owner = new UUID(nbt.m_128454_(NBT_OWNER1), nbt.m_128454_(NBT_OWNER2));
    }

    private void sendUpdate() {
        this.m_6596_();
        BlockState defaultBlockState = ((Block)Registry.SIMPLE_SHOP.get()).m_49966_();
        this.f_58857_.m_7260_(this.f_58858_, defaultBlockState, defaultBlockState, 3);
    }
}

