/*
 * Decompiled with CFR 0.152.
 */
package wolforce.simpleshops;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wolforce.simpleshops.SimpleShopTileEntity;
import wolforce.simpleshops.SimplesShopsTutorial;
import wolforce.simpleshops.StockBarItem;
import wolforce.simpleshops.utils.Util;

public class SimpleShopBlock
extends Block
implements EntityBlock {
    private static final float F = 0.0625f;
    private static final VoxelShape shape = Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.6875, (double)0.9375);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public final boolean isCreative;
    private HashMap<String, Long> playersLastClick = new HashMap();

    public SimpleShopBlock(BlockBehaviour.Properties props, boolean isCreative) {
        super(props);
        this.isCreative = isCreative;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    protected void fillStateContainer(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_8125_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity _te = world.m_7702_(pos);
        if (!(_te instanceof SimpleShopTileEntity)) {
            return;
        }
        SimpleShopTileEntity te = (SimpleShopTileEntity)_te;
        te.setOwner(entity);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity _te = world.m_7702_(pos);
        if (!(_te instanceof SimpleShopTileEntity)) {
            return InteractionResult.PASS;
        }
        SimpleShopTileEntity te = (SimpleShopTileEntity)_te;
        if (te.isOwner(this, (LivingEntity)player)) {
            ItemStack handStack = player.m_21120_(hand);
            if (!handStack.m_41619_()) {
                if (!this.isCreative && handStack.m_41720_() instanceof StockBarItem) {
                    ItemStack prevBar = te.getBar();
                    if (prevBar != null && !prevBar.m_41619_()) {
                        te.spawn(player.f_19853_, player.m_20182_(), prevBar, 1);
                    }
                    ItemStack newbar = handStack.m_41777_();
                    newbar.m_41764_(1);
                    te.setBar(newbar);
                    handStack.m_41774_(1);
                    return InteractionResult.SUCCESS;
                }
                ItemStack cost = te.getCost();
                if (cost.m_41619_()) {
                    te.setCost(handStack);
                } else {
                    ItemStack out = te.getOutputStack();
                    if (this.isCreative) {
                        te.setOutputStack(handStack);
                    } else if (out.m_41619_() || out.m_41656_(handStack) && handStack.m_41613_() >= out.m_41613_()) {
                        player.m_21008_(hand, te.insertInv(player, handStack));
                    }
                }
            } else if (!this.isCreative) {
                ItemStack out;
                String id = player.m_20149_();
                if (this.playersLastClick.containsKey(id) && System.currentTimeMillis() - this.playersLastClick.get(id) < 1000L && Util.hasRequiredStack(player, out = te.getOutputStack().m_41777_())) {
                    Util.removeRequiredStack(player, out);
                    te.insertInv(player, out);
                }
                this.playersLastClick.put(id, System.currentTimeMillis());
            }
        } else {
            ItemStack out = te.getOutputStack();
            if (out != null && !out.m_41619_()) {
                te.tryBuy(player, player.m_21120_(hand), this.isCreative);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity _te = world.m_7702_(pos);
        if (!(_te instanceof SimpleShopTileEntity)) {
            return;
        }
        SimpleShopTileEntity te = (SimpleShopTileEntity)_te;
        if (te.isOwner(this, (LivingEntity)player)) {
            if (player.m_6144_()) {
                te.dropShop(player, pos);
            } else {
                te.popGains(player);
            }
        }
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return shape;
    }

    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> lines, TooltipFlag f) {
        super.m_5871_(stack, world, lines, f);
        for (SimplesShopsTutorial line : SimplesShopsTutorial.values()) {
            if (line.isCreative && (!line.isCreative || !this.isCreative)) continue;
            lines.add(line.createTextComponent());
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SimpleShopTileEntity(pos, state);
    }
}

