/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.utils;

import com.mojang.math.Vector3f;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.DummyDrawingTool;
import io.github.mortuusars.chalk.core.IDrawingTool;
import io.github.mortuusars.chalk.utils.PositionUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;

public class MarkDrawHelper {
    public static boolean draw(Player player, Level level, BlockPos markPos, BlockState markBlockState, int markColor, InteractionHand drawingHand) {
        IDrawingTool tool;
        ItemStack drawingItemstack = player.m_21120_(drawingHand);
        Item item = drawingItemstack.m_41720_();
        IDrawingTool drawingTool = item instanceof IDrawingTool ? (tool = (IDrawingTool)item) : new DummyDrawingTool();
        boolean isMarkDrawn = level.m_7731_(markPos, markBlockState, 11);
        if (isMarkDrawn) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    drawingTool.getMarkColor(drawingItemstack).ifPresent(color -> {
                        BlockPos surfacePos = markPos.m_121945_(((Direction)markBlockState.m_61143_((Property)ChalkMarkBlock.FACING)).m_122424_());
                        BlockState surfaceState = player.f_19853_.m_8055_(surfacePos);
                        MaterialColor surfaceMaterialColor = surfaceState.m_60780_((BlockGetter)player.f_19853_, surfacePos);
                        Chalk.CriteriaTriggers.CHALK_DRAW_COLORS.trigger(serverPlayer, surfaceMaterialColor, (DyeColor)color);
                    });
                    float R = (markColor & 0xFF0000) >> 16;
                    float G = (markColor & 0xFF00) >> 8;
                    float B = markColor & 0xFF;
                    Vector3f pos = PositionUtils.blockCenterOffsetToFace(markPos, (Direction)markBlockState.m_61143_((Property)ChalkMarkBlock.FACING), 0.25f);
                    serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(R / 255.0f, G / 255.0f, B / 255.0f), 2.0f), (double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_6263_(null, (double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_(), (SoundEvent)Chalk.SoundEvents.MARK_DRAW.get(), SoundSource.BLOCKS, 0.7f, new Random().nextFloat() * 0.2f + 0.8f);
                    if (((Boolean)markBlockState.m_61143_((Property)ChalkMarkBlock.GLOWING)).booleanValue()) {
                        serverLevel.m_5594_(null, markPos, (SoundEvent)Chalk.SoundEvents.GLOWING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_122239_(), (double)pos.m_122260_(), (double)pos.m_122269_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            drawingTool.onMarkDrawn(player, drawingHand, markPos, markBlockState);
            player.m_6674_(drawingHand);
        }
        return isMarkDrawn;
    }
}

