/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.menus;

import com.mojang.datafixers.util.Pair;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.items.ChalkBox;
import io.github.mortuusars.chalk.items.ChalkBoxItem;
import io.github.mortuusars.chalk.menus.ChalkBoxItemStackHandler;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChalkBoxMenu
extends AbstractContainerMenu {
    public final ItemStack chalkBoxStack;
    private final Player player;
    public Pair<Integer, Integer> chalkBoxCoords = Pair.of((Object)Integer.MIN_VALUE, (Object)Integer.MIN_VALUE);
    private final int chalkBoxSlotId;

    public ChalkBoxMenu(int pContainerId, Inventory playerInventory, final ItemStack chalkBoxStack, @Nullable IItemHandler itemHandler) {
        super((MenuType)Chalk.Menus.CHALK_BOX.get(), pContainerId);
        this.chalkBoxStack = chalkBoxStack;
        this.player = playerInventory.f_35978_;
        boolean glowingEnabled = (Boolean)Config.CHALK_BOX_GLOWING.get();
        int slotsYPos = glowingEnabled ? 18 : 33;
        this.chalkBoxSlotId = playerInventory.m_36030_(chalkBoxStack);
        int index = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 4; ++column) {
                if (index >= 8) {
                    throw new IllegalStateException("Chalk slot ids should go before Glowing Item slot id and not exceed it.");
                }
                this.m_38897_((Slot)new SlotItemHandler(itemHandler, index++, column * 18 + 53, row * 18 + slotsYPos));
            }
        }
        if (glowingEnabled) {
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 8, 80, 68){

                public void m_5852_(@NotNull ItemStack stack) {
                    Level level = ChalkBoxMenu.this.player.f_19853_;
                    if (level instanceof ClientLevel) {
                        ClientLevel clientLevel = (ClientLevel)level;
                        if (this.m_7993_().m_41619_() && ChalkBox.getGlowLevel(chalkBoxStack) <= 0 && stack.m_204117_(Chalk.Tags.Items.GLOWINGS)) {
                            Vec3 pos = ChalkBoxMenu.this.player.m_20182_();
                            clientLevel.m_6263_(ChalkBoxMenu.this.player, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)Chalk.SoundEvents.GLOW_APPLIED.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            clientLevel.m_6263_(ChalkBoxMenu.this.player, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)Chalk.SoundEvents.GLOWING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                    }
                    super.m_5852_(stack);
                }
            });
        }
        this.addPlayerSlots(playerInventory);
    }

    public void m_6877_(@NotNull Player pPlayer) {
        super.m_6877_(pPlayer);
        pPlayer.m_5496_((SoundEvent)Chalk.SoundEvents.CHALK_BOX_CLOSE.get(), 0.85f, 0.9f + pPlayer.f_19853_.f_46441_.m_188501_() * 0.2f);
        pPlayer.f_36095_.m_150444_();
    }

    public static ChalkBoxMenu fromBuffer(int containerID, Inventory playerInventory, FriendlyByteBuf dataBuffer) {
        ItemStack chalkBoxStack = dataBuffer.m_130267_().m_41777_();
        ChalkBoxItemStackHandler itemHandler = new ChalkBoxItemStackHandler(chalkBoxStack);
        return new ChalkBoxMenu(containerID, playerInventory, chalkBoxStack, (IItemHandler)itemHandler);
    }

    public int getGlowingUses() {
        return ChalkBox.getGlowLevel(this.chalkBoxStack);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotItemStack = slot.m_7993_();
            itemstack = slotItemStack.m_41777_();
            if (index < 9 ? !this.m_38903_(slotItemStack, 9, this.f_38839_.size(), true) : !this.m_38903_(slotItemStack, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.chalkBoxSlotId < 0 || player.m_150109_().m_8020_(this.chalkBoxSlotId).m_41720_() instanceof ChalkBoxItem;
    }

    private void addPlayerSlots(Inventory playerInventory) {
        int chalkBoxSlotId = playerInventory.m_36030_(this.chalkBoxStack);
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = column + row * 9 + 9;
                if (index == chalkBoxSlotId) {
                    this.chalkBoxCoords = Pair.of((Object)(column * 18 + 8), (Object)(98 + row * 18));
                    this.m_38897_(new Slot((Container)playerInventory, index, column * 18 + 8, 98 + row * 18){

                        public boolean m_5857_(@NotNull ItemStack pStack) {
                            return false;
                        }

                        public boolean m_8010_(@NotNull Player pPlayer) {
                            return false;
                        }

                        public boolean m_6659_() {
                            return false;
                        }
                    });
                    continue;
                }
                this.m_38897_(new Slot((Container)playerInventory, index, column * 18 + 8, 98 + row * 18));
            }
        }
        for (int index = 0; index < 9; ++index) {
            if (index == chalkBoxSlotId) {
                this.chalkBoxCoords = Pair.of((Object)(index * 18 + 8), (Object)156);
                this.m_38897_(new Slot((Container)playerInventory, index, index * 18 + 8, 156){

                    public boolean m_5857_(@NotNull ItemStack pStack) {
                        return false;
                    }

                    public boolean m_8010_(@NotNull Player pPlayer) {
                        return false;
                    }

                    public boolean m_6659_() {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, index, index * 18 + 8, 156));
        }
    }
}

