/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.feet;

import artifacts.common.config.ModConfig;
import artifacts.common.init.ModTags;
import artifacts.common.item.curio.HurtSoundModifyingItem;
import artifacts.common.util.DamageSourceHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class KittySlippersItem
extends HurtSoundModifyingItem {
    public KittySlippersItem() {
        super(SoundEvents.f_11791_);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        this.addListener(LivingSetAttackTargetEvent.class, this::onLivingSetAttackTarget, LivingSetAttackTargetEvent::getTarget);
        this.addListener(LivingEvent.LivingTickEvent.class, this::onLivingUpdate, (T event) -> event.getEntity().m_21188_());
        this.addListener(LivingAttackEvent.class, this::onLivingAttack, (T event) -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        Mob creeper;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (creeper = (Mob)livingEntity).m_6095_().m_204039_(ModTags.CREEPERS)) {
            this.damageEquippedStacks(wearer);
        }
    }

    private void onEntityJoinWorld(EntityJoinLevelEvent event) {
        PathfinderMob creeper;
        Entity entity2;
        if (!ModConfig.server.isCosmetic(this) && (entity2 = event.getEntity()) instanceof PathfinderMob && (creeper = (PathfinderMob)entity2).m_6095_().m_204039_(ModTags.CREEPERS)) {
            creeper.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal(creeper, Player.class, entity -> entity != null && this.isEquippedBy((LivingEntity)entity), 6.0f, 1.0, 1.3, EntitySelector.f_20406_::test));
        }
    }

    private void onLivingSetAttackTarget(LivingSetAttackTargetEvent event, LivingEntity wearer) {
        Mob creeper;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob && (creeper = (Mob)livingEntity).m_6095_().m_204039_(ModTags.CREEPERS)) {
            creeper.m_6710_(null);
        }
    }

    private void onLivingUpdate(LivingEvent.LivingTickEvent event, LivingEntity wearer) {
        if (event.getEntity().m_6095_().m_204039_(ModTags.CREEPERS)) {
            event.getEntity().m_6703_(null);
        }
    }

    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11785_, 1.0f, 1.0f);
    }
}

