/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.world.gen.feature.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import nonamecrackers2.witherstormmod.common.init.WitherStormModStructures;

public class StormSpawnPlatformStructure
extends Structure {
    public static final Codec<StormSpawnPlatformStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StormSpawnPlatformStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)BlockPos.f_121852_.fieldOf("position").forGetter(structure -> structure.spawnPos)).apply((Applicative)instance, StormSpawnPlatformStructure::new));
    private BlockPos spawnPos;

    public StormSpawnPlatformStructure(Structure.StructureSettings settings, BlockPos pos) {
        super(settings);
        this.spawnPos = pos;
    }

    private boolean isInChunk(ChunkPos pos) {
        return this.spawnPos.m_123341_() >= pos.m_45604_() && this.spawnPos.m_123341_() <= pos.m_45608_() && this.spawnPos.m_123343_() >= pos.m_45605_() && this.spawnPos.m_123343_() <= pos.m_45609_();
    }

    private static boolean isFeatureChunk(Structure.GenerationContext context, StormSpawnPlatformStructure structure) {
        return structure.isInChunk(context.f_226628_());
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (StormSpawnPlatformStructure.isFeatureChunk(context, this)) {
            Rotation rotation = Rotation.m_221990_((RandomSource)RandomSource.m_216327_());
            ChunkPos chunk = context.f_226628_();
            BlockPos prePos = new BlockPos(chunk.m_45604_(), 0, chunk.m_45605_());
            BlockPos pos = prePos.m_6630_(context.f_226622_().m_214096_(prePos.m_123341_(), prePos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_226629_(), context.f_226624_()));
            return Optional.of(new Structure.GenerationStub(pos, builder -> builder.m_142679_((StructurePiece)new Piece(context.f_226625_(), WitherStormModStructures.STORM_SPAWN_PLATFORM.getId(), pos, rotation, 0))));
        }
        return Optional.empty();
    }

    public StructureType<?> m_213658_() {
        return (StructureType)WitherStormModStructures.STORM_SPAWN_PLATFORM.get();
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager manager, ResourceLocation location, BlockPos pos, Rotation rotation, int offsetY) {
            super(WitherStormModStructures.PLATFORM, 0, manager, location, location.toString(), Piece.makeSettings(rotation, pos), pos);
        }

        public Piece(StructureTemplateManager manager, CompoundTag nbt) {
            super(WitherStormModStructures.PLATFORM, nbt, manager, id -> {
                StructureTemplate template = manager.m_230359_(id);
                return Piece.makeSettings(Rotation.valueOf((String)nbt.m_128461_("Rot")), new BlockPos(template.m_163801_().m_123341_() / 2, 0, template.m_163801_().m_123343_() / 2));
            });
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, BlockPos pos) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_213704_(String p_226906_, BlockPos p_226907_, ServerLevelAccessor p_226908_, RandomSource p_226909_, BoundingBox p_226910_) {
        }
    }
}

