/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;

public class WorldUtil {
    public static <T extends Entity> List<T> getPerformantEntitiesOfClass(ServerLevel world, Class<T> clazz, AABB box, @Nullable Predicate<? super T> predicate) {
        return world.m_6443_(clazz, box, predicate);
    }

    public static <T extends Entity> List<T> getPerformantEntitiesOfClass(ServerLevel world, Class<T> clazz, AABB box) {
        return WorldUtil.getPerformantEntitiesOfClass(world, clazz, box, EntitySelector.f_20408_);
    }

    public static List<BlockEntity> getBlockEntitiesInAABB(Level world, AABB box) {
        ArrayList<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        ChunkSource source = world.m_7726_();
        for (int x = Mth.m_14107_((double)(box.f_82288_ / 16.0)); x < Mth.m_14107_((double)(box.f_82291_ / 16.0)); ++x) {
            for (int z = Mth.m_14107_((double)(box.f_82290_ / 16.0)); z < Mth.m_14107_((double)(box.f_82293_ / 16.0)); ++z) {
                LevelChunk chunk = source.m_62227_(x, z, false);
                if (chunk == null) continue;
                for (BlockPos pos : chunk.m_5928_()) {
                    if (!box.m_82390_(Vec3.m_82539_((Vec3i)pos))) continue;
                    blockEntities.add(chunk.m_7702_(pos));
                }
            }
        }
        return blockEntities;
    }

    @Nullable
    public static <T> T getNearest(List<T> objects, Vec3 center, Function<T, Vec3> toVec) {
        double distance = -1.0;
        T toReturn = null;
        for (T t : objects) {
            Vec3 vec = toVec.apply(t);
            double d0 = vec.m_82557_(center);
            if (distance != -1.0 && !(d0 < distance)) continue;
            distance = d0;
            toReturn = t;
        }
        return toReturn;
    }

    public static List<WitherStormEntity> getAllStorms(ServerLevel level) {
        return Lists.newArrayList((Iterable)level.m_8583_()).stream().filter(e -> e instanceof WitherStormEntity).collect(Collectors.mapping(e -> (WitherStormEntity)e, Collectors.toList()));
    }

    public static boolean checkForIntersect(AABB box, Vec3 start, Vec3 end) {
        double d1;
        double d0 = Double.MAX_VALUE;
        boolean flag = false;
        Optional optional = box.m_82371_(start, end);
        if (optional.isPresent() && (d1 = start.m_82557_((Vec3)optional.get())) < d0) {
            flag = true;
            d0 = d1;
        }
        if (box.m_82390_(start)) {
            flag = true;
        }
        return flag;
    }

    public static boolean areaLoaded(Level level, BlockPos center, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                ChunkPos chunkPos = new ChunkPos(center);
                ChunkAccess chunk = level.m_6522_(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z, ChunkStatus.f_62326_, false);
                if (!(chunk instanceof LevelChunk)) {
                    return false;
                }
                ChunkHolder.FullChunkStatus type = ((LevelChunk)chunk).m_6708_();
                if (type.m_140114_(ChunkHolder.FullChunkStatus.TICKING)) continue;
                return false;
            }
        }
        return true;
    }
}

