/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.CommandBlockEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModItems;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModItemTags;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModStructureTags;

public class UltimateTargetManager {
    protected final WitherStormEntity entity;
    @Nullable
    protected ServerPlayer ultimateTarget;
    @Nullable
    protected UUID targetOverride;
    @Nullable
    protected BlockPos blockTargetOverride;
    @Nullable
    protected Vec3 alternativeUltimateTarget;
    @Nullable
    protected BlockPos distractedPos;
    @Nullable
    protected ChunkPos center;
    protected boolean ultimateTargetStationary;
    protected int ticksSinceStationary;
    protected int runawayDiminishTicks;
    protected final int chunkBoundaryRadius;
    protected int runawayAttempts;
    protected boolean canCountRunawayAttempt;
    protected boolean canBeDistracted;
    protected boolean isDistracted;
    protected int ticksSinceDistracted;
    protected int canBeDistractedFor;
    protected int distractionWait;
    protected int tillShowHole;

    public UltimateTargetManager(WitherStormEntity entity) {
        this.entity = entity;
        this.chunkBoundaryRadius = WitherStormModConfig.SERVER.targetStationaryChunkRadius.get();
    }

    public void tick() {
        Player override = null;
        List players = ((ServerLevel)this.entity.f_19853_).m_6907_();
        Predicate<Entity> predicate = entity -> !entity.m_5833_();
        double d0 = -1.0;
        for (ServerPlayer player : players) {
            if (!predicate.test((Entity)player)) continue;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                double d1;
                if (!stack.m_150930_((Item)WitherStormModItems.AMULET.get()) || !((d1 = player.m_20280_((Entity)this.entity)) < d0) && d0 != -1.0) continue;
                d0 = player.m_20280_((Entity)this.entity);
                override = player;
            }
        }
        if (this.getTargetOverride() != null) {
            override = this.entity.f_19853_.m_46003_(this.getTargetOverride());
        }
        if (override != null) {
            this.setUltimateTarget((ServerPlayer)override);
        } else {
            this.setUltimateTarget(WitherStormModConfig.SERVER.ultimateTargetingType.get().getPlayer(this.entity, players, predicate));
        }
        if (this.getUltimateTarget() != null) {
            ServerPlayer target = this.getUltimateTarget();
            this.setAlternativeUltimateTarget(target.m_20182_());
        }
        for (ServerPlayer player : players) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!stack.m_204117_(WitherStormModItemTags.COMMAND_BLOCK_TOOLS) || this.tillShowHole() > 0 || this.entity.isBeingTornApart() || this.entity.getPhase() <= 6) continue;
                this.tillShowHole = WitherStormModConfig.SERVER.tillShouldShowHole.get() * 1200 + this.entity.m_217043_().m_188503_(4800);
            }
        }
        if (this.getUltimateTargetPos() != null && this.currentPlayerChunkPos() == null) {
            this.setCenter(new ChunkPos(this.asBlockPos()));
        }
        int distance = (int)(this.getDistance() * WitherStormModConfig.SERVER.distanceMultiplier.get());
        if (WitherStormModConfig.SERVER.usePhaseAsDistanceMultiplier.get().booleanValue()) {
            distance = (int)((double)distance * ((double)this.entity.getPhase() * 0.2 + 1.0));
        }
        int stationaryTicks = WitherStormModConfig.SERVER.targetStationaryMinutes.get() * 1200;
        int runawayTicks = stationaryTicks - WitherStormModConfig.SERVER.targetRunawayMinutes.get() * 1200;
        int runawayAttemptsDiminish = WitherStormModConfig.SERVER.minutesTillRunawayAttemptDiminish.get() * 1200;
        if (!this.isDistracted()) {
            if (this.isPosInChunkRadius(this.getUltimateTargetPos())) {
                if (this.ticksSinceStationary > Math.max(2400, stationaryTicks - distance)) {
                    this.ultimateTargetStationary = true;
                }
                if (this.ticksSinceStationary <= Math.max(2400, stationaryTicks)) {
                    ++this.ticksSinceStationary;
                    if (this.ticksSinceStationary > WitherStormModConfig.SERVER.targetRunawayAttemptMinutes.get() * 1200 && WitherStormModConfig.SERVER.targetRunawayAttempts.get().booleanValue()) {
                        this.canCountRunawayAttempt = true;
                    }
                }
                if (this.runawayDiminishTicks > runawayAttemptsDiminish) {
                    this.reduceRunawayAttempts();
                    this.runawayDiminishTicks = 0;
                } else {
                    ++this.runawayDiminishTicks;
                }
            } else if (this.ticksSinceStationary <= Math.max(2400, runawayTicks - distance)) {
                if (this.ultimateTargetStationary) {
                    boolean flag1 = true;
                    CommandBlockEntity commandBlock = this.entity.getBowelsCommandBlock();
                    if (commandBlock != null && commandBlock.m_21223_() < commandBlock.m_21233_()) {
                        flag1 = false;
                    }
                    if (this.entity.getPhase() > 3 && flag1) {
                        boolean shouldActuallyBeDistracted;
                        boolean shouldNotBeDistracted;
                        boolean flag = WitherStormModConfig.SERVER.randomDistractionChances.get();
                        boolean bl = flag ? this.entity.m_217043_().m_188503_(30) == 1 : (shouldNotBeDistracted = false);
                        boolean bl2 = flag ? this.entity.m_217043_().m_188503_(10) == 1 : (shouldActuallyBeDistracted = false);
                        if (this.canBeDistracted() && !shouldNotBeDistracted || shouldActuallyBeDistracted) {
                            int minimumDistance = WitherStormModConfig.SERVER.minimumDistractionDistance.get();
                            if (this.getUltimateTargetPos().m_82554_(this.entity.m_20182_()) < this.entity.m_21133_(Attributes.f_22277_) + (double)minimumDistance && minimumDistance != 0) {
                                this.setDistractionWait(WitherStormModConfig.SERVER.distractionWaitTime.get() * 1200 + this.entity.m_217043_().m_188503_(1200));
                            }
                            this.makeDistracted();
                        }
                    }
                }
                this.ultimateTargetStationary = false;
                this.setCenter(new ChunkPos(this.asBlockPos()));
                this.ticksSinceStationary = 0;
            } else {
                --this.ticksSinceStationary;
                this.ultimateTargetStationary = true;
            }
            if (this.isTargetStationary() && !this.canBeDistracted && this.getDistance() < this.entity.m_21133_(Attributes.f_22277_) + (double)WitherStormModConfig.SERVER.maximumDistractionDistance.get().intValue()) {
                this.canBeDistracted = true;
            }
            if (this.getDistractionWait() > 0) {
                --this.distractionWait;
                if (this.distractionWait <= 0 && this.canBeDistracted() && this.getUltimateTargetPos().m_82554_(this.entity.m_20182_()) >= this.entity.m_21133_(Attributes.f_22277_) + 50.0 && !this.ultimateTargetStationary) {
                    this.makeDistracted();
                }
            }
        } else {
            ++this.ticksSinceDistracted;
            if (this.getTicksSinceDistracted() > this.canBeDistractedFor) {
                this.makeFocused();
            }
            if (this.getDistance() < this.entity.m_21133_(Attributes.f_22277_) * 2.5) {
                this.makeFocused();
            }
        }
        if (this.runawayAttempts > WitherStormModConfig.SERVER.targetRunawayAttemptsRequired.get() && WitherStormModConfig.SERVER.targetRunawayAttempts.get().booleanValue() && !this.isDistracted()) {
            this.accelerate();
            this.canCountRunawayAttempt = false;
            this.setRunawayAttempts(0);
        }
        if (this.tillShowHole > 0) {
            --this.tillShowHole;
            if (this.tillShowHole == 0 && this.entity.getPhase() > 6) {
                this.entity.setShouldShowHole(true);
            }
        }
    }

    public void accelerate() {
        if (this.isDistracted()) {
            this.makeFocused();
        }
        this.ticksSinceStationary = WitherStormModConfig.SERVER.targetStationaryMinutes.get() * 1200;
        this.ultimateTargetStationary = true;
    }

    protected double getDistance() {
        float x = (float)(this.getUltimateTargetPos().m_7096_() - this.entity.m_20185_());
        float y = (float)(this.getUltimateTargetPos().m_7098_() - this.entity.m_20186_());
        float z = (float)(this.getUltimateTargetPos().m_7094_() - this.entity.m_20189_());
        return Mth.m_14116_((float)(x * x + y * y + z * z));
    }

    public void setUltimateTarget(ServerPlayer player) {
        this.ultimateTarget = player;
    }

    public void setAlternativeUltimateTarget(Vec3 pos) {
        this.alternativeUltimateTarget = pos;
    }

    public ServerPlayer getUltimateTarget() {
        return this.ultimateTarget;
    }

    public Vec3 getAlternativeUltimateTarget() {
        return this.alternativeUltimateTarget;
    }

    public Vec3 getUltimateTargetPos() {
        if (this.ultimateTarget != null) {
            return this.ultimateTarget.m_20182_();
        }
        if (this.alternativeUltimateTarget != null) {
            return this.alternativeUltimateTarget;
        }
        return Vec3.f_82478_;
    }

    private BlockPos asBlockPos() {
        return new BlockPos(this.getUltimateTargetPos());
    }

    public ChunkPos currentPlayerChunkPos() {
        return this.center;
    }

    public void setCurrentPlayerChunkpos(ChunkPos pos) {
        this.center = pos;
    }

    public boolean isPosInChunkRadius(Vec3 pos) {
        if (pos != null && this.center != null) {
            for (int x = -this.chunkBoundaryRadius; x <= this.chunkBoundaryRadius; ++x) {
                for (int z = -this.chunkBoundaryRadius; z <= this.chunkBoundaryRadius; ++z) {
                    ChunkPos chunk = new ChunkPos(this.center.f_45578_ + x, this.center.f_45579_ + z);
                    if (!chunk.equals((Object)new ChunkPos(new BlockPos(pos)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isTargetStationary() {
        return this.ultimateTargetStationary;
    }

    public int targetStationaryTicks() {
        return this.ticksSinceStationary;
    }

    public void setTargetStationaryTicks(int amount) {
        this.ticksSinceStationary = amount;
    }

    public int getRunawayAttempts() {
        return this.runawayAttempts;
    }

    public void setRunawayAttempts(int attempts) {
        this.runawayAttempts = attempts;
    }

    public void countRunawayAttempt() {
        ++this.runawayAttempts;
    }

    public void reduceRunawayAttempts() {
        double amount = this.runawayAttempts - 1;
        if (amount >= 0.0) {
            --this.runawayAttempts;
        }
    }

    public int getRunawayDimishTicks() {
        return this.runawayDiminishTicks;
    }

    public void setCenter(ChunkPos pos) {
        this.center = pos;
        if (this.canCountRunawayAttempt) {
            this.countRunawayAttempt();
            this.canCountRunawayAttempt = false;
        }
    }

    @Nullable
    public BlockPos findDistractPos() {
        ServerLevel level = (ServerLevel)this.entity.m_9236_();
        BlockPos pos = level.m_215011_(WitherStormModStructureTags.WITHER_STORM_DISTRACTABLE, this.entity.m_20183_(), 100, false);
        if (pos == null) {
            int times = 10;
            for (int i = 0; i < times && pos == null; ++i) {
                int multiplier = WitherStormModConfig.SERVER.searchRangeMultiplier.get();
                double range = this.entity.m_21133_(Attributes.f_22277_) * 2.0 * (double)multiplier;
                BlockPos current = new BlockPos(this.entity.m_20208_(range), this.entity.m_20186_(), this.entity.m_20262_(range));
                Vec3 vectorCurrent = new Vec3((double)current.m_123341_(), (double)current.m_123342_(), (double)current.m_123343_());
                if (!this.entity.f_19853_.m_8055_(current).m_60713_(Blocks.f_50016_) || !(Math.sqrt(this.entity.m_20238_(vectorCurrent)) > 2000.0 * (double)multiplier) || !(this.getUltimateTargetPos().m_82554_(vectorCurrent) > 500.0)) continue;
                pos = current;
            }
        }
        return pos;
    }

    public boolean canBeDistracted() {
        return this.canBeDistracted && WitherStormModConfig.SERVER.targettingDistractionsEnabled.get() != false;
    }

    public void setCanBeDistracted(boolean distractable) {
        this.canBeDistracted = distractable;
    }

    public boolean isDistracted() {
        return this.isDistracted;
    }

    public void markDistracted(boolean distracted) {
        this.isDistracted = distracted;
    }

    public int getTicksSinceDistracted() {
        return this.ticksSinceDistracted;
    }

    public void setTicksSinceDistracted(int ticks) {
        this.ticksSinceDistracted = ticks;
    }

    public void makeDistracted() {
        if (WitherStormModConfig.SERVER.targettingDistractionsEnabled.get().booleanValue() && this.distractionWait <= 0) {
            this.distractedPos = this.findDistractPos();
            if (this.distractedPos != null) {
                this.isDistracted = true;
                this.canBeDistractedFor = Math.max(4800, WitherStormModConfig.SERVER.distractionTimeMinutes.get() * 1200 + this.entity.m_217043_().m_188503_(12000) - (int)this.entity.distanceTo(this.distractedPos) * 2);
                this.canBeDistracted = false;
            }
        }
    }

    public void makeFocused() {
        this.isDistracted = false;
        this.ticksSinceDistracted = 0;
        this.canBeDistracted = false;
        this.distractedPos = null;
        this.canBeDistractedFor = 0;
        this.distractionWait = 0;
    }

    @Nullable
    public BlockPos getDistractedPos() {
        return this.distractedPos;
    }

    public void setDistractedPos(@Nullable BlockPos pos) {
        this.distractedPos = pos;
    }

    public int getDistractedTickTime() {
        return this.canBeDistractedFor;
    }

    public void setDistractedTickTime(int ticks) {
        this.canBeDistractedFor = ticks;
    }

    public int getDistractionWait() {
        return this.distractionWait;
    }

    public void setDistractionWait(int ticks) {
        this.distractionWait = ticks;
    }

    public int tillShowHole() {
        return this.tillShowHole;
    }

    public void setTillShowHole(int ticks) {
        this.tillShowHole = ticks;
    }

    public void setTargetOverride(@Nullable UUID uuid) {
        this.targetOverride = uuid;
    }

    @Nullable
    public UUID getTargetOverride() {
        return this.targetOverride;
    }

    public void setBlockTargetOverride(@Nullable BlockPos pos) {
        this.blockTargetOverride = pos;
    }

    @Nullable
    public BlockPos getBlockTargetOverride() {
        return this.blockTargetOverride;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TargetingType {
        NEAREST{

            @Override
            @Nullable
            public ServerPlayer getPlayer(WitherStormEntity storm, List<ServerPlayer> players, Predicate<Entity> predicate) {
                double d0 = -1.0;
                ServerPlayer closest = null;
                for (ServerPlayer player : players) {
                    double d1;
                    if (!predicate.test((Entity)player) || !((d1 = player.m_20280_((Entity)storm)) < d0) && d0 != -1.0) continue;
                    d0 = player.m_20280_((Entity)storm);
                    closest = player;
                }
                return closest;
            }
        }
        ,
        FARTHEST{

            @Override
            @Nullable
            public ServerPlayer getPlayer(WitherStormEntity storm, List<ServerPlayer> players, Predicate<Entity> predicate) {
                double d0 = -1.0;
                ServerPlayer farthest = null;
                for (ServerPlayer player : players) {
                    double d1;
                    if (!predicate.test((Entity)player) || !((d1 = player.m_20280_((Entity)storm)) > d0) && d0 != -1.0) continue;
                    d0 = player.m_20280_((Entity)storm);
                    farthest = player;
                }
                return farthest;
            }
        }
        ,
        GROUP{

            @Override
            @Nullable
            public ServerPlayer getPlayer(WitherStormEntity storm, List<ServerPlayer> players, Predicate<Entity> predicate) {
                double size = -1.0;
                ServerPlayer toTarget = null;
                for (ServerPlayer player : players) {
                    AABB box;
                    List nearby;
                    if (!predicate.test((Entity)player) || !((double)(nearby = storm.f_19853_.m_6443_(ServerPlayer.class, box = player.m_20191_().m_82400_(20.0), EntitySelector.f_20403_.and(EntitySelector.f_20408_))).size() > size) && size != -1.0) continue;
                    size = nearby.size();
                    toTarget = player;
                }
                return toTarget;
            }
        }
        ,
        NONE{

            @Override
            @Nullable
            public ServerPlayer getPlayer(WitherStormEntity storm, List<ServerPlayer> players, Predicate<Entity> predicate) {
                return null;
            }
        };


        @Nullable
        public abstract ServerPlayer getPlayer(WitherStormEntity var1, List<ServerPlayer> var2, Predicate<Entity> var3);
    }
}

