/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCriteriaTriggers;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.packet.NotifyHeadInjuryMessage;

public class HeadInjuryManager {
    private final WitherStormEntity storm;
    private final int[] nextShake = new int[]{20, 20, 20};
    private final boolean[] isHeadShaking = new boolean[]{false, false, false};
    private final float[] headShakeAnim = new float[]{0.0f, 0.0f, 0.0f};
    private final float[] headShakeAnimO = new float[]{0.0f, 0.0f, 0.0f};

    public HeadInjuryManager(WitherStormEntity storm) {
        this.storm = storm;
    }

    public void save(CompoundTag tag) {
        ListTag cooldowns = new ListTag();
        for (int i = 0; i < 3; ++i) {
            CompoundTag cooldownTag = new CompoundTag();
            cooldownTag.m_128405_("Cooldown", this.getHeadInjureAttemptCooldown(i));
            cooldowns.add((Object)cooldownTag);
        }
        tag.m_128365_("Cooldowns", (Tag)cooldowns);
        ListTag injuryTimes = new ListTag();
        for (int i = 0; i < 3; ++i) {
            CompoundTag injuryTimeTag = new CompoundTag();
            injuryTimeTag.m_128405_("InjuryTime", this.getHeadInjuryTicks(i));
            injuryTimes.add((Object)injuryTimeTag);
        }
        tag.m_128365_("InjuryTimes", (Tag)injuryTimes);
    }

    public void read(CompoundTag tag) {
        ListTag cooldowns = tag.m_128437_("Cooldowns", 10);
        ListTag injuryTimes = tag.m_128437_("InjuryTimes", 10);
        for (int i = 0; i < 3; ++i) {
            this.setHeadInjureAttemptCooldown(i, cooldowns.m_128728_(i).m_128451_("Cooldown"));
            this.setHeadInjuryTicks(i, injuryTimes.m_128728_(i).m_128451_("InjuryTime"));
        }
    }

    public void tick() {
        for (int i = 0; i < 3; ++i) {
            if (this.getHeadInjuryTicks(i) > 0) {
                this.decreaseHeadInjuryTicks(i);
            }
            if (this.getHeadInjureAttemptCooldown(i) > 0) {
                this.decreaseInjureAttemptCooldown(i);
            }
            if (!this.storm.f_19853_.f_46443_) {
                if (this.headInjured(i)) {
                    this.storm.removableGoals.removeGoals(WitherStormEntity.REMOVABLE_LOOK_GOALS[i], this.storm.getGoalSelectorForHead(i));
                    this.storm.removableGoals.removeGoals(WitherStormEntity.REMOVABLE_TARGET_GOALS[i], this.storm.getTargetSelectorForHead(i));
                } else {
                    this.storm.removableGoals.putGoals(WitherStormEntity.REMOVABLE_LOOK_GOALS[i], this.storm.getGoalSelectorForHead(i));
                    this.storm.removableGoals.putGoals(WitherStormEntity.REMOVABLE_TARGET_GOALS[i], this.storm.getTargetSelectorForHead(i));
                }
            }
            if (this.storm.isHeadInjured(i) && this.nextShake[i] > 0) {
                int n = i;
                this.nextShake[n] = this.nextShake[n] - 1;
                if (this.nextShake[i] == 0) {
                    this.isHeadShaking[i] = true;
                }
            }
            this.headShakeAnimO[i] = this.headShakeAnim[i];
            if (!this.isHeadShaking[i]) continue;
            int n = i;
            this.headShakeAnim[n] = this.headShakeAnim[n] + (0.02f + this.storm.m_217043_().m_188501_() * 0.05f);
            if (!(this.headShakeAnimO[i] >= 2.0f)) continue;
            this.headShakeAnimO[i] = 0.0f;
            this.headShakeAnim[i] = 0.0f;
            this.isHeadShaking[i] = false;
            this.nextShake[i] = 20 + this.storm.m_217043_().m_188503_(20);
        }
    }

    public void update(int phase) {
        if (phase > 3) {
            this.setHeadInjuryTime(720);
        } else {
            this.setHeadInjuryTime(180);
        }
    }

    public int getHeadInjureAttemptCooldown(int head) {
        return (Integer)this.storm.m_20088_().m_135370_(WitherStormEntity.INJURE_ATTEMPT_COOLDOWN.get(head));
    }

    public void setHeadInjureAttemptCooldown(int head, int amount) {
        this.storm.m_20088_().m_135381_(WitherStormEntity.INJURE_ATTEMPT_COOLDOWN.get(head), (Object)amount);
    }

    public void decreaseInjureAttemptCooldown(int head) {
        this.setHeadInjureAttemptCooldown(head, this.getHeadInjureAttemptCooldown(head) - 1);
    }

    public int getHeadInjuryTicks(int head) {
        return (Integer)this.storm.m_20088_().m_135370_(WitherStormEntity.HURT_HEAD_TIME.get(head));
    }

    public void setHeadInjuryTicks(int head, int amount) {
        this.storm.m_20088_().m_135381_(WitherStormEntity.HURT_HEAD_TIME.get(head), (Object)amount);
    }

    public void decreaseHeadInjuryTicks(int head) {
        this.setHeadInjuryTicks(head, this.getHeadInjuryTicks(head) - 1);
    }

    public int getHeadInjuryTime() {
        return (Integer)this.storm.m_20088_().m_135370_(WitherStormEntity.TIME);
    }

    public void setHeadInjuryTime(int time) {
        this.storm.m_20088_().m_135381_(WitherStormEntity.TIME, (Object)time);
    }

    public boolean headInjured(int head) {
        return this.getHeadInjuryTicks(head) > 0;
    }

    public void hurtHead(@Nullable Entity entity, int head) {
        this.setHeadInjuryTicks(head, this.getHeadInjuryTime());
        this.storm.setRoar(head, true);
        Vec3 view = this.storm.getViewVector(this.storm.m_146909_(), this.storm.m_146908_(), 1.0f);
        if (head != 0) {
            view = this.storm.getViewVector(this.storm.getHeadXRot(head - 1), this.storm.getHeadYRot(head - 1), 1.0f);
        }
        this.storm.spawnFlamingWitherSkull(head, view.f_82479_ + this.storm.getHeadX(head), view.f_82480_ + this.storm.getHeadY(head), view.f_82481_ + this.storm.getHeadZ(head));
        this.storm.roarTicks[head] = 20;
        this.setHeadInjureAttemptCooldown(head, 40);
        if (!this.storm.f_19853_.f_46443_) {
            NotifyHeadInjuryMessage message = new NotifyHeadInjuryMessage(this.storm, head);
            ResourceKey dimension = this.storm.f_19853_.m_46472_();
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)message);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (this.storm.alreadyATarget(entity, true)) {
                    entity.getCapability(WitherStormModCapabilities.PLAYER_WITHER_STORM_DATA).ifPresent(data -> data.makeInvulnerable(240 + player.m_217043_().m_188503_(80)));
                    WitherStormModCriteriaTriggers.ESCAPE_STORM.trigger(player, this.storm);
                }
            }
        }
    }

    public float getRollAngle(int head, float partialTicks) {
        float lerp = Mth.m_14036_((float)Mth.m_14179_((float)partialTicks, (float)this.headShakeAnimO[head], (float)this.headShakeAnim[head]), (float)0.0f, (float)1.0f);
        return Mth.m_14031_((float)(lerp * (float)Math.PI)) * Mth.m_14031_((float)(lerp * (float)Math.PI * 12.0f)) * 0.05f * (float)Math.PI;
    }
}

