/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.util;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.common.capability.WitherStormBowelsManager;
import nonamecrackers2.witherstormmod.common.entity.CommandBlockEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;

public class BowelsInstanceManager {
    private final WitherStormEntity storm;
    @Nullable
    private WitherStormBowelsManager.BowelsInstance instance;
    @Nullable
    private CommandBlockEntity commandBlock;

    public BowelsInstanceManager(WitherStormEntity storm) {
        this.storm = storm;
    }

    public void loadInstance() {
        ServerLevel bowels = WitherStormMod.bowels((ServerLevel)this.storm.f_19853_);
        bowels.getCapability(WitherStormModCapabilities.BOWELS_MANAGER).ifPresent(manager -> {
            WitherStormBowelsManager.BowelsInstance instance = manager.getOrCreateInstanceFor(this.storm);
            if (instance != null) {
                manager.add(instance);
                instance.setup(bowels);
                this.instance = instance;
            }
        });
    }

    public void tick() {
        if (this.instance != null) {
            if (this.instance.isCompleted()) {
                this.commandBlock = null;
                this.instance = null;
                this.loadInstance();
            }
            if (this.commandBlock == null && this.instance.hasPreparedArena()) {
                ServerLevel bowels = WitherStormMod.bowels((ServerLevel)this.storm.f_19853_);
                UUID uuid = this.instance.getCommandBlockUUID();
                if (uuid != null) {
                    ChunkPos center = new ChunkPos(this.instance.getPos());
                    for (int x = -3; x <= 3; ++x) {
                        for (int z = -3; z <= 3; ++z) {
                            bowels.m_6325_(x + center.f_45578_, z + center.f_45579_);
                        }
                    }
                    Entity entity = bowels.m_8791_(this.instance.getCommandBlockUUID());
                    if (entity instanceof CommandBlockEntity) {
                        this.commandBlock = (CommandBlockEntity)entity;
                    }
                }
            }
        }
    }

    @Nullable
    public CommandBlockEntity getCommandBlock() {
        return this.commandBlock;
    }

    @Nullable
    public WitherStormBowelsManager.BowelsInstance getBowelsInstance() {
        return this.instance;
    }
}

