/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.packet.InjureHeadMessage;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WitherStormModMessageHandlerServer {
    public static final Logger LOGGER = LogManager.getLogger();

    public static void processInjureHeadMessage(InjureHeadMessage message, ServerPlayer player) {
        ServerLevel world = player.m_9236_();
        double pickRange = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 pos = player.m_20299_(1.0f);
        Vec3 eye = player.m_20252_(1.0f);
        Vec3 reach = pos.m_82520_(eye.f_82479_ * pickRange, eye.f_82480_ * pickRange, eye.f_82481_ * pickRange);
        Entity entity = world.m_6815_(message.getEntityID());
        byte head = message.getHead();
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            ItemStack item = player.m_21120_(message.getHand());
            if (!storm.isDeadOrPlayingDead() && (storm.getPhase() < 4 && head == 0 || storm.getPhase() > 3) && (storm.areOtherHeadsDisabled() && head == 0 || !storm.areOtherHeadsDisabled()) && WorldUtil.checkForIntersect(storm.getBoxForHead(head), pos, reach)) {
                if (storm.getHeadInjureAttemptCooldown(head) <= 0 && storm.getHeadInjuryTicks(head) <= 0) {
                    storm.setHeadInjureAttemptCooldown(head, 20);
                    int chance = 7;
                    if (item.m_41720_() instanceof SwordItem) {
                        chance = (int)((float)chance + ((SwordItem)item.m_41720_()).m_43299_() * 2.0f);
                    } else if (item.m_41720_() instanceof DiggerItem) {
                        chance = (int)((float)chance + ((DiggerItem)item.m_41720_()).m_41008_() * 2.0f);
                    }
                    if (storm.m_217043_().m_188503_(100) < chance) {
                        storm.hurtHead((Entity)player, head);
                        player.m_6330_(SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                    } else {
                        player.m_6330_(SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
                    }
                } else {
                    player.m_6330_(SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
                }
            }
        } else {
            LOGGER.warn("Received entity " + entity + " that is not an instance of WitherStormEntity");
        }
    }
}

