/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.util.PlayDeadManager;

public class UpdatePlayDeadManagerMessage
extends Message<UpdatePlayDeadManagerMessage> {
    private int entityId;
    private PlayDeadManager.State state = PlayDeadManager.State.NORMAL_BEHAVIOR;
    private int ticks;
    private int revivalTicks;
    private boolean hasRecentlyBeenRevived;
    private boolean updateTick;
    private int revivalPlayerProtection;

    public UpdatePlayDeadManagerMessage(int id, PlayDeadManager manager, boolean updateTick) {
        super(true);
        this.entityId = id;
        this.state = manager.getState();
        this.ticks = manager.getTicks();
        this.revivalTicks = manager.getTicksSinceRevival();
        this.hasRecentlyBeenRevived = manager.hasRecentlyBeenRevived();
        this.updateTick = updateTick;
        this.revivalPlayerProtection = manager.getRevivalPlayerProtectionTime();
    }

    public UpdatePlayDeadManagerMessage() {
        super(false);
    }

    public int getEntityID() {
        return this.entityId;
    }

    public PlayDeadManager.State getState() {
        return this.state;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getTicksSinceRevival() {
        return this.revivalTicks;
    }

    public boolean hasRecentlyBeenRevived() {
        return this.hasRecentlyBeenRevived;
    }

    public boolean shouldUpdateTick() {
        return this.updateTick;
    }

    public int getRevivalPlayerProtectionTime() {
        return this.revivalPlayerProtection;
    }

    @Override
    public void decode(UpdatePlayDeadManagerMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.entityId = buffer.m_130242_();
        message.state = (PlayDeadManager.State)buffer.m_130066_(PlayDeadManager.State.class);
        message.ticks = buffer.readInt();
        message.revivalTicks = buffer.readInt();
        message.hasRecentlyBeenRevived = buffer.readBoolean();
        message.updateTick = buffer.readBoolean();
        message.revivalPlayerProtection = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.entityId);
        buffer.m_130068_((Enum)this.state);
        buffer.writeInt(this.ticks);
        buffer.writeInt(this.revivalTicks);
        buffer.writeBoolean(this.hasRecentlyBeenRevived);
        buffer.writeBoolean(this.updateTick);
        buffer.writeInt(this.revivalPlayerProtection);
    }

    @Override
    public Runnable getProcessor(UpdatePlayDeadManagerMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processUpdatePlayDeadManagerMessage(message));
    }

    public String toString() {
        return "UpdatePlayDeadManagerMessage[id=" + this.entityId + ", state=" + this.state.toString() + ", ticks=" + this.ticks + ", updateTick=" + this.updateTick + "]";
    }
}

