/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class UpdateDamagingProjectileMessage
extends Message<UpdateDamagingProjectileMessage> {
    private int entityId;
    private double xPower;
    private double yPower;
    private double zPower;

    public UpdateDamagingProjectileMessage(AbstractHurtingProjectile entity) {
        super(true);
        this.entityId = entity.m_19879_();
        this.xPower = entity.f_36813_;
        this.yPower = entity.f_36814_;
        this.zPower = entity.f_36815_;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public double getXPower() {
        return this.xPower;
    }

    public double getYPower() {
        return this.yPower;
    }

    public double getZPower() {
        return this.zPower;
    }

    public UpdateDamagingProjectileMessage() {
        super(false);
    }

    @Override
    public void decode(UpdateDamagingProjectileMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.entityId = buffer.m_130242_();
        message.xPower = buffer.readDouble();
        message.yPower = buffer.readDouble();
        message.zPower = buffer.readDouble();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.entityId);
        buffer.writeDouble(this.xPower);
        buffer.writeDouble(this.yPower);
        buffer.writeDouble(this.zPower);
    }

    @Override
    public Runnable getProcessor(UpdateDamagingProjectileMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processUpdateDamagingProjectileMessage(message));
    }

    public String toString() {
        return "UpdateDamagingProjectileMessage[id=" + this.entityId + ", xPower=" + this.xPower + ", yPower=" + this.yPower + ", zPower=" + this.zPower + "]";
    }
}

