/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.config.SyncableConfigValue;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class SyncConfigValueMessage
extends Message<SyncConfigValueMessage> {
    private ResourceLocation id;
    private final SyncableConfigValue<?> value;
    private FriendlyByteBuf buffer;

    public SyncConfigValueMessage(SyncableConfigValue<?> value) {
        super(true);
        this.id = value.getId();
        this.value = value;
    }

    public SyncConfigValueMessage() {
        super(false);
        this.value = null;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130085_(this.id);
        this.value.write(buffer);
    }

    @Override
    public void decode(SyncConfigValueMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.id = buffer.m_130281_();
        message.buffer = buffer;
    }

    @Override
    public Runnable getProcessor(SyncConfigValueMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processSyncConfigValueMessage(message));
    }
}

