/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class PlayAdditionalLoopingSoundMessage
extends Message<PlayAdditionalLoopingSoundMessage> {
    private int entityId;
    private SoundEvent event;
    private double x;
    private double y;
    private double z;

    public PlayAdditionalLoopingSoundMessage(WitherStormEntity entity, SoundEvent event) {
        super(true);
        this.entityId = entity.m_19879_();
        this.event = event;
        this.x = entity.m_20185_();
        this.y = entity.m_20188_();
        this.z = entity.m_20189_();
    }

    public PlayAdditionalLoopingSoundMessage() {
        super(false);
    }

    public int getEntityID() {
        return this.entityId;
    }

    public SoundEvent getSound() {
        return this.event;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.entityId);
        buffer.m_236818_((IdMap)Registry.f_122821_, (Object)this.event);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
    }

    @Override
    public void decode(PlayAdditionalLoopingSoundMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.entityId = buffer.m_130242_();
        message.event = (SoundEvent)buffer.m_236816_((IdMap)Registry.f_122821_);
        message.x = buffer.readDouble();
        message.y = buffer.readDouble();
        message.z = buffer.readDouble();
    }

    @Override
    public Runnable getProcessor(PlayAdditionalLoopingSoundMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processPlayAdditionalLoopingSoundMessage(message));
    }

    public String toString() {
        return "PlayAdditionalLoopingSoundMessage[id=" + this.entityId + ", event=" + this.event + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

