/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class NotifyHeadInjuryMessage
extends Message<NotifyHeadInjuryMessage> {
    private int entityId;
    private byte head;

    public NotifyHeadInjuryMessage(WitherStormEntity entity, int head) {
        super(true);
        this.entityId = entity.m_19879_();
        this.head = (byte)head;
    }

    public NotifyHeadInjuryMessage() {
        super(false);
    }

    public int getEntityID() {
        return this.entityId;
    }

    public byte getHead() {
        return this.head;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.entityId);
        buffer.writeByte((int)this.head);
    }

    @Override
    public void decode(NotifyHeadInjuryMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.entityId = buffer.readInt();
        message.head = buffer.readByte();
    }

    @Override
    public Runnable getProcessor(NotifyHeadInjuryMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processNotifyHeadInjuryMessage(message));
    }

    public String toString() {
        return "NotifyHeadInjuryMessage[entityId=" + this.entityId + ", head=" + this.head + "]";
    }
}

