/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.packet.WitherStormModMessageHandlerServer;

public class InjureHeadMessage
extends Message<InjureHeadMessage> {
    private int entityId;
    private byte head;
    private InteractionHand hand;

    public InjureHeadMessage(WitherStormEntity entity, int head, InteractionHand hand) {
        super(true);
        this.entityId = entity.m_19879_();
        this.head = (byte)head;
        this.hand = hand;
    }

    public InjureHeadMessage() {
        super(false);
    }

    public int getEntityID() {
        return this.entityId;
    }

    public byte getHead() {
        return this.head;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeInt(this.entityId);
        buffer.writeByte((int)this.head);
        buffer.m_130068_((Enum)this.hand);
    }

    @Override
    public void decode(InjureHeadMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.entityId = buffer.readInt();
        message.head = buffer.readByte();
        message.hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
    }

    @Override
    public Runnable getProcessor(InjureHeadMessage message, NetworkEvent.Context context) {
        return () -> WitherStormModMessageHandlerServer.processInjureHeadMessage(message, context.getSender());
    }

    public String toString() {
        return "InjureHeadMessage[entityId=" + this.entityId + ", head=" + this.head + ", hand=" + this.hand + "]";
    }
}

