/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class GlobalSoundMessage
extends Message<GlobalSoundMessage> {
    private boolean hasPos;
    private Vec3 pos;
    private double distance;
    private SoundEvent event;
    private float pitch;
    private float volume;

    public GlobalSoundMessage(@Nullable Vec3 pos, double distance, SoundEvent event, float volume, float pitch) {
        super(true);
        this.hasPos = pos != null;
        this.pos = pos;
        this.distance = distance;
        this.event = event;
        this.pitch = pitch;
        this.volume = volume;
    }

    public GlobalSoundMessage(SoundEvent event, float volume, float pitch) {
        this(null, 0.0, event, volume, pitch);
    }

    public GlobalSoundMessage() {
        super(false);
    }

    public boolean hasPos() {
        return this.hasPos;
    }

    @Nullable
    public Vec3 getPos() {
        return this.pos;
    }

    public double getDistance() {
        return this.distance;
    }

    public SoundEvent getSoundEvent() {
        return this.event;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.writeBoolean(this.hasPos);
        if (this.hasPos) {
            buffer.writeDouble(this.pos.m_7096_());
            buffer.writeDouble(this.pos.m_7098_());
            buffer.writeDouble(this.pos.m_7094_());
        }
        buffer.writeDouble(this.distance);
        buffer.m_130070_(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.event).toString());
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.volume);
    }

    @Override
    public void decode(GlobalSoundMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.hasPos = buffer.readBoolean();
        if (message.hasPos) {
            double x = buffer.readDouble();
            double y = buffer.readDouble();
            double z = buffer.readDouble();
            message.pos = new Vec3(x, y, z);
        }
        message.distance = buffer.readDouble();
        message.event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(buffer.m_130277_()));
        message.pitch = buffer.readFloat();
        message.volume = buffer.readFloat();
    }

    @Override
    public Runnable getProcessor(GlobalSoundMessage message, NetworkEvent.Context contextt) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processGlobalSoundMessage(message));
    }

    public String toString() {
        return "GlobalSoundMessage[sound_event=" + ForgeRegistries.SOUND_EVENTS.getKey((Object)this.event).toString() + ", pitch=" + String.valueOf(this.pitch) + ", volume=" + String.valueOf(this.volume) + "]";
    }
}

