/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.util.IEntitySyncableData;

public class EntitySyncableDataMessage
extends Message<EntitySyncableDataMessage> {
    private int id;
    private final IEntitySyncableData entity;
    private FriendlyByteBuf buffer;

    public EntitySyncableDataMessage(int id, IEntitySyncableData entity) {
        super(true);
        this.id = id;
        this.entity = entity;
    }

    public EntitySyncableDataMessage() {
        super(false);
        this.entity = null;
    }

    public int getId() {
        return this.id;
    }

    public FriendlyByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.id);
        this.entity.writeData(buffer);
    }

    @Override
    public void decode(EntitySyncableDataMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.id = buffer.m_130242_();
        message.buffer = buffer;
    }

    @Override
    public Runnable getProcessor(EntitySyncableDataMessage message, NetworkEvent.Context contextt) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processEntitySyncableDataMessage(message));
    }

    public String toString() {
        return "EntitySyncableDataMessage[entity=" + this.id + "]";
    }
}

