/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.packet.Message;

public class CreateDebrisMessage
extends Message<CreateDebrisMessage> {
    private int entityId;
    private boolean hidden;

    public CreateDebrisMessage(WitherStormEntity entity, boolean hidden) {
        super(true);
        this.entityId = entity.m_19879_();
        this.hidden = hidden;
    }

    public CreateDebrisMessage() {
        super(false);
    }

    public int getEntityID() {
        return this.entityId;
    }

    public boolean isDebrisHidden() {
        return this.hidden;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130130_(this.entityId);
        buffer.writeBoolean(this.hidden);
    }

    @Override
    public void decode(CreateDebrisMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
        message.entityId = buffer.m_130242_();
        message.hidden = buffer.readBoolean();
    }

    @Override
    public Runnable getProcessor(CreateDebrisMessage message, NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processCreateDebrisMessage(message));
    }

    public String toString() {
        return "CreateDebrisMessage[id=" + this.entityId + ", hidden=" + this.hidden + "]";
    }
}

