/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.init;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;
import nonamecrackers2.witherstormmod.common.entity.CommandBlockEntity;
import nonamecrackers2.witherstormmod.common.entity.TentacleEntity;
import nonamecrackers2.witherstormmod.common.entity.WitheredSymbiontEntity;
import nonamecrackers2.witherstormmod.common.packet.BlindScreenMessage;
import nonamecrackers2.witherstormmod.common.packet.CreateDebrisMessage;
import nonamecrackers2.witherstormmod.common.packet.CreateLoopingSoundMessage;
import nonamecrackers2.witherstormmod.common.packet.EntitySyncableDataMessage;
import nonamecrackers2.witherstormmod.common.packet.FormidibombExplosionMessage;
import nonamecrackers2.witherstormmod.common.packet.GlobalSoundMessage;
import nonamecrackers2.witherstormmod.common.packet.InjureHeadMessage;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.packet.NotifyHeadInjuryMessage;
import nonamecrackers2.witherstormmod.common.packet.PlayAdditionalLoopingSoundMessage;
import nonamecrackers2.witherstormmod.common.packet.PlayerMotionMessage;
import nonamecrackers2.witherstormmod.common.packet.RemoveAdditionalLoopingSoundMessage;
import nonamecrackers2.witherstormmod.common.packet.RemoveSoundLoopMessage;
import nonamecrackers2.witherstormmod.common.packet.RemoveStormFromDistantRendererMessage;
import nonamecrackers2.witherstormmod.common.packet.ShakeScreenMessage;
import nonamecrackers2.witherstormmod.common.packet.StormAttributesMessage;
import nonamecrackers2.witherstormmod.common.packet.StormMetadataMessage;
import nonamecrackers2.witherstormmod.common.packet.StormSoundPositionMessage;
import nonamecrackers2.witherstormmod.common.packet.StormTeleportMessage;
import nonamecrackers2.witherstormmod.common.packet.SyncConfigValueMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateDamagingProjectileMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateEffectInstanceMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdatePlayDeadManagerMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateStormHeadLookMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateStormPositionMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateStormVelocityMessage;
import nonamecrackers2.witherstormmod.common.packet.UpdateWitherSicknessTrackerMessage;
import nonamecrackers2.witherstormmod.common.packet.WitherStormModMessageHandlerServer;
import nonamecrackers2.witherstormmod.common.packet.WitherStormToDistantRendererMessage;
import nonamecrackers2.witherstormmod.common.util.WitherStormBodyController;

public class WitherStormModPacketHandlers {
    private static final String PROTOCOL_VERSION = "2.3";
    public static final SimpleChannel MAIN = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("witherstormmod", "main"), () -> "2.3", "2.3"::equals, "2.3"::equals);
    public static final int PLAYER_MOTION_MESSAGE_ID = 1;
    public static final int GLOBAL_SOUND_MESSAGE_ID = 2;
    public static final int UPDATE_YBODYROT_MESSAGE_ID = 3;
    public static final int WITHER_STORM_TO_DISTANT_RENDERER_ID = 5;
    public static final int REMOVE_STORM_FROM_DISTANT_RENDERER_ID = 6;
    public static final int UPDATE_STORM_POSITION_MESSAGE_ID = 7;
    public static final int STORM_TELEPORT_MESSAGE_ID = 8;
    public static final int STORM_VELOCITY_MESSAGE_ID = 9;
    public static final int UPDATE_STORM_HEAD_LOOK_MESSAGE_ID = 10;
    public static final int STORM_METADATA_MESSAGE_ID = 11;
    public static final int STORM_ATTRIBUTE_MESSAGE_ID = 12;
    public static final int CREATE_LOOPING_SOUND_MESSAGE_ID = 14;
    public static final int UPDATE_LOOPING_SOUND_MESSAGE_ID = 15;
    public static final int REMOVE_LOOPING_SOUND_MESSAGE_ID = 16;
    public static final int PLAY_BOSS_THEME_MESSAGE_ID = 17;
    public static final int NOTIFY_HEAD_INJURY_MESSAGE_ID = 19;
    public static final int INJURE_HEAD_MESSAGE_ID = 20;
    public static final int UPDATE_EFFECT_INSTANCE_MESSAGE_ID = 21;
    public static final int UPDATE_WITHER_SICKNESS_TRACKER_MESSAGE_ID = 22;
    public static final int UPDATE_PLAY_DEAD_MANAGER_MESSAGE_ID = 23;
    public static final int CREATE_DEBRIS_MESSAGE_ID = 24;
    public static final int ENTITY_SYNCABLE_DATA_MESSAGE_ID = 25;
    public static final int PLAY_ADDITIONAL_LOOP_MESSAGE_ID = 26;
    public static final int REMOVE_ADDITIONAL_LOOP_MESSAGE_ID = 27;
    public static final int SHAKE_SCREEN_MESSAGE_ID = 28;
    public static final int FORMIDIBOMB_EXPLOSION_MESSAGE_ID = 29;
    public static final int OVERWRITE_BOSS_THEME_MESSAGE_ID = 30;
    public static final int UPDATE_DAMAGING_PROJECTILE_MESSAGE_ID = 31;
    public static final int WITHERED_SYMBIONT_SET_SPELL_TIME_ID = 32;
    public static final int UPDATE_SYNC_CONFIG_VALUE_MESSAGE_ID = 33;
    public static final int COMMAND_BLOCK_ANIM_MESSAGE_ID = 34;
    public static final int TENTACLE_ANIM_MESSAGE_ID = 35;
    public static final int BLIND_SCREEN_MESSAGE_ID = 36;

    public static void registerPackets() {
        MAIN.registerMessage(1, PlayerMotionMessage.class, PlayerMotionMessage::encode, buffer -> Message.decode(PlayerMotionMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(2, GlobalSoundMessage.class, GlobalSoundMessage::encode, buffer -> Message.decode(GlobalSoundMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(3, WitherStormBodyController.UpdateBodyRotMessage.class, WitherStormBodyController.UpdateBodyRotMessage::encode, buffer -> Message.decode(WitherStormBodyController.UpdateBodyRotMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(5, WitherStormToDistantRendererMessage.class, WitherStormToDistantRendererMessage::encode, buffer -> Message.decode(() -> new WitherStormToDistantRendererMessage((FriendlyByteBuf)buffer), buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(6, RemoveStormFromDistantRendererMessage.class, RemoveStormFromDistantRendererMessage::encode, buffer -> Message.decode(RemoveStormFromDistantRendererMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(7, UpdateStormPositionMessage.class, UpdateStormPositionMessage::encode, buffer -> Message.decode(UpdateStormPositionMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(8, StormTeleportMessage.class, StormTeleportMessage::encode, buffer -> Message.decode(StormTeleportMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(9, UpdateStormVelocityMessage.class, UpdateStormVelocityMessage::encode, buffer -> Message.decode(UpdateStormVelocityMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(10, UpdateStormHeadLookMessage.class, UpdateStormHeadLookMessage::encode, buffer -> Message.decode(UpdateStormHeadLookMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(11, StormMetadataMessage.class, StormMetadataMessage::encode, buffer -> Message.decode(StormMetadataMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(12, StormAttributesMessage.class, StormAttributesMessage::encode, buffer -> Message.decode(StormAttributesMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(14, CreateLoopingSoundMessage.class, CreateLoopingSoundMessage::encode, buffer -> Message.decode(CreateLoopingSoundMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(15, StormSoundPositionMessage.class, StormSoundPositionMessage::encode, buffer -> Message.decode(StormSoundPositionMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(16, RemoveSoundLoopMessage.class, RemoveSoundLoopMessage::encode, buffer -> Message.decode(RemoveSoundLoopMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(19, NotifyHeadInjuryMessage.class, NotifyHeadInjuryMessage::encode, buffer -> Message.decode(NotifyHeadInjuryMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(20, InjureHeadMessage.class, InjureHeadMessage::encode, buffer -> Message.decode(InjureHeadMessage::new, buffer), WitherStormModPacketHandlers::receiveServerMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        MAIN.registerMessage(21, UpdateEffectInstanceMessage.class, UpdateEffectInstanceMessage::encode, buffer -> Message.decode(UpdateEffectInstanceMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(22, UpdateWitherSicknessTrackerMessage.class, UpdateWitherSicknessTrackerMessage::encode, buffer -> Message.decode(UpdateWitherSicknessTrackerMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(23, UpdatePlayDeadManagerMessage.class, UpdatePlayDeadManagerMessage::encode, buffer -> Message.decode(UpdatePlayDeadManagerMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(24, CreateDebrisMessage.class, CreateDebrisMessage::encode, buffer -> Message.decode(CreateDebrisMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(25, EntitySyncableDataMessage.class, EntitySyncableDataMessage::encode, buffer -> Message.decode(EntitySyncableDataMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(26, PlayAdditionalLoopingSoundMessage.class, PlayAdditionalLoopingSoundMessage::encode, buffer -> Message.decode(PlayAdditionalLoopingSoundMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(27, RemoveAdditionalLoopingSoundMessage.class, RemoveAdditionalLoopingSoundMessage::encode, buffer -> Message.decode(RemoveAdditionalLoopingSoundMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(28, ShakeScreenMessage.class, ShakeScreenMessage::encode, buffer -> Message.decode(ShakeScreenMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(29, FormidibombExplosionMessage.class, FormidibombExplosionMessage::encode, buffer -> Message.decode(FormidibombExplosionMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(31, UpdateDamagingProjectileMessage.class, UpdateDamagingProjectileMessage::encode, buffer -> Message.decode(UpdateDamagingProjectileMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(32, WitheredSymbiontEntity.SetSpellTimeMessage.class, WitheredSymbiontEntity.SetSpellTimeMessage::encode, buffer -> Message.decode(WitheredSymbiontEntity.SetSpellTimeMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(33, SyncConfigValueMessage.class, SyncConfigValueMessage::encode, buffer -> Message.decode(SyncConfigValueMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(34, CommandBlockEntity.ModeAnimationMessage.class, CommandBlockEntity.ModeAnimationMessage::encode, buffer -> Message.decode(CommandBlockEntity.ModeAnimationMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(35, TentacleEntity.UpdateAnimationMessage.class, TentacleEntity.UpdateAnimationMessage::encode, buffer -> Message.decode(TentacleEntity.UpdateAnimationMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        MAIN.registerMessage(36, BlindScreenMessage.class, BlindScreenMessage::encode, buffer -> Message.decode(BlindScreenMessage::new, buffer), WitherStormModPacketHandlers::receiveClientMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static <T extends Message<T>> void receiveClientMessage(T message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        LogicalSide sideReceived = context.getDirection().getReceptionSide();
        context.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            WitherStormModMessageHandlerClient.LOGGER.warn(message.toString() + " was received on the wrong side: " + sideReceived);
            return;
        }
        if (!message.isMessageValid()) {
            WitherStormModMessageHandlerClient.LOGGER.warn(message.toString() + " was invalid");
            return;
        }
        context.enqueueWork(message.getProcessor(message, context));
    }

    public static <T extends Message<T>> void receiveServerMessage(T message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        LogicalSide sideReceived = context.getDirection().getReceptionSide();
        context.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            WitherStormModMessageHandlerServer.LOGGER.warn(message.toString() + " was received on the wrong side: " + sideReceived);
            return;
        }
        if (!message.isMessageValid()) {
            WitherStormModMessageHandlerServer.LOGGER.warn(message.toString() + " was invalid");
            return;
        }
        ServerPlayer player = context.getSender();
        if (player == null) {
            WitherStormModMessageHandlerServer.LOGGER.warn("The sending player is not present when " + message.toString() + " was received");
            return;
        }
        context.enqueueWork(message.getProcessor(message, context));
    }
}

