/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.init;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.common.capability.EntityCapability;
import nonamecrackers2.witherstormmod.common.capability.PlayerWitherStormData;
import nonamecrackers2.witherstormmod.common.capability.WitherSicknessTracker;
import nonamecrackers2.witherstormmod.common.capability.WitherStormBowelsManager;
import nonamecrackers2.witherstormmod.common.capability.WitherStormChunkHolder;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;

public class WitherStormModCapabilities {
    public static Capability<WitherStormChunkHolder> WITHER_STORM_CHUNKS_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<WitherStormChunkHolder>(){});
    public static Capability<WitherSicknessTracker> WITHER_SICKNESS_TRACKER = CapabilityManager.get((CapabilityToken)new CapabilityToken<WitherSicknessTracker>(){});
    public static Capability<PlayerWitherStormData> PLAYER_WITHER_STORM_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerWitherStormData>(){});
    public static Capability<WitherStormBowelsManager> BOWELS_MANAGER = CapabilityManager.get((CapabilityToken)new CapabilityToken<WitherStormBowelsManager>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(WitherStormChunkHolder.class);
        event.register(WitherSicknessTracker.class);
        event.register(PlayerWitherStormData.class);
        event.register(WitherStormBowelsManager.class);
    }

    public static void attachWorldCapabilities(AttachCapabilitiesEvent<Level> event) {
        Level world = (Level)event.getObject();
        if (!world.f_46443_) {
            final LazyOptional stormChunk = LazyOptional.of(() -> new WitherStormChunkHolder((ServerLevel)world));
            event.addCapability(new ResourceLocation("witherstormmod", "storm_chunk_tracker"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

                public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
                    return capability == WITHER_STORM_CHUNKS_CAPABILITY ? stormChunk.cast() : LazyOptional.empty();
                }

                public Tag serializeNBT() {
                    return ((WitherStormChunkHolder)stormChunk.orElse(null)).write();
                }

                public void deserializeNBT(Tag nbt) {
                    ((WitherStormChunkHolder)stormChunk.orElse(null)).read((CompoundTag)nbt);
                }
            });
            event.addListener(() -> ((LazyOptional)stormChunk).invalidate());
            if (world.m_46472_().m_135782_().equals((Object)WitherStormMod.bowelsLocation())) {
                final LazyOptional bowelsManager = LazyOptional.of(() -> new WitherStormBowelsManager((ServerLevel)world));
                event.addCapability(new ResourceLocation("witherstormmod", "bowels_manager"), (ICapabilityProvider)new ICapabilitySerializable<Tag>(){

                    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
                        return capability == BOWELS_MANAGER ? bowelsManager.cast() : LazyOptional.empty();
                    }

                    public Tag serializeNBT() {
                        return ((WitherStormBowelsManager)bowelsManager.orElse(null)).write();
                    }

                    public void deserializeNBT(Tag nbt) {
                        ((WitherStormBowelsManager)bowelsManager.orElse(null)).read((CompoundTag)nbt);
                    }
                });
                event.addListener(() -> ((LazyOptional)bowelsManager).invalidate());
            }
        }
    }

    public static void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (!(entity instanceof AbstractSickenedEntity) && entity instanceof LivingEntity && WitherStormModConfig.SERVER.witherSicknessEnabled.get().booleanValue()) {
            LivingEntity living = (LivingEntity)entity;
            LazyOptional tracker = LazyOptional.of(() -> new WitherSicknessTracker(living));
            event.addCapability(new ResourceLocation("witherstormmod", "wither_sickness_tracker"), new EntityCapability.Serializable(WITHER_SICKNESS_TRACKER, tracker));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LazyOptional data = LazyOptional.of(() -> new PlayerWitherStormData(player));
            event.addCapability(new ResourceLocation("witherstormmod", "wither_storm_data"), new EntityCapability.Serializable(PLAYER_WITHER_STORM_DATA, data));
        }
    }
}

