/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.packet.CreateDebrisMessage;

public class WitherStormDebrisUpdater {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        WitherStormDebrisUpdater.createDebris((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        WitherStormDebrisUpdater.createDebris((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        WitherStormDebrisUpdater.createDebris((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        WitherStormDebrisUpdater.createDebris((ServerPlayer)event.getEntity(), event.getTarget());
    }

    public static void createDebris(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.f_19853_;
        for (Entity entity : world.m_8583_()) {
            if (!(entity instanceof WitherStormEntity)) continue;
            WitherStormEntity storm = (WitherStormEntity)entity;
            CreateDebrisMessage message = new CreateDebrisMessage(storm, storm.isDeadOrPlayingDead());
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        }
    }

    public static void createDebris(ServerPlayer player, Entity entity) {
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            CreateDebrisMessage message = new CreateDebrisMessage(storm, storm.isDeadOrPlayingDead());
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
        }
    }
}

