/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.event;

import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;

public class WitherStormChunkLoader {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).ifPresent(stormChunks -> {
                if (world.m_7654_().m_7416_() > 0) {
                    boolean flag = true;
                    for (Map.Entry<UUID, BlockPos> entry : stormChunks.getStormPositions().entrySet()) {
                        UUID uuid = entry.getKey();
                        for (Entity entity : world.m_8583_()) {
                            if (entity instanceof WitherStormEntity && entity.m_20148_().equals(uuid) && !entity.m_213877_()) {
                                storm = (WitherStormEntity)entity;
                                ChunkPos prevChunk = new ChunkPos(stormChunks.getPrevStormPositions().get(uuid));
                                ChunkPos chunk = new ChunkPos(stormChunks.getStormPositions().get(uuid));
                                if (chunk != prevChunk) {
                                    stormChunks.createChunkQueue(storm, chunk, true);
                                }
                                stormChunks.updateStormPosition(storm);
                            } else if (entity instanceof WitherStormEntity && entity.m_20148_().equals(uuid) && !entity.m_213877_()) {
                                storm = (WitherStormEntity)entity;
                                stormChunks.removeStorm(storm);
                            }
                            if (!entity.m_20148_().equals(uuid)) continue;
                            flag = false;
                        }
                        if (!stormChunks.getChunksToLoad().get(uuid).isEmpty()) {
                            flag = false;
                        }
                        if (!flag) continue;
                        stormChunks.removeStorm(uuid);
                    }
                }
                stormChunks.tick();
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (!server.m_129792_() && !WitherStormModConfig.SERVER.shouldChunkLoadWhenNoPlayers.get().booleanValue() && server.m_7416_() == 1) {
            for (ServerLevel world : server.m_129785_()) {
                world.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).ifPresent(stormChunks -> stormChunks.unloadAll());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = event.getEntity().m_20194_();
        if (!server.m_129792_() && !WitherStormModConfig.SERVER.shouldChunkLoadWhenNoPlayers.get().booleanValue() && server.m_7416_() == 1) {
            for (ServerLevel world : server.m_129785_()) {
                world.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).ifPresent(stormChunks -> {
                    for (Map.Entry<UUID, BlockPos> entry : stormChunks.getStormPositions().entrySet()) {
                        UUID uuid = entry.getKey();
                        BlockPos pos = entry.getValue();
                        ChunkPos chunk = new ChunkPos(pos);
                        world.m_46865_(pos);
                        stormChunks.createChunkQueue(uuid, chunk, false);
                    }
                });
            }
        }
    }
}

