/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.event;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;

public class PlayDeadManagerUpdater {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayDeadManagerUpdater.sendChanges((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onChangedDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayDeadManagerUpdater.sendChanges((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayDeadManagerUpdater.sendChanges((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        PlayDeadManagerUpdater.sendChanges((ServerPlayer)event.getEntity(), event.getTarget());
    }

    public static void sendChanges(ServerPlayer player) {
        ServerLevel world = (ServerLevel)player.f_19853_;
        for (Entity entity : world.m_8583_()) {
            if (!(entity instanceof WitherStormEntity)) continue;
            WitherStormEntity storm = (WitherStormEntity)entity;
            storm.getPlayDeadManager().sendChanges(PacketDistributor.PLAYER.with(() -> player), false);
        }
    }

    public static void sendChanges(ServerPlayer player, Entity entity) {
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            storm.getPlayDeadManager().sendChanges(PacketDistributor.PLAYER.with(() -> player), false);
        }
    }
}

