/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity.goal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.Team;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModAttributes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class WitherStormNearestAttackableTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final WitherStormEntity storm;
    private int unseenTicks;

    public WitherStormNearestAttackableTargetGoal(WitherStormEntity entity, Class<T> targetType, int interval, boolean mustSee, boolean mustReach, Predicate<LivingEntity> conditions) {
        super((Mob)entity, targetType, interval, mustSee, mustReach, conditions);
        this.storm = entity;
        this.f_26051_ = TargetingConditions.m_148352_().m_26888_(conditions).m_148355_();
    }

    public boolean m_8045_() {
        LivingEntity entity = this.storm.m_5448_();
        if (entity == null) {
            entity = this.f_26137_;
        }
        if (entity == null) {
            return false;
        }
        if (!entity.m_6084_()) {
            return false;
        }
        Team team = this.f_26135_.m_5647_();
        Team team1 = entity.m_5647_();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.m_7623_();
        if (this.f_26135_.m_20280_((Entity)entity) > d0 * d0) {
            return false;
        }
        if (this.f_26136_) {
            if (this.storm.canSee(0, (Entity)entity)) {
                this.unseenTicks = 0;
            } else if (++this.unseenTicks > this.f_26138_) {
                return false;
            }
        }
        if (entity instanceof Player && ((Player)entity).m_150110_().f_35934_) {
            return false;
        }
        this.storm.m_6710_(entity);
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.unseenTicks = 0;
    }

    protected AABB m_7255_(double range) {
        return this.storm.getPhase() > 3 ? this.f_26135_.m_20191_().m_82377_(range, range + 50.0, range) : this.f_26135_.m_20191_().m_82377_(range, range * 2.0, range);
    }

    public T findApplicableTarget() {
        double range = this.storm.getPhase() > 3 ? this.f_26135_.m_21133_(Attributes.f_22277_) : this.f_26135_.m_21133_((Attribute)WitherStormModAttributes.HUNCHBACK_FOLLOW_RANGE.get());
        List<LivingEntity> nearbyEntities = WorldUtil.getPerformantEntitiesOfClass((ServerLevel)this.f_26135_.f_19853_, this.f_26048_, this.m_7255_(range));
        ArrayList<LivingEntity> entitiesToSort = new ArrayList<LivingEntity>();
        for (LivingEntity entity : nearbyEntities) {
            if (!this.storm.targetApplicable(this.f_26048_, entity, 0)) continue;
            entitiesToSort.add(entity);
        }
        double d0 = -1.0;
        LivingEntity t = null;
        for (LivingEntity t1 : entitiesToSort) {
            double random;
            if (!this.f_26051_.m_26885_((LivingEntity)this.f_26135_, t1) || !this.storm.canSee(0, (Entity)t1)) continue;
            double d1 = t1.m_20275_(this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
            if (d0 == -1.0 || d1 < d0) {
                d0 = d1;
                t = t1;
            }
            if (!WitherStormModConfig.COMMON.playerFavorability.get().booleanValue() || !(t1 instanceof Player) || !((random = (double)this.storm.m_217043_().m_188503_(10)) <= (double)WitherStormModConfig.SERVER.playerPickupChance.get().intValue())) continue;
            t = t1;
            break;
        }
        return (T)t;
    }

    protected double m_7623_() {
        return this.f_26135_.m_21133_(Attributes.f_22277_) + 100.0;
    }

    protected void m_26073_() {
        Mob mob;
        this.f_26050_ = this.findApplicableTarget();
        if (this.f_26050_ instanceof Mob && this.storm.getHeadInjuryTicks(0) <= 0 && (mob = (Mob)this.f_26050_).m_6779_((LivingEntity)this.storm) && this.storm.getPhase() > 3) {
            mob.m_6710_((LivingEntity)this.storm);
        }
        if (this.f_26050_ != null) {
            this.f_26050_.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).ifPresent(tracker -> tracker.countContact());
        }
    }

    public void m_8037_() {
        if (this.f_26050_ != null) {
            if (this.storm.getPhase() > 3 && this.storm.isEntityBehindBack((Entity)this.f_26050_)) {
                this.f_26050_ = null;
                this.storm.m_6710_(null);
            }
            if (this.f_26050_ != null && !this.f_26050_.f_19853_.m_46472_().equals((Object)this.storm.f_19853_.m_46472_())) {
                this.f_26050_ = null;
                this.storm.m_6710_(null);
            }
        }
    }
}

