/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import nonamecrackers2.witherstormmod.client.init.WitherStormModClientCapabilities;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.CommandBlockEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModAttributes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;
import nonamecrackers2.witherstormmod.common.util.DebrisChunks;
import nonamecrackers2.witherstormmod.common.util.DebrisRingSettings;
import nonamecrackers2.witherstormmod.common.util.PlayDeadManager;
import nonamecrackers2.witherstormmod.common.util.SegmentsManager;
import nonamecrackers2.witherstormmod.common.util.TractorBeamHelper;

public class WitherStormSegmentEntity
extends WitherStormEntity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(WitherStormSegmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Nullable
    private WitherStormEntity parent;
    private EntityDimensions startingSize = EntityDimensions.m_20395_((float)15.0f, (float)17.5f);
    private EntityDimensions evolvedSize = EntityDimensions.m_20395_((float)15.0f, (float)17.5f);
    private int tillFreeFall;
    private int dropTime;
    private int nextDropTime = 120 + this.f_19796_.m_188503_(160);
    private int timeWithParent;

    public WitherStormSegmentEntity(EntityType<? extends WitherStormEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.f_21364_ = 0;
        this.partsEnabled = false;
        this.bossEvent = Optional.empty();
        this.shouldFollowUltimateTarget = false;
        this.chunkloads = false;
        this.segments = Optional.empty();
        this.headPosX = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0}, {-6.0, -6.0, -6.0, -6.0, -6.0, -6.0, -6.0, -6.0}};
        this.headPosY = new double[][]{{9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0}, {8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0}, {8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0, 8.0}};
        this.headPosZ = new double[][]{{14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0}, {12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0}, {12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0}};
        this.shouldPlaySoundLoop = false;
        this.shouldPlayGlobalSounds = false;
        this.shouldIgnoreFormidibomb = true;
        this.tillFreeFall = Math.max(220, this.f_19796_.m_188503_(260));
        this.summoningManager = Optional.empty();
        this.bowelsInstance = Optional.empty();
    }

    public WitherStormSegmentEntity(WitherStormEntity parent) {
        this((EntityType<? extends WitherStormEntity>)((EntityType)WitherStormModEntityTypes.WITHER_STORM_SEGMENT.get()), parent.f_19853_);
        this.setParent(parent);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_((Attribute)WitherStormModAttributes.TARGET_STATIONARY_FLYING_SPEED.get(), 0.4).m_22268_((Attribute)WitherStormModAttributes.SLOW_FLYING_SPEED.get(), 0.05).m_22268_((Attribute)WitherStormModAttributes.EVOLUTION_SPEED.get(), 1.0).m_22268_(Attributes.f_22280_, 0.0).m_22268_(Attributes.f_22276_, 4000.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 160.0).m_22268_((Attribute)WitherStormModAttributes.HUNCHBACK_FOLLOW_RANGE.get(), 40.0).m_22268_(Attributes.f_22284_, 6.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getParentUUID() != null) {
            compound.m_128362_("Parent", this.getParentUUID());
        }
        compound.m_128405_("TimeWithParent", this.timeWithParent);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Parent")) {
            this.setParentUUID(compound.m_128342_("Parent"));
        }
        this.timeWithParent = compound.m_128451_("TimeWithParent");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getParent() == null && this.getParentUUID() != null) {
            List entities = this.f_19853_.m_45976_(WitherStormEntity.class, this.m_20191_().m_82400_(1000.0));
            if (!this.f_19853_.f_46443_) {
                entities = Lists.newArrayList((Iterable)((ServerLevel)this.f_19853_).m_8583_());
            }
            for (Entity entity : entities) {
                if (!this.getParentUUID().equals(entity.m_20148_())) continue;
                WitherStormEntity storm = (WitherStormEntity)entity;
                this.setParent(storm);
            }
            if (this.isOnDistantRenderer()) {
                this.f_19853_.getCapability(WitherStormModClientCapabilities.DISTANT_RENDERER).ifPresent(renderer -> {
                    for (WitherStormEntity storm : renderer.getKnown()) {
                        if (!this.getParentUUID().equals(storm.m_20148_())) continue;
                        this.setParent(storm);
                    }
                });
            }
        }
        if (this.getParent() != null) {
            ++this.timeWithParent;
        }
    }

    @Override
    protected void m_8024_() {
        CommandBlockEntity commandBlock;
        Vec3 parent;
        super.m_8024_();
        if (this.getParent() != null && (parent = new Vec3(this.getParent().m_20185_() - this.m_20185_(), this.getParent().m_20186_() - this.m_20186_(), this.getParent().m_20189_() - this.m_20189_())).m_165924_() > 100.0) {
            Vec3 wanted = new Vec3(this.getParent().getDesiredSegmentX(this.isMirrored() ? 1 : 2), this.getParent().getDesiredSegmentY(this.isMirrored() ? 1 : 2), this.getParent().getDesiredSegmentZ(this.isMirrored() ? 1 : 2));
            this.m_20219_(wanted);
        }
        if ((commandBlock = this.getBowelsCommandBlock()) != null && commandBlock.m_21223_() < commandBlock.m_21233_()) {
            --this.nextDropTime;
            if (this.nextDropTime == 0) {
                this.dropTime = 10 + this.f_19796_.m_188503_(5);
                this.nextDropTime = (int)((double)(360 + this.f_19796_.m_188503_(160)) * Math.max(0.2, (double)(commandBlock.m_21223_() / commandBlock.m_21233_())));
            }
        }
        if (this.dropTime > 0) {
            --this.dropTime;
        }
    }

    @Override
    public double getHeightToAscendTo(Vec3 vector3d, double height, double ascendSpeed) {
        return this.getParent() != null ? this.getParent().getDesiredSegmentY(this.isMirrored() ? 1 : 2) : super.getHeightToAscendTo(vector3d, height, ascendSpeed);
    }

    @Override
    public double getFlyingSpeed(Vec3 ultimateTarget) {
        if (this.getParent() != null) {
            return this.getParent().m_21133_(Attributes.f_22280_) + (this.getParent().shouldSpeedUp() ? this.getParent().m_21133_((Attribute)WitherStormModAttributes.TARGET_STATIONARY_FLYING_SPEED.get()) + 0.05 : this.getParent().m_21133_((Attribute)WitherStormModAttributes.SLOW_FLYING_SPEED.get()) + 0.08);
        }
        return super.getFlyingSpeed(ultimateTarget);
    }

    @Override
    protected Vec3 doCustomFlying(Vec3 movement) {
        if (this.getParent() != null && !this.isDeadOrPlayingDead()) {
            Vec3 vector3d = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
            double height = 75.0;
            double ascendSpeed = 0.02;
            height = this.getParent().getDesiredSegmentY(this.isMirrored() ? 1 : 2);
            double d0 = vector3d.f_82480_;
            if (this.m_20186_() < height || !this.m_7090_() && this.m_20186_() < height + 5.0) {
                d0 = (height - this.m_20186_()) * ascendSpeed;
            }
            vector3d = new Vec3(vector3d.f_82479_, d0, vector3d.f_82481_);
            Vec3 wanted = new Vec3(this.getParent().getDesiredSegmentX(this.isMirrored() ? 1 : 2), this.getParent().getDesiredSegmentY(this.isMirrored() ? 1 : 2), this.getParent().getDesiredSegmentZ(this.isMirrored() ? 1 : 2));
            Vec3 vector3d1 = new Vec3(wanted.f_82479_ - this.m_20185_(), 0.0, wanted.f_82481_ - this.m_20189_());
            double speed = this.getFlyingSpeed(vector3d1);
            speed = Math.min(speed, Math.sqrt(this.m_20238_(wanted)) * 0.01);
            if (vector3d1.m_165924_() > 1.0) {
                Vec3 vector3d2 = vector3d1.m_82541_();
                vector3d = vector3d.m_82520_(vector3d2.f_82479_ * speed - vector3d.f_82479_ * 0.6, 0.0, vector3d2.f_82481_ * speed - vector3d.f_82481_ * 0.6);
            }
            return vector3d;
        }
        return super.doCustomFlying(movement);
    }

    @Override
    protected void m_6153_() {
        super.m_6153_();
        if (this.f_19853_.f_46443_ && !this.m_20096_()) {
            float xOffset = (this.f_19796_.m_188501_() - 0.5f) * ((float)this.m_20191_().m_82362_() + 5.0f);
            float yOffset = (this.f_19796_.m_188501_() - 0.5f) * ((float)this.m_20191_().m_82376_() + 5.0f);
            float zOffset = (this.f_19796_.m_188501_() - 0.5f) * ((float)this.m_20191_().m_82385_() + 5.0f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)xOffset, this.m_20188_() + (double)yOffset, this.m_20189_() + (double)zOffset, -5.0, 0.0, 0.0);
        }
        if (this.m_20096_()) {
            for (int i = 0; i < 3; ++i) {
                this.lerpHeadsXTo(i, 90.0f, 10.0f);
            }
        }
    }

    @Override
    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions size = this.getUnmodifiedDimensions(pose);
        if (WitherStormModConfig.SERVER.squashHitbox.get().booleanValue() && this.getPhase() > 3) {
            size = EntityDimensions.m_20395_((float)size.f_20377_, (float)1.0f);
        }
        return size;
    }

    @Override
    public EntityDimensions getUnmodifiedDimensions(Pose pose) {
        EntityDimensions size = this.startingSize;
        if (this.getPhase() == 7) {
            size = this.evolvedSize;
        }
        return size;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 10.0f;
    }

    @Override
    public boolean setPhase(int phase) {
        boolean result = false;
        if (this.getParent() != null) {
            result = false;
            this.f_19804_.m_135381_(PHASE, (Object)this.getParent().getPhase());
        } else if (phase <= 7) {
            this.f_19804_.m_135381_(PHASE, (Object)(phase < 6 ? 6 : phase));
            result = phase >= 6;
        } else {
            result = false;
        }
        this.clusterRadius = (int)Math.max(1.0, (double)((float)this.getPhase() * 0.75f));
        int n = this.entityConsumptionRadius = this.getPhase() > 3 ? 64 : 16;
        this.consumptionAmountTillPhaseChange = (int)(this.getPhase() > 3 ? (100.0 * (double)(this.getPhase() - 1 < 0 ? 0 : this.getPhase() - 1) * ((double)(this.getPhase() - 1 < 0 ? 0 : this.getPhase() - 1) * 2.0) * (double)(this.clusterRadius * this.clusterRadius * this.clusterRadius) + Math.max(100.0, 100.0 * (double)this.getPhase() * ((double)this.getPhase() * 2.0) * (double)(this.clusterRadius * this.clusterRadius * this.clusterRadius))) * 3.0 : 100.0 * (double)(this.getPhase() - 1 < 0 ? 0 : this.getPhase() - 1) * ((double)(this.getPhase() - 1 < 0 ? 0 : this.getPhase() - 1) * 2.0) * (double)(this.clusterRadius * this.clusterRadius * this.clusterRadius) + Math.max(100.0, 100.0 * (double)this.getPhase() * ((double)this.getPhase() * 2.0) * (double)(this.clusterRadius * this.clusterRadius * this.clusterRadius)));
        this.m_20090_();
        this.m_6210_();
        return result;
    }

    @Override
    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public void setParent(WitherStormEntity parent) {
        this.parent = parent;
        if (parent != null) {
            this.f_19804_.m_135381_(PARENT_UUID, Optional.of(parent.m_20148_()));
            this.getPlayDeadManager().setStateRaw(this.getParent().getPlayDeadManager().getState());
            this.getPlayDeadManager().setTickAmount(this.getParent().getPlayDeadManager().getTicks());
        } else {
            this.f_19804_.m_135381_(PARENT_UUID, Optional.empty());
        }
    }

    protected void setParentUUID(UUID uuid) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.of(uuid));
    }

    @Nullable
    public UUID getParentUUID() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    @Nullable
    public WitherStormEntity getParent() {
        return this.parent;
    }

    @Override
    public ServerPlayer getUltimateTarget() {
        return this.getParent() != null ? this.getParent().getUltimateTarget() : null;
    }

    @Override
    public Vec3 getAlternativeUltimateTarget() {
        return this.getParent() != null ? this.getParent().getAlternativeUltimateTarget() : null;
    }

    @Override
    public int getConsumedEntities() {
        return this.getParent() != null ? this.getParent().getConsumedEntities() : 0;
    }

    @Override
    public void setConsumedEntities(int newAmount) {
    }

    @Override
    public void addToConsumedEntities(int amount) {
    }

    @Override
    public int getInvulnerableTicks() {
        return this.getParent() != null ? this.getParent().getInvulnerableTicks() : 0;
    }

    @Override
    public void setInvulnerableTicks(int ticks) {
    }

    @Override
    public boolean targetInUseBySegment(Entity entity) {
        if (this.getParent() != null) {
            for (int i = 1; i < 3; ++i) {
                if (this.getParent().getAlternativeTarget(i) == null || this.getParent().getAlternativeTarget(i).m_19879_() != entity.m_19879_()) continue;
                return true;
            }
            if (this.getParent().m_5448_() != null && this.getParent().m_5448_().equals((Object)entity)) {
                return true;
            }
            Optional<SegmentsManager> manager = this.getParent().getSegmentsManager();
            if (manager.isPresent()) {
                WitherStormSegmentEntity[] segments = manager.get().getSegments();
                for (int i = 0; i < segments.length; ++i) {
                    if (segments[i] == null || segments[i].equals(this)) continue;
                    for (int j = 1; j < 3; ++j) {
                        if (segments[i].getAlternativeTarget(j) == null || segments[i].getAlternativeTarget(j).m_19879_() != entity.m_19879_()) continue;
                        return true;
                    }
                    if (segments[i].m_5448_() == null || !segments[i].m_5448_().equals((Object)entity)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<DebrisChunks> createDebris(boolean hidden) {
        int debrisChunks = Math.max(500, this.f_19796_.m_188503_(600));
        DebrisChunks debris = new DebrisChunks(hidden, debrisChunks, 50.0f, 0.0f, 6);
        this.debris = ImmutableList.of((Object)debris);
        return this.debris;
    }

    @Override
    public List<DebrisRingSettings> createDebrisRings(boolean hidden) {
        return this.debrisRings;
    }

    public int getTimeTillFreeFall() {
        return this.tillFreeFall;
    }

    @Override
    public void onBigFall() {
        super.onBigFall();
        Explosion.BlockInteraction explosionMode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
        for (int i = 0; i < 6; ++i) {
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20188_() - (double)i, this.m_20189_(), 16.0f, false, explosionMode);
        }
    }

    public void regatherCapabilities() {
        this.gatherCapabilities();
    }

    @Override
    public boolean shouldDoCustomMovement() {
        PlayDeadManager.State state = this.getPlayDeadManager().getState();
        if (this.dropTime > 0) {
            return false;
        }
        if (this.getDeathTime() >= this.getTimeTillFreeFall()) {
            return false;
        }
        if (state == PlayDeadManager.State.FALLING && this.getPlayDeadManager().getTicks() > 200) {
            return false;
        }
        return this.shouldDoCustomMovement;
    }

    @Override
    public boolean canFallOnBack() {
        return false;
    }

    @Override
    public Vec3 getUltimateTargetPos() {
        return this.getParent() != null ? this.getParent().getUltimateTargetPos() : super.getUltimateTargetPos();
    }

    @Override
    public BlockPos getUltimateTargetDistractedPos() {
        return this.getParent() != null ? this.getParent().getUltimateTargetDistractedPos() : super.getUltimateTargetDistractedPos();
    }

    @Override
    public boolean isDistractedFromUltimateTarget() {
        return this.getParent() != null ? this.getParent().isDistractedFromUltimateTarget() : false;
    }

    @Override
    public CommandBlockEntity getBowelsCommandBlock() {
        return this.getParent() != null ? this.getParent().getBowelsCommandBlock() : super.getBowelsCommandBlock();
    }

    @Override
    public void dropDropsAt(Entity player) {
    }

    @Override
    protected boolean canTrackEntity(Entity entity) {
        if (!super.canTrackEntity(entity)) {
            return false;
        }
        return this.getParent() == null || !this.getParent().currentTrackedEntities.contains(entity);
    }

    @Override
    public boolean isBeingTornApart() {
        return this.getParent() != null ? this.getParent().isBeingTornApart() : super.isBeingTornApart();
    }

    public int getTimeWithParent() {
        return this.timeWithParent;
    }

    @Override
    protected boolean isInsideOtherTractorBeam(LivingEntity entity, int head) {
        if (this.getParent() != null) {
            ArrayList storms = Lists.newArrayList((Object[])new WitherStormEntity[]{this.getParent()});
            this.getParent().getSegmentsManager().ifPresent(manager -> {
                for (WitherStormSegmentEntity segment : manager.getSegments()) {
                    if (segment == null || !segment.m_6084_()) continue;
                    storms.add(segment);
                }
            });
            for (WitherStormEntity storm : storms) {
                Pair<Boolean, Integer> flag = TractorBeamHelper.isInsideTractorBeam((Entity)entity, storm, 5.0);
                if (!((Boolean)flag.getFirst()).booleanValue() || (Integer)flag.getSecond() == head) continue;
                return true;
            }
            return false;
        }
        return super.isInsideOtherTractorBeam(entity, head);
    }

    @Override
    public void dropMassCluster(int radius) {
    }

    @Override
    protected boolean isCompletelyInvulnerable() {
        return true;
    }
}

