/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.client.capability.WitherStormLoopingSoundManager;
import nonamecrackers2.witherstormmod.common.blockentity.FormidibombTileEntity;
import nonamecrackers2.witherstormmod.common.capability.PlayerWitherStormData;
import nonamecrackers2.witherstormmod.common.capability.WitherStormBowelsManager;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;
import nonamecrackers2.witherstormmod.common.entity.BlockClusterEntity;
import nonamecrackers2.witherstormmod.common.entity.CommandBlockEntity;
import nonamecrackers2.witherstormmod.common.entity.FlamingWitherSkullEntity;
import nonamecrackers2.witherstormmod.common.entity.FormidibombEntity;
import nonamecrackers2.witherstormmod.common.entity.IBossTheme;
import nonamecrackers2.witherstormmod.common.entity.IDistractable;
import nonamecrackers2.witherstormmod.common.entity.IPlayDead;
import nonamecrackers2.witherstormmod.common.entity.TentacleEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormBase;
import nonamecrackers2.witherstormmod.common.entity.WitherStormHeadEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.entity.WitheredSymbiontEntity;
import nonamecrackers2.witherstormmod.common.entity.goal.AdditionalHeadLookAtDistractionGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.AdditionalHeadLookAtTargetGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.AdditionalHeadTargetGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.DoNothingGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.FindNearestFormidibombGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.LookAtDistractionGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.LookAtFormidibombGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.RemovableGoals;
import nonamecrackers2.witherstormmod.common.entity.goal.RemovableGoalsManager;
import nonamecrackers2.witherstormmod.common.entity.goal.WitherStormLookAtTargetGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.WitherStormLookRandomlyGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.WitherStormNearestAttackableTargetGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.WitherStormNearestDistractionGoal;
import nonamecrackers2.witherstormmod.common.entity.goal.WitherStormRangedAttackGoal;
import nonamecrackers2.witherstormmod.common.entity.section.CollisionActionSection;
import nonamecrackers2.witherstormmod.common.entity.section.FallingSection;
import nonamecrackers2.witherstormmod.common.entity.section.Section;
import nonamecrackers2.witherstormmod.common.init.WitherStormModAttributes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModBlocks;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModItems;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.init.WitherStormModParticleTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModSoundEvents;
import nonamecrackers2.witherstormmod.common.item.FormidibombItem;
import nonamecrackers2.witherstormmod.common.packet.CreateDebrisMessage;
import nonamecrackers2.witherstormmod.common.packet.CreateLoopingSoundMessage;
import nonamecrackers2.witherstormmod.common.packet.GlobalSoundMessage;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.packet.PlayerMotionMessage;
import nonamecrackers2.witherstormmod.common.packet.RemoveSoundLoopMessage;
import nonamecrackers2.witherstormmod.common.packet.ShakeScreenMessage;
import nonamecrackers2.witherstormmod.common.packet.StormSoundPositionMessage;
import nonamecrackers2.witherstormmod.common.serializer.WitherStormModDataSerializers;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModBlockTags;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModItemTags;
import nonamecrackers2.witherstormmod.common.util.AttributeModifierSnapshot;
import nonamecrackers2.witherstormmod.common.util.BowelsInstanceManager;
import nonamecrackers2.witherstormmod.common.util.DebrisChunks;
import nonamecrackers2.witherstormmod.common.util.DebrisRingSettings;
import nonamecrackers2.witherstormmod.common.util.DistantRendererManager;
import nonamecrackers2.witherstormmod.common.util.HeadInjuryManager;
import nonamecrackers2.witherstormmod.common.util.IEntitySyncableData;
import nonamecrackers2.witherstormmod.common.util.IFormidibomb;
import nonamecrackers2.witherstormmod.common.util.PlayDeadManager;
import nonamecrackers2.witherstormmod.common.util.SegmentsManager;
import nonamecrackers2.witherstormmod.common.util.SummoningManager;
import nonamecrackers2.witherstormmod.common.util.TractorBeamHelper;
import nonamecrackers2.witherstormmod.common.util.UltimateTargetManager;
import nonamecrackers2.witherstormmod.common.util.WitherStormBodyController;
import nonamecrackers2.witherstormmod.common.util.WitherStormLookController;
import nonamecrackers2.witherstormmod.common.util.WitherStormModNBTUtil;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class WitherStormEntity
extends Monster
implements RangedAttackMob,
PowerableMob,
IEntitySyncableData,
IBossTheme,
IDistractable,
WitherStormBase,
IPlayDead {
    protected static final EntityDataAccessor<Integer> INVULNERABLE = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> STARTING_INVULNERABLE = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<Vec3>> TARGET_A = SynchedEntityData.m_135353_(WitherStormEntity.class, WitherStormModDataSerializers.OPTIONAL_VECTOR_3D);
    private static final EntityDataAccessor<Optional<Vec3>> TARGET_B = SynchedEntityData.m_135353_(WitherStormEntity.class, WitherStormModDataSerializers.OPTIONAL_VECTOR_3D);
    private static final EntityDataAccessor<Optional<Vec3>> TARGET_C = SynchedEntityData.m_135353_(WitherStormEntity.class, WitherStormModDataSerializers.OPTIONAL_VECTOR_3D);
    private static final EntityDataAccessor<Integer> CONSUMED_ENTITIES = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAN_ROAR_A = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_ROAR_B = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_ROAR_C = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BITE_A = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BITE_B = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BITE_C = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> OTHER_HEADS_DISABLED = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MIRRORED = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_TARGET_ID = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHOULD_SHOW_HOLE = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final List<EntityDataAccessor<Boolean>> HEAD_ROARS = ImmutableList.of(CAN_ROAR_A, CAN_ROAR_B, CAN_ROAR_C);
    protected static final List<EntityDataAccessor<Boolean>> HEADS_BITING = ImmutableList.of(CAN_BITE_A, CAN_BITE_B, CAN_BITE_C);
    protected static final List<EntityDataAccessor<Optional<Vec3>>> TARGETS = ImmutableList.of(TARGET_A, TARGET_B, TARGET_C);
    public static final EntityDataAccessor<Integer> HURT_HEAD_TIME_0 = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HURT_HEAD_TIME_1 = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HURT_HEAD_TIME_2 = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final List<EntityDataAccessor<Integer>> HURT_HEAD_TIME = ImmutableList.of(HURT_HEAD_TIME_0, HURT_HEAD_TIME_1, HURT_HEAD_TIME_2);
    public static final EntityDataAccessor<Integer> INJURE_ATTEMPT_COOLDOWN_0 = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> INJURE_ATTEMPT_COOLDOWN_1 = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> INJURE_ATTEMPT_COOLDOWN_2 = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final List<EntityDataAccessor<Integer>> INJURE_ATTEMPT_COOLDOWN = ImmutableList.of(INJURE_ATTEMPT_COOLDOWN_0, INJURE_ATTEMPT_COOLDOWN_1, INJURE_ATTEMPT_COOLDOWN_2);
    public static final EntityDataAccessor<Integer> TIME = SynchedEntityData.m_135353_(WitherStormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("9B8DA22B-138B-4B68-879D-3FD329FAF903");
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("C806DBFA-2B10-4BEA-B16C-C3233707399C");
    private static final SimpleWeightedRandomList<Block> OUTSIDE = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_FLESH_BLOCK.get()), 20).m_146271_((Object)((Block)WitherStormModBlocks.INFECTED_FLESH_BLOCK.get()), 3).m_146270_();
    private static final SimpleWeightedRandomList<Block> BLOCKS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_FLESH_BLOCK.get()), 20).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_SAND.get()), 15).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_COBBLESTONE.get()), 10).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_STONE.get()), 10).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_PLANKS.get()), 8).m_146271_((Object)((Block)WitherStormModBlocks.INFECTED_FLESH_BLOCK.get()), 5).m_146270_();
    private static final SimpleWeightedRandomList<Block> DECORATION = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_DUST.get()), 10).m_146271_((Object)((Block)WitherStormModBlocks.TAINTED_MUSHROOM.get()), 5).m_146270_();
    private int lastConsumedEntities;
    protected int consumptionAmountTillPhaseChange = 100;
    private LivingEntity[] targets = new LivingEntity[]{null, null, null};
    private Vec3[] distractedPositions = new Vec3[]{null, null, null};
    public final float[] xRotHeads = new float[2];
    public final float[] yRotHeads = new float[2];
    public final float[] xRotOHeads = new float[2];
    public final float[] yRotOHeads = new float[2];
    protected final float[] lerpXRotHeads = new float[3];
    protected final float[] lerpYRotHeads = new float[3];
    protected final float[] lerpXRotHeadsSteps = new float[3];
    protected final float[] lerpYRotHeadsSteps = new float[3];
    protected final float[] mouthAnim = new float[3];
    protected final float[] mouthAnimO = new float[3];
    protected final float[] jawBrokenAnimation = new float[3];
    protected final float[] jawBrokenAnimationO = new float[3];
    private int tentacleTickCount;
    private int tentacleTickCountO;
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private final int[] nextClusterPickup = new int[3];
    private final int[] idleClusterPickup = new int[3];
    protected Vec3[] headPos = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_};
    protected Vec3[] headPosO = new Vec3[]{Vec3.f_82478_, Vec3.f_82478_, Vec3.f_82478_};
    public double[][] headPosX = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {-1.3, -1.3, -1.3, -1.3, -12.0, -12.0, -12.0, -12.0}, {1.3, 1.3, 1.3, 1.3, 8.5, 8.5, 8.5, 8.5}};
    public double[][] headPosY = new double[][]{{3.0, 3.0, 2.75, 2.75, 12.0, 12.0, 12.0, 12.0}, {2.2, 2.2, 2.2, 2.2, 22.5, 22.5, 22.5, 22.5}, {2.2, 2.2, 2.2, 2.2, 24.5, 24.5, 24.5, 24.5}};
    public double[][] headPosZ = new double[][]{{0.0, 0.0, 0.5, 0.5, 10.0, 10.0, 10.0, 10.0}, {0.0, 0.0, 0.0, 0.0, 10.0, 10.0, 10.0, 10.0}, {0.0, 0.0, 0.0, 0.0, 16.0, 16.0, 16.0, 16.0}};
    private int destroyBlocksTick;
    protected final HeadInjuryManager headInjuries;
    protected int entityConsumptionRadius = 16;
    protected int clusterRadius = 1;
    public int[] nextRoarTick = new int[3];
    public int[] roarTicks = new int[3];
    public int[] biteTicks = new int[3];
    public int idleTargetTicks;
    List<Entity> currentTrackedEntities = new ArrayList<Entity>();
    List<Player> playersToHurt = new ArrayList<Player>();
    protected Optional<ServerBossEvent> bossEvent = Optional.of((ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true));
    public static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> entity.m_5789_() && entity.m_6095_() != EntityType.f_20566_ && !(entity instanceof WitherBoss) && !(entity instanceof FlyingMob) && !(entity instanceof EnderDragon) && !(entity instanceof WitherStormEntity) && !(entity instanceof AbstractSickenedEntity) && !(entity instanceof CommandBlockEntity) && !(entity instanceof WitheredSymbiontEntity) && !(entity instanceof WitherStormHeadEntity) && !(entity instanceof TentacleEntity) && !(entity instanceof AmbientCreature);
    public static final Predicate<Entity> DISTRACTION_SELECTOR = entity -> entity instanceof FireworkRocketEntity;
    public static final Predicate<Entity> TRACTOR_BEAM_PULLABLE = entity -> entity.m_6095_() == EntityType.f_20515_ || entity instanceof Boat || entity instanceof AbstractMinecart;
    private EntityDimensions startingSize = EntityDimensions.m_20395_((float)0.9f, (float)3.5f);
    private EntityDimensions destroyerSize = EntityDimensions.m_20395_((float)10.0f, (float)30.0f);
    private EntityDimensions evolvedDestroyerSize = EntityDimensions.m_20395_((float)10.0f, (float)60.0f);
    private EntityDimensions devourerSize = EntityDimensions.m_20395_((float)15.0f, (float)90.0f);
    private EntityDimensions evolvedDevourerSize = EntityDimensions.m_20395_((float)15.0f, (float)120.0f);
    public boolean chunkloads = true;
    protected Section[] sections = new Section[3];
    private FallingSection fallingSection;
    public boolean partsEnabled = true;
    public boolean shouldFollowUltimateTarget = true;
    protected Optional<SegmentsManager> segments;
    private double[] segmentDesiredX = new double[]{75.0, 75.0};
    private double[] segmentDesiredZ = new double[]{30.0, -30.0};
    public boolean shouldPlaySoundLoop = true;
    public boolean hasDistantImpulse;
    public boolean distanceHurtMarked;
    public final DistantRendererManager distantUpdater;
    public boolean shouldPlayGlobalSounds = true;
    public final UltimateTargetManager targetManager;
    public int witherStormDeathTime;
    public boolean shouldDoCustomMovement = true;
    protected List<DebrisChunks> debris = ImmutableList.of();
    protected List<DebrisRingSettings> debrisRings = ImmutableList.of();
    private boolean isOnDistantRenderer;
    private final PlayDeadManager playDeadManager;
    protected float onGroundAnimation;
    protected float onGroundAnimationO;
    public float xBodyRot;
    public float xBodyRotO;
    public boolean shouldIgnoreFormidibomb;
    protected Optional<SummoningManager> summoningManager;
    protected final int[] distractedTime = new int[3];
    private List<GoalSelector> headGoalSelectors;
    private List<GoalSelector> headTargetSelectors;
    protected Optional<BowelsInstanceManager> bowelsInstance;
    private int flickerTime;
    private int nextFlicker = 40;
    private boolean shouldFlicker;
    public RemovableGoalsManager removableGoals;
    public static final String[] REMOVABLE_LOOK_GOALS = new String[]{"lookGoals0", "lookGoals1", "lookGoals2"};
    public static final String[] REMOVABLE_TARGET_GOALS = new String[]{"targetGoals0", "targetGoals1", "targetGoals2"};

    public WitherStormEntity(EntityType<? extends WitherStormEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_21153_(this.m_21233_());
        this.m_21573_().m_7008_(true);
        this.f_21364_ = 10000;
        this.f_19811_ = true;
        this.f_21365_ = new WitherStormLookController(this);
        this.buildSections();
        this.segments = Optional.of(new SegmentsManager(this));
        this.distantUpdater = new DistantRendererManager(this);
        this.targetManager = new UltimateTargetManager(this);
        this.playDeadManager = new PlayDeadManager(this);
        this.summoningManager = Optional.of(new SummoningManager(this));
        this.bowelsInstance = Optional.of(new BowelsInstanceManager(this));
        this.headInjuries = new HeadInjuryManager(this);
    }

    protected void buildSections() {
        this.sections[0] = new Section(this, 30.0f, 15.0f, 13.0, 28.0, 0.0, 4);
        this.sections[1] = new Section(this, 30.0f, 15.0f, -13.0, 28.0, 0.0, 4);
        this.fallingSection = new FallingSection(this, 50.0f, 70.0f, 0.0, 60.0, 30.0, 4);
        this.sections[2] = new CollisionActionSection(this, 16.0f, 16.0f, -3.0, 34.0, -24.0, storm -> storm.isBeingTornApart() && storm.getPhase() >= 7, entity -> {
            if (!(this.f_19853_.f_46443_ || entity instanceof BlockClusterEntity || this.alreadyATarget((Entity)entity, true))) {
                if (entity instanceof ThrownEnderpearl) {
                    ThrownEnderpearl pearl = (ThrownEnderpearl)entity;
                    Entity owner = pearl.m_37282_();
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        if (player.f_8906_.m_6198_().m_129536_() && player.f_19853_ == pearl.f_19853_ && !player.m_5803_()) {
                            if (player.m_20159_()) {
                                player.m_8127_();
                            }
                            player.m_6021_(pearl.m_20185_(), pearl.m_20186_(), pearl.m_20189_());
                            player.f_19789_ = 0.0f;
                            player.m_6469_(DamageSource.f_19315_, 5.0f);
                            this.sendToBowels(owner);
                        }
                    } else if (owner != null) {
                        owner.m_6021_(pearl.m_20185_(), pearl.m_20186_(), pearl.m_20189_());
                        owner.f_19789_ = 0.0f;
                        this.sendToBowels(owner);
                    }
                    pearl.m_146870_();
                } else {
                    this.sendToBowels((Entity)entity);
                }
            }
        }).setColor(0.0f, 1.0f, 1.0f);
    }

    protected BodyRotationControl m_7560_() {
        return new WitherStormBodyController(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVULNERABLE, (Object)0);
        this.f_19804_.m_135372_(STARTING_INVULNERABLE, (Object)(WitherStormModConfig.SERVER.invulnerabilityTime.get() * 20));
        this.f_19804_.m_135372_(PHASE, (Object)0);
        this.f_19804_.m_135372_(TARGET_A, Optional.empty());
        this.f_19804_.m_135372_(TARGET_B, Optional.empty());
        this.f_19804_.m_135372_(TARGET_C, Optional.empty());
        this.f_19804_.m_135372_(CONSUMED_ENTITIES, (Object)0);
        this.f_19804_.m_135372_(CAN_ROAR_A, (Object)false);
        this.f_19804_.m_135372_(CAN_ROAR_C, (Object)false);
        this.f_19804_.m_135372_(CAN_ROAR_B, (Object)false);
        this.f_19804_.m_135372_(OTHER_HEADS_DISABLED, (Object)false);
        this.f_19804_.m_135372_(MIRRORED, (Object)false);
        this.f_19804_.m_135372_(CAN_BITE_A, (Object)false);
        this.f_19804_.m_135372_(CAN_BITE_B, (Object)false);
        this.f_19804_.m_135372_(CAN_BITE_C, (Object)false);
        this.f_19804_.m_135372_(DATA_TARGET_ID, (Object)0);
        this.f_19804_.m_135372_(SHOULD_SHOW_HOLE, (Object)false);
        this.f_19804_.m_135372_(HURT_HEAD_TIME_0, (Object)0);
        this.f_19804_.m_135372_(HURT_HEAD_TIME_1, (Object)0);
        this.f_19804_.m_135372_(HURT_HEAD_TIME_2, (Object)0);
        this.f_19804_.m_135372_(INJURE_ATTEMPT_COOLDOWN_0, (Object)0);
        this.f_19804_.m_135372_(INJURE_ATTEMPT_COOLDOWN_1, (Object)0);
        this.f_19804_.m_135372_(INJURE_ATTEMPT_COOLDOWN_2, (Object)0);
        this.f_19804_.m_135372_(TIME, (Object)320);
    }

    protected void m_8099_() {
        this.headGoalSelectors = ImmutableList.builder().add((Object)new GoalSelector(this.f_19853_.m_46658_())).add((Object)new GoalSelector(this.f_19853_.m_46658_())).build();
        this.headTargetSelectors = ImmutableList.builder().add((Object)new GoalSelector(this.f_19853_.m_46658_())).add((Object)new GoalSelector(this.f_19853_.m_46658_())).build();
        this.removableGoals = new RemovableGoalsManager();
        this.f_21345_.m_25352_(0, (Goal)new DoNothingGoal(this, 0));
        this.removableGoals.put(REMOVABLE_LOOK_GOALS[0], RemovableGoals.Builder.builder().put(1, new LookAtFormidibombGoal(this)).put(2, new LookAtDistractionGoal<WitherStormEntity>(this)).put(3, (Goal)new WitherStormRangedAttackGoal(this, 1.0, 40, 20.0f)).put(3, new WitherStormLookAtTargetGoal((Mob)this)).put(6, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 12.0f)).build(this.f_21345_));
        this.f_21345_.m_25352_(7, (Goal)new WitherStormLookRandomlyGoal(this, 0, 120));
        this.removableGoals.put(REMOVABLE_TARGET_GOALS[0], RemovableGoals.Builder.builder().put(0, (Goal)new FindNearestFormidibombGoal(this, 0)).put(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0])).put(2, new WitherStormNearestDistractionGoal(this, 0, DISTRACTION_SELECTOR, 8)).put(3, (Goal)new WitherStormNearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR)).build(this.f_21346_));
        this.addHeadGoals((selector, head) -> {
            selector.m_25352_(0, (Goal)new DoNothingGoal(this, (int)head));
            this.removableGoals.put(REMOVABLE_LOOK_GOALS[head], RemovableGoals.Builder.builder().put(1, new AdditionalHeadLookAtDistractionGoal(this, (int)head)).put(2, new AdditionalHeadLookAtTargetGoal(this, (int)head)).build((GoalSelector)selector));
            selector.m_25352_(3, (Goal)new WitherStormLookRandomlyGoal(this, (int)head, 120));
        });
        this.addHeadTargetGoals((selector, head) -> this.removableGoals.put(REMOVABLE_TARGET_GOALS[head], RemovableGoals.Builder.builder().put(0, new WitherStormNearestDistractionGoal(this, (int)head, DISTRACTION_SELECTOR, 8)).put(1, (Goal)new AdditionalHeadTargetGoal<LivingEntity>(this, (int)head, LivingEntity.class, 0, false, false, LIVING_ENTITY_SELECTOR)).build((GoalSelector)selector)));
    }

    protected void addHeadGoals(BiConsumer<GoalSelector, Integer> goals) {
        for (int i = 0; i < this.headGoalSelectors.size(); ++i) {
            goals.accept(this.headGoalSelectors.get(i), i + 1);
        }
    }

    protected void addHeadTargetGoals(BiConsumer<GoalSelector, Integer> goals) {
        for (int i = 0; i < this.headTargetSelectors.size(); ++i) {
            goals.accept(this.headTargetSelectors.get(i), i + 1);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_((Attribute)WitherStormModAttributes.TARGET_STATIONARY_FLYING_SPEED.get(), 0.4).m_22268_((Attribute)WitherStormModAttributes.SLOW_FLYING_SPEED.get(), 0.02).m_22268_((Attribute)WitherStormModAttributes.EVOLUTION_SPEED.get(), 1.0).m_22268_(Attributes.f_22280_, 0.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.6).m_22268_(Attributes.f_22277_, 120.0).m_22268_((Attribute)WitherStormModAttributes.HUNCHBACK_FOLLOW_RANGE.get(), 40.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22281_, 3.5);
    }

    public boolean shouldSpeedUp() {
        if (WitherStormModConfig.SERVER.shouldAccelerateWhenTargetStopped.get().booleanValue()) {
            return this.targetManager.isTargetStationary() && this.m_20238_(this.targetManager.getUltimateTargetPos()) > 15000.0;
        }
        return false;
    }

    public double getFlyingSpeed(Vec3 ultimateTarget) {
        if (this.getPhase() > 3) {
            return this.m_21133_(Attributes.f_22280_) + (this.shouldSpeedUp() ? Math.min(this.m_21133_((Attribute)WitherStormModAttributes.TARGET_STATIONARY_FLYING_SPEED.get()), Math.sqrt(this.m_20238_(this.targetManager.getUltimateTargetPos())) * 0.001) : (ultimateTarget.m_165925_() > 42000.0 ? this.m_21133_((Attribute)WitherStormModAttributes.SLOW_FLYING_SPEED.get()) + 0.03 : this.m_21133_((Attribute)WitherStormModAttributes.SLOW_FLYING_SPEED.get())));
        }
        return this.m_21133_((Attribute)WitherStormModAttributes.SLOW_FLYING_SPEED.get());
    }

    public void m_8107_() {
        int i;
        Vec3 vector3d = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
        if (!this.f_19853_.f_46443_ && !this.shouldDoNothing()) {
            this.targetManager.tick();
            this.summoningManager.ifPresent(manager -> manager.tick());
            if (!this.isDeadOrPlayingDead()) {
                double height = 10.0;
                double ascendSpeed = 0.02;
                if (this.getPhase() > 3) {
                    height = WitherStormModConfig.SERVER.flyingHeight.get().intValue();
                    ascendSpeed = 0.005;
                }
                double finalHeight = this.getHeightToAscendTo(vector3d, height, ascendSpeed);
                vector3d = new Vec3(vector3d.f_82479_, finalHeight, vector3d.f_82481_);
                if (this.m_5448_() != null && this.getPhase() < 4) {
                    LivingEntity entity = this.m_5448_();
                    Vec3 vector3d1 = new Vec3(entity.m_20185_() - this.m_20185_(), 0.0, entity.m_20189_() - this.m_20189_());
                    if (vector3d1.m_165925_() > 9.0) {
                        Vec3 vector3d2 = vector3d1.m_82541_();
                        vector3d = vector3d.m_82520_(vector3d2.f_82479_ * 0.3 - vector3d.f_82479_ * 0.6, 0.0, vector3d2.f_82481_ * 0.3 - vector3d.f_82481_ * 0.6);
                    }
                } else if (!this.isNearbyTickingFormidibomb() && this.shouldTrackUltimateTarget() && (this.m_5448_() == null || this.getPhase() > 3)) {
                    Vec3 pos;
                    double minDistance = 12000.0;
                    if (this.getPhase() > 3) {
                        minDistance = 6000.0;
                    }
                    if ((pos = this.getUltimateTargetPos()) != null) {
                        vector3d = new Vec3(vector3d.f_82479_, finalHeight, vector3d.f_82481_);
                        Vec3 vector3d1 = new Vec3(pos.m_7096_() - this.m_20185_(), 0.0, pos.m_7094_() - this.m_20189_());
                        double speed = this.getFlyingSpeed(vector3d1);
                        if (vector3d1.m_165925_() > minDistance) {
                            Vec3 vector3d2 = vector3d1.m_82541_();
                            vector3d = vector3d.m_82520_(vector3d2.f_82479_ * speed - vector3d.f_82479_ * 0.6, 0.0, vector3d2.f_82481_ * speed - vector3d.f_82481_ * 0.6);
                        }
                    }
                }
            }
            for (i = 0; i < 3; ++i) {
                if (this.distractedTime[i] <= 0) continue;
                int n = i;
                this.distractedTime[n] = this.distractedTime[n] - 1;
                if (this.distractedTime[i] > 0) continue;
                this.setDistractedPos(i, null);
            }
        }
        vector3d = this.doCustomFlying(vector3d);
        if (this.shouldDoCustomMovement()) {
            this.m_20256_(vector3d);
        }
        if (vector3d.m_165925_() > 0.05) {
            this.m_146922_((float)Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.295776f - 90.0f);
        }
        super.m_8107_();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotHeads[i];
            this.xRotOHeads[i] = this.xRotHeads[i];
        }
        if (!(this.areOtherHeadsDisabled() || this.isDeadOrPlayingDead() || this.shouldDoNothing())) {
            for (int j = 0; j < 2; ++j) {
                Vec3 pos = this.getLookPos(j + 1);
                if (pos != null) {
                    double d9 = this.getHeadX(j + 1);
                    double d1 = this.getHeadY(j + 1);
                    double d3 = this.getHeadZ(j + 1);
                    double d4 = pos.m_7096_() - d9;
                    double d5 = pos.m_7098_() - d1;
                    double d6 = pos.m_7094_() - d3;
                    double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                    float f = (float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875) - 90.0f;
                    float f1 = (float)(-(Mth.m_14136_((double)d5, (double)d7) * 57.2957763671875));
                    this.lerpHeadsTo(j + 1, f1, f, 3.0f);
                    continue;
                }
                if (this.isOnDistantRenderer() || this.isDeadOrPlayingDead()) continue;
                this.yRotHeads[j] = this.m_21376_(this.yRotHeads[j], this.f_20883_, 10.0f);
            }
        }
        boolean flag = this.m_7090_();
        if (this.getPhase() < 4) {
            for (int l = 0; l < 3; ++l) {
                double d8 = this.getHeadX(l);
                double d10 = this.getHeadY(l);
                double d2 = this.getHeadZ(l);
                if (l == 0) {
                    d8 = this.m_20185_();
                    d10 = this.m_20188_();
                    d2 = this.m_20189_();
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d8 + this.f_19796_.m_188583_() * (double)0.3f, d10 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, 0.0, 0.0, 0.0);
                if (!flag || this.f_19853_.f_46441_.m_188503_(4) != 0) continue;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, d8 + this.f_19796_.m_188583_() * (double)0.3f, d10 + this.f_19796_.m_188583_() * (double)0.3f, d2 + this.f_19796_.m_188583_() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
            }
        }
        if (this.getPhase() < 3) {
            for (int i2 = 0; i2 < 5; ++i2) {
                float angle = (this.f_20883_ + 90.0f) * ((float)Math.PI / 180);
                double x = (double)Mth.m_14089_((float)angle) * 0.3 + this.m_20185_();
                double z = (double)Mth.m_14031_((float)angle) * 0.3 + this.m_20189_();
                double y = this.m_20186_() + 1.4;
                double startX = x + this.f_19796_.m_188583_();
                double startY = y + this.f_19796_.m_188583_();
                double startZ = z + this.f_19796_.m_188583_();
                Vec3 delta = new Vec3(x, y, z).m_82492_(startX, startY, startZ).m_82541_().m_82490_(0.1);
                this.f_19853_.m_7106_((ParticleOptions)WitherStormModParticleTypes.COMMAND_BLOCK.get(), startX, startY, startZ, delta.f_82479_, delta.f_82480_, delta.f_82481_);
            }
        }
        if (this.getInvulnerableTicks() > 0 && this.getPhase() < 4) {
            for (int i1 = 0; i1 < 3; ++i1) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + this.f_19796_.m_188583_(), this.m_20186_() + (double)(this.f_19796_.m_188501_() * 3.3f), this.m_20189_() + this.f_19796_.m_188583_(), (double)0.7f, (double)0.7f, (double)0.9f);
            }
        }
        if (!(this.f_19853_.f_46443_ || this.isDeadOrPlayingDead() || this.shouldDoNothing())) {
            for (int i3 = 0; i3 < 3; ++i3) {
                if (this.nextRoarTick[i3] == 0) {
                    this.nextRoarTick[i3] = this.areOtherHeadsDisabled() || this.getPhase() < 6 ? this.f_19797_ + Math.max(Math.max(400, this.f_19796_.m_188503_(1000)), this.f_19796_.m_188503_(1800)) : this.f_19797_ + Math.max(Math.max(3200, this.f_19796_.m_188503_(4800)), this.f_19796_.m_188503_(6400));
                }
                if (this.f_19797_ > this.nextRoarTick[i3]) {
                    if (!this.m_21525_() && (this.areOtherHeadsDisabled() && i3 == 0 || !this.areOtherHeadsDisabled()) && !this.isDistracted(i3)) {
                        Vec3 view = this.getViewVector(this.m_146909_(), this.f_20885_, 1.0f);
                        if (i3 > 0) {
                            view = this.getViewVector(this.getHeadXRot(i3 - 1), this.getHeadYRot(i3 - 1), 1.0f);
                        }
                        if (this.getPhase() < 4 && i3 == 0 && this.m_5448_() != null) {
                            this.spawnFlamingWitherSkull(i3, view.f_82479_ + this.getHeadX(i3), view.f_82480_ + this.getHeadY(i3), view.f_82481_ + this.getHeadZ(i3));
                        } else if (this.getPhase() > 3) {
                            this.spawnFlamingWitherSkull(i3, view.f_82479_ + this.getHeadX(i3), view.f_82480_ + this.getHeadY(i3), view.f_82481_ + this.getHeadZ(i3));
                        }
                    }
                    this.setRoar(i3, this.isHeadInjured(i3));
                    this.nextRoarTick[i3] = this.areOtherHeadsDisabled() || this.getPhase() < 6 ? this.f_19797_ + Math.max(Math.max(400, this.f_19796_.m_188503_(1000)), this.f_19796_.m_188503_(1800)) : this.f_19797_ + Math.max(Math.max(3200, this.f_19796_.m_188503_(4800)), this.f_19796_.m_188503_(6400));
                }
                if (this.getCanRoar(i3)) {
                    int n = i3;
                    this.roarTicks[n] = this.roarTicks[n] + 1;
                    if (this.roarTicks[i3] > 40) {
                        this.disableRoar(i3);
                        this.roarTicks[i3] = 0;
                    }
                }
                if (!this.isBiting(i3)) continue;
                int n = i3;
                this.biteTicks[n] = this.biteTicks[n] + 1;
                if (this.biteTicks[i3] <= 10) continue;
                this.stopBiting(i3);
                this.biteTicks[i3] = 0;
                this.playSound((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_BITE.get(), i3, Math.max(2.0f, this.m_6121_()), 1.0f);
            }
        }
        this.headInjuries.tick();
        if (!this.m_21224_() && this.m_6084_()) {
            this.getPlayDeadManager().tick();
        }
    }

    protected void m_8022_() {
        super.m_8022_();
        boolean flag = !(this.m_6688_() instanceof Mob);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.headGoalSelectors.forEach(selector -> {
            selector.m_25360_(Goal.Flag.MOVE, flag);
            selector.m_25360_(Goal.Flag.JUMP, flag && flag1);
            selector.m_25360_(Goal.Flag.LOOK, flag);
        });
    }

    public double getHeightToAscendTo(Vec3 vector3d, double height, double ascendSpeed) {
        double finalHeight = vector3d.f_82480_;
        double yToStart = Math.min((double)(this.f_19853_.m_151558_() - 1), this.m_20191_().m_82399_().m_7098_());
        int radius = (int)(this.m_6972_((Pose)this.m_20089_()).f_20377_ * 1.5f);
        double highest = -1.0;
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                int currentHeight;
                Heightmap.Types type = Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
                if (this.getPhase() < 4) {
                    type = Heightmap.Types.MOTION_BLOCKING;
                }
                if ((currentHeight = this.f_19853_.m_6924_(type, x + Mth.m_14107_((double)this.m_20185_()), z + Mth.m_14107_((double)this.m_20189_()))) > (int)yToStart) {
                    currentHeight = (int)yToStart;
                }
                if (highest != -1.0 && !((double)currentHeight > highest)) continue;
                highest = currentHeight;
            }
        }
        double heightToAscendTo = highest + height;
        if (this.m_20186_() < heightToAscendTo || !this.m_7090_() && this.m_20186_() < heightToAscendTo + 5.0) {
            finalHeight = (heightToAscendTo - this.m_20186_()) * ascendSpeed;
        }
        return finalHeight;
    }

    public double distanceTo(BlockPos pos) {
        float x = (float)(this.m_20185_() - (double)pos.m_123341_());
        float y = (float)(this.m_20186_() - (double)pos.m_123342_());
        float z = (float)(this.m_20189_() - (double)pos.m_123343_());
        return Mth.m_14116_((float)(x * x + y * y + z * z));
    }

    public boolean targetInUseBySegment(Entity entity) {
        if (this.getSegmentsManager().isPresent()) {
            WitherStormSegmentEntity[] segments = this.getSegmentsManager().get().getSegments();
            for (int i = 0; i < segments.length; ++i) {
                if (segments[i] == null) continue;
                if (!this.areOtherHeadsDisabled()) {
                    for (int j = 1; j < 3; ++j) {
                        LivingEntity target = segments[i].getAlternativeTarget(j);
                        if (target == null || target.m_19879_() != entity.m_19879_()) continue;
                        return true;
                    }
                }
                if (segments[i].m_5448_() == null || !segments[i].m_5448_().equals((Object)entity)) continue;
                return true;
            }
        }
        return false;
    }

    protected Vec3 doCustomFlying(Vec3 movement) {
        return movement;
    }

    protected SoundEvent m_7515_() {
        if (!this.isDeadOrPlayingDead()) {
            if (this.getPhase() < 4) {
                return SoundEvents.f_12554_;
            }
            return (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_GROWL.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        if (this.getPhase() < 4) {
            return SoundEvents.f_12557_;
        }
        return (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (this.getPhase() < 4) {
            return SoundEvents.f_12556_;
        }
        return null;
    }

    public int m_8100_() {
        if (this.getPhase() > 3) {
            return Math.max(80, this.f_19796_.m_188503_(120));
        }
        return super.m_8100_();
    }

    protected float m_6121_() {
        if (this.getPhase() > 3) {
            return 25.0f;
        }
        return super.m_6121_();
    }

    public final float m_21376_(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = Mth.m_14177_((float)(p_82204_2_ - p_82204_1_));
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    @Override
    public float getHeadYRot(int head) {
        return this.yRotHeads[head];
    }

    @Override
    public float getHeadXRot(int head) {
        return this.xRotHeads[head];
    }

    @Override
    public float getHeadYRotO(int head) {
        return this.yRotOHeads[head];
    }

    @Override
    public float getHeadXRotO(int head) {
        return this.xRotOHeads[head];
    }

    public boolean targetIsStillApplicable(int head, LivingEntity entity) {
        return entity.m_6084_() && this.getTargettingPredicate().m_26885_((LivingEntity)this, entity) && this.canSee(head, (Entity)entity) && this.getPhase() > 3 ? this.isEntityBehindBack((Entity)entity) : true;
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("goalSelectorHeads");
        this.headGoalSelectors.forEach(selector -> selector.m_25373_());
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("targetSelectorHeads");
        this.headTargetSelectors.forEach(selector -> selector.m_25373_());
        this.f_19853_.m_46473_().m_7238_();
        if (this.getInvulnerableTicks() > 0) {
            int ticks = this.getInvulnerableTicks() - 1;
            if (ticks <= 0) {
                Explosion.BlockInteraction explosionMode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 7.0f, false, explosionMode);
                if (!this.m_20067_()) {
                    this.f_19853_.m_6798_(1023, this.m_20183_(), 0);
                }
            }
            this.setInvulnerableTicks(ticks);
            if (this.f_19797_ % 10 == 0) {
                this.m_5634_(10.0f);
            }
        } else {
            super.m_8024_();
            if (!this.isDeadOrPlayingDead()) {
                CommandBlockEntity commandBlock;
                int i;
                if (this.getPhase() > 1) {
                    for (i = 0; i < (this.getPhase() < 4 || this.areOtherHeadsDisabled() ? this.idleClusterPickup.length - 2 : this.idleClusterPickup.length); ++i) {
                        if (this.f_19797_ < this.nextClusterPickup[i]) continue;
                        this.nextClusterPickup[i] = this.f_19797_ + 560 + this.f_19796_.m_188503_(120);
                        this.idleClusterPickup[i] = this.idleClusterPickup[i] + 1;
                        float x = i > 0 ? this.getHeadXRot(i - 1) : this.m_5686_(1.0f);
                        float y = i > 0 ? this.getHeadYRot(i - 1) : this.m_5675_(1.0f);
                        this.createClusterFromLook(x, y, this.clusterRadius + 1, 25, i);
                        this.idleClusterPickup[i] = 0;
                    }
                }
                if (!this.areOtherHeadsDisabled()) {
                    for (i = 1; i < 3; ++i) {
                        if (this.f_19797_ < this.nextHeadUpdate[i - 1]) continue;
                        this.nextHeadUpdate[i - 1] = this.getPhase() < 4 ? this.f_19797_ + 10 + this.f_19796_.m_188503_(10) : this.f_19797_ + 1200 + this.f_19796_.m_188503_(120);
                        int k3 = this.idleHeadUpdates[i - 1];
                        this.idleHeadUpdates[i - 1] = this.idleHeadUpdates[i - 1] + 1;
                        if (k3 > 15) {
                            double d0 = Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.getHeadX(i) - 10.0), (double)(this.getHeadX(i) + 10.0));
                            double d1 = Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.getHeadY(i) - 5.0), (double)(this.getHeadY(i) + 5.0));
                            double d2 = Mth.m_216263_((RandomSource)this.f_19796_, (double)(this.getHeadZ(i) - 10.0), (double)(this.getHeadZ(i) + 10.0));
                            this.performRangedAttack(i, d0, d1, d2, true);
                            this.idleHeadUpdates[i - 1] = 0;
                        }
                        if (this.getAlternativeTarget(i) == null) continue;
                        LivingEntity entity = this.getAlternativeTarget(i);
                        if (entity != null) {
                            if (this.targetIsStillApplicable(i, entity)) {
                                this.performRangedAttack(i, entity);
                                this.nextHeadUpdate[i - 1] = this.getPhase() < 4 ? this.f_19797_ + 40 + this.f_19796_.m_188503_(20) : this.f_19797_ + 1800 + this.f_19796_.m_188503_(160);
                                this.idleHeadUpdates[i - 1] = 0;
                                continue;
                            }
                            this.nextHeadUpdate[i - 1] = this.f_19797_ + 40 + this.f_19796_.m_188503_(20);
                            continue;
                        }
                        this.nextHeadUpdate[i - 1] = this.f_19797_ + 40 + this.f_19796_.m_188503_(20);
                    }
                }
                if (this.destroyBlocksTick > 0) {
                    --this.destroyBlocksTick;
                    if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                        int i1 = Mth.m_14107_((double)this.m_20186_());
                        int l1 = Mth.m_14107_((double)this.m_20185_());
                        int i2 = Mth.m_14107_((double)this.m_20189_());
                        boolean flag = false;
                        for (int k2 = -1; k2 <= 1; ++k2) {
                            for (int l2 = -1; l2 <= 1; ++l2) {
                                for (int j = 0; j <= 3; ++j) {
                                    int i3 = l1 + k2;
                                    int k = i1 + j;
                                    int l = i2 + l2;
                                    BlockPos blockpos = new BlockPos(i3, k, l);
                                    BlockState blockstate2 = this.f_19853_.m_8055_(blockpos);
                                    if (!blockstate2.canEntityDestroy((BlockGetter)this.f_19853_, blockpos, (Entity)this) || blockstate2.m_204336_(WitherStormModBlockTags.WITHER_STORM_BLOCK_BLACKLIST) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate2)) continue;
                                    flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
                                }
                            }
                        }
                        if (flag) {
                            this.f_19853_.m_5898_((Player)null, 1022, this.m_20183_(), 0);
                        }
                    }
                }
                if (this.f_19797_ % this.getBlockClusterPickupInterval() == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                    int clusterRadius = this.clusterRadius;
                    int flooredX = Mth.m_14107_((double)this.m_20185_());
                    int flooredY = Math.min(this.f_19853_.m_151558_() - 1, Mth.m_14107_((double)(this.m_20188_() + 1.0)));
                    int flooredZ = Mth.m_14107_((double)this.m_20189_());
                    int randomX = this.f_19796_.m_188503_(this.entityConsumptionRadius * 2);
                    int randomZ = this.f_19796_.m_188503_(this.entityConsumptionRadius * 2);
                    BlockPos blockToCollect = new BlockPos(flooredX + randomX - this.entityConsumptionRadius * 2 / 2, flooredY, flooredZ + randomZ - this.entityConsumptionRadius * 2 / 2);
                    while (blockToCollect.m_123342_() >= this.f_19853_.m_141937_() && this.f_19853_.m_8055_(blockToCollect).m_60713_(Blocks.f_50016_) || this.f_19853_.m_8055_(blockToCollect).m_60713_(Blocks.f_49990_)) {
                        blockToCollect = blockToCollect.m_7495_();
                    }
                    BlockClusterEntity clusterEntity = (BlockClusterEntity)((EntityType)WitherStormModEntityTypes.BLOCK_CLUSTER.get()).m_20615_(this.f_19853_);
                    clusterEntity.populateWithRadius(blockToCollect, clusterRadius, blockstate -> !blockstate.m_204336_(WitherStormModBlockTags.WITHER_STORM_BLOCK_BLACKLIST));
                    clusterEntity.setTime(50);
                    clusterEntity.setShakeTime(this.f_19796_.m_188503_(10) + 20);
                    if (!clusterEntity.containsBlock((Block)WitherStormModBlocks.FORMIDIBOMB.get())) {
                        this.currentTrackedEntities.add(clusterEntity);
                        clusterEntity.setRotationDelta(new Vec2((float)this.f_19796_.m_188503_(20) * 0.1f / 2.0f, (float)this.f_19796_.m_188503_(20) * 0.1f / 2.0f));
                        clusterEntity.m_20242_(true);
                        clusterEntity.setPhysics(false);
                        this.f_19853_.m_7967_((Entity)clusterEntity);
                    }
                }
                if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                    AABB searchBB = this.m_20191_().m_82400_((double)this.entityConsumptionRadius);
                    List entities = this.f_19853_.m_45976_(ItemEntity.class, searchBB);
                    int size = entities.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        ItemStack item;
                        ItemEntity entity = (ItemEntity)entities.get(i2);
                        if (!(this.f_19796_.m_188501_() >= 0.9f) || !((item = entity.m_32055_()).m_204117_(WitherStormModItemTags.UNAPPETIZING) && entity.m_20270_((Entity)this) < (float)(this.getPhase() > 3 ? 35 : 2)) && item.m_204117_(WitherStormModItemTags.UNAPPETIZING) || item.m_150930_((Item)WitherStormModItems.COMMAND_BLOCK_BOOK.get()) || item.m_204117_(WitherStormModItemTags.COMMAND_BLOCK_TOOLS) || item.m_150930_((Item)WitherStormModItems.WITHERED_NETHER_STAR.get()) || !this.canTrackEntity((Entity)entity)) continue;
                        this.currentTrackedEntities.add((Entity)entity);
                        entity.m_20242_(true);
                    }
                }
                double speed = 0.2;
                for (int i3 = 0; i3 < 3; ++i3) {
                    this.pullInTarget((Entity)this.getTarget(i3), speed, i3);
                }
                if (WitherStormModConfig.SERVER.canPickupMobClusters.get().booleanValue()) {
                    for (Entity entity : this.f_19853_.m_45976_(Entity.class, this.getSearchBox())) {
                        for (int i4 = 0; i4 < this.getTotalHeads(); ++i4) {
                            LivingEntity living;
                            if (!(entity instanceof LivingEntity ? LIVING_ENTITY_SELECTOR.test(living = (LivingEntity)entity) : TRACTOR_BEAM_PULLABLE.test(entity)) || !EntitySelector.f_20406_.test(entity) || !TractorBeamHelper.isInsideTractorBeam(entity, this, 4.0, i4) || this.alreadyATarget(entity, true) || this.targetInUseBySegment(entity) || this.nearNonApplicableObject(entity) || !this.canSee(i4, entity)) continue;
                            this.pullInTarget(entity, speed, i4);
                        }
                    }
                }
                if (this.isAddedToWorld() && this.f_19797_ % 20 == 0 && this.isCompletelyInvulnerable()) {
                    this.m_5634_(10.0f);
                }
                for (int i5 = 0; i5 < this.playersToHurt.size(); ++i5) {
                    Player player = this.playersToHurt.get(i5);
                    if (player.m_6084_()) {
                        player.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                        if (player.m_21224_()) {
                            this.addToConsumedEntities(1);
                            this.playersToHurt.remove(i5);
                            return;
                        }
                        if (player.m_150110_().f_35934_ || !this.alreadyATarget((Entity)player, true)) {
                            this.playersToHurt.remove(i5);
                            return;
                        }
                        boolean flag = true;
                        for (int j = 0; j < 3; ++j) {
                            AABB headBox = this.getBoxForHead(j);
                            if (!player.m_20191_().m_82381_(headBox)) continue;
                            flag = false;
                            break;
                        }
                        if (!flag) continue;
                        this.playersToHurt.remove(i5);
                        return;
                    }
                    this.playersToHurt.remove(i5);
                }
                this.bossEvent.ifPresent(bossEvent -> bossEvent.m_142711_(this.m_21223_() / this.m_21233_()));
                if (this.m_5448_() != null) {
                    ++this.idleTargetTicks;
                }
                if (this.idleTargetTicks > 1800 || this.m_5448_() == null) {
                    this.m_6710_(null);
                    this.idleTargetTicks = 0;
                }
                if (this.getPhase() > 1) {
                    AABB headBox = this.getBoxForHead(0);
                    List boundingBoxEntities = this.f_19853_.m_45976_(Projectile.class, headBox);
                    for (Projectile projectile : boundingBoxEntities) {
                        if (projectile.m_37282_() == this) continue;
                        if (this.getHeadInjureAttemptCooldown(0) <= 0 && this.getHeadInjuryTicks(0) <= 0) {
                            this.setHeadInjureAttemptCooldown(0, 40);
                            if (this.f_19796_.m_188503_(10) > 5 && !this.isDeadOrPlayingDead()) {
                                this.hurtHead(projectile.m_37282_(), 0);
                                if (projectile.m_37282_() instanceof Player) {
                                    Player owner = (Player)projectile.m_37282_();
                                    owner.m_6330_(SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                }
                            }
                        }
                        if (projectile instanceof ThrownTrident) continue;
                        projectile.m_146870_();
                    }
                }
                if (this.getPhase() > 3 && !this.areOtherHeadsDisabled()) {
                    for (int i6 = 1; i6 < 3; ++i6) {
                        AABB headBox = this.getBoxForHead(i6);
                        List headBoxEntities = this.f_19853_.m_45976_(Projectile.class, headBox);
                        for (Projectile projectile : headBoxEntities) {
                            if (projectile.m_37282_() == this) continue;
                            if (this.getHeadInjureAttemptCooldown(0) <= 0 && this.getHeadInjuryTicks(0) <= 0) {
                                this.setHeadInjureAttemptCooldown(i6, 40);
                                if (this.f_19796_.m_188503_(10) > 5 && !this.isDeadOrPlayingDead()) {
                                    this.hurtHead(projectile.m_37282_(), i6);
                                    if (projectile.m_37282_() instanceof Player) {
                                        Player owner = (Player)projectile.m_37282_();
                                        owner.m_6330_(SoundEvents.f_11686_, SoundSource.PLAYERS, 1.0f, 1.0f);
                                    }
                                }
                            }
                            if (projectile instanceof ThrownTrident) continue;
                            projectile.m_146870_();
                        }
                    }
                }
                if ((commandBlock = this.getBowelsCommandBlock()) != null && commandBlock.m_21223_() < commandBlock.m_21233_() && this.nextFlicker > 0) {
                    --this.nextFlicker;
                    if (this.nextFlicker == 0) {
                        this.doFlicker();
                        this.nextFlicker = (int)((double)this.f_19796_.m_188503_(40) + 60.0 * Math.max(0.2, (double)(commandBlock.m_21223_() / commandBlock.m_21233_())));
                    }
                }
                if ((this.f_19862_ || this.f_19863_) && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) && this.getPhase() > 3) {
                    Vec3 center = this.m_20182_().m_82520_(0.0, (double)this.getUnmodifiedHeight() / 2.0, 0.0);
                    Vec3 top = this.m_20182_().m_82520_(0.0, (double)this.getUnmodifiedHeight(), 0.0);
                    Vec3 bottom = this.m_20182_();
                    float power = 8.0f;
                    this.f_19853_.m_46511_((Entity)this, top.f_82479_, top.f_82480_, top.f_82481_, power, Explosion.BlockInteraction.DESTROY);
                    this.f_19853_.m_46511_((Entity)this, center.f_82479_, center.f_82480_, center.f_82481_, power, Explosion.BlockInteraction.DESTROY);
                    this.f_19853_.m_46511_((Entity)this, bottom.f_82479_, bottom.f_82480_, bottom.f_82481_, power, Explosion.BlockInteraction.DESTROY);
                    int explosionCount = Math.max(4, this.f_19796_.m_188503_(10));
                    for (int i7 = 0; i7 < explosionCount; ++i7) {
                        double deltaX = this.f_19853_.f_46441_.m_188583_() * ((double)this.getUnmodifiedHeight() / 2.0);
                        double deltaY = this.f_19853_.f_46441_.m_188583_() * ((double)this.getUnmodifiedHeight() / 2.0);
                        double deltaZ = this.f_19853_.f_46441_.m_188583_() * ((double)this.getUnmodifiedHeight() / 2.0);
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123812_, center.f_82479_ + deltaX, center.f_82480_ + deltaY, center.f_82481_ + deltaZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    protected boolean canTrackEntity(Entity entity) {
        SegmentsManager manager = this.getSegmentsManager().orElse(null);
        if (manager != null) {
            for (WitherStormSegmentEntity segment : manager.getSegments()) {
                if (segment == null || !segment.m_6084_() || !segment.currentTrackedEntities.contains(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public void hurtHead(@Nullable Entity entity, int head) {
        this.headInjuries.hurtHead(entity, head);
    }

    private TargetingConditions getTargettingPredicate() {
        TargetingConditions bigRange = TargetingConditions.m_148352_().m_26883_(this.m_21133_(Attributes.f_22277_) + 100.0).m_26888_(LIVING_ENTITY_SELECTOR);
        TargetingConditions smallRange = TargetingConditions.m_148352_().m_26883_(this.m_21133_((Attribute)WitherStormModAttributes.HUNCHBACK_FOLLOW_RANGE.get())).m_26888_(LIVING_ENTITY_SELECTOR);
        return this.getPhase() > 3 ? bigRange : smallRange;
    }

    public AABB getBoxForHead(int head) {
        double x = this.getHeadX(head);
        double y = this.getHeadY(head);
        double z = this.getHeadZ(head);
        float size = this.getPhase() > 3 ? 3.0f : 0.5f;
        return new AABB(x - (double)size, y - (double)size, z - (double)size, x + (double)size, y + (double)size, z + (double)size);
    }

    protected void m_6153_() {
        if (this.getPhase() > 3) {
            ++this.witherStormDeathTime;
        } else {
            ++this.f_20919_;
        }
        if (!this.m_20096_()) {
            for (int i = 0; i < 3; ++i) {
                this.lerpHeadsXTo(i, -50.0f, 64.0f);
            }
        }
        if (!this.f_19853_.f_46443_) {
            if (this.getPhase() > 5 && this.getDeathTime() < 240) {
                int interval = 240 / this.getPhase();
                if (this.getDeathTime() % interval == 0) {
                    this.dropMassCluster(this.getPhase() - 2);
                }
                if (this.getDeathTime() % 5 == 0) {
                    this.dropMassCluster(2);
                }
            }
            if (this.getPhase() > 3 && this.getDeathTime() == 360) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                Player nearest = this.f_19853_.m_45924_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21133_(Attributes.f_22277_) + 50.0, false);
                if (nearest != null) {
                    this.dropDropsAt((Entity)nearest);
                }
            } else if (this.getPhase() < 4 && this.f_20919_ == 20) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
        for (int l = 0; l < Math.max(2, this.f_19796_.m_188503_(5)); ++l) {
            for (DebrisChunks chunks : this.getChunks()) {
                if (chunks.getChunks().isEmpty()) continue;
                int j = this.f_19796_.m_188503_(chunks.getChunks().size());
                chunks.getChunks().get((int)j).disabled = true;
            }
        }
        float percentage = Math.max(0.0f, (360.0f - (float)this.getDeathTime()) / 360.0f);
        for (DebrisRingSettings settings : this.getDebrisRings()) {
            settings.setAlpha(percentage);
        }
    }

    public boolean alreadyATarget(Entity entity, boolean countMain) {
        boolean flag = false;
        if (!this.areOtherHeadsDisabled()) {
            for (int i = 1; i < 3; ++i) {
                if (entity != this.getAlternativeTarget(i)) continue;
                flag = true;
            }
        }
        if (this.m_5448_() != null && countMain && this.m_5448_().m_19879_() == entity.m_19879_()) {
            flag = true;
        }
        return flag;
    }

    public boolean alreadyATargetId(int id, boolean countMain) {
        boolean flag = false;
        for (int i = 1; i < 3; ++i) {
            if (this.getAlternativeTarget(i) == null || id != this.getAlternativeTarget(i).m_19879_()) continue;
            flag = true;
        }
        if (this.getTargetId() == id && countMain) {
            flag = true;
        }
        return flag;
    }

    private void createClusterFromLook(float x, float y, int radius, int time, int head) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            Vec3 vecPos = new Vec3(this.getHeadX(head), this.getHeadY(head), this.getHeadZ(head));
            BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(vecPos, vecPos.m_82549_(this.getViewVector(x, y, (float)this.getPhase() * 100.0f)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
            BlockClusterEntity cluster = (BlockClusterEntity)((EntityType)WitherStormModEntityTypes.BLOCK_CLUSTER.get()).m_20615_(this.f_19853_);
            cluster.populateWithRadius(result.m_82425_(), radius, blockstate -> !blockstate.m_204336_(WitherStormModBlockTags.WITHER_STORM_BLOCK_BLACKLIST));
            cluster.setTime(time);
            cluster.setShakeTime(this.f_19796_.m_188503_(10) + 20);
            if (!cluster.containsBlock((Block)WitherStormModBlocks.FORMIDIBOMB.get())) {
                this.currentTrackedEntities.add(cluster);
                cluster.setRotationDelta(new Vec2((float)this.f_19796_.m_188503_(20) * 0.1f / 2.0f, (float)this.f_19796_.m_188503_(20) * 0.1f / 2.0f));
                cluster.m_20242_(true);
                cluster.setPhysics(false);
                this.f_19853_.m_7967_((Entity)cluster);
            }
        }
    }

    private void setPlayerDeltaMovement(ServerPlayer player, Vec3 motion) {
        PlayerMotionMessage message = new PlayerMotionMessage(motion);
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(50.0);
    }

    public EntityDimensions m_6972_(Pose pose) {
        EntityDimensions size = this.getUnmodifiedDimensions(pose);
        if (WitherStormModConfig.SERVER.squashHitbox.get().booleanValue() && this.getPhase() > 3) {
            size = EntityDimensions.m_20395_((float)size.f_20377_, (float)1.0f);
        }
        if (this.getPlayDeadManager().getState() == PlayDeadManager.State.PLAYING_DEAD) {
            size = EntityDimensions.m_20395_((float)size.f_20377_, (float)0.1f);
        }
        return size;
    }

    public EntityDimensions getUnmodifiedDimensions(Pose pos) {
        EntityDimensions size = this.startingSize;
        if (this.getPhase() == 4) {
            size = this.destroyerSize;
        } else if (this.getPhase() == 5) {
            size = this.evolvedDestroyerSize;
        } else if (this.getPhase() == 6) {
            size = this.devourerSize;
        } else if (this.getPhase() == 7) {
            size = this.evolvedDevourerSize;
        }
        return size;
    }

    public float getUnmodifiedHeight() {
        return this.getUnmodifiedDimensions((Pose)this.m_20089_()).f_20378_;
    }

    public float getUnmodifiedWidth() {
        return this.getUnmodifiedDimensions((Pose)this.m_20089_()).f_20377_;
    }

    public float getUnmodifiedSize() {
        float width = this.getUnmodifiedWidth();
        float height = this.getUnmodifiedHeight();
        return (width + height + width) / 3.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        if (this.getPhase() > 3) {
            return 17.5f;
        }
        return super.m_6431_(pose, size);
    }

    public void m_6075_() {
        super.m_6075_();
        this.xBodyRotO = this.xBodyRot;
        this.headPosO = this.headPos;
    }

    public void m_8119_() {
        int i;
        int i2;
        super.m_8119_();
        this.tentacleTickCountO = this.tentacleTickCount++;
        if (!this.isDeadOrPlayingDead()) {
            // empty if block
        }
        this.lastConsumedEntities = this.getConsumedEntities();
        if (!this.f_19853_.f_46443_) {
            this.bowelsInstance.ifPresent(BowelsInstanceManager::tick);
            Vec3 stormPosition = this.m_20191_().m_82399_();
            for (i2 = 0; i2 < this.currentTrackedEntities.size(); ++i2) {
                Entity entity = this.currentTrackedEntities.get(i2);
                if (entity.m_6084_()) {
                    Object cluster;
                    if (entity instanceof BlockClusterEntity && ((BlockClusterEntity)((Object)(cluster = (BlockClusterEntity)entity))).getShakeTime() > 0) continue;
                    Vec3 entityPosition = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    double speed = 0.5;
                    if (entity instanceof BlockClusterEntity) {
                        BlockClusterEntity cluster2 = (BlockClusterEntity)entity;
                        speed += (double)cluster2.time * 0.001;
                    }
                    Vec3 position = stormPosition.m_82546_(entityPosition).m_82541_();
                    entity.m_20256_(position.m_82542_(speed, speed, speed));
                    ServerLevel world = (ServerLevel)this.f_19853_;
                    for (ServerPlayer player : world.m_6907_()) {
                        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
                    }
                    List entities = this.f_19853_.m_45976_(entity.getClass(), this.m_20191_().m_82406_((double)this.getUnmodifiedWidth() / 2.0));
                    int size1 = entities.size();
                    for (int k = 0; k < size1; ++k) {
                        if (!entity.m_20148_().equals(((Entity)entities.get(k)).m_20148_())) continue;
                        this.currentTrackedEntities.remove(i2);
                        if (entity instanceof BlockClusterEntity) {
                            this.addToConsumedEntities(((BlockClusterEntity)entity).getSize());
                        } else {
                            this.addToConsumedEntities(1);
                        }
                        entity.m_146870_();
                    }
                    continue;
                }
                this.currentTrackedEntities.remove(entity);
            }
            this.getDistantUpdater().sendChangesToDistantRenderer();
            if (this.getPhase() > 5) {
                this.findSegments();
                this.createSegments();
                this.addSegments();
            }
            if (this.getPhase() < 6) {
                this.removeSegments();
            } else {
                this.readdSegments();
            }
        }
        for (DebrisChunks chunks : this.getChunks()) {
            List<DebrisChunks.DebrisChunk> chunkList = chunks.getChunks();
            for (DebrisChunks.DebrisChunk chunk : chunkList) {
                chunk.setRotation(chunk.xRot + chunk.getMotion().f_82470_, chunk.getMotion().f_82471_);
                chunk.setOrbitalAngle(chunk.orbitalAngle + chunk.speed);
            }
        }
        this.checkConsumptionAmount();
        if (this.partsEnabled) {
            Section[] sections = this.getSections();
            for (i2 = 0; i2 < sections.length; ++i2) {
                if (!sections[i2].isActive()) continue;
                sections[i2].tick();
            }
        }
        if (this.chunkloads && !this.f_19853_.f_46443_ && !this.m_21224_()) {
            this.f_19853_.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).ifPresent(stormChunk -> stormChunk.addStorm(this));
        }
        if (!this.f_19853_.f_46443_ && this.shouldPlaySoundLoops()) {
            StormSoundPositionMessage message = new StormSoundPositionMessage(this.m_19879_(), this.m_20185_(), this.m_20188_(), this.m_20189_(), (byte)this.getPhase());
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
        }
        for (i = 0; i < 3; ++i) {
            this.mouthAnimO[i] = this.mouthAnim[i];
            if (!this.isBiting(i) && this.getCanRoar(i)) {
                int n = i;
                this.mouthAnim[n] = this.mouthAnim[n] + ((1.0f - this.mouthAnim[i]) * 0.15f + 0.04f);
                if (this.mouthAnim[i] > 2.0f) {
                    this.mouthAnim[i] = 2.0f;
                }
            } else if (this.isBiting(i)) {
                int n = i;
                this.mouthAnim[n] = this.mouthAnim[n] + ((1.0f - this.mouthAnim[i]) * 0.16f + 0.1f);
                if (this.mouthAnim[i] > 1.4f) {
                    this.mouthAnim[i] = 1.4f;
                }
            } else {
                int n = i;
                this.mouthAnim[n] = this.mouthAnim[n] + (-this.mouthAnim[i] * 0.16f - 0.02f);
                if (this.mouthAnim[i] < 0.0f) {
                    this.mouthAnim[i] = 0.0f;
                }
            }
            this.jawBrokenAnimationO[i] = this.jawBrokenAnimation[i];
            if (this.m_20096_() && this.isDeadOrPlayingDead()) {
                int n = i;
                this.jawBrokenAnimation[n] = this.jawBrokenAnimation[n] + ((1.0f - this.jawBrokenAnimation[i]) * 0.2f + 0.05f);
                if (!(this.jawBrokenAnimation[i] > 1.5f)) continue;
                this.jawBrokenAnimation[i] = 1.5f;
                continue;
            }
            int n = i;
            this.jawBrokenAnimation[n] = this.jawBrokenAnimation[n] + (-this.jawBrokenAnimation[i] * 0.2f - 0.05f);
            if (!(this.jawBrokenAnimation[i] < 0.0f)) continue;
            this.jawBrokenAnimation[i] = 0.0f;
        }
        this.onGroundAnimationO = this.onGroundAnimation;
        if (this.m_20096_() && this.isDeadOrPlayingDead()) {
            this.onGroundAnimation += 1.0f + this.f_19796_.m_188501_() * 2.0f;
            if (this.onGroundAnimation > 300.0f) {
                this.onGroundAnimation = 300.0f;
            }
        } else {
            this.onGroundAnimation -= 1.0f + this.f_19796_.m_188501_() * 2.0f;
            if (this.onGroundAnimation < 0.0f) {
                this.onGroundAnimation = 0.0f;
            }
        }
        for (i = 0; i < 3; ++i) {
            float rotNew;
            if (this.lerpXRotHeadsSteps[i] > 0.0f) {
                float rot = i == 0 ? this.m_146909_() : this.xRotHeads[i - 1];
                rotNew = (float)((double)rot + Mth.m_14175_((double)((double)this.lerpXRotHeads[i] - (double)rot)) / (double)this.lerpXRotHeadsSteps[i]);
                if (i == 0) {
                    this.m_146926_(rotNew);
                } else {
                    this.xRotHeads[i - 1] = rotNew;
                }
                int n = i;
                this.lerpXRotHeadsSteps[n] = this.lerpXRotHeadsSteps[n] - 1.0f;
            }
            if (!(this.lerpYRotHeadsSteps[i] > 0.0f)) continue;
            float rot = i == 0 ? this.m_146908_() : this.yRotHeads[i - 1];
            rotNew = (float)((double)rot + Mth.m_14175_((double)((double)this.lerpYRotHeads[i] - (double)rot)) / (double)this.lerpYRotHeadsSteps[i]);
            if (i == 0) {
                this.m_146922_(rotNew);
            } else {
                this.yRotHeads[i - 1] = rotNew;
            }
            int n = i;
            this.lerpYRotHeadsSteps[n] = this.lerpYRotHeadsSteps[n] - 1.0f;
        }
        this.headPos = this.calculateHeadPositions();
        if (this.flickerTime > 0) {
            --this.flickerTime;
            boolean bl = this.shouldFlicker = Mth.m_14089_((float)(this.flickerTime + this.f_19796_.m_188503_(20))) * Mth.m_14031_((float)(this.flickerTime + 30 + this.f_19796_.m_188503_(20))) < -0.5f;
            if (this.flickerTime == 0) {
                this.shouldFlicker = false;
            }
        }
        if (this.f_19853_.f_46443_ && WitherStormModConfig.CLIENT.tractorBeamParticles.get().booleanValue() && !this.isOnDistantRenderer()) {
            for (i = 0; i < this.getTotalHeads(); ++i) {
                if (!this.tractorBeamActive(i) || this.isDeadOrPlayingDead() || this.getXBodyRot() != 0.0f) continue;
                for (int amount = 0; amount < 5; ++amount) {
                    double randZ;
                    double randY;
                    float x = i == 0 ? this.m_146909_() : this.getHeadXRot(i - 1);
                    float y = i == 0 ? this.f_20885_ : this.getHeadYRot(i - 1);
                    Vec3 lookVec = this.getViewVector(x, y, this.f_19796_.m_188501_() * 200.0f);
                    Vec3 headPos = this.getHeadPos(i);
                    Vec3 pos = headPos.m_82549_(lookVec).m_82520_(0.0, 5.5, 0.0);
                    double distanceFromHead = Math.sqrt(pos.m_82557_(headPos));
                    double distanceAllowed = distanceFromHead * 2.0 * 0.02;
                    double randX = this.f_19796_.m_188583_() * distanceAllowed;
                    if (!((Boolean)TractorBeamHelper.isInsideTractorBeam(pos = pos.m_82520_(randX, randY = this.f_19796_.m_188583_() * distanceAllowed, randZ = this.f_19796_.m_188583_() * distanceAllowed), this, 4.0).getFirst()).booleanValue()) continue;
                    Vec3 delta = pos.m_82546_(headPos).m_82541_().m_82490_(-0.8);
                    this.f_19853_.m_6493_((ParticleOptions)WitherStormModParticleTypes.TRACTOR_BEAM.get(), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, delta.f_82479_, delta.f_82480_, delta.f_82481_);
                }
            }
        }
    }

    public DistantRendererManager getDistantUpdater() {
        return this.distantUpdater;
    }

    public UltimateTargetManager getUltimateTargetManager() {
        return this.targetManager;
    }

    public void checkConsumptionAmount() {
        if (!this.isDeadOrPlayingDead() && this.canEvolve() && this.getConsumedEntities() > this.consumptionAmountTillPhaseChange && this.getConsumedEntities() != this.lastConsumedEntities) {
            this.setPhase(this.getPhase() + 1);
            if (WitherStormModConfig.SERVER.accelerateOnPhaseChange.get().booleanValue() && this.getPhase() > 3) {
                this.targetManager.accelerate();
            }
            if (this.shouldPlayGlobalSounds && this.getPhase() == 4) {
                this.playSoundToEveryone(this.m_21133_(Attributes.f_22277_), (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_EVOLVES.get(), 1.0f, 1.0f);
            }
        }
    }

    public void m_6210_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        super.m_6210_();
        this.m_6034_(x, y, z);
    }

    public void playSoundToEveryone(SoundEvent event, float volume, float pitch) {
        GlobalSoundMessage message = new GlobalSoundMessage(event, volume, pitch);
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
    }

    public void playSoundToEveryone(double distance, SoundEvent event, float volume, float pitch) {
        GlobalSoundMessage message = new GlobalSoundMessage(this.m_20182_(), distance, event, volume, pitch);
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (!this.f_19853_.f_46443_) {
            int size = this.currentTrackedEntities.size();
            for (int i = 0; i < size; ++i) {
                Entity entity = this.currentTrackedEntities.get(i);
                entity.m_20242_(false);
                if (!(entity instanceof BlockClusterEntity)) continue;
                ((BlockClusterEntity)entity).setPhysics(true);
            }
            this.currentTrackedEntities.clear();
            DistantRendererManager.removeEntityFromDistantRenderer(this, PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()));
            if (this.shouldPlaySoundLoop) {
                RemoveSoundLoopMessage message = new RemoveSoundLoopMessage(this);
                WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
            }
        }
        if (!this.m_6084_()) {
            this.getPlayDeadManager().removePodium();
        }
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.f_19853_.f_46443_) {
            if (this.getPhase() > 3) {
                if (this.shouldPlaySoundLoop) {
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_DEATH.get(), SoundSource.HOSTILE, 20.0f, 1.0f);
                    RemoveSoundLoopMessage message = new RemoveSoundLoopMessage(this);
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
                }
                for (int i = 0; i < 3; ++i) {
                    this.setRoar(i, false);
                }
                int size = this.currentTrackedEntities.size();
                for (int i = 0; i < size; ++i) {
                    Entity entity = this.currentTrackedEntities.get(i);
                    entity.m_20242_(false);
                    if (!(entity instanceof BlockClusterEntity)) continue;
                    ((BlockClusterEntity)entity).setPhysics(true);
                }
                this.currentTrackedEntities.clear();
            }
            List entities = this.f_19853_.m_45976_(LivingEntity.class, this.getSearchBox());
            for (LivingEntity living : entities) {
                living.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).ifPresent(tracker -> tracker.cure());
                if (!(living instanceof AbstractSickenedEntity)) continue;
                AbstractSickenedEntity sickened = (AbstractSickenedEntity)living;
                sickened.finishConversion((ServerLevel)this.f_19853_);
            }
            this.getSegmentsManager().ifPresent(manager -> manager.killSegments());
        }
    }

    public void performRangedAttack(int head, LivingEntity entity) {
        this.performRangedAttack(head, entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_() * 0.5, entity.m_20189_(), head == 0 && this.f_19796_.m_188501_() < 0.001f);
    }

    public void performRangedAttack(int head, double x, double y, double z, boolean dangerous) {
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_((Player)null, 1024, this.m_20183_(), 0);
        }
        double d0 = this.getHeadX(head);
        double d1 = this.getHeadY(head);
        double d2 = this.getHeadZ(head);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        WitherSkull witherskullentity = new WitherSkull(this.f_19853_, (LivingEntity)this, d3, d4, d5);
        witherskullentity.m_5602_((Entity)this);
        if (dangerous) {
            witherskullentity.m_37629_(true);
        }
        witherskullentity.m_20343_(d0, d1, d2);
        this.f_19853_.m_7967_((Entity)witherskullentity);
    }

    public void spawnFlamingWitherSkull(int head, double x, double y, double z) {
        this.playSound((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_SHOOT.get(), head, Math.max(5.0f, this.m_6121_() - 5.0f), 1.0f);
        double d0 = this.getHeadX(head);
        double d1 = this.getHeadY(head);
        double d2 = this.getHeadZ(head);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        FlamingWitherSkullEntity skull = new FlamingWitherSkullEntity(this.f_19853_, (LivingEntity)this, d3, d4, d5);
        skull.m_5602_((Entity)this);
        skull.m_20343_(d0, d1, d2);
        this.f_19853_.m_7967_((Entity)skull);
    }

    public double getDesiredSegmentX(int segment) {
        if (segment <= 0) {
            return this.m_20185_();
        }
        double staticX = this.segmentDesiredX[segment - 1];
        double staticZ = this.segmentDesiredZ[segment - 1];
        if (this.isPlayingDead()) {
            staticX = 45.0;
            staticZ = 0.0;
        }
        float f = (this.f_20883_ + (float)(180 * (segment - 1))) * ((float)Math.PI / 180);
        float offset = (float)Mth.m_14136_((double)staticZ, (double)staticX);
        float f1 = Mth.m_14089_((float)(f + offset));
        return this.m_20185_() + (double)f1 * Math.sqrt(staticX * staticX + staticZ * staticZ);
    }

    public double getDesiredSegmentY(int segment) {
        double pos = this.m_20188_();
        if (this.isPlayingDead()) {
            pos = this.m_20191_().m_82399_().m_7098_() + 10.0;
        }
        return pos;
    }

    public double getDesiredSegmentZ(int segment) {
        if (segment <= 0) {
            return this.m_20189_();
        }
        double staticX = this.segmentDesiredX[segment - 1];
        double staticZ = this.segmentDesiredZ[segment - 1];
        if (this.isPlayingDead()) {
            staticX = 45.0;
            staticZ = 0.0;
        }
        float f = (this.f_20883_ + (float)(180 * (segment - 1))) * ((float)Math.PI / 180);
        float offset = (float)Mth.m_14136_((double)staticZ, (double)staticX);
        float f1 = Mth.m_14031_((float)(f + offset));
        return this.m_20189_() + (double)f1 * Math.sqrt(staticX * staticX + staticZ * staticZ);
    }

    public void m_5997_(double deltaX, double deltaY, double deltaZ) {
        this.hasDistantImpulse = true;
    }

    public void m_147240_(double strength, double x, double z) {
        if (!(strength <= 0.0)) {
            this.hasDistantImpulse = true;
        }
    }

    protected void m_6135_() {
        super.m_6135_();
        this.hasDistantImpulse = true;
    }

    protected void m_5834_() {
        super.m_5834_();
        this.distanceHurtMarked = this.f_19796_.m_188500_() >= this.m_21133_(Attributes.f_22278_);
    }

    public Vec3[] calculateHeadPositions() {
        Vec3[] positions = new Vec3[3];
        for (int i = 0; i < 3; ++i) {
            positions[i] = this.calculateHeadPosition(i);
        }
        return positions;
    }

    public Vec3 calculateHeadPosition(int head) {
        if (head > 2) {
            head = 2;
        }
        float yBodyRot = (this.f_20883_ + 180.0f) * ((float)Math.PI / 180);
        float yBodyRot90 = (this.f_20883_ + 270.0f) * ((float)Math.PI / 180);
        float xBodyRot = -(this.xBodyRot + 270.0f) * ((float)Math.PI / 180);
        double staticX = this.headPosX[head][this.getPhase()];
        double staticY = this.headPosY[head][this.getPhase()];
        double staticZ = this.headPosZ[head][this.getPhase()];
        double xOffset = (double)Mth.m_14089_((float)yBodyRot) * staticX;
        double zOffset = (double)Mth.m_14031_((float)yBodyRot) * staticX;
        float offset = (float)Mth.m_14136_((double)staticZ, (double)staticY);
        double rawX = Mth.m_14089_((float)(xBodyRot + offset)) * Mth.m_14089_((float)yBodyRot90);
        double rawY = Mth.m_14031_((float)(xBodyRot + offset));
        double rawZ = Mth.m_14089_((float)(xBodyRot + offset)) * Mth.m_14031_((float)yBodyRot90);
        double x = xOffset + this.m_20185_() + rawX * Math.sqrt(staticZ * staticZ + staticY * staticY);
        double y = this.m_20186_() + rawY * Math.sqrt(staticZ * staticZ + staticY * staticY);
        double z = zOffset + this.m_20189_() + rawZ * Math.sqrt(staticZ * staticZ + staticY * staticY);
        return new Vec3(x, y, z);
    }

    @Override
    public Vec3 getHeadPos(int head) {
        if (head > 2) {
            head = 2;
        }
        return this.headPos[head];
    }

    public Vec3 getHeadPosO(int head) {
        if (head > 2) {
            head = 2;
        }
        return this.headPosO[head];
    }

    public double getHeadX(int head) {
        return this.getHeadPos(head).m_7096_();
    }

    public double getHeadY(int head) {
        return this.getHeadPos(head).m_7098_();
    }

    public double getHeadZ(int head) {
        return this.getHeadPos(head).m_7094_();
    }

    public double getPrevHeadX(int head) {
        return this.getHeadPosO(head).m_7096_();
    }

    public double getPrevHeadY(int head) {
        return this.getHeadPosO(head).m_7098_();
    }

    public double getPrevHeadZ(int head) {
        return this.getHeadPosO(head).m_7094_();
    }

    public void m_7380_(CompoundTag compound) {
        ListTag headsRoaring = new ListTag();
        for (int i = 0; i < 3; ++i) {
            boolean roaring = this.getCanRoar(i);
            CompoundTag head = new CompoundTag();
            head.m_128379_(Integer.toString(i), roaring);
            head.m_128405_("Time", this.roarTicks[i]);
            headsRoaring.add((Object)head);
        }
        compound.m_128365_("HeadsRoaring", (Tag)headsRoaring);
        CompoundTag playDeadManagerNBT = new CompoundTag();
        PlayDeadManager playDeadManager = this.getPlayDeadManager();
        playDeadManagerNBT.m_128379_("PodiumPlaced", playDeadManager.isPodiumPlaced());
        if (playDeadManager.getPodiumPos() != null) {
            playDeadManagerNBT.m_128365_("PodiumPos", (Tag)NbtUtils.m_129224_((BlockPos)playDeadManager.getPodiumPos()));
        }
        playDeadManagerNBT.m_128405_("StateTicks", playDeadManager.getTicks());
        playDeadManagerNBT.m_128405_("State", playDeadManager.getState().ordinal());
        playDeadManagerNBT.m_128405_("RevivalTime", playDeadManager.getTicksSinceRevival());
        playDeadManagerNBT.m_128379_("RecentlyRevived", playDeadManager.hasRecentlyBeenRevived());
        playDeadManagerNBT.m_128405_("CommandBlockMissingTicks", playDeadManager.getTicksSinceCommandBlockMissing());
        compound.m_128365_("PlayDeadManager", (Tag)playDeadManagerNBT);
        compound.m_128405_("Phase", this.getPhase());
        super.m_7380_(compound);
        compound.m_128405_("Invul", this.getInvulnerableTicks());
        compound.m_128405_("StartingInvul", this.getStartingInvulnerableTicks());
        compound.m_128405_("ConsumedEntities", this.getConsumedEntities());
        if (this.getAlternativeUltimateTarget() != null) {
            compound.m_128365_("AlternativeUltimateTarget", (Tag)WitherStormModNBTUtil.writeVector3d(this.getAlternativeUltimateTarget()));
        }
        if (this.targetManager.currentPlayerChunkPos() != null) {
            compound.m_128365_("UltimateTargetChunkPos", (Tag)WitherStormModNBTUtil.writeChunkPos(this.targetManager.currentPlayerChunkPos()));
        }
        compound.m_128379_("OtherHeadsDisabled", this.areOtherHeadsDisabled());
        compound.m_128405_("TargetStationaryTicks", this.targetManager.targetStationaryTicks());
        compound.m_128405_("TargetRunawayAttempts", this.targetManager.getRunawayAttempts());
        if (this.targetManager.getTargetOverride() != null) {
            compound.m_128362_("TargetOverride", this.targetManager.getTargetOverride());
        }
        if (this.targetManager.getBlockTargetOverride() != null) {
            compound.m_128365_("BlockTargetOverride", (Tag)NbtUtils.m_129224_((BlockPos)this.targetManager.getBlockTargetOverride()));
        }
        CompoundTag ultimateTargetDistractions = new CompoundTag();
        if (this.getUltimateTargetDistractedPos() != null) {
            ultimateTargetDistractions.m_128365_("DistractedPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getUltimateTargetDistractedPos()));
        }
        ultimateTargetDistractions.m_128379_("CanBeDistracted", this.targetManager.canBeDistracted());
        ultimateTargetDistractions.m_128379_("IsDistracted", this.targetManager.isDistracted());
        ultimateTargetDistractions.m_128405_("TicksSinceDistracted", this.targetManager.getTicksSinceDistracted());
        ultimateTargetDistractions.m_128405_("CanBeDistractedFor", this.targetManager.getDistractedTickTime());
        ultimateTargetDistractions.m_128405_("DistractionWait", this.targetManager.getDistractionWait());
        compound.m_128365_("UltimateTargetDistraction", (Tag)ultimateTargetDistractions);
        compound.m_128350_("YBodyRot", this.f_20883_);
        compound.m_128350_("XBodyRot", this.xBodyRot);
        compound.m_128379_("Mirrored", this.isMirrored());
        ListTag headRots = new ListTag();
        for (int i = 0; i < 2; ++i) {
            CompoundTag headRot = new CompoundTag();
            headRot.m_128350_("xRot", this.getHeadXRot(i));
            headRot.m_128350_("yRot", this.getHeadYRot(i));
            headRots.add((Object)headRot);
        }
        compound.m_128365_("HeadRots", (Tag)headRots);
        this.summoningManager.ifPresent(manager -> compound.m_128405_("SymbiontSummoningCooldown", manager.getSummoningDelay()));
        ListTag distractions = new ListTag();
        for (int i = 0; i < 3; ++i) {
            CompoundTag distractionsCompound = new CompoundTag();
            if (this.getDistractedPos(i) != null) {
                distractionsCompound.m_128365_("Pos", (Tag)WitherStormModNBTUtil.writeVector3d(this.getDistractedPos(i)));
            }
            distractionsCompound.m_128405_("DistractionTime", this.distractedTime[i]);
            distractions.add((Object)distractionsCompound);
        }
        compound.m_128365_("Distractions", (Tag)distractions);
        compound.m_128379_("ShouldShowHole", ((Boolean)this.f_19804_.m_135370_(SHOULD_SHOW_HOLE)).booleanValue());
        CompoundTag headInjuries = new CompoundTag();
        this.headInjuries.save(headInjuries);
        compound.m_128365_("HeadInjuries", (Tag)headInjuries);
    }

    public void m_7378_(CompoundTag compound) {
        CompoundTag ultimateTargetDistractions;
        ListTag headsRoaring = compound.m_128437_("HeadsRoaring", 10);
        for (int i = 0; i < 3; ++i) {
            CompoundTag head = headsRoaring.m_128728_(i);
            this.f_19804_.m_135381_(HEAD_ROARS.get(i), (Object)head.m_128471_(Integer.toString(i)));
            this.roarTicks[i] = head.m_128451_("Time");
        }
        CompoundTag playDeadManagerNBT = compound.m_128469_("PlayDeadManager");
        PlayDeadManager playDeadManager = this.getPlayDeadManager();
        playDeadManager.setPodiumPlaced(playDeadManagerNBT.m_128471_("PodiumPlaced"));
        if (playDeadManagerNBT.m_128441_("PodiumPos")) {
            playDeadManager.setPodiumPos(NbtUtils.m_129239_((CompoundTag)playDeadManagerNBT.m_128469_("PodiumPos")));
        }
        playDeadManager.setTickAmountAndO(playDeadManagerNBT.m_128451_("StateTicks"));
        int state = playDeadManagerNBT.m_128451_("State");
        if (state >= 0 && state < PlayDeadManager.State.values().length) {
            playDeadManager.setState(PlayDeadManager.State.values()[state]);
        }
        playDeadManager.setTicksSinceRevival(playDeadManagerNBT.m_128451_("RevivalTime"));
        playDeadManager.setRecentlyRevived(playDeadManagerNBT.m_128471_("RecentlyRevived"));
        playDeadManager.setTicksSinceCommandBlockMissing(playDeadManagerNBT.m_128451_("CommandBlockMissingTicks"));
        this.setPhase(compound.m_128451_("Phase"));
        super.m_7378_(compound);
        ArrayList<AttributeModifierSnapshot> attributeConfigs = new ArrayList<AttributeModifierSnapshot>();
        attributeConfigs.addAll((Collection<AttributeModifierSnapshot>)WitherStormModConfig.COMMON.getAttributeConfigs());
        attributeConfigs.addAll((Collection<AttributeModifierSnapshot>)WitherStormModConfig.SERVER.getAttributeConfigs());
        for (AttributeModifierSnapshot snapshot : attributeConfigs) {
            snapshot.applyModifier(this.m_21204_());
        }
        this.setInvulnerableTicks(compound.m_128451_("Invul"));
        this.setStartingInvulnerableTicks(compound.m_128451_("StartingInvul"));
        if (compound.m_128441_("ConsumedEntities")) {
            this.setConsumedEntities(compound.m_128451_("ConsumedEntities"));
        }
        if (this.m_8077_()) {
            this.bossEvent.ifPresent(bossEvent -> bossEvent.m_6456_(this.m_5446_()));
        }
        if (compound.m_128441_("AlternativeUltimateTarget")) {
            this.targetManager.setAlternativeUltimateTarget(WitherStormModNBTUtil.readVector3d(compound.m_128469_("AlternativeUltimateTarget")));
        }
        if (compound.m_128441_("UltimateTargetChunkPos")) {
            this.targetManager.setCurrentPlayerChunkpos(WitherStormModNBTUtil.readChunkPos(compound.m_128469_("UltimateTargetChunkPos")));
        }
        this.setOtherHeadsDisabled(compound.m_128471_("OtherHeadsDisabled"));
        this.targetManager.setTargetStationaryTicks(compound.m_128451_("TargetStationaryTicks"));
        this.targetManager.setRunawayAttempts(compound.m_128451_("TargetRunawayAttempts"));
        if (compound.m_128441_("TargetOverride")) {
            this.targetManager.setTargetOverride(compound.m_128342_("TargetOverride"));
        }
        if (compound.m_128441_("BlockTargetOverride")) {
            this.targetManager.setBlockTargetOverride(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BlockTargetOverride")));
        }
        if ((ultimateTargetDistractions = compound.m_128469_("UltimateTargetDistraction")).m_128441_("DistractedPos")) {
            this.targetManager.setDistractedPos(NbtUtils.m_129239_((CompoundTag)ultimateTargetDistractions.m_128469_("DistractedPos")));
        }
        this.targetManager.setCanBeDistracted(ultimateTargetDistractions.m_128471_("CanBeDistracted"));
        this.targetManager.markDistracted(ultimateTargetDistractions.m_128471_("IsDistracted"));
        this.targetManager.setTicksSinceDistracted(ultimateTargetDistractions.m_128451_("TicksSinceDistracted"));
        this.targetManager.setDistractedTickTime(ultimateTargetDistractions.m_128451_("CanBeDistractedFor"));
        this.targetManager.setDistractionWait(ultimateTargetDistractions.m_128451_("DistractionWait"));
        this.m_5618_(compound.m_128457_("YBodyRot"));
        this.setXBodyRot(compound.m_128457_("XBodyRot"));
        this.setMirrored(compound.m_128471_("Mirrored"));
        ListTag headRots = compound.m_128437_("HeadRots", 10);
        for (int i = 0; i < 2; ++i) {
            CompoundTag headRot = headRots.m_128728_(i);
            this.xRotHeads[i] = headRot.m_128457_("xRot");
            this.yRotHeads[i] = headRot.m_128457_("yRot");
        }
        this.getBossInfo().ifPresent(info -> info.m_8321_(!this.isPlayingDead()));
        this.summoningManager.ifPresent(manager -> manager.setSummoningDelay(compound.m_128451_("SymbiontSummoningCooldown")));
        ListTag distractions = compound.m_128437_("Distractions", 10);
        for (int i = 0; i < 3; ++i) {
            CompoundTag distractionsCompound = distractions.m_128728_(i);
            if (distractionsCompound.m_128441_("Pos")) {
                this.setDistractedPos(i, WitherStormModNBTUtil.readVector3d(distractionsCompound.m_128469_("Pos")));
            }
            this.distractedTime[i] = distractionsCompound.m_128451_("DistractionTime");
        }
        this.f_19804_.m_135381_(SHOULD_SHOW_HOLE, (Object)compound.m_128471_("ShouldShowHole"));
        this.headInjuries.read(compound.m_128469_("HeadInjuries"));
    }

    public void m_6593_(Component component) {
        super.m_6593_(component);
        this.bossEvent.ifPresent(bossEvent -> bossEvent.m_6456_(this.m_5446_()));
    }

    public void setInvulnerableTicks(int ticks) {
        this.f_19804_.m_135381_(INVULNERABLE, (Object)ticks);
    }

    public int getInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(INVULNERABLE);
    }

    public void setStartingInvulnerableTicks(int ticks) {
        this.f_19804_.m_135381_(STARTING_INVULNERABLE, (Object)ticks);
    }

    public int getStartingInvulnerableTicks() {
        return (Integer)this.f_19804_.m_135370_(STARTING_INVULNERABLE);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public int getConsumptionAmountForPhase(int phase) {
        int clusterRadius = (int)Math.max(1.0, (double)((float)phase * 0.75f));
        if (phase >= 0) {
            return (int)((100.0 * (double)(phase - 1 < 0 ? 0 : phase - 1) * ((double)(phase - 1 < 0 ? 0 : phase - 1) * 2.0) * (double)(clusterRadius * clusterRadius * clusterRadius) + Math.max(100.0, 100.0 * (double)phase * ((double)phase * 2.0) * (double)(clusterRadius * clusterRadius * clusterRadius))) * this.m_21133_((Attribute)WitherStormModAttributes.EVOLUTION_SPEED.get()));
        }
        return 0;
    }

    public boolean setPhase(int phase) {
        if (phase >= 0 && phase <= 7) {
            this.f_19804_.m_135381_(PHASE, (Object)phase);
            this.clusterRadius = (int)Math.max(1.0, (double)((float)this.getPhase() * 0.75f));
            this.entityConsumptionRadius = this.getPhase() > 3 ? 64 : 16;
            this.consumptionAmountTillPhaseChange = this.getConsumptionAmountForPhase(this.getPhase());
            this.setConsumedEntities(this.getConsumptionAmountForPhase(phase - 1));
            this.m_20090_();
            this.m_6210_();
            if (this.isAddedToWorld()) {
                if (phase < 6) {
                    this.removeSegments();
                } else {
                    this.readdSegments();
                }
            }
            if (phase == 6 && this.getConsumedEntities() < this.getSubPhaseRequirement(phase)) {
                this.setOtherHeadsDisabled(true);
            }
            this.updateSections();
            if (phase != 6) {
                this.setOtherHeadsDisabled(false);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.shouldPlaySoundLoops()) {
                    message = new CreateLoopingSoundMessage(this);
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
                } else {
                    message = new RemoveSoundLoopMessage(this);
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
                }
            }
            this.headInjuries.update(phase);
            AttributeInstance health = this.m_21051_(Attributes.f_22276_);
            if (!this.f_19853_.f_46443_) {
                AttributeModifier modifier;
                if (phase < 4) {
                    health.m_22127_(HEALTH_MODIFIER_UUID);
                } else if (phase > 3 && !health.m_22109_(modifier = new AttributeModifier(HEALTH_MODIFIER_UUID, "Phase health modifier", 624.0, AttributeModifier.Operation.ADDITION))) {
                    health.m_22125_(modifier);
                }
            }
            AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
            if (!this.f_19853_.f_46443_) {
                AttributeModifier modifier;
                if (phase < 4) {
                    armor.m_22127_(ARMOR_MODIFIER_UUID);
                } else if (phase > 3 && !armor.m_22109_(modifier = new AttributeModifier(ARMOR_MODIFIER_UUID, "Phase armor modifier", (double)((phase + 1) * 2), AttributeModifier.Operation.ADDITION))) {
                    armor.m_22125_(modifier);
                }
            }
            return true;
        }
        return false;
    }

    protected void updateSections() {
        if (this.getPhase() == 5) {
            if (this.getConsumptionAmountForPhase(this.getPhase()) <= this.getConsumedEntities()) {
                this.sections[0].setSize(60.0f, 35.0f);
                this.sections[1].setSize(60.0f, 35.0f);
                this.sections[0].setOffset(24.0, 28.0, 0.0);
                this.sections[1].setOffset(-24.0, 28.0, 0.0);
                this.fallingSection.setSize(50.0f, 70.0f);
                this.fallingSection.setOffset(0.0, 60.0, 30.0);
            } else {
                this.sections[0].setSize(30.0f, 15.0f);
                this.sections[1].setSize(30.0f, 15.0f);
                this.sections[0].setOffset(13.0, 28.0, 0.0);
                this.sections[1].setOffset(-13.0, 28.0, 0.0);
                this.fallingSection.setSize(30.0f, 35.0f);
                this.fallingSection.setOffset(0.0, 35.0, 15.0);
            }
        } else if (this.getPhase() == 6) {
            this.sections[0].setSize(60.0f, 35.0f);
            this.sections[1].setSize(60.0f, 35.0f);
            this.sections[0].setOffset(24.0, 28.0, 0.0);
            this.sections[1].setOffset(-24.0, 28.0, 0.0);
            this.fallingSection.setSize(50.0f, 70.0f);
            this.fallingSection.setOffset(0.0, 60.0, 30.0);
        } else if (this.getPhase() == 7) {
            this.sections[0].setSize(95.0f, 45.0f);
            this.sections[1].setSize(95.0f, 45.0f);
            this.sections[0].setOffset(28.0, 28.0, 0.0);
            this.sections[1].setOffset(-28.0, 28.0, 0.0);
            this.fallingSection.setSize(60.0f, 85.0f);
            this.fallingSection.setOffset(0.0, 80.0, 30.0);
        }
    }

    public void m_7350_(EntityDataAccessor<?> parameter) {
        super.m_7350_(parameter);
        if (parameter.equals(PHASE)) {
            this.updateSections();
            this.m_6210_();
            this.headInjuries.update(this.getPhase());
        } else if (parameter.equals(CONSUMED_ENTITIES)) {
            this.updateSections();
        }
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(WitherStormModConfig.SERVER.invulnerabilityTime.get() * 20);
    }

    public void m_7601_(BlockState blockState, Vec3 vector3d) {
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.ifPresent(bossEvent -> bossEvent.m_6543_(player));
    }

    @Override
    public SoundEvent getBossTheme() {
        if (this.hasRecentlyBeenRevived()) {
            return (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_REVIVAL_THEME.get();
        }
        return (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_BOSS_THEME.get();
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public boolean shouldPlayBossTheme() {
        boolean commandBlockOverride = false;
        CommandBlockEntity commandBlock = this.getPlayDeadManager().getCommandBlock();
        if (commandBlock != null && commandBlock.m_6084_()) {
            commandBlockOverride = commandBlock.getState().shouldShowOwnerBossBar();
        }
        return IBossTheme.super.shouldPlayBossTheme() && this.shouldPlaySoundLoop && !this.m_21525_() && !this.m_20067_() && (!this.isDeadOrPlayingDead() || commandBlockOverride);
    }

    @Override
    public boolean isStillAlive() {
        return this.m_6084_();
    }

    @Override
    public Vec3 getPosition() {
        return this.m_20182_();
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.ifPresent(bossEvent -> bossEvent.m_6539_(player));
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource source) {
        int damage = this.m_5639_(p_225503_1_, p_225503_2_);
        if (damage > 15) {
            this.onBigFall();
        }
        return false;
    }

    public void onBigFall() {
        if (this.getPhase() > 3) {
            this.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_THUMP.get(), this.m_6121_() + 3.0f, 1.0f);
            this.shake(30.0f, 12.0f);
        }
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity entity) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return false;
    }

    public void m_6504_(LivingEntity entity, float p_82196_2_) {
        this.performRangedAttack(0, entity);
    }

    public boolean m_7090_() {
        return this.getInvulnerableTicks() > 900 && this.getPhase() < 4;
    }

    public boolean m_5789_() {
        return this.shouldDoNothing() && this.getPhase() < 4;
    }

    @Nullable
    public LivingEntity getAlternativeTarget(int head) {
        return this.targets[head];
    }

    public void setAlternativeTarget(int head, @Nullable LivingEntity entity) {
        this.targets[head] = entity;
    }

    public boolean m_6469_(DamageSource source, float floatIn) {
        if (source.m_19378_()) {
            return super.m_6469_(source, floatIn);
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (source != DamageSource.f_19312_ && !(source.m_7639_() instanceof WitherStormEntity)) {
            Entity entity;
            if (this.shouldDoNothing() && source != DamageSource.f_19317_) {
                return false;
            }
            if (this.getPhase() > 3 && this.isCompletelyInvulnerable()) {
                return false;
            }
            if (this.m_7090_() && (entity = source.m_7640_()) instanceof AbstractArrow) {
                return false;
            }
            Entity entity1 = source.m_7639_();
            if (entity1 != null && !(entity1 instanceof Player) && entity1 instanceof LivingEntity && ((LivingEntity)entity1).m_6336_() == this.m_6336_()) {
                return false;
            }
            if (this.destroyBlocksTick <= 0) {
                this.destroyBlocksTick = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            return super.m_6469_(source, floatIn);
        }
        return false;
    }

    public int getConsumedEntities() {
        return (Integer)this.f_19804_.m_135370_(CONSUMED_ENTITIES);
    }

    public void setConsumedEntities(int newAmount) {
        int amount;
        this.f_19804_.m_135381_(CONSUMED_ENTITIES, (Object)newAmount);
        this.updateSections();
        if (this.getPhase() == 6 && newAmount > (amount = this.getSubPhaseRequirement(this.getPhase())) && this.areOtherHeadsDisabled()) {
            this.setOtherHeadsDisabled(false);
            this.nextRoarTick[1] = this.f_19797_ + this.f_19796_.m_188503_(30);
            this.nextRoarTick[2] = this.f_19797_ + this.f_19796_.m_188503_(30);
            this.getSegmentsManager().ifPresent(manager -> {
                for (WitherStormSegmentEntity entity : manager.getSegments()) {
                    if (entity == null) continue;
                    entity.nextRoarTick[1] = entity.f_19797_ + entity.f_19796_.m_188503_(30);
                    entity.nextRoarTick[2] = entity.f_19797_ + entity.f_19796_.m_188503_(30);
                }
            });
        }
    }

    public void addToConsumedEntities(int amount) {
        this.setConsumedEntities(this.getConsumedEntities() + amount);
    }

    public void setRoar(int head, boolean screaming) {
        this.f_19804_.m_135381_(HEAD_ROARS.get(head), (Object)true);
        SoundEvent event = (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_ROAR.get();
        if (screaming) {
            event = (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_HURT.get();
        }
        if (this.areOtherHeadsDisabled() || this.getPhase() < 4 && this.getPhase() > 1) {
            if (head == 0) {
                this.playSound(event, head, Math.max(6.0f, this.m_6121_() + 2.5f), 1.0f);
            }
        } else if (this.getPhase() > 3 && !this.areOtherHeadsDisabled()) {
            this.playSound(event, head, Math.max(6.0f, this.m_6121_() + 2.5f), 1.0f);
        }
    }

    public void openMouth(int head) {
        this.f_19804_.m_135381_(HEAD_ROARS.get(head), (Object)true);
    }

    public void disableRoar(int head) {
        this.f_19804_.m_135381_(HEAD_ROARS.get(head), (Object)false);
    }

    public void closeMouth(int head) {
        this.f_19804_.m_135381_(HEAD_ROARS.get(head), (Object)false);
    }

    public boolean getCanRoar(int head) {
        return (Boolean)this.f_19804_.m_135370_(HEAD_ROARS.get(head));
    }

    public int m_8132_() {
        return this.getPhase() > 3 ? 180 : super.m_8132_();
    }

    public ServerPlayer getUltimateTarget() {
        return this.targetManager.getUltimateTarget();
    }

    public Vec3 getAlternativeUltimateTarget() {
        return this.targetManager.getAlternativeUltimateTarget();
    }

    @Nullable
    public Vec3 getUltimateTargetPos() {
        UltimateTargetManager manager = this.getUltimateTargetManager();
        if (manager.getBlockTargetOverride() != null) {
            return Vec3.m_82539_((Vec3i)manager.getBlockTargetOverride());
        }
        if (this.isDistractedFromUltimateTarget()) {
            return Vec3.m_82539_((Vec3i)manager.getDistractedPos());
        }
        if (manager.getUltimateTarget() != null || manager.getAlternativeUltimateTarget() != null) {
            return manager.getUltimateTargetPos();
        }
        return null;
    }

    public Section[] getSections() {
        if (this.xBodyRot != 0.0f) {
            return new Section[]{this.fallingSection, this.sections[2]};
        }
        return this.sections;
    }

    public void setSections(Section[] sections) {
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i] = sections[i];
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.f_19853_.f_46443_) {
            Message message;
            DistantRendererManager.addEntityToDistantRenderer(this, PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()));
            if (this.shouldPlaySoundLoops()) {
                message = new CreateLoopingSoundMessage(this);
                WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
            }
            this.createDebris(this.isDeadOrPlayingDead());
            this.createDebrisRings(this.isDeadOrPlayingDead());
            this.getPlayDeadManager().sendChanges(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), false);
            message = new CreateDebrisMessage(this, this.isDeadOrPlayingDead());
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.DIMENSION.with(() -> this.f_19853_.m_46472_()), (Object)message);
            this.bowelsInstance.ifPresent(instance -> instance.loadInstance());
        }
    }

    public void findSegments() {
        if (!this.f_19853_.f_46443_) {
            this.getSegmentsManager().ifPresent(manager -> {
                ServerLevel world = (ServerLevel)this.f_19853_;
                manager.findSegments(world);
            });
        }
    }

    public void createSegments() {
        this.getSegmentsManager().ifPresent(manager -> manager.createSegments());
    }

    public void removeSegments() {
        this.getSegmentsManager().ifPresent(manager -> manager.removeSegments());
    }

    public void readdSegments() {
        this.getSegmentsManager().ifPresent(manager -> manager.readdSegments());
    }

    public Optional<SegmentsManager> getSegmentsManager() {
        return this.segments;
    }

    public void addSegments() {
        this.getSegmentsManager().ifPresent(manager -> manager.addSegments());
    }

    @Override
    public boolean areOtherHeadsDisabled() {
        return (Boolean)this.f_19804_.m_135370_(OTHER_HEADS_DISABLED);
    }

    public void setOtherHeadsDisabled(boolean value) {
        this.f_19804_.m_135381_(OTHER_HEADS_DISABLED, (Object)value);
        this.getSegmentsManager().ifPresent(manager -> {
            WitherStormSegmentEntity[] segments = manager.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                if (segments[i] == null) continue;
                segments[i].setOtherHeadsDisabled(value);
            }
        });
    }

    public void setMirrored(boolean mirrored) {
        this.f_19804_.m_135381_(MIRRORED, (Object)mirrored);
    }

    public boolean isMirrored() {
        return (Boolean)this.f_19804_.m_135370_(MIRRORED);
    }

    public List<DebrisChunks> createDebris(boolean hidden) {
        int tinyDebrisCloud = Math.max(65, this.f_19796_.m_188503_(75));
        DebrisChunks tinyDebris = new DebrisChunks(hidden, tinyDebrisCloud, 13.5f, -4.5f, 40, 50, 0.3f, 2);
        int smallDebrisCloud = Math.max(85, this.f_19796_.m_188503_(105));
        DebrisChunks smallDebris = new DebrisChunks(hidden, smallDebrisCloud, 15.0f, -4.5f, 40, 50, 0.3f, 3);
        int debrisChunks = Math.max(700, this.f_19796_.m_188503_(800));
        DebrisChunks debris = new DebrisChunks(hidden, debrisChunks, 50.0f, 0.0f, 80, 20, 0.3f, 4);
        int secondaryDebrisChunks = Math.max(800, this.f_19796_.m_188503_(900));
        DebrisChunks secondaryDebris = new DebrisChunks(hidden, secondaryDebrisChunks, 80.0f, 40.0f, 80, 20, 0.6f, 5);
        int terteriaryDebrisChunks = Math.max(1300, this.f_19796_.m_188503_(1400));
        DebrisChunks tertiaryDebris = new DebrisChunks(hidden, terteriaryDebrisChunks, 100.0f, 60.0f, 80, 20, 1.0f, 6);
        this.debris = ImmutableList.of((Object)tinyDebris, (Object)smallDebris, (Object)debris, (Object)secondaryDebris, (Object)tertiaryDebris);
        return this.debris;
    }

    public List<DebrisRingSettings> createDebrisRings(boolean hidden) {
        ImmutableList list;
        this.debrisRings = list = ImmutableList.of((Object)new DebrisRingSettings(16, 100.0f, 60.0f, 30.0f, 25.0f, 0.02f, true, 4, hidden), (Object)new DebrisRingSettings(24, 160.0f, 120.0f, 10.0f, 50.0f, 0.005f, false, 4, hidden), (Object)new DebrisRingSettings(24, 180.0f, 100.0f, 30.0f, 60.0f, 0.001f, true, 4, hidden), (Object)new DebrisRingSettings(24, 130.0f, 50.0f, 80.0f, 10.0f, 0.008f, false, 4, hidden), (Object)new DebrisRingSettings(36, 240.0f, 200.0f, 0.0f, 40.0f, 0.002f, true, 6, hidden), (Object)new DebrisRingSettings(36, 250.0f, 210.0f, -30.0f, 10.0f, 0.001f, true, 6, hidden));
        return this.debrisRings;
    }

    public List<DebrisRingSettings> getDebrisRings() {
        return this.debrisRings;
    }

    public List<DebrisChunks> getChunks() {
        return this.debris;
    }

    public int getDeathTime() {
        return this.witherStormDeathTime;
    }

    public void m_5802_(BlockPos pos) {
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public void startBiting(int head) {
        this.biteTicks[head] = 0;
        this.f_19804_.m_135381_(HEADS_BITING.get(head), (Object)true);
    }

    public void stopBiting(int head) {
        this.f_19804_.m_135381_(HEADS_BITING.get(head), (Object)false);
    }

    public boolean isBiting(int head) {
        return (Boolean)this.f_19804_.m_135370_(HEADS_BITING.get(head));
    }

    public void m_6710_(LivingEntity entity) {
        super.m_6710_(entity);
        if (entity != null) {
            this.f_19804_.m_135381_(DATA_TARGET_ID, (Object)entity.m_19879_());
        } else {
            this.f_19804_.m_135381_(DATA_TARGET_ID, (Object)0);
        }
    }

    public int getTargetId() {
        return (Integer)this.f_19804_.m_135370_(DATA_TARGET_ID);
    }

    public final boolean isOnDistantRenderer() {
        return this.isOnDistantRenderer;
    }

    public final void setOnDistantRenderer() {
        this.isOnDistantRenderer = true;
    }

    public int getHeadInjureAttemptCooldown(int head) {
        return this.headInjuries.getHeadInjureAttemptCooldown(head);
    }

    public void setHeadInjureAttemptCooldown(int head, int amount) {
        this.headInjuries.setHeadInjureAttemptCooldown(head, amount);
    }

    public int getHeadInjuryTicks(int head) {
        return this.headInjuries.getHeadInjuryTicks(head);
    }

    public int getHeadInjuryTime() {
        return this.headInjuries.getHeadInjuryTime();
    }

    public boolean isEntityNearby(Entity entity) {
        return this.getSearchBox().m_82390_(entity.m_20182_());
    }

    public AABB getSearchBox() {
        double range = this.getPhase() > 3 ? this.m_21133_(Attributes.f_22277_) : this.m_21133_((Attribute)WitherStormModAttributes.HUNCHBACK_FOLLOW_RANGE.get());
        return this.getPhase() > 3 ? this.m_20191_().m_82377_(range, range + 255.0, range) : this.m_20191_().m_82377_(range, range * 2.0, range);
    }

    public void playSound(SoundEvent event, int head, float volume, float pitch) {
        Vec3 pos = new Vec3(this.getHeadX(head), this.getHeadY(head), this.getHeadZ(head));
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, event, this.m_5720_(), volume, pitch);
        }
    }

    public void lerpHeadsTo(int head, float lerpToX, float lerpToY, float steps) {
        this.lerpXRotHeads[head] = lerpToX;
        this.lerpYRotHeads[head] = lerpToY;
        this.lerpXRotHeadsSteps[head] = steps;
        this.lerpYRotHeadsSteps[head] = steps;
    }

    public void lerpHeadsXTo(int head, float lerpToX, float steps) {
        this.lerpXRotHeads[head] = lerpToX;
        this.lerpXRotHeadsSteps[head] = steps;
    }

    public void lerpHeadsYTo(int head, float lerpToY, float steps) {
        this.lerpYRotHeads[head] = lerpToY;
        this.lerpYRotHeadsSteps[head] = steps;
    }

    @Override
    public float getMouthAnimation(int head, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.mouthAnimO[head], (float)this.mouthAnim[head]);
    }

    @Override
    public float getBrokenJawAnimation(int head, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.jawBrokenAnimationO[head], (float)this.jawBrokenAnimation[head]);
    }

    public int getTentacleTickCount() {
        return this.tentacleTickCount;
    }

    @Override
    public float getTentacleAnimation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.tentacleTickCountO, (float)this.tentacleTickCount);
    }

    @Override
    public float getFadeAnimation(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.onGroundAnimationO, (float)this.onGroundAnimation);
    }

    @Override
    public float getFadeAnimation() {
        return this.onGroundAnimation;
    }

    public boolean isBeingTornApart() {
        return this.getConsumedEntities() >= 2125000 || (Boolean)this.f_19804_.m_135370_(SHOULD_SHOW_HOLE) != false && this.getPhase() > 6;
    }

    public void setShouldShowHole(boolean flag) {
        this.f_19804_.m_135381_(SHOULD_SHOW_HOLE, (Object)flag);
    }

    public PlayDeadManager getPlayDeadManager() {
        return this.playDeadManager;
    }

    public boolean shouldDoNothing() {
        if (this.getInvulnerableTicks() > 0) {
            return true;
        }
        return this.getPlayDeadManager().getState().disablesAi();
    }

    @Override
    public boolean isDeadOrPlayingDead() {
        if (this.m_21224_()) {
            return true;
        }
        return this.getPlayDeadManager().getState().disablesAi();
    }

    @Override
    public boolean isPlayingDead() {
        return this.getPlayDeadManager().getState().disablesAi();
    }

    public boolean canEvolve() {
        return this.getPhase() < 5 || this.getPhase() > 5;
    }

    public int getSubPhaseRequirement(int phase) {
        return this.getConsumptionAmountForPhase(phase) - this.getConsumptionAmountForPhase(phase - 1);
    }

    public boolean shouldDoCustomMovement() {
        PlayDeadManager.State state = this.getPlayDeadManager().getState();
        if (state == PlayDeadManager.State.FALLING && this.getPlayDeadManager().getTicks() > 300) {
            return false;
        }
        return this.shouldDoCustomMovement;
    }

    public List<Entity> getTrackedEntities() {
        return this.currentTrackedEntities;
    }

    public Optional<ServerBossEvent> getBossInfo() {
        return this.bossEvent;
    }

    public boolean canFallOnBack() {
        return true;
    }

    @Override
    public void writeData(FriendlyByteBuf buffer) {
        for (int i = 0; i < 2; ++i) {
            buffer.writeFloat(this.xRotHeads[i]);
            buffer.writeFloat(this.yRotHeads[i]);
        }
        buffer.writeBoolean(this.m_20096_());
    }

    @Override
    public void readData(FriendlyByteBuf buffer) {
        for (int i = 0; i < 2; ++i) {
            this.xRotHeads[i] = buffer.readFloat();
            this.yRotHeads[i] = buffer.readFloat();
        }
        this.m_6853_(buffer.readBoolean());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void setXBodyRot(float rot) {
        this.xBodyRot = rot;
    }

    protected void m_6138_() {
        if (this.canFallOnBack() && this.getPlayDeadManager().getState() == PlayDeadManager.State.PLAYING_DEAD) {
            return;
        }
        super.m_6138_();
    }

    public void onFallOnBack() {
        this.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_THUMP.get(), this.m_6121_() + 3.0f, 1.0f);
        this.shake(30.0f, 12.0f);
    }

    public boolean isOnBack() {
        return this.xBodyRot >= 90.0f;
    }

    public void shake(float duration, float power) {
        if (!this.f_19853_.f_46443_) {
            ShakeScreenMessage message = new ShakeScreenMessage(duration, power);
            WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)message);
        }
    }

    public void setFormidibomb(FormidibombEntity entity) {
        this.getPlayDeadManager().setFormidibomb(entity);
    }

    @Nullable
    public FormidibombEntity getFormidibomb() {
        return this.getPlayDeadManager().getFormidibomb();
    }

    public boolean canBeFormidibombed(boolean isExplosion) {
        if (this.shouldIgnoreFormidibomb) {
            return false;
        }
        if (this.getPhase() < 4) {
            return false;
        }
        if (this.getPhase() > 6 && this.isBeingTornApart()) {
            return false;
        }
        if (this.getFormidibomb() == null) {
            return false;
        }
        FormidibombEntity formidibomb = this.getFormidibomb();
        if (!isExplosion && !formidibomb.m_6084_()) {
            return false;
        }
        return !((float)formidibomb.getFuseLife() > 600.0f + this.m_20270_((Entity)formidibomb));
    }

    public void explode() {
        if (this.getPhase() > 3 && !this.isDeadOrPlayingDead()) {
            this.getPlayDeadManager().explode();
        }
    }

    public void reviveFromPlayingDead() {
        if (this.isPlayingDead()) {
            this.getPlayDeadManager().revive();
        }
    }

    public boolean isReviving() {
        return this.getPlayDeadManager().getState() == PlayDeadManager.State.REVIVING;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean isAttractingFormidibomb() {
        boolean flag = false;
        Stream goals = this.f_21345_.m_25386_();
        for (WrappedGoal prioritizedGoal : (WrappedGoal[])goals.toArray(WrappedGoal[]::new)) {
            LookAtFormidibombGoal goal;
            if (!(prioritizedGoal.m_26015_() instanceof LookAtFormidibombGoal) || !(goal = (LookAtFormidibombGoal)prioritizedGoal.m_26015_()).hasTarget()) continue;
            flag = true;
        }
        return flag;
    }

    public boolean isNearbyTickingFormidibomb() {
        FormidibombEntity formidibomb = this.getFormidibomb();
        boolean flag = false;
        if (formidibomb != null && formidibomb.m_6084_() && formidibomb.getStartFuse() > 0 && formidibomb.getFuseLife() <= 800) {
            flag = true;
        }
        return flag;
    }

    public boolean targetApplicable(Class<? extends LivingEntity> targetType, LivingEntity entity, int head) {
        if (entity != this) {
            PlayerWitherStormData data;
            LazyOptional optional;
            if (this.isPlayingDead()) {
                return false;
            }
            if (this.isAttractingFormidibomb()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_21205_().m_41720_() instanceof ShieldItem ? player.m_6117_() : player.m_21206_().m_41720_() instanceof ShieldItem && player.m_6117_()) {
                    return false;
                }
                if (this.hasRecentlyBeenRevived()) {
                    return false;
                }
            }
            if (this.getPhase() > 3 && entity.m_20145_()) {
                return false;
            }
            if (this.getPhase() > 3 && (this.targetInUseBySegment((Entity)entity) || this.alreadyATarget((Entity)entity, head != 0))) {
                return false;
            }
            if (this.isInsideOtherTractorBeam(entity, head)) {
                return false;
            }
            if (this.getPhase() > 3) {
                List entities = this.f_19853_.m_45976_(targetType, this.m_20191_().m_82377_(10.0, 255.0, 10.0));
                for (LivingEntity entityBelow : entities) {
                    if (!entityBelow.m_7306_((Entity)entity)) continue;
                    return false;
                }
                if (this.isEntityBehindBack((Entity)entity)) {
                    return false;
                }
            }
            if ((optional = entity.getCapability(WitherStormModCapabilities.PLAYER_WITHER_STORM_DATA)).isPresent() && (data = (PlayerWitherStormData)optional.resolve().get()).hasKilledSymbiontRecently()) {
                return false;
            }
            return !this.nearNonApplicableObject((Entity)entity);
        }
        return false;
    }

    public boolean nearNonApplicableObject(Entity target) {
        IFormidibomb formidibomb;
        AABB formidibombCheckArea = target.m_20191_().m_82400_(20.0);
        for (Entity toCheck : this.f_19853_.m_45976_(Entity.class, formidibombCheckArea)) {
            if (toCheck instanceof FormidibombEntity) {
                formidibomb = (FormidibombEntity)toCheck;
                if (!formidibomb.m_6084_() || ((FormidibombEntity)formidibomb).getStartFuse() <= 0) continue;
                return true;
            }
            if (!(toCheck instanceof Player)) continue;
            Player player = (Player)toCheck;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                FormidibombItem item;
                int startFuse;
                if (!(stack.m_41720_() instanceof FormidibombItem) || (startFuse = (item = (FormidibombItem)stack.m_41720_()).getStartFuse(stack)) <= 0) continue;
                return true;
            }
        }
        for (BlockEntity tile : WorldUtil.getBlockEntitiesInAABB(this.f_19853_, formidibombCheckArea)) {
            if (!(tile instanceof FormidibombTileEntity) || ((FormidibombTileEntity)(formidibomb = (FormidibombTileEntity)tile)).getStartFuse() <= 0) continue;
            return true;
        }
        if (target instanceof Player) {
            List entities = this.f_19853_.m_45976_(WitheredSymbiontEntity.class, target.m_20191_().m_82400_(50.0));
            for (int i = 0; i < entities.size(); ++i) {
                WitheredSymbiontEntity symbiont = (WitheredSymbiontEntity)entities.get(i);
                if (!symbiont.m_6084_()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isInsideOtherTractorBeam(LivingEntity entity, int head) {
        ArrayList storms = Lists.newArrayList((Object[])new WitherStormEntity[]{this});
        this.getSegmentsManager().ifPresent(manager -> {
            for (WitherStormSegmentEntity segment : manager.getSegments()) {
                if (segment == null || !segment.m_6084_()) continue;
                storms.add(segment);
            }
        });
        for (WitherStormEntity storm : storms) {
            Pair<Boolean, Integer> flag = TractorBeamHelper.isInsideTractorBeam((Entity)entity, storm, 5.0);
            if (!((Boolean)flag.getFirst()).booleanValue() || (Integer)flag.getSecond() == head) continue;
            return true;
        }
        return false;
    }

    public boolean m_6783_(double sqrDistance) {
        double d0 = this.m_20191_().m_82309_();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return sqrDistance < (d0 = d0 * 248.0 * Entity.m_20150_()) * d0;
    }

    public int getTicksSinceRevival() {
        return this.getPlayDeadManager().getTicksSinceRevival();
    }

    public boolean hasRecentlyBeenRevived() {
        return this.getPlayDeadManager().hasRecentlyBeenRevived();
    }

    public boolean isDistractedFromUltimateTarget() {
        return this.targetManager.isDistracted();
    }

    @Nullable
    public BlockPos getUltimateTargetDistractedPos() {
        return this.targetManager.getDistractedPos();
    }

    @Override
    @Nullable
    public Vec3 getDistractedPos(int head) {
        return this.distractedPositions[head];
    }

    @Override
    public void setDistractedPos(int head, @Nullable Vec3 pos) {
        this.distractedPositions[head] = pos;
    }

    @Override
    public void makeDistracted(Vec3 pos, int time, int head) {
        this.distractedTime[head] = time;
        this.setDistractedPos(head, pos);
    }

    public boolean isEntityBehindBack(Entity entity) {
        return this.isPosBehindBack(entity.m_20182_());
    }

    public boolean isPosBehindBack(Vec3 pos) {
        float angle = (float)(Mth.m_14136_((double)(pos.m_7096_() - this.m_20185_()), (double)(pos.m_7094_() - this.m_20189_())) * 57.29577951308232);
        float angleDiff = (Mth.m_14177_((float)(-this.f_20883_)) - angle + 180.0f + 360.0f) % 360.0f - 180.0f;
        return !(angleDiff <= 80.0f) || !(angleDiff >= -80.0f);
    }

    @Override
    public boolean canBeDistracted(int head) {
        return this.getPhase() > 3;
    }

    public void sendToBowels(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            WitherStormBowelsManager.queueEnter(player, this);
        } else {
            WitherStormBowelsManager.enter((ServerLevel)entity.f_19853_, this, entity);
        }
    }

    public boolean canSee(int head, Entity entity) {
        Vec3 pos = this.getHeadPos(head);
        Vec3 entityPos = entity.m_20299_(1.0f);
        if (entity.f_19853_ != this.f_19853_) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(pos, entityPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    @Override
    public float getXBodyRot() {
        return this.xBodyRot;
    }

    @Override
    public float getXBodyRotO() {
        return this.xBodyRotO;
    }

    public void doFlicker() {
        this.flickerTime = 60;
        this.f_19853_.m_7605_((Entity)this, (byte)11);
    }

    public void m_7822_(byte event) {
        if (event == 11) {
            this.doFlicker();
        } else {
            super.m_7822_(event);
        }
    }

    public boolean shouldFlicker() {
        return this.shouldFlicker;
    }

    public int getFlickerTime() {
        return this.flickerTime;
    }

    @Nullable
    public CommandBlockEntity getBowelsCommandBlock() {
        BowelsInstanceManager manager = this.bowelsInstance.orElse(null);
        if (manager != null) {
            return manager.getCommandBlock();
        }
        return null;
    }

    @Nullable
    public WitherStormBowelsManager.BowelsInstance getBowelsInstance() {
        BowelsInstanceManager manager = this.bowelsInstance.orElse(null);
        if (manager != null) {
            return manager.getBowelsInstance();
        }
        return null;
    }

    public void dropDropsAt(Entity player) {
        ItemStack stack = new ItemStack((ItemLike)WitherStormModItems.WITHERED_NETHER_STAR.get());
        ItemEntity item = new ItemEntity(this.f_19853_, player.m_20185_(), player.m_20188_() + 2.0, player.m_20189_(), stack);
        item.m_20334_(0.0, -0.08, 0.0);
        item.m_20242_(true);
        this.f_19853_.m_7967_((Entity)item);
        ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.f_19853_), (Vec3)player.m_20182_().m_82520_(0.0, 10.0, 0.0), (int)ForgeEventFactory.getExperienceDrop((LivingEntity)this, (Player)this.f_20888_, (int)this.m_213860_()));
    }

    public boolean shouldPlaySoundLoops() {
        return this.shouldPlaySoundLoop && !this.m_20067_() && !this.isDeadOrPlayingDead();
    }

    public static SoundEvent getSoundForLoop(int phase, float fade) {
        SoundEvent event = (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_LOOP.get();
        if (phase > 3) {
            event = WitherStormLoopingSoundManager.getSoundBasedOnDistance(fade);
        } else if (phase < 3) {
            event = (SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_PULSE_LOOP.get();
        }
        return event;
    }

    public int getBlockClusterPickupInterval() {
        if (this.getPhase() < 4) {
            return WitherStormModConfig.SERVER.hunchbackClusterPickupInterval.get();
        }
        if (this.getPhase() < 6) {
            return WitherStormModConfig.SERVER.clusterPickupInterval.get();
        }
        return WitherStormModConfig.SERVER.devourerClusterPickupInterval.get();
    }

    public boolean shouldTrackUltimateTarget() {
        CommandBlockEntity entity = this.getBowelsCommandBlock();
        if (entity != null && entity.m_21223_() < entity.m_21233_()) {
            return false;
        }
        return this.shouldFollowUltimateTarget;
    }

    public boolean shouldLookAtUltimateTarget() {
        CommandBlockEntity entity = this.getBowelsCommandBlock();
        return entity == null || !(entity.m_21223_() / entity.m_21233_() <= 0.25f);
    }

    public void setLookPos(int head, @Nullable Vec3 pos) {
        this.f_19804_.m_135381_(TARGETS.get(head), Optional.ofNullable(pos));
    }

    @Nullable
    public Vec3 getLookPos(int head) {
        return ((Optional)this.f_19804_.m_135370_(TARGETS.get(head))).orElse(null);
    }

    @Override
    public boolean isHeadInjured(int head) {
        return this.headInjuries.headInjured(head);
    }

    public GoalSelector getGoalSelectorForHead(int head) {
        if (head > 0) {
            return this.headGoalSelectors.get(head - 1);
        }
        return this.f_21345_;
    }

    public GoalSelector getTargetSelectorForHead(int head) {
        if (head > 0) {
            return this.headTargetSelectors.get(head - 1);
        }
        return this.f_21346_;
    }

    @Override
    public float getHeadShakeAnim(int head, float partialTicks) {
        return this.headInjuries.getRollAngle(head, partialTicks);
    }

    @Override
    public boolean tractorBeamActive(int head) {
        boolean flag = false;
        if (this.getPhase() < 4) {
            flag = head == 0 && this.getPhase() > 1;
        } else if (this.getPhase() > 1) {
            flag = true;
        }
        return WitherStormBase.super.tractorBeamActive(head) && flag && !this.isDeadOrPlayingDead();
    }

    public void pullInTarget(Entity target, double speed, int head) {
        if (target != null && !(target instanceof WitherStormEntity) && this.tractorBeamActive(head)) {
            LivingEntity living;
            Entity vehicle = target.m_20202_();
            Vec3 entityPosition = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
            Vec3 headPosition = new Vec3(this.getHeadX(head), this.getHeadY(head), this.getHeadZ(head));
            Vec3 position = headPosition.m_82546_(entityPosition).m_82541_();
            boolean flag = true;
            if (vehicle instanceof LivingEntity && !LIVING_ENTITY_SELECTOR.test(living = (LivingEntity)vehicle)) {
                flag = false;
            }
            if (target.m_20159_() && WitherStormModConfig.COMMON.shouldPickUpVehicles.get().booleanValue() && flag) {
                vehicle.m_20256_(position.m_82542_(speed, speed, speed));
            } else {
                target.m_20256_(position.m_82542_(speed, speed, speed));
            }
            AABB headBB = new AABB(this.getHeadX(head) - 2.0, this.getHeadY(head) - 4.0, this.getHeadZ(head) - 2.0, this.getHeadX(head) + 2.0, this.getHeadY(head) + 2.0, this.getHeadZ(head) + 2.0);
            if (target instanceof Player) {
                this.setPlayerDeltaMovement((ServerPlayer)target, position.m_82542_(speed, speed, speed));
            }
            if (headBB.m_82381_(target.m_20191_())) {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (!this.playersToHurt.contains(player) && !player.m_21224_()) {
                        this.playersToHurt.add(player);
                    }
                    this.startBiting(head);
                } else {
                    this.addToConsumedEntities(1);
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)this), Float.MAX_VALUE);
                    this.startBiting(head);
                    if (head > 0) {
                        this.nextHeadUpdate[head - 1] = this.f_19797_ + this.f_19796_.m_188503_(20) + this.f_19796_.m_188503_(60);
                    }
                }
            }
        }
    }

    @Nullable
    public LivingEntity getTarget(int head) {
        if (head > 0) {
            return this.getAlternativeTarget(head);
        }
        return this.m_5448_();
    }

    protected void m_21226_() {
    }

    public void dropMassCluster(int radius) {
        LinkedHashMap states = Maps.newLinkedHashMap();
        radius += this.f_19796_.m_188503_(2);
        float stretch = 3.0f;
        for (int i = 0; i <= 3; ++i) {
            float xStretch = stretch * Math.max(0.5f, this.f_19796_.m_188501_());
            float yStretch = stretch;
            float zStretch = stretch * Math.max(0.5f, this.f_19796_.m_188501_());
            int offsetR = radius - 1;
            BlockPos offset = new BlockPos(this.f_19796_.m_188503_(offsetR * 2) - offsetR, this.f_19796_.m_188503_(radius * 2) - radius, this.f_19796_.m_188503_(radius * 2) - radius);
            for (int x = -radius; x < radius; ++x) {
                for (int y = -radius; y < radius; ++y) {
                    for (int z = -radius; z < radius; ++z) {
                        int sqrt = Mth.m_14143_((float)Mth.m_14116_((float)((float)(x * x) * xStretch + 1.0f + ((float)(y * y) * yStretch + 1.0f) + ((float)(z * z) * zStretch + 1.0f))));
                        if (sqrt > radius) continue;
                        SimpleWeightedRandomList<Block> list = OUTSIDE;
                        if (sqrt < radius - 1) {
                            list = BLOCKS;
                        }
                        int randomY = this.f_19796_.m_188503_(2);
                        for (int l = -randomY; l <= randomY; ++l) {
                            BlockPos pos = new BlockPos(x, y - l, z).m_121955_((Vec3i)offset);
                            if (states.containsKey(pos)) continue;
                            BlockState state = list.m_216820_(this.f_19796_).orElse(Blocks.f_50016_).m_49966_();
                            states.put(pos, state);
                        }
                    }
                }
            }
        }
        HashMap toAdd = Maps.newHashMap();
        for (Map.Entry entry : states.entrySet()) {
            BlockPos above = ((BlockPos)entry.getKey()).m_7494_();
            if (states.containsKey(above) || this.f_19796_.m_188503_(3) != 0) continue;
            BlockState decoration = DECORATION.m_216820_(this.f_19796_).orElse(Blocks.f_50016_).m_49966_();
            toAdd.put(above, decoration);
        }
        toAdd.forEach(states::put);
        BlockClusterEntity cluster = (BlockClusterEntity)((EntityType)WitherStormModEntityTypes.BLOCK_CLUSTER.get()).m_20615_(this.f_19853_);
        cluster.setSink(radius / 2 + 1);
        cluster.populate(states);
        cluster.m_146884_(this.m_20182_().m_82520_(0.0, (double)this.getUnmodifiedHeight() / 2.0, 0.0));
        cluster.m_20334_(this.f_19796_.m_188583_() * 0.3, 0.0, this.f_19796_.m_188583_() * 0.3);
        cluster.setRotationDelta(new Vec2((float)this.f_19796_.m_188503_(20) * 0.3f / 2.0f, (float)this.f_19796_.m_188503_(20) * 0.3f / 2.0f));
        cluster.setAntiStacking(true);
        this.f_19853_.m_7967_((Entity)cluster);
    }

    protected boolean isCompletelyInvulnerable() {
        return WitherStormModConfig.SERVER.witherStormInvulnerability.get();
    }

    public boolean equals(Object obj) {
        WitherStormEntity storm;
        return super.equals(obj) && obj instanceof WitherStormEntity && (storm = (WitherStormEntity)obj).isOnDistantRenderer() == this.isOnDistantRenderer();
    }
}

