/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;

public class SickenedZombieEntity
extends AbstractSickenedEntity {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("D3A939F8-73AC-4642-BE7B-C83B36C9D9A0");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> BABY = SynchedEntityData.m_135353_(SickenedZombieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;

    public SickenedZombieEntity(EntityType<? extends SickenedZombieEntity> type, Level world) {
        super(type, world);
    }

    public SickenedZombieEntity(Level world) {
        this((EntityType<? extends SickenedZombieEntity>)((EntityType)WitherStormModEntityTypes.SICKENED_ZOMBIE.get()), world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, 3.5).m_22268_(Attributes.f_22284_, 2.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{SickenedZombieEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BABY, (Object)false);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean able) {
        if (this.supportsBreakDoorGoal() && GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != able) {
                this.canBreakDoors = able;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(able);
                if (able) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    public boolean m_6162_() {
        return (Boolean)this.f_19804_.m_135370_(BABY);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((float)this.f_21364_ * 2.5f);
        }
        return super.m_213860_();
    }

    public void m_6863_(boolean baby) {
        this.f_19804_.m_135381_(BABY, (Object)baby);
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            AttributeInstance instance = this.m_21051_(Attributes.f_22279_);
            instance.m_22130_(SPEED_MODIFIER_BABY);
            if (baby) {
                instance.m_22118_(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> parameter) {
        if (BABY.equals(parameter)) {
            this.m_6210_();
        }
        super.m_7350_(parameter);
    }

    public void m_8107_() {
        boolean flag;
        if (this.m_6084_() && (flag = this.m_21527_())) {
            ItemStack stack = this.m_6844_(EquipmentSlot.HEAD);
            if (!stack.m_41619_()) {
                if (stack.m_41763_()) {
                    stack.m_41721_(stack.m_41773_() + this.f_19796_.m_188503_(2));
                    if (stack.m_41773_() >= stack.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.m_20254_(8);
            }
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity target) {
        boolean flag = super.m_7327_(target);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                target.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        super.m_213945_(random, instance);
        float f = this.f_19796_.m_188501_();
        float f2 = this.f_19853_.m_46791_() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.f_19796_.m_188503_(4);
            if (i == 0) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            } else if (i < 4) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42384_));
            } else if (i == 4) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42430_));
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsBaby", this.m_6162_());
        compound.m_128379_("CanBreakDoors", this.canBreakDoors());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_6863_(compound.m_128471_("IsBaby"));
        this.setCanBreakDoors(compound.m_128471_("CanBreakDoors"));
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    public boolean m_7252_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42521_ && this.m_6162_() && this.m_20159_() ? false : super.m_7252_(stack);
    }

    public boolean m_7243_(ItemStack stack) {
        return stack.m_150930_(Items.f_151056_) ? false : super.m_7243_(stack);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance instance, MobSpawnType reason, SpawnGroupData data, CompoundTag compound) {
        data = super.m_6518_(world, instance, reason, data, compound);
        float f = instance.m_19057_();
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * f);
        if (data == null) {
            data = new Zombie.ZombieGroupData(Zombie.m_219162_((RandomSource)world.m_213780_()), true);
        }
        if (data instanceof Zombie.ZombieGroupData) {
            Zombie.ZombieGroupData groupData = (Zombie.ZombieGroupData)data;
            if (groupData.f_34354_) {
                this.m_6863_(true);
                if (groupData.f_34355_) {
                    if ((double)world.m_213780_().m_188501_() < 0.05) {
                        List list = world.m_6443_(Chicken.class, this.m_20191_().m_82377_(5.0, 3.0, 5.0), EntitySelector.f_20404_);
                        if (!list.isEmpty()) {
                            Chicken entity = (Chicken)list.get(0);
                            entity.m_28273_(true);
                            this.m_20329_((Entity)entity);
                        }
                    } else if ((double)world.m_213780_().m_188501_() < 0.05) {
                        Chicken entity = (Chicken)EntityType.f_20555_.m_20615_(this.f_19853_);
                        entity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                        entity.m_6518_(world, instance, MobSpawnType.JOCKEY, null, null);
                        entity.m_28273_(true);
                        this.m_20329_((Entity)entity);
                        world.m_7967_((Entity)entity);
                    }
                }
            }
            this.setCanBreakDoors(this.supportsBreakDoorGoal() && this.f_19796_.m_188501_() < f * 0.1f);
            RandomSource random = world.m_213780_();
            this.m_213945_(random, instance);
            this.m_213946_(random, instance);
        }
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate date = LocalDate.now();
            int i = date.get(ChronoField.DAY_OF_WEEK);
            int j = date.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        this.handleAttributes(f);
        return data;
    }

    protected void handleAttributes(float multiplier) {
        this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.f_19796_.m_188500_() * 1.5 * (double)multiplier;
        if (d0 > 1.0) {
            this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.m_188501_() < multiplier * 0.05f) {
            this.setCanBreakDoors(this.supportsBreakDoorGoal());
        }
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    private class AttackGoal
    extends MeleeAttackGoal {
        private final SickenedZombieEntity zombie;
        private int raiseArmTicks;

        public AttackGoal(SickenedZombieEntity entity, double p_i1636_2_, boolean p_i1636_4_) {
            super((PathfinderMob)entity, p_i1636_2_, p_i1636_4_);
            this.zombie = entity;
        }

        public void m_8056_() {
            super.m_8056_();
            this.raiseArmTicks = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            this.zombie.m_21561_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.raiseArmTicks;
            if (this.raiseArmTicks >= 5 && this.m_25565_() < this.m_25566_() / 2) {
                this.zombie.m_21561_(true);
            } else {
                this.zombie.m_21561_(false);
            }
        }
    }
}

