/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;
import nonamecrackers2.witherstormmod.common.entity.SickenedSkeletonEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;

public class SickenedSpiderEntity
extends AbstractSickenedEntity {
    private static final EntityDataAccessor<Byte> FLAGS = SynchedEntityData.m_135353_(SickenedSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public SickenedSpiderEntity(EntityType<? extends AbstractSickenedEntity> type, Level world) {
        super(type, world);
    }

    public SickenedSpiderEntity(EntityType<? extends AbstractSickenedEntity> type, Level world, EntityType<? extends Mob> original, CompoundTag originalData) {
        super(type, world, original, originalData);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, (double)0.32f).m_22268_(Attributes.f_22281_, 2.5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.45f));
        this.f_21345_.m_25352_(4, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    public double m_6048_() {
        return this.m_20206_() * 0.7f;
    }

    protected PathNavigation m_6037_(Level world) {
        return new WallClimberNavigation((Mob)this, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAGS, (Object)0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12435_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public void m_7601_(BlockState state, Vec3 pos) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, pos);
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (effect.m_19544_() == MobEffects.f_19614_) {
            MobEffectEvent.Applicable event = new MobEffectEvent.Applicable((LivingEntity)this, effect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.m_7301_(effect);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(FLAGS) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte b = (Byte)this.f_19804_.m_135370_(FLAGS);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.f_19804_.m_135381_(FLAGS, (Object)b);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance instance, MobSpawnType reason, SpawnGroupData data, CompoundTag compound) {
        MobEffect effect;
        data = super.m_6518_(world, instance, reason, data, compound);
        if (world.m_213780_().m_188503_(100) == 0) {
            SickenedSkeletonEntity entity = (SickenedSkeletonEntity)((EntityType)WitherStormModEntityTypes.SICKENED_SKELETON.get()).m_20615_(this.f_19853_);
            entity.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            entity.m_6518_(world, instance, reason, null, null);
            entity.m_20329_((Entity)this);
        }
        if (data == null) {
            data = new Spider.SpiderEffectsGroupData();
            if (world.m_46791_() == Difficulty.HARD && world.m_213780_().m_188501_() < 0.1f * instance.m_19057_()) {
                ((Spider.SpiderEffectsGroupData)data).m_219118_(world.m_213780_());
            }
        }
        if (data instanceof Spider.SpiderEffectsGroupData && (effect = ((Spider.SpiderEffectsGroupData)data).f_33827_) != null) {
            this.m_7292_(new MobEffectInstance(effect, Integer.MAX_VALUE));
        }
        return data;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.65f;
    }

    private static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(SickenedSpiderEntity entity) {
            super((PathfinderMob)entity, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        protected double m_6639_(LivingEntity target) {
            return 4.0f + target.m_20205_();
        }
    }
}

