/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;

public class SickenedSkeletonEntity
extends AbstractSickenedEntity
implements RangedAttackMob {
    private final RangedBowAttackGoal<SickenedSkeletonEntity> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 18.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public void m_8041_() {
            super.m_8041_();
            SickenedSkeletonEntity.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            SickenedSkeletonEntity.this.m_21561_(true);
        }
    };

    public SickenedSkeletonEntity(EntityType<? extends SickenedSkeletonEntity> type, Level world) {
        super(type, world);
        this.reassessWeaponGoal();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.28);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8107_() {
        boolean flag = this.m_21527_();
        if (flag) {
            ItemStack stack = this.m_6844_(EquipmentSlot.HEAD);
            if (!stack.m_41619_()) {
                if (stack.m_41763_()) {
                    stack.m_41721_(stack.m_41773_() + this.f_19796_.m_188503_(2));
                    if (stack.m_41773_() >= stack.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.m_20254_(8);
            }
        }
        super.m_8107_();
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() instanceof PathfinderMob) {
            PathfinderMob creature = (PathfinderMob)this.m_20202_();
            this.f_20883_ = creature.f_20883_;
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        super.m_213945_(random, instance);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance instance, MobSpawnType reason, SpawnGroupData data, CompoundTag compound) {
        data = super.m_6518_(world, instance, reason, data, compound);
        RandomSource random = world.m_213780_();
        this.m_213945_(random, instance);
        this.m_213946_(random, instance);
        this.reassessWeaponGoal();
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * instance.m_19057_());
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate date = LocalDate.now();
            int i = date.get(ChronoField.DAY_OF_MONTH);
            int j = date.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        return data;
    }

    public void reassessWeaponGoal() {
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack stack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (stack.m_41720_() == Items.f_42411_) {
                int i = 20;
                if (this.f_19853_.m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public void m_6504_(LivingEntity entity, float f) {
        ItemStack stack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = this.getArrow(stack, f);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
        }
        double d0 = entity.m_20185_() - this.m_20185_();
        double d1 = entity.m_20227_(0.3333333333333333) - arrow.m_20186_();
        double d2 = entity.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)arrow);
    }

    protected AbstractArrow getArrow(ItemStack stack, float f) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)stack, (float)f);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item == Items.f_42411_;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.reassessWeaponGoal();
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
        if (!this.f_19853_.f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.74f;
    }

    public double m_6049_() {
        return -0.6;
    }

    public boolean isShaking() {
        return this.m_146890_();
    }
}

