/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;

public class SickenedCreeperEntity
extends AbstractSickenedEntity
implements PowerableMob {
    private static final EntityDataAccessor<Integer> SWELL_DIR = SynchedEntityData.m_135353_(SickenedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_POWERED = SynchedEntityData.m_135353_(SickenedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_IGNITED = SynchedEntityData.m_135353_(SickenedCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 40;
    private int explosionRadius = 5;

    public SickenedCreeperEntity(EntityType<? extends AbstractSickenedEntity> type, Level world) {
        super(type, world);
    }

    public SickenedCreeperEntity(EntityType<? extends AbstractSickenedEntity> type, Level world, EntityType<? extends Mob> original, CompoundTag originalData) {
        super(type, world, original, originalData);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.255).m_22268_(Attributes.f_22276_, 26.0);
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource source) {
        boolean flag = super.m_142535_(p_225503_1_, p_225503_2_, source);
        this.swell = (int)((float)this.swell + p_225503_1_ * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return flag;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(IS_IGNITED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (((Boolean)this.f_19804_.m_135370_(IS_POWERED)).booleanValue()) {
            compound.m_128379_("Powered", true);
        }
        compound.m_128376_("Fuse", (short)this.maxSwell);
        compound.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compound.m_128379_("Ignited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(IS_POWERED, (Object)compound.m_128471_("Powered"));
        if (compound.m_128441_("Fuse")) {
            this.maxSwell = compound.m_128448_("Fuse");
        }
        if (compound.m_128441_("ExplosionRadius")) {
            this.explosionRadius = compound.m_128445_("ExplosionRadius");
        }
        if (compound.m_128471_("Ignited")) {
            this.ignite();
        }
    }

    @Override
    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeCreeper();
            }
        }
        super.m_8119_();
    }

    protected SoundEvent m_7975_(DamageSource sound) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    public boolean m_7327_(Entity entity) {
        return true;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(IS_POWERED);
    }

    public float getSwelling(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(SWELL_DIR);
    }

    public void setSwellDir(int direction) {
        this.f_19804_.m_135381_(SWELL_DIR, (Object)direction);
    }

    public void m_8038_(ServerLevel world, LightningBolt entity) {
        super.m_8038_(world, entity);
        this.f_19804_.m_135381_(IS_POWERED, (Object)true);
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == Items.f_42409_) {
            this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                stack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private void explodeCreeper() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction mode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, mode);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            cloud.m_19712_(2.5f);
            cloud.m_19732_(-0.5f);
            cloud.m_19740_(10);
            cloud.m_19734_(cloud.m_19748_() / 2);
            cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
            for (MobEffectInstance effect : collection) {
                cloud.m_19716_(new MobEffectInstance(effect));
            }
            this.f_19853_.m_7967_((Entity)cloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IS_IGNITED, (Object)true);
    }

    private static class SwellGoal
    extends Goal {
        private final SickenedCreeperEntity creeper;
        private LivingEntity target;

        public SwellGoal(SickenedCreeperEntity entity) {
            this.creeper = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity living = this.creeper.m_5448_();
            return this.creeper.getSwellDir() > 0 || living != null && this.creeper.m_20280_((Entity)living) < 9.5;
        }

        public void m_8056_() {
            this.creeper.m_21573_().m_26573_();
            this.target = this.creeper.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.creeper.setSwellDir(-1);
            } else if (this.creeper.m_20280_((Entity)this.target) > 49.5) {
                this.creeper.setSwellDir(-1);
            } else if (!this.creeper.m_21574_().m_148306_((Entity)this.target)) {
                this.creeper.setSwellDir(-1);
            } else {
                this.creeper.setSwellDir(1);
            }
        }
    }
}

