/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public interface IBossTheme {
    public SoundEvent getBossTheme();

    default public SoundSource getCategory() {
        return SoundSource.RECORDS;
    }

    default public boolean matches(IBossTheme entity) {
        return this.getBossTheme() == entity.getBossTheme() && this.getCategory() == entity.getCategory() && this.priority() == entity.priority();
    }

    default public int getFadeTime() {
        return 240;
    }

    public boolean isStillAlive();

    default public boolean shouldPlayBossTheme() {
        return this.isStillAlive() && this.getBossTheme() != null;
    }

    default public double distanceToPlay() {
        return 0.0;
    }

    public int priority();

    default public boolean hasPriority(IBossTheme entity) {
        return this.priority() > entity.priority();
    }

    public Vec3 getPosition();

    @Nullable
    default public Component getWatermark() {
        return null;
    }
}

