/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;

public class FlamingWitherSkullEntity
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    public FlamingWitherSkullEntity(EntityType<? extends FlamingWitherSkullEntity> type, Level world) {
        super(type, world);
    }

    public FlamingWitherSkullEntity(Level world, LivingEntity owner, double x, double y, double z) {
        super((EntityType)WitherStormModEntityTypes.FLAMING_WITHER_SKULL.get(), owner, x, y, z, world);
    }

    protected float m_6884_() {
        return 0.9f;
    }

    public boolean m_6060_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    protected void m_5790_(EntityHitResult ray) {
        super.m_5790_(ray);
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            Entity victim = ray.m_82443_();
            Entity owner = this.m_37282_();
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                flag = victim.m_6469_(FlamingWitherSkullEntity.damageSource(this, (Entity)livingOwner), 10.0f);
                if (flag) {
                    if (victim.m_6084_()) {
                        this.m_19970_(livingOwner, victim);
                    } else {
                        livingOwner.m_5634_(10.0f);
                    }
                }
            } else {
                flag = victim.m_6469_(DamageSource.f_19319_, 8.0f);
            }
            if (flag && victim instanceof LivingEntity) {
                int i = 0;
                if (this.f_19853_.m_46791_() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.f_19853_.m_46791_() == Difficulty.HARD) {
                    i = 40;
                }
                if (i > 0) {
                    ((LivingEntity)victim).m_7292_(new MobEffectInstance(MobEffects.f_19615_, 180, 1));
                }
            }
        }
    }

    protected void m_6532_(HitResult ray) {
        super.m_6532_(ray);
        if (!this.f_19853_.f_46443_ && ray.m_6662_() != HitResult.Type.ENTITY) {
            boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
            Explosion.BlockInteraction mode = flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, flag, mode);
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    protected boolean m_5931_() {
        return false;
    }

    public static DamageSource damageSource(FlamingWitherSkullEntity cause, Entity entity) {
        return new IndirectEntityDamageSource("flamingWitherSkull", (Entity)cause, entity).m_19366_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.f_36813_);
        buffer.writeDouble(this.f_36814_);
        buffer.writeDouble(this.f_36815_);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_36813_ = additionalData.readDouble();
        this.f_36814_ = additionalData.readDouble();
        this.f_36815_ = additionalData.readDouble();
    }
}

