/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import nonamecrackers2.witherstormmod.WitherStormMod;
import nonamecrackers2.witherstormmod.common.capability.WitherSicknessTracker;
import nonamecrackers2.witherstormmod.common.capability.WitherStormBowelsManager;
import nonamecrackers2.witherstormmod.common.config.WitherStormModConfig;
import nonamecrackers2.witherstormmod.common.entity.AbstractSickenedEntity;
import nonamecrackers2.witherstormmod.common.entity.BlockClusterEntity;
import nonamecrackers2.witherstormmod.common.entity.IBossTheme;
import nonamecrackers2.witherstormmod.common.entity.SickenedCreeperEntity;
import nonamecrackers2.witherstormmod.common.entity.SickenedSpiderEntity;
import nonamecrackers2.witherstormmod.common.entity.TentacleEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormHeadEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.entity.WitheredSymbiontEntity;
import nonamecrackers2.witherstormmod.common.entity.bossfight.BossfightManager;
import nonamecrackers2.witherstormmod.common.entity.bossfight.BossfightPhase;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEntityTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModPacketHandlers;
import nonamecrackers2.witherstormmod.common.init.WitherStormModParticleTypes;
import nonamecrackers2.witherstormmod.common.init.WitherStormModSoundEvents;
import nonamecrackers2.witherstormmod.common.packet.BlindScreenMessage;
import nonamecrackers2.witherstormmod.common.packet.Message;
import nonamecrackers2.witherstormmod.common.packet.PlayerMotionMessage;
import nonamecrackers2.witherstormmod.common.packet.ShakeScreenMessage;
import nonamecrackers2.witherstormmod.common.serializer.WitherStormModDataSerializers;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModItemTags;
import nonamecrackers2.witherstormmod.common.util.IEntitySyncableData;
import nonamecrackers2.witherstormmod.common.util.StructureAnimationHelper;
import nonamecrackers2.witherstormmod.common.util.TentacleOffsets;
import nonamecrackers2.witherstormmod.common.util.WorldUtil;

public class CommandBlockEntity
extends LivingEntity
implements IEntitySyncableData,
IBossTheme {
    private static final EntityDataAccessor<State> STATE = SynchedEntityData.m_135353_(CommandBlockEntity.class, WitherStormModDataSerializers.STATE_ENUM);
    private static final EntityDataAccessor<Mode> MODE = SynchedEntityData.m_135353_(CommandBlockEntity.class, WitherStormModDataSerializers.MODE_ENUM);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(CommandBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> PHASE_KEY = SynchedEntityData.m_135353_(CommandBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Predicate<LivingEntity> SEARCHABLE_PLAYER_SELECTOR = living -> {
        if (living instanceof Player) {
            Player player = (Player)living;
            return player.m_6084_() && !player.m_150110_().f_35934_ && !player.m_7500_() && !player.m_5833_() && player.m_6097_();
        }
        return false;
    };
    private static final SimpleWeightedRandomList<EntityType<? extends Mob>> WAVE_1_MOBS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_ZOMBIE.get()), 20).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_SKELETON.get()), 10).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_SPIDER.get()), 8).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_CREEPER.get()), 2).m_146270_();
    private static final SimpleWeightedRandomList<EntityType<? extends Mob>> WAVE_2_MOBS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_ZOMBIE.get()), 10).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_SKELETON.get()), 10).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_SPIDER.get()), 8).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_CREEPER.get()), 6).m_146270_();
    private static final SimpleWeightedRandomList<EntityType<? extends Mob>> WAVE_3_MOBS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_ZOMBIE.get()), 10).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_SKELETON.get()), 10).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_SPIDER.get()), 10).m_146271_((Object)((EntityType)WitherStormModEntityTypes.SICKENED_CREEPER.get()), 8).m_146270_();
    private static final BossfightPhase<CommandBlockEntity> IDLE = BossfightPhase.blank();
    private static final BossfightPhase<CommandBlockEntity> HIT = new BossfightPhase<CommandBlockEntity>(entity -> {
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ShakeScreenMessage(240.0f, 12.0f));
        entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.LOUD_TREMBLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.BOWELS_LOUD_HURT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        for (TentacleEntity tentacle : entity.getTentacleStructure().tentacleStructure) {
            if (tentacle == null || !tentacle.m_6084_()) continue;
            tentacle.setDormant(false);
            tentacle.doAwakeAnimation();
        }
    }, 60);
    private static final BossfightPhase<CommandBlockEntity> MOVE_PODIUM = new BossfightPhase<CommandBlockEntity>(entity -> {
        entity.createPodiumCluster();
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ShakeScreenMessage(120.0f, 12.0f));
        entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.LOUD_TREMBLE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
    }, 100).setTickAction((time, entity) -> {
        entity.findPodiumCluster();
        Vec3 delta = new Vec3(0.0, 0.05, 0.0);
        entity.movePodiumCluster(delta);
        entity.m_6478_(MoverType.SELF, delta);
    }).setFinishAction(entity -> {
        BlockClusterEntity cluster = entity.getPodiumCluster();
        Vec3 pos = Vec3.m_82539_((Vec3i)entity.m_20183_());
        if (cluster != null && cluster.m_6084_()) {
            Vec3 clusterPos = pos.m_82520_(0.0, cluster.m_20186_() - entity.m_20186_() + 1.0, 0.0);
            cluster.m_6034_(clusterPos.f_82479_, clusterPos.f_82480_, clusterPos.f_82481_);
            cluster.place();
        }
        entity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        entity.podiumCluster = null;
        entity.podiumClusterUUID = null;
    });
    private static final BossfightPhase<CommandBlockEntity> WAIT = BossfightPhase.blank().setFixedTime(20);
    private static final BossfightPhase<CommandBlockEntity> MOB_WAVE_1 = new BossfightPhase<CommandBlockEntity>(entity -> {
        entity.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_ACTIVATES.get(), 5.0f, 1.0f);
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 60, entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), 0.2);
    }, 100).setTickAction((time, entity) -> {
        if (time % 8 == 0) {
            entity.summonRandomMob(50, WAVE_1_MOBS);
        }
    }).setFinishAction(entity -> entity.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_POWER_DOWN.get(), 5.0f, 1.0f));
    private static final BossfightPhase<CommandBlockEntity> MOB_WAVE_2 = new BossfightPhase<CommandBlockEntity>(entity -> {
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ShakeScreenMessage(120.0f, 8.0f));
        entity.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_ACTIVATES.get(), 5.0f, 1.0f);
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 60, entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), 0.2);
        for (Entity nearby : entity.f_19853_.m_45976_(TentacleEntity.class, entity.m_20191_().m_82400_(50.0))) {
            TentacleEntity tentacle = (TentacleEntity)nearby;
            tentacle.setDormant(false);
            tentacle.doAwakeAnimation();
        }
    }, 100).setTickAction((time, entity) -> {
        if (time % 10 == 0) {
            entity.summonRandomMob(50, WAVE_2_MOBS);
        }
    }).setFinishAction(entity -> {
        entity.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_POWER_DOWN.get(), 5.0f, 1.0f);
        BlockPos pos = entity.getRandomNearbyPos(50, 20);
        if (pos != null) {
            ServerLevel world = (ServerLevel)entity.f_19853_;
            WitheredSymbiontEntity symbiont = (WitheredSymbiontEntity)((EntityType)WitherStormModEntityTypes.WITHERED_SYMBIONT.get()).m_20600_(world, null, null, null, pos, MobSpawnType.EVENT, false, false);
            symbiont.setNonBossMode(true);
            symbiont.setRushMode(true);
            symbiont.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Withered symbiont final boss battle low health", -0.5, AttributeModifier.Operation.MULTIPLY_BASE));
            symbiont.m_21530_();
            symbiont.m_21153_(symbiont.m_21233_());
            world.m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), symbiont.m_20185_(), symbiont.m_20188_(), symbiont.m_20189_(), 40, entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), 0.2);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123755_, symbiont.m_20185_(), symbiont.m_20188_(), symbiont.m_20189_(), 40, entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), 0.01);
            symbiont.m_5496_((SoundEvent)WitherStormModSoundEvents.WITHERED_SYMBIONT_SPAWN.get(), 4.0f, 1.0f);
        }
    });
    private static final BossfightPhase<CommandBlockEntity> MOB_WAVE_3 = new BossfightPhase<CommandBlockEntity>(entity -> {
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ShakeScreenMessage(120.0f, 16.0f));
        entity.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_ACTIVATES.get(), 6.0f, 1.0f);
        ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 80, entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), entity.f_19796_.m_188583_(), 0.2);
        for (Entity nearby : entity.f_19853_.m_45976_(Entity.class, entity.m_20191_().m_82400_(50.0))) {
            if (nearby instanceof TentacleEntity) {
                TentacleEntity tentacle = (TentacleEntity)nearby;
                tentacle.setDormant(false);
                tentacle.doAwakeAnimation();
                continue;
            }
            if (!(nearby instanceof WitherStormHeadEntity)) continue;
            WitherStormHeadEntity head = (WitherStormHeadEntity)nearby;
            head.setActive(true);
            head.setRoar(false);
            head.setRoarTime(40);
        }
    }, 120).setTickAction((time, entity) -> {
        Mob mob;
        if (time % 5 == 0 && (mob = entity.summonRandomMob(50, WAVE_3_MOBS)) != null) {
            mob.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Extra health final bossfight", 8.0, AttributeModifier.Operation.ADDITION));
            if (!(mob instanceof SickenedSpiderEntity) && !(mob instanceof SickenedCreeperEntity)) {
                ItemStack stack = EnchantmentHelper.m_220292_((RandomSource)mob.m_217043_(), (ItemStack)(mob.m_217043_().m_188499_() ? new ItemStack((ItemLike)Items.f_42469_) : new ItemStack((ItemLike)Items.f_42466_)), (int)((int)(5.0f + mob.f_19853_.m_6436_(mob.m_20183_()).m_19057_() * (float)mob.m_217043_().m_188503_(18))), (boolean)false);
                if (mob.m_217043_().m_188501_() > 0.2f) {
                    mob.m_8061_(Mob.m_147233_((ItemStack)stack), stack);
                }
            }
        }
    }).setFinishAction(entity -> entity.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_POWER_DOWN.get(), 6.0f, 1.0f));
    private static final BossfightPhase<CommandBlockEntity> PROTECT_IDLE = BossfightPhase.copyOf(IDLE, entity -> {
        for (TentacleEntity tentacle : entity.getTentacleStructure().tentacleStructure) {
            if (tentacle == null || !tentacle.m_6084_()) continue;
            tentacle.curlAround(entity.m_20182_());
        }
    }, entity -> {
        if (!WorldUtil.areaLoaded(entity.f_19853_, entity.m_20183_(), 2)) {
            return false;
        }
        boolean flag = true;
        for (Entity nearby : entity.f_19853_.m_45976_(WitherStormHeadEntity.class, entity.m_20191_().m_82400_(50.0))) {
            WitherStormHeadEntity head = (WitherStormHeadEntity)nearby;
            if (!head.m_6084_() || head.isPlayingDead() || head.isHurt()) continue;
            flag = false;
        }
        return flag;
    }).setTickAction((time, entity) -> {
        if (time % 40 == 0) {
            for (TentacleEntity tentacle : entity.getTentacleStructure().tentacleStructure) {
                if (tentacle == null || !tentacle.m_6084_() || tentacle.isDoingSwingAttack()) continue;
                tentacle.curlAround(entity.m_20182_());
            }
        }
    }).setFinishAction(entity -> {
        for (TentacleEntity tentacle : entity.getTentacleStructure().tentacleStructure) {
            if (tentacle == null || !tentacle.m_6084_()) continue;
            tentacle.stopCurlingAround();
        }
    });
    private static final BossfightPhase<CommandBlockEntity> DEATH = new BossfightPhase<CommandBlockEntity>(entity -> {
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ShakeScreenMessage(240.0f, 14.0f));
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new BlindScreenMessage(240, 120, 80));
        entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.LOUD_TREMBLE.get(), SoundSource.AMBIENT, 5.0f, 1.0f);
        entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.BOWELS_LOUD_HURT.get(), SoundSource.HOSTILE, 5.0f, 1.0f);
        for (Entity nearby : entity.f_19853_.m_45976_(Entity.class, entity.m_20191_().m_82400_(50.0))) {
            if (!nearby.m_6084_()) continue;
            if (nearby instanceof TentacleEntity) {
                TentacleEntity tentacle = (TentacleEntity)nearby;
                tentacle.doIndefiniteAwakeAnimation();
                tentacle.setCanSwing(false);
                tentacle.setCanStrangle(false);
                continue;
            }
            if (nearby instanceof WitherStormHeadEntity) {
                WitherStormHeadEntity head = (WitherStormHeadEntity)nearby;
                head.m_6074_();
                continue;
            }
            if (!(nearby instanceof WitheredSymbiontEntity) && !(nearby instanceof AbstractSickenedEntity)) continue;
            nearby.m_6074_();
        }
    }, entity -> false).setFinishAction(entity -> {
        WitherStormEntity storm = entity.getOwner();
        if (storm != null) {
            if (entity.killer != null) {
                if (entity.killer instanceof Player) {
                    storm.m_6469_(DamageSource.m_19344_((Player)((Player)entity.killer)).m_19381_(), Float.MAX_VALUE);
                } else {
                    storm.m_6469_(DamageSource.m_19370_((LivingEntity)entity.killer).m_19381_(), Float.MAX_VALUE);
                }
            } else {
                storm.m_6074_();
            }
        }
        for (ServerPlayer player : entity.f_19853_.m_45976_(ServerPlayer.class, entity.m_20191_().m_82400_(150.0))) {
            if (player != entity.killer) {
                player.m_36246_(Stats.f_12986_.m_12902_((Object)storm.m_6095_()));
            }
            if (player.m_8963_().equals((Object)WitherStormMod.bowels(player.m_9236_()).m_46472_())) {
                player.m_9158_(null, null, 0.0f, false, false);
            }
            player.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).ifPresent(WitherSicknessTracker::cure);
            List<TamableAnimal> playersPets = player.f_19853_.m_45976_(TamableAnimal.class, entity.m_20191_().m_82400_(150.0)).stream().filter(animal -> player.m_20148_().equals(animal.m_21805_())).collect(Collectors.toList());
            playersPets.forEach(animal -> WitherStormBowelsManager.leave(player.m_9236_(), (Entity)animal, null));
            WitherStormBowelsManager.queueLeave(player, () -> {
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket((SoundEvent)WitherStormModSoundEvents.WITHER_STORM_DEATH.get(), SoundSource.HOSTILE, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, entity.f_19796_.m_188505_()));
                if (storm != null) {
                    for (int i = 0; i < 10; ++i) {
                        float angle = (storm.f_20883_ + 90.0f) * ((float)Math.PI / 180);
                        double x = (double)Mth.m_14089_((float)angle) * 100.0 + storm.m_20185_();
                        double z = (double)Mth.m_14031_((float)angle) * 100.0 + storm.m_20189_();
                        BlockPos pos = new BlockPos(x += storm.m_217043_().m_188583_() * 5.0, 0.0, z += storm.m_217043_().m_188583_() * 5.0);
                        BlockState state = storm.f_19853_.m_8055_(pos = storm.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_7495_());
                        if (!state.m_60783_((BlockGetter)storm.f_19853_, pos, Direction.UP)) continue;
                        Vec3 finalPos = Vec3.m_82514_((Vec3i)pos, (double)1.0);
                        player.m_20219_(finalPos);
                        player.m_7618_(EntityAnchorArgument.Anchor.EYES, storm.m_20299_(1.0f));
                        break;
                    }
                }
            });
        }
    });
    private int modeAnim;
    private int modeAnimO;
    private int stateTicks;
    @Nullable
    private Player toLure;
    private List<StructureAnimationHelper> ribStructure = new ArrayList<StructureAnimationHelper>();
    private final TentacleManager tentacleStructure;
    private float protectionYOffset;
    private float protectionYOffsetO;
    @Nullable
    private WitherStormEntity owner;
    private final BossfightManager<CommandBlockEntity> bossfightManager;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    @Nullable
    private BlockClusterEntity podiumCluster;
    @Nullable
    private UUID podiumClusterUUID;
    private int specialDeathTime;
    @Nullable
    private LivingEntity killer;

    public CommandBlockEntity(EntityType<? extends CommandBlockEntity> type, Level world) {
        super(type, world);
        this.createStructureHelpers();
        this.tentacleStructure = new TentacleManager(this, 6, new TentacleOffsets[]{new TentacleOffsets(2.0, -2.0, 3.0, 1.45f, 1.0f, 40.0f, -70.0f), new TentacleOffsets(0.0, -2.0, 4.0, 1.4f, 1.0f, 35.0f, -90.0f), new TentacleOffsets(-2.0, -2.0, 3.0, 1.45f, 1.0f, 40.0f, -110.0f), new TentacleOffsets(2.0, -2.0, -3.0, 1.45f, 1.0f, 40.0f, 70.0f), new TentacleOffsets(0.0, -2.0, -4.0, 1.4f, 1.0f, 35.0f, 90.0f), new TentacleOffsets(-2.0, -2.0, -3.0, 1.45f, 1.0f, 40.0f, 110.0f)});
        this.bossfightManager = new BossfightManager<CommandBlockEntity>(IDLE, this).addPhase(1, HIT).addPhase(2, MOVE_PODIUM).addPhase(3, WAIT).addPhase(4, MOB_WAVE_1).addPhase(5, IDLE).addPhase(6, HIT).addPhase(7, MOVE_PODIUM).addPhase(8, WAIT).addPhase(9, MOB_WAVE_2).addPhase(10, IDLE).addPhase(11, HIT).addPhase(12, MOVE_PODIUM).addPhase(13, MOB_WAVE_3).addPhase(14, PROTECT_IDLE).addPhase(15, IDLE).addPhase(16, DEATH).addPhase(17, IDLE);
    }

    public CommandBlockEntity(Level world, WitherStormEntity owner, double x, double y, double z) {
        this((EntityType<? extends CommandBlockEntity>)((EntityType)WitherStormModEntityTypes.COMMAND_BLOCK.get()), world);
        this.m_6034_(x, y, z);
        this.setState(State.PLAYING_DEAD);
        this.setMode(Mode.RIBS);
        this.setOwner(owner);
        this.setOwnerUUID(owner.m_20148_());
        this.m_146922_(owner.m_146908_());
        this.m_5618_(owner.f_20883_);
        this.m_5616_(owner.m_6080_());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 64.0).m_22268_(Attributes.f_22284_, 32.0).m_22268_(Attributes.f_22285_, 32.0).m_22268_(Attributes.f_22278_, 1024.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    private void createStructureHelpers() {
        this.ribStructure.add(new StructureAnimationHelper());
        this.ribStructure.add(new StructureAnimationHelper().setBaseRotationAngle(0.0f, 180.0f));
        this.ribStructure.add(new StructureAnimationHelper().setBaseRotationAngle(0.0f, 145.0f));
        this.ribStructure.add(new StructureAnimationHelper().setBaseRotationAngle(0.0f, 35.0f));
        this.ribStructure.add(new StructureAnimationHelper().setBaseRotationAngle(0.0f, -35.0f));
        this.ribStructure.add(new StructureAnimationHelper().setBaseRotationAngle(0.0f, 215.0f));
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(PHASE_KEY, (Object)this.getBossfightManager().getCurrentPhaseIndex());
        }
        super.m_8119_();
        this.findOwner();
        this.getState().tick(this);
        this.modeAnimO = this.modeAnim;
        this.protectionYOffsetO = this.protectionYOffset;
        this.getStructures().forEach(helper -> helper.tick());
        if (!this.f_19853_.f_46443_) {
            this.tentacleStructure.findTentacles((ServerLevel)this.f_19853_);
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)State.IDLE);
        this.f_19804_.m_135372_(MODE, (Object)Mode.NONE);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(PHASE_KEY, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Mode", this.getMode().ordinal());
        compound.m_128405_("State", this.getState().ordinal());
        compound.m_128405_("StateTicks", this.stateTicks);
        compound.m_128405_("ModeAnim", this.modeAnim);
        compound.m_128350_("YOffset", this.protectionYOffset);
        compound.m_128350_("YBodyRot", this.f_20883_);
        compound.m_128365_("Structures", this.writeStructures());
        if (this.getOwnerUUID() != null) {
            compound.m_128362_("OwnerUUID", this.getOwnerUUID());
        }
        this.tentacleStructure.addSaveData(compound);
        if (this.podiumCluster != null && this.podiumCluster.m_6084_()) {
            compound.m_128362_("PodiumCluster", this.podiumCluster.m_20148_());
        }
        compound.m_128365_("BossfightManager", (Tag)this.bossfightManager.write());
    }

    public void m_7378_(CompoundTag compound) {
        int state;
        super.m_7378_(compound);
        this.protectionYOffsetO = this.protectionYOffset;
        int mode = compound.m_128451_("Mode");
        if (mode >= 0 && mode < Mode.values().length) {
            this.setMode(Mode.values()[mode]);
        }
        if ((state = compound.m_128451_("State")) >= 0 && state < State.values().length) {
            this.setState(State.values()[state]);
        }
        this.stateTicks = compound.m_128451_("StateTicks");
        this.modeAnimO = this.modeAnim = compound.m_128451_("ModeAnim");
        this.protectionYOffset = compound.m_128457_("YOffset");
        this.m_5618_(compound.m_128457_("YBodyRot"));
        this.readStructures(compound.m_128437_("Structures", 10));
        if (compound.m_128441_("OwnerUUID")) {
            this.setOwnerUUID(compound.m_128342_("OwnerUUID"));
        }
        this.tentacleStructure.readSaveData(compound);
        if (compound.m_128441_("PodiumCluster")) {
            this.podiumClusterUUID = compound.m_128342_("PodiumCluster");
        }
        if (compound.m_128441_("BossfightManager")) {
            this.bossfightManager.read(compound.m_128469_("BossfightManager"));
        }
    }

    public Mode getMode() {
        return (Mode)((Object)this.f_19804_.m_135370_(MODE));
    }

    public void setMode(Mode mode) {
        this.f_19804_.m_135381_(MODE, (Object)mode);
    }

    public State getState() {
        return (State)((Object)this.f_19804_.m_135370_(STATE));
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
        this.initState();
    }

    private void initState() {
        this.getState().init(this);
    }

    public void nextState() {
        if (this.getState().ordinal() + 1 < State.values().length) {
            this.setState(State.values()[this.getState().ordinal() + 1]);
        }
    }

    public void setLuringPlayer(@Nullable Player player) {
        this.toLure = player;
    }

    @Nullable
    public Player getLuringPlayer() {
        return this.toLure;
    }

    public void m_7350_(EntityDataAccessor<?> parameter) {
        super.m_7350_(parameter);
        if (parameter.equals(STATE)) {
            this.initState();
        }
        if (parameter.equals(MODE)) {
            this.getMode().init(this, this.getState());
        }
    }

    public BlockState getBlockState() {
        return (BlockState)Blocks.f_50272_.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)this.m_6350_());
    }

    public int m_213860_() {
        return 10;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(20.0);
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        LivingEntity entity;
        ItemStack stack;
        if (source.m_19378_()) {
            return super.m_6469_(source, amount);
        }
        boolean flag = false;
        if (source.m_7640_() instanceof LivingEntity && (stack = (entity = (LivingEntity)source.m_7640_()).m_21205_()).m_204117_(WitherStormModItemTags.COMMAND_BLOCK_TOOLS)) {
            this.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_HIT.get(), 4.0f, 1.0f);
            if (!this.isVulnerable(source)) {
                if (this.getState() != State.BOSSFIGHT) {
                    entity.m_147240_(1.0, this.m_20185_() - entity.m_20185_(), this.m_20189_() - entity.m_20189_());
                }
                flag = true;
            } else {
                boolean hurt = false;
                float health = this.m_21223_() - this.m_21233_() / 4.0f;
                if (health <= 0.0f) {
                    hurt = super.m_6469_(source, Float.MAX_VALUE);
                } else {
                    this.m_21153_(health);
                    hurt = super.m_6469_(source, 0.0f);
                }
                if (!this.f_19853_.f_46443_ && hurt && !this.m_21224_()) {
                    this.getBossfightManager().goToNextPhase();
                    WitherStormEntity owner = this.getOwner();
                    if (owner != null && owner.m_6084_()) {
                        owner.getSegmentsManager().ifPresent(manager -> {
                            for (WitherStormSegmentEntity segment : manager.getSegments()) {
                                if (segment == null || !segment.m_6084_()) continue;
                                for (Entity tracked : segment.getTrackedEntities()) {
                                    tracked.m_20242_(false);
                                    if (!(tracked instanceof BlockClusterEntity)) continue;
                                    ((BlockClusterEntity)tracked).setPhysics(true);
                                }
                                segment.getTrackedEntities().clear();
                                for (int i = 0; i < 3; ++i) {
                                    if (!(this.f_19796_.m_188501_() > 0.6f)) continue;
                                    segment.hurtHead(null, i);
                                }
                            }
                        });
                        for (Entity tracked : owner.getTrackedEntities()) {
                            tracked.m_20242_(false);
                            if (!(tracked instanceof BlockClusterEntity)) continue;
                            ((BlockClusterEntity)tracked).setPhysics(true);
                        }
                        owner.getTrackedEntities().clear();
                        for (int i = 0; i < 3; ++i) {
                            if (!(this.f_19796_.m_188501_() > 0.6f)) continue;
                            owner.hurtHead(null, i);
                        }
                        owner.m_5496_((SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_DAMAGE.get(), 16.0f, 1.0f);
                    }
                }
                return hurt;
            }
        }
        if ((source.m_19372_() || source.m_19387_() || flag) && this.getState().equals((Object)State.PLAYING_DEAD)) {
            this.setState(State.REACTIVATING);
            return false;
        }
        return false;
    }

    public boolean isVulnerable(DamageSource source) {
        BossfightPhase<CommandBlockEntity> currentPhase = this.getCurrentPhase();
        return this.getState() == State.BOSSFIGHT && !this.m_6673_(source) && currentPhase.equals(IDLE) && !currentPhase.equals(PROTECT_IDLE);
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_7334_(Entity entity) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.5f;
    }

    public float getModeAnim(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.modeAnimO, (float)this.modeAnim);
    }

    public List<StructureAnimationHelper> getRibStructure() {
        return this.ribStructure;
    }

    public TentacleManager getTentacleStructure() {
        return this.tentacleStructure;
    }

    public List<StructureAnimationHelper> getStructures() {
        ArrayList<StructureAnimationHelper> all = new ArrayList<StructureAnimationHelper>();
        all.addAll(this.getRibStructure());
        return all;
    }

    public TargetingConditions searchablePlayersPredicate() {
        return TargetingConditions.m_148353_().m_26888_(SEARCHABLE_PLAYER_SELECTOR).m_26883_(6.0);
    }

    public void lerpStructureBaseRotTo(List<StructureAnimationHelper> structure, float xRot, float yRot, int steps) {
        for (StructureAnimationHelper helper : structure) {
            helper.lerpBaseTo(this, xRot, yRot, steps);
        }
    }

    public void lerpStructureRotTo(List<StructureAnimationHelper> structure, float xRot, float yRot, int steps) {
        for (StructureAnimationHelper helper : structure) {
            helper.lerpTo(this, xRot, yRot, steps);
        }
    }

    public void setProtectionYOffsetAndO(float offset) {
        this.protectionYOffset = offset;
        this.protectionYOffsetO = offset;
    }

    public void setProtectionYOffset(float offset) {
        this.protectionYOffset = offset;
    }

    public float getProtectionYOffset() {
        return this.protectionYOffset;
    }

    public float lerpProtectionYOffset(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.protectionYOffsetO, (float)this.protectionYOffset);
    }

    public int getStateTicks() {
        return this.stateTicks;
    }

    public Tag writeStructures() {
        ListTag structures = new ListTag();
        for (StructureAnimationHelper helper : this.getRibStructure()) {
            CompoundTag ribStructure = new CompoundTag();
            helper.write(ribStructure);
            structures.add((Object)ribStructure);
        }
        return structures;
    }

    public void readStructures(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag ribStructure = list.m_128728_(i);
            if (i >= this.getRibStructure().size()) continue;
            this.getRibStructure().get(i).read(ribStructure);
        }
    }

    @Override
    public void writeData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.stateTicks);
        buffer.writeInt(this.modeAnim);
        buffer.writeFloat(this.protectionYOffset);
        for (StructureAnimationHelper helper : this.getStructures()) {
            helper.writeBuffer(buffer);
        }
    }

    @Override
    public void readData(FriendlyByteBuf buffer) {
        this.stateTicks = buffer.readInt();
        this.modeAnimO = this.modeAnim = buffer.readInt();
        this.protectionYOffsetO = this.protectionYOffset = buffer.readFloat();
        for (StructureAnimationHelper helper : this.getStructures()) {
            helper.readBuffer(buffer);
        }
    }

    public void findOwner() {
        block2: {
            block3: {
                if (this.getOwnerUUID() == null || this.getOwner() != null) break block2;
                if (this.getState() == State.BOSSFIGHT) break block3;
                for (Entity entity : this.f_19853_.m_45976_(WitherStormEntity.class, this.m_20191_().m_82400_(100.0))) {
                    WitherStormEntity storm = (WitherStormEntity)entity;
                    if (!storm.m_20148_().equals(this.getOwnerUUID())) continue;
                    this.setOwner(storm);
                    storm.getPlayDeadManager().setCommandBlock(this);
                }
                break block2;
            }
            if (this.f_19853_.f_46443_) break block2;
            MinecraftServer server = this.f_19853_.m_7654_();
            for (Level world : server.m_129785_()) {
                ServerLevel serverWorld = (ServerLevel)world;
                Entity entity = serverWorld.m_8791_(this.getOwnerUUID());
                if (!(entity instanceof WitherStormEntity)) continue;
                this.setOwner((WitherStormEntity)entity);
                break;
            }
        }
    }

    public void setOwner(@Nullable WitherStormEntity entity) {
        this.owner = entity;
        if (entity != null) {
            this.setOwnerUUID(entity.m_20148_());
            this.getState().initWithOwner(entity, this);
        } else {
            this.setOwnerUUID(null);
        }
    }

    @Nullable
    public WitherStormEntity getOwner() {
        return this.owner;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public Packet<?> m_5654_() {
        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ModeAnimationMessage(this.m_19879_(), this.modeAnim));
        return super.m_5654_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.f_19853_.f_46443_) {
            this.tentacleStructure.createTentacles();
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void m_6667_(DamageSource source) {
        if (!this.f_19853_.f_46443_ && this.getState() == State.BOSSFIGHT && this.getBossfightManager().getCurrentPhase() != DEATH) {
            this.getBossfightManager().setCurrentFromNextInOrder(DEATH);
        }
        this.killer = this.m_21232_();
        super.m_6667_(source);
    }

    protected void m_6153_() {
        if (this.getCurrentPhase().equals(DEATH)) {
            ++this.specialDeathTime;
            if (!this.f_19853_.f_46443_) {
                if (this.specialDeathTime > 160) {
                    this.getBossfightManager().goToNextPhase();
                }
                if (this.specialDeathTime > 240) {
                    this.tentacleStructure.killTentacles();
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        } else {
            super.m_6153_();
            if (!this.f_19853_.f_46443_ && this.f_20919_ >= 20) {
                this.tentacleStructure.removeTentacles();
            }
        }
    }

    public BossfightManager<CommandBlockEntity> getBossfightManager() {
        return this.bossfightManager;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    @Override
    public SoundEvent getBossTheme() {
        return (SoundEvent)WitherStormModSoundEvents.WITHER_STORM_FINAL_BOSS_THEME.get();
    }

    @Override
    public boolean shouldPlayBossTheme() {
        return IBossTheme.super.shouldPlayBossTheme() && this.m_21223_() < this.m_21233_() && this.getState() == State.BOSSFIGHT;
    }

    @Override
    public Vec3 getPosition() {
        return this.m_20182_();
    }

    @Override
    public boolean isStillAlive() {
        return this.m_6084_();
    }

    @Override
    public int priority() {
        return 3;
    }

    @Override
    public int getFadeTime() {
        return 40;
    }

    public void createPodiumCluster() {
        if (this.podiumCluster == null && this.podiumClusterUUID == null) {
            BlockClusterEntity cluster = (BlockClusterEntity)((EntityType)WitherStormModEntityTypes.BLOCK_CLUSTER.get()).m_20615_(this.f_19853_);
            BlockPos bottomCorner = new BlockPos(-5, -13, -5).m_121955_((Vec3i)this.m_20183_());
            cluster.populate(bottomCorner, bottomCorner.m_7918_(10, 19, 10), blockstate -> true);
            cluster.setResetGravityOnLoad(false);
            cluster.setPhysics(false);
            cluster.m_20242_(true);
            cluster.setForceRender(true);
            this.f_19853_.m_7967_((Entity)cluster);
            this.podiumCluster = cluster;
        }
    }

    public void movePodiumCluster(Vec3 delta) {
        if (this.podiumCluster != null) {
            this.podiumCluster.m_20256_(delta);
        }
    }

    public void findPodiumCluster() {
        ServerLevel serverWorld;
        Entity entity;
        if (!this.f_19853_.f_46443_ && this.podiumClusterUUID != null && this.podiumCluster == null && (entity = (serverWorld = (ServerLevel)this.f_19853_).m_8791_(this.podiumClusterUUID)) instanceof BlockClusterEntity) {
            this.podiumCluster = (BlockClusterEntity)entity;
        }
    }

    @Nullable
    public BlockClusterEntity getPodiumCluster() {
        return this.podiumCluster;
    }

    @Nullable
    public Mob summonRandomMob(int diameter, SimpleWeightedRandomList<EntityType<? extends Mob>> types) {
        BlockPos pos = this.getRandomNearbyPos(diameter, 5);
        if (pos != null) {
            ServerLevel world = (ServerLevel)this.f_19853_;
            Mob entity = (Mob)((EntityType)types.m_216820_(this.f_19796_).orElse(null)).m_20615_((Level)world);
            if (this.hasEnoughSpace((Entity)entity, pos)) {
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5);
                entity.m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.EVENT, null, null);
                this.addAttributes(entity);
                entity.m_8032_();
                entity.m_21373_();
                entity.m_21530_();
                world.m_8767_((ParticleOptions)((SimpleParticleType)WitherStormModParticleTypes.COMMAND_BLOCK.get()), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 20, this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), 0.2);
                world.m_8767_((ParticleOptions)ParticleTypes.f_123755_, entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), 20, this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), this.f_19796_.m_188583_(), 0.01);
                world.m_47205_((Entity)entity);
                return entity;
            }
        }
        return null;
    }

    @Nullable
    private BlockPos getRandomNearbyPos(int diameter, int attempts) {
        BlockPos pos = null;
        BlockPos start = this.m_20183_();
        for (int i = 0; i < attempts; ++i) {
            int x = start.m_123341_() + this.f_19796_.m_188503_(diameter) - diameter / 2;
            int z = start.m_123343_() + this.f_19796_.m_188503_(diameter) - diameter / 2;
            int y = start.m_123342_();
            BlockPos currentPos = new BlockPos(x, y, z);
            for (int j = 0; j < 30 && this.f_19853_.m_8055_(currentPos.m_7495_()).m_60713_(Blocks.f_50016_); ++j) {
                currentPos = currentPos.m_7495_();
            }
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.f_19853_, (BlockPos)currentPos, (EntityType)((EntityType)WitherStormModEntityTypes.TENTACLE.get())) || !(Math.sqrt(this.m_20183_().m_123331_((Vec3i)currentPos)) > 6.0)) continue;
            pos = currentPos;
            break;
        }
        return pos;
    }

    private void addAttributes(Mob mob) {
        mob.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("194fec31-b36e-41fc-ad72-02a5cb891def", -((mob.m_217043_().m_188500_() + 0.5) * 2.0), AttributeModifier.Operation.ADDITION));
        mob.m_21051_(Attributes.f_22279_).m_22125_(new AttributeModifier("5965c24d-8ac1-4f04-92ee-3d2724f976e8", -0.08, AttributeModifier.Operation.ADDITION));
    }

    private boolean hasEnoughSpace(Entity entity, BlockPos spawnPos) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)spawnPos, (BlockPos)spawnPos.m_7637_((double)entity.m_20205_(), (double)entity.m_20206_(), (double)entity.m_20205_()))) {
            if (this.f_19853_.m_8055_(pos).m_60812_((BlockGetter)this.f_19853_, pos).m_83281_()) continue;
            return false;
        }
        return true;
    }

    public BossfightPhase<CommandBlockEntity> getCurrentPhase() {
        if (this.f_19853_.f_46443_) {
            return this.getBossfightManager().getPhase((Integer)this.f_19804_.m_135370_(PHASE_KEY));
        }
        return this.getBossfightManager().getCurrentPhase();
    }

    public int getSpecialDeathTime() {
        return this.specialDeathTime;
    }

    protected float m_6121_() {
        return 4.0f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_DAMAGE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_DEATH.get();
    }

    public float m_6100_() {
        return 1.0f;
    }

    public boolean m_6149_() {
        return false;
    }

    protected boolean m_20073_() {
        return false;
    }

    private static class TentacleManager {
        private static final UUID KNOCKBACK_MODIFIER = UUID.fromString("72aeccbe-cdfe-41c9-9d21-261f29f6da60");
        private final CommandBlockEntity entity;
        private final int tentacles;
        private TentacleEntity[] tentacleStructure;
        private UUID[] savedTentacleStructure;
        private TentacleOffsets[] offsets;

        public TentacleManager(CommandBlockEntity entity, int amount, TentacleOffsets[] offsets) {
            this.entity = entity;
            this.tentacles = amount;
            this.tentacleStructure = new TentacleEntity[this.tentacles];
            this.savedTentacleStructure = new UUID[this.tentacles];
            this.offsets = offsets;
        }

        public void createTentacles() {
            for (int i = 0; i < this.tentacleStructure.length; ++i) {
                this.createTentacle(i);
            }
        }

        private void createTentacle(int index) {
            if (this.tentacleStructure[index] == null || !this.tentacleStructure[index].m_6084_()) {
                TentacleEntity tentacle = (TentacleEntity)((EntityType)WitherStormModEntityTypes.TENTACLE.get()).m_20615_(this.entity.f_19853_);
                this.getOffsetsForTentacle(index).apply(this.entity, tentacle);
                tentacle.setDormant(true);
                tentacle.lerpCurlTo(0.0f, 0.0f, 1);
                tentacle.m_20331_(true);
                tentacle.m_20242_(true);
                tentacle.setAnimationOffset(this.entity.f_19796_.m_188503_(35) * 10000);
                tentacle.setCanStrangle(false);
                tentacle.m_21051_(Attributes.f_22282_).m_22125_(new AttributeModifier(KNOCKBACK_MODIFIER, "Command block's tentacles knockback modifier", 5.0, AttributeModifier.Operation.ADDITION));
                this.tentacleStructure[index] = tentacle;
            }
        }

        public void removeTentacles() {
            for (int i = 0; i < this.tentacleStructure.length; ++i) {
                TentacleEntity tentacle = this.tentacleStructure[i];
                if (tentacle == null || !tentacle.m_6084_()) continue;
                tentacle.m_146870_();
            }
        }

        public void readdTentacles() {
            this.createTentacles();
            this.addTentacles();
        }

        public void addTentacles() {
            if (this.entity.isAddedToWorld() && this.entity.m_6084_()) {
                for (int i = 0; i < this.tentacleStructure.length; ++i) {
                    this.addTentacle(i);
                }
            }
        }

        private void addTentacle(int index) {
            TentacleEntity tentacle = this.tentacleStructure[index];
            if (tentacle != null && !tentacle.isAddedToWorld() && tentacle.m_6084_()) {
                this.getOffsetsForTentacle(index).apply(this.entity, tentacle);
                this.entity.f_19853_.m_7967_((Entity)tentacle);
            }
        }

        public void updateTentacles() {
            for (int i = 0; i < this.tentacleStructure.length; ++i) {
                TentacleEntity tentacle = this.tentacleStructure[i];
                if (tentacle == null || !tentacle.m_6084_()) continue;
                this.getOffsetsForTentacle(i).apply(this.entity, tentacle);
            }
        }

        public void killTentacles() {
            for (int i = 0; i < this.tentacleStructure.length; ++i) {
                TentacleEntity tentacle = this.tentacleStructure[i];
                if (tentacle == null) continue;
                tentacle.m_6074_();
            }
        }

        public void findTentacles(ServerLevel world) {
            for (int i = 0; i < this.savedTentacleStructure.length; ++i) {
                Entity entity;
                UUID uuid = this.savedTentacleStructure[i];
                TentacleEntity preexisting = this.tentacleStructure[i];
                if ((uuid == null || preexisting == null || preexisting.m_20148_().equals(uuid)) && preexisting != null || !((entity = world.m_8791_(uuid)) instanceof TentacleEntity)) continue;
                TentacleEntity found = (TentacleEntity)entity;
                if (preexisting != null) {
                    preexisting.m_146870_();
                }
                this.tentacleStructure[i] = found;
                this.savedTentacleStructure[i] = null;
            }
        }

        public TentacleOffsets getOffsetsForTentacle(int index) {
            return this.offsets[index];
        }

        public void addSaveData(CompoundTag compound) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.tentacleStructure.length; ++i) {
                TentacleEntity tentacle = this.tentacleStructure[i];
                CompoundTag tentacleCompound = new CompoundTag();
                if (tentacle != null) {
                    tentacleCompound.m_128362_("UUID", tentacle.m_20148_());
                }
                list.add((Object)tentacleCompound);
            }
            compound.m_128365_("Tentacles", (Tag)list);
        }

        public void readSaveData(CompoundTag compound) {
            ListTag list = compound.m_128437_("Tentacles", 10);
            for (int i = 0; i < this.tentacleStructure.length; ++i) {
                CompoundTag tentacleCompound = list.m_128728_(i);
                if (!tentacleCompound.m_128441_("UUID") || this.savedTentacleStructure[i] != null) continue;
                this.savedTentacleStructure[i] = tentacleCompound.m_128342_("UUID");
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum State {
        IDLE{

            @Override
            public void tick(CommandBlockEntity entity) {
                super.tick(entity);
                if (this.modeTickDelay() < entity.getStateTicks()) {
                    entity.getMode().idleTick(entity);
                }
            }
        }
        ,
        PLAYING_DEAD{

            @Override
            public void tick(CommandBlockEntity entity) {
                super.tick(entity);
                if (this.modeTickDelay() < entity.getStateTicks()) {
                    entity.getMode().playingDeadTick(entity);
                }
                if (!entity.f_19853_.f_46443_) {
                    Level world = entity.f_19853_;
                    Player player = world.m_45946_(entity.searchablePlayersPredicate(), (LivingEntity)entity);
                    if (player != null) {
                        entity.setLuringPlayer(player);
                        entity.nextState();
                    }
                    int time = WitherStormModConfig.SERVER.revivalTimeMinutes.get();
                    if (WitherStormModConfig.SERVER.revivalTimer.get().booleanValue() && time > 0 && entity.getStateTicks() > time * 1200) {
                        entity.setState(REACTIVATING);
                    }
                }
            }
        }
        ,
        LURING{

            @Override
            public void tick(CommandBlockEntity entity) {
                super.tick(entity);
                if (this.modeTickDelay() < entity.getStateTicks()) {
                    entity.getMode().idleTick(entity);
                }
                if (!entity.f_19853_.f_46443_) {
                    Player player = entity.getLuringPlayer();
                    if (player != null && entity.searchablePlayersPredicate().m_26883_(12.0).m_26885_((LivingEntity)entity, (LivingEntity)player) && entity.getStateTicks() < 240) {
                        double speed = 0.025;
                        Vec3 motion = entity.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82542_(speed, speed, speed);
                        player.m_20334_(motion.f_82479_, player.m_20184_().f_82480_, motion.f_82481_);
                        WitherStormModPacketHandlers.MAIN.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerMotionMessage(new Vec3(motion.f_82479_, player.m_20184_().f_82480_, motion.f_82481_)));
                        if ((double)player.m_20270_((Entity)entity) < 3.0) {
                            entity.setLuringPlayer(null);
                            entity.nextState();
                        }
                        for (int i = 0; i < 4; ++i) {
                            double x = player.m_20185_() + entity.f_19796_.m_188583_() * player.m_20191_().m_82362_() * 0.4;
                            double y = player.m_20191_().m_82399_().m_7098_() + entity.f_19796_.m_188583_() * player.m_20191_().m_82376_() * 0.4;
                            double z = player.m_20189_() + entity.f_19796_.m_188583_() * player.m_20191_().m_82385_() * 0.4;
                            Vec3 delta = entity.m_20299_(1.0f).m_82492_(x, y, z).m_82541_().m_82490_(0.1);
                            entity.f_19853_.m_7106_((ParticleOptions)WitherStormModParticleTypes.COMMAND_BLOCK.get(), x, y, z, delta.m_7096_(), delta.m_7098_(), delta.m_7094_());
                        }
                    } else {
                        entity.nextState();
                    }
                }
            }

            @Override
            public void init(CommandBlockEntity entity) {
                super.init(entity);
                entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.COMMAND_BLOCK_ACTIVATES.get(), SoundSource.HOSTILE, 5.0f, 1.0f);
                entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.TREMBLE.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
                if (!entity.f_19853_.f_46443_) {
                    ShakeScreenMessage message = new ShakeScreenMessage(40.0f, 5.0f);
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
                }
                for (int i = 0; i < 10; ++i) {
                    entity.f_19853_.m_7106_((ParticleOptions)WitherStormModParticleTypes.COMMAND_BLOCK.get(), entity.m_20185_(), entity.m_20188_(), entity.m_20189_(), entity.f_19796_.m_188583_() * 0.5, entity.f_19796_.m_188583_() * 0.5, entity.f_19796_.m_188583_() * 0.5);
                }
            }

            @Override
            public boolean shouldShowOwnerBossBar() {
                return true;
            }

            @Override
            public int modeTickDelay() {
                return 40;
            }
        }
        ,
        REACTIVATING{

            @Override
            public void tick(CommandBlockEntity entity) {
                WitherStormEntity owner;
                super.tick(entity);
                if (this.modeTickDelay() < entity.getStateTicks()) {
                    entity.getMode().protectTick(entity);
                }
                if (!entity.f_19853_.f_46443_ && entity.getOwner() != null && entity.getStateTicks() > 60 && !(owner = entity.getOwner()).isReviving()) {
                    owner.reviveFromPlayingDead();
                }
            }

            @Override
            public void init(CommandBlockEntity entity) {
                super.init(entity);
                if (!entity.f_19853_.f_46443_) {
                    ShakeScreenMessage message = new ShakeScreenMessage(120.0f, 5.0f);
                    WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
                }
                entity.f_19853_.m_5594_(null, entity.m_20183_(), (SoundEvent)WitherStormModSoundEvents.TREMBLE.get(), SoundSource.AMBIENT, 10.0f, 1.0f);
            }

            @Override
            public boolean shouldShowOwnerBossBar() {
                return true;
            }

            @Override
            public int modeTickDelay() {
                return 20;
            }
        }
        ,
        BOSSFIGHT{

            @Override
            public void tick(CommandBlockEntity entity) {
                super.tick(entity);
                if (!entity.f_19853_.f_46443_) {
                    entity.getBossfightManager().tick();
                    if (!entity.getCurrentPhase().equals(CommandBlockEntity.IDLE) || entity.m_21223_() < entity.m_21233_()) {
                        entity.bossInfo.m_8321_(true);
                    }
                }
                entity.getMode().idleTick(entity);
            }

            @Override
            public void init(CommandBlockEntity entity) {
                super.init(entity);
            }
        };


        public void tick(CommandBlockEntity entity) {
            entity.getMode().tick(entity, entity.getState());
            ++entity.stateTicks;
            if (this != PLAYING_DEAD) {
                for (int i = 0; i < 5; ++i) {
                    double x = entity.m_20185_() + entity.f_19796_.m_188583_();
                    double y = entity.m_20188_() + entity.f_19796_.m_188583_();
                    double z = entity.m_20189_() + entity.f_19796_.m_188583_();
                    float particleSpeed = (entity.m_21233_() - entity.m_21223_()) / entity.m_21233_() + 1.0f;
                    Vec3 delta = entity.m_20299_(1.0f).m_82492_(x, y, z).m_82541_().m_82490_(0.1 * (double)particleSpeed);
                    entity.f_19853_.m_7106_((ParticleOptions)WitherStormModParticleTypes.COMMAND_BLOCK.get(), x, y, z, delta.m_7096_(), delta.m_7098_(), delta.m_7094_());
                }
            }
        }

        public void init(CommandBlockEntity entity) {
            entity.stateTicks = 0;
            entity.getMode().init(entity, entity.getState());
            entity.setProtectionYOffset(0.0f);
            if (entity.getOwner() != null) {
                this.initWithOwner(entity.getOwner(), entity);
            }
            entity.bossInfo.m_8321_(false);
        }

        public int modeTickDelay() {
            return 0;
        }

        public boolean shouldShowOwnerBossBar() {
            return false;
        }

        public void initWithOwner(WitherStormEntity owner, CommandBlockEntity entity) {
            if (owner.m_6084_()) {
                if (this.shouldShowOwnerBossBar()) {
                    owner.getBossInfo().ifPresent(info -> info.m_8321_(true));
                } else {
                    owner.getBossInfo().ifPresent(info -> info.m_8321_(!owner.isPlayingDead()));
                }
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        NONE,
        RIBS{

            @Override
            public void playingDeadTick(CommandBlockEntity entity) {
                super.playingDeadTick(entity);
                Random random = new Random(entity.m_20148_().getLeastSignificantBits());
                for (StructureAnimationHelper helper : this.getStructure(entity)) {
                    helper.lerpBaseTo(entity, -50.0f, 0.0f, Math.max(4, random.nextInt(11)));
                    helper.lerpTo(entity, Math.max(30.0f, (float)random.nextInt(131)), (float)random.nextInt(21) - 10.0f, Math.max(4, random.nextInt(11)));
                }
            }

            @Override
            public void idleTick(CommandBlockEntity entity) {
                super.idleTick(entity);
                entity.lerpStructureBaseRotTo(this.getStructure(entity), -50.0f, 0.0f, 10);
                entity.lerpStructureRotTo(this.getStructure(entity), 60.0f, 0.0f, 20);
            }

            @Override
            public void protectTick(CommandBlockEntity entity) {
                super.protectTick(entity);
                entity.lerpStructureBaseRotTo(this.getStructure(entity), 0.0f, 0.0f, 40);
                entity.lerpStructureRotTo(this.getStructure(entity), 70.0f, 0.0f, 20);
                if (entity.getProtectionYOffset() > -0.8f && entity.getStateTicks() > 20 + entity.getState().modeTickDelay()) {
                    entity.protectionYOffset -= 0.05f;
                }
            }

            @Override
            public void playMovementSound(CommandBlockEntity entity) {
                for (int i = 0; i < this.getStructure(entity).size(); ++i) {
                    double x = entity.f_19796_.m_188583_() * 3.0 + entity.m_20185_();
                    double y = entity.m_20188_();
                    double z = entity.f_19796_.m_188583_() * 3.0 + entity.m_20189_();
                    entity.f_19853_.m_6263_(null, x, y, z, (SoundEvent)WitherStormModSoundEvents.RIB_BONE_CRACK.get(), SoundSource.AMBIENT, 0.2f, 0.8f);
                }
            }

            @Override
            public List<StructureAnimationHelper> getStructure(CommandBlockEntity entity) {
                return entity.getRibStructure();
            }
        }
        ,
        TENTACLES{

            @Override
            public void tick(CommandBlockEntity entity, State state) {
                super.tick(entity, state);
                if (!entity.f_19853_.f_46443_) {
                    entity.tentacleStructure.addTentacles();
                    entity.tentacleStructure.updateTentacles();
                }
            }
        };


        public void tick(CommandBlockEntity entity, State state) {
            ++entity.modeAnim;
            if (!entity.f_19853_.f_46443_ && entity.f_19797_ % 120 == 0) {
                WitherStormModPacketHandlers.MAIN.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ModeAnimationMessage(entity.m_19879_(), entity.modeAnim));
            }
        }

        public void idleTick(CommandBlockEntity entity) {
        }

        public void playingDeadTick(CommandBlockEntity entity) {
        }

        public void protectTick(CommandBlockEntity entity) {
        }

        public void init(CommandBlockEntity entity, State state) {
            entity.modeAnim = 0;
            if (!entity.f_19853_.f_46443_ && entity.isAddedToWorld()) {
                if (this == TENTACLES) {
                    entity.tentacleStructure.readdTentacles();
                } else {
                    entity.tentacleStructure.removeTentacles();
                }
            }
        }

        public List<StructureAnimationHelper> getStructure(CommandBlockEntity entity) {
            return Lists.newArrayList();
        }

        public void playMovementSound(CommandBlockEntity entity) {
        }
    }

    public static class ModeAnimationMessage
    extends Message<ModeAnimationMessage> {
        private int id;
        private int anim;

        public ModeAnimationMessage(int entityId, int anim) {
            super(true);
            this.id = entityId;
            this.anim = anim;
        }

        public ModeAnimationMessage() {
            super(false);
        }

        @Override
        public void encode(FriendlyByteBuf buffer) {
            super.encode(buffer);
            buffer.m_130130_(this.id);
            buffer.writeInt(this.anim);
        }

        @Override
        public void decode(ModeAnimationMessage message, FriendlyByteBuf buffer) throws IllegalArgumentException, IndexOutOfBoundsException {
            message.id = buffer.m_130242_();
            message.anim = buffer.readInt();
        }

        @Override
        public Runnable getProcessor(ModeAnimationMessage message, NetworkEvent.Context context) {
            return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                Optional optional = (Optional)LogicalSidedProvider.CLIENTWORLD.get(context.getDirection().getReceptionSide());
                optional.ifPresent(world -> {
                    Entity entity = world.m_6815_(message.id);
                    if (entity instanceof CommandBlockEntity) {
                        CommandBlockEntity commandBlock = (CommandBlockEntity)entity;
                        commandBlock.modeAnim = message.anim;
                    }
                });
            });
        }
    }
}

