/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCriteriaTriggers;
import nonamecrackers2.witherstormmod.common.init.WitherStormModEffects;
import nonamecrackers2.witherstormmod.common.init.WitherStormModItems;

public abstract class AbstractSickenedEntity
extends Monster {
    private static final Map<EntityType<?>, EntityType<? extends AbstractSickenedEntity>> CONVERSIONS = new HashMap();
    protected static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(AbstractSickenedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int conversionTime;
    protected UUID conversionStarter;
    @Nullable
    protected EntityType<?> original;
    @Nullable
    protected CompoundTag originalData;

    public static void addApplicableConversionType(EntityType<?> from, EntityType<? extends AbstractSickenedEntity> to) {
        CONVERSIONS.put(from, to);
    }

    @Nullable
    public static EntityType<? extends AbstractSickenedEntity> getConversion(EntityType<?> type) {
        return CONVERSIONS.get(type);
    }

    public AbstractSickenedEntity(EntityType<? extends AbstractSickenedEntity> type, Level world) {
        super(type, world);
    }

    public AbstractSickenedEntity(EntityType<? extends AbstractSickenedEntity> type, Level world, EntityType<? extends Mob> original, CompoundTag originalData) {
        super(type, world);
        this.original = original;
        this.originalData = originalData;
    }

    public void setOriginal(EntityType<?> originalType, CompoundTag originalData) {
        this.original = originalType;
        this.originalData = originalData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CONVERTING, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        String id = this.encodeOriginalId();
        if (id != null) {
            compound.m_128359_("OriginalType", id);
        }
        if (this.getOriginalData() != null) {
            compound.m_128365_("OriginalData", (Tag)this.getOriginalData());
        }
        compound.m_128405_("ConversionTime", this.isConverting() ? this.getConversionTime() : -1);
        if (this.getConversionStarter() != null) {
            compound.m_128362_("ConversionPlayer", this.getConversionStarter());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("OriginalType")) {
            ResourceLocation location = ResourceLocation.m_135820_((String)compound.m_128461_("OriginalType"));
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location);
            this.setOriginal(type, compound.m_128441_("OriginalData") ? compound.m_128469_("OriginalData") : null);
        }
        if (compound.m_128441_("ConversionTime") && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"));
        }
    }

    @Nullable
    public final String encodeOriginalId() {
        if (this.getOriginalType() != null) {
            EntityType<?> type = this.getOriginalType();
            ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey(type);
            return type.m_20584_() && location != null ? location.toString() : null;
        }
        return null;
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.isConverting()) {
            int i = this.getConversionProgress();
            this.conversionTime -= i;
            if (this.getConversionTime() <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)this.m_6095_(), timer -> {
                this.conversionTime = timer;
            })) {
                this.finishConversion((ServerLevel)this.f_19853_);
            }
        }
        super.m_8119_();
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == WitherStormModItems.GOLDEN_APPLE_STEW.get()) {
            if (!this.isConverting() && this.getOriginalType() != null) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    this.startConverting(player.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public void finishConversion(ServerLevel world) {
        Object entity;
        if (this.getOriginalType() != null && (entity = this.m_21406_(this.getOriginalType(), false)) != null) {
            Player player;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = this.m_6844_(slot);
                if (stack.m_41619_()) continue;
                if (EnchantmentHelper.m_44920_((ItemStack)stack)) {
                    entity.m_141942_(slot.m_20749_() + 300).m_142104_(stack);
                    continue;
                }
                double d0 = this.m_21519_(slot);
                if (!(d0 > 1.0)) continue;
                this.m_19983_(stack);
            }
            entity.m_6518_((ServerLevelAccessor)world, world.m_6436_(entity.m_20183_()), MobSpawnType.CONVERSION, null, null);
            if (this.conversionStarter != null && (player = world.m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
                WitherStormModCriteriaTriggers.CURED_SICKENED_MOB.trigger((ServerPlayer)player, this, (Mob)entity);
            }
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            if (!this.m_20067_()) {
                world.m_5898_(null, 1027, this.m_20183_(), 0);
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, entity);
        }
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.35f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.85f;
    }

    protected void startConverting(@Nullable UUID uuid, int duration) {
        if (this.getOriginalType() != null) {
            this.conversionStarter = uuid;
            this.conversionTime = duration;
            this.f_19804_.m_135381_(CONVERTING, (Object)true);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration, Math.min(this.f_19853_.m_46791_().m_19028_() - 1, 0)));
            this.f_19853_.m_7605_((Entity)this, (byte)16);
        }
    }

    public void m_7822_(byte id) {
        if (id == 16) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_6043_() {
        if (this.getOriginalType() != null) {
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
                this.m_146870_();
            } else {
                this.f_20891_ = 0;
            }
        } else {
            super.m_6043_();
        }
    }

    public UUID getConversionStarter() {
        return this.conversionStarter;
    }

    public int getConversionTime() {
        return this.conversionTime;
    }

    public boolean isConverting() {
        return (Boolean)this.f_19804_.m_135370_(CONVERTING);
    }

    protected int getConversionProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        Block block = this.f_19853_.m_8055_((BlockPos)pos.m_122178_(k, l, i1)).m_60734_();
                        if (block != Blocks.f_50183_ && !(block instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    public EntityType<?> getOriginalType() {
        return this.original;
    }

    protected CompoundTag getOriginalData() {
        return this.originalData;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> type, boolean loot) {
        if (!this.m_6084_()) {
            return null;
        }
        Mob t = (Mob)type.m_20615_(this.f_19853_);
        if (this.getOriginalData() != null) {
            t.m_20258_(this.getOriginalData());
        }
        t.m_21153_(this.m_21223_());
        t.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).ifPresent(tracker -> tracker.cure());
        t.m_21219_();
        t.m_20359_((Entity)this);
        t.m_6863_(this.m_6162_());
        t.m_21557_(this.m_21525_());
        if (this.m_8077_()) {
            t.m_6593_(this.m_7770_());
            t.m_20340_(this.m_20151_());
        }
        if (this.m_21532_()) {
            t.m_21530_();
        }
        t.m_20331_(this.m_20147_());
        if (loot) {
            t.m_21553_(this.m_21531_());
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = this.m_6844_(slot);
                if (stack.m_41619_()) continue;
                t.m_8061_(slot, stack.m_41777_());
                t.m_21409_(slot, this.m_21519_(slot));
                stack.m_41764_(0);
            }
        }
        this.f_19853_.m_7967_((Entity)t);
        if (this.m_20159_()) {
            Entity entity = this.m_20202_();
            this.m_8127_();
            t.m_7998_(entity, true);
        }
        this.m_146870_();
        return (T)t;
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity entity) {
        if (effect.m_19544_() == WitherStormModEffects.WITHER_SICKNESS.get()) {
            return false;
        }
        return super.m_147207_(effect, entity);
    }
}

