/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config.preset;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import nonamecrackers2.witherstormmod.common.config.AbstractConfig;
import nonamecrackers2.witherstormmod.common.config.ConfigValue;

public class ConfigPreset {
    private final AbstractConfig config;
    private final LinkedHashMap<ConfigValue<Object>, Object> values;
    private final MutableComponent translatedName;
    @Nullable
    private MutableComponent description;
    private final ResourceLocation name;
    private final Optional<ConfigPreset> parent;
    private final boolean isDefault;

    private ConfigPreset(AbstractConfig config, LinkedHashMap<ConfigValue<Object>, Object> map, MutableComponent translated, ResourceLocation location, boolean isDefault, Optional<ConfigPreset> parent) {
        this.config = config;
        this.values = map;
        this.translatedName = translated;
        this.name = location;
        this.isDefault = isDefault;
        this.parent = parent;
    }

    public ConfigPreset withDescription(MutableComponent components) {
        this.description = components;
        return this;
    }

    public <T> T getPresetValue(ConfigValue<T> config) {
        return (T)this.values.get(config);
    }

    public LinkedHashMap<ConfigValue<Object>, Object> getValues() {
        return this.values;
    }

    public MutableComponent getTranslationName() {
        return this.translatedName;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public List<FormattedCharSequence> getTooltip(boolean hasShiftDown) {
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(FormattedCharSequence.m_13714_((String)this.translatedName.getString(), (Style)Style.f_131099_));
        if (!hasShiftDown) {
            tooltip.add(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"gui.witherstormmod.button.preset.holdShift", (Object[])new Object[0]), (Style)Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
        } else {
            this.getParent().ifPresent(preset -> {
                String[] parentComponents = preset.description.getString().split("\n");
                for (int i = 0; i < parentComponents.length; ++i) {
                    tooltip.add(FormattedCharSequence.m_13714_((String)parentComponents[i].trim(), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
                }
                ConfigPreset.blankLine(tooltip);
            });
            if (this.description != null) {
                String[] components = this.description.getString().split("\n");
                for (int i = 0; i < components.length; ++i) {
                    tooltip.add(FormattedCharSequence.m_13714_((String)components[i].trim(), (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
                }
            }
            HashSet<ConfigValue.ReloadType> reloadTypes = new HashSet<ConfigValue.ReloadType>();
            for (Map.Entry<ConfigValue<Object>, Object> entry : this.getValues().entrySet()) {
                if (entry.getKey().getReloadType() == ConfigValue.ReloadType.NONE) continue;
                reloadTypes.add(entry.getKey().getReloadType());
            }
            for (ConfigValue.ReloadType reloadType : reloadTypes) {
                tooltip.add(FormattedCharSequence.m_13714_((String)("May require reload of: " + reloadType.toString()), (Style)Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
            }
            tooltip.add(FormattedCharSequence.m_13714_((String)this.name.toString(), (Style)Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY)));
            this.getParent().ifPresent(parent -> tooltip.add(FormattedCharSequence.m_13714_((String)("parent: " + parent.getName().toString()), (Style)Style.f_131099_.m_131140_(ChatFormatting.DARK_GRAY))));
        }
        return tooltip;
    }

    private static void blankLine(List<FormattedCharSequence> text) {
        text.add(FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_));
    }

    public boolean doesValuesMatch(List<ConfigValue<Object>> values) {
        boolean flag;
        block1: {
            ConfigValue<Object> value;
            flag = true;
            if (this.values.isEmpty()) break block1;
            Iterator<ConfigValue<Object>> iterator = values.iterator();
            while (iterator.hasNext() && (flag = (value = iterator.next()).getNonDirtyOrDirty().equals(this.values.get(value)))) {
            }
        }
        return flag;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public AbstractConfig getAssociatedConfig() {
        return this.config;
    }

    public Optional<ConfigPreset> getParent() {
        return this.parent;
    }

    public static class Builder {
        private final AbstractConfig config;
        private final Map<ConfigValue<Object>, Object> values;
        private boolean isDefault;
        private Optional<ConfigPreset> parent = Optional.empty();

        private Builder(AbstractConfig config, Map<ConfigValue<Object>, Object> map) {
            this.config = config;
            this.values = map;
        }

        public static Builder of(AbstractConfig config) {
            HashMap map = Maps.newHashMap();
            config.getValues().forEach(value -> {
                if (!config.shouldExclude((ConfigValue<Object>)value)) {
                    map.put(value, value.getDefault());
                }
            });
            return new Builder(config, map).setDefault(true);
        }

        public static Builder ofPreset(ConfigPreset preset) {
            if (preset.config != null) {
                HashMap map = Maps.newHashMap();
                preset.getValues().forEach((key, value) -> map.put(key, value));
                return new Builder(preset.getAssociatedConfig(), map).setParent(preset).setDefault(preset.isDefault());
            }
            throw new NullPointerException("Cannot construct ConfigPreset based off of another ConfigPreset with a null config");
        }

        public static <T> Builder empty() {
            return new Builder(null, Maps.newHashMap());
        }

        public <T> Builder setConfigPreset(ConfigValue<T> config, T value) {
            this.values.computeIfPresent(config, (key, old) -> value);
            return this.setDefault(false);
        }

        private Builder setDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        private Builder setParent(ConfigPreset preset) {
            this.parent = Optional.of(preset);
            return this;
        }

        public ConfigPreset build(MutableComponent translation, ResourceLocation name) {
            return new ConfigPreset(this.config, Maps.newLinkedHashMap(this.values), translation, name, this.isDefault, this.parent);
        }
    }
}

