/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config;

import com.google.common.collect.ImmutableList;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import nonamecrackers2.witherstormmod.common.config.AbstractConfig;
import nonamecrackers2.witherstormmod.common.config.ConfigValue;
import nonamecrackers2.witherstormmod.common.config.SyncableConfigValue;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;
import nonamecrackers2.witherstormmod.common.init.WitherStormModAttributes;
import nonamecrackers2.witherstormmod.common.util.UltimateTargetManager;
import org.apache.commons.lang3.tuple.Pair;

public class WitherStormModConfig {
    private static final ImmutableList<AbstractConfig> ALL_CONFIGS;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;

    public static ImmutableList<AbstractConfig> getAllConfigs() {
        return ALL_CONFIGS;
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (ClientConfig)clientSpecPair.getLeft();
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (CommonConfig)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (ServerConfig)serverSpecPair.getLeft();
        ALL_CONFIGS = ImmutableList.of((Object)CLIENT, (Object)COMMON, (Object)SERVER);
    }

    public static class ClientConfig
    extends AbstractConfig {
        public final ConfigValue<Boolean> renderDebrisCloud;
        public final ConfigValue<Boolean> renderDebrisRings;
        public final ConfigValue<Boolean> renderDebrisTwoDimensional;
        public final ConfigValue<Boolean> renderDistantDebris;
        public final ConfigValue<Boolean> renderSegmentDebris;
        public final ConfigValue<Boolean> lowerDebrisResWithPhase;
        public final ConfigValue<Boolean> witherStormLOD;
        public final ConfigValue<Boolean> lowResModels;
        public final ConfigValue<Boolean> renderTractorBeams;
        public final ConfigValue<Boolean> renderPulse;
        public final ConfigValue<Boolean> distantRenderer;
        public final ConfigValue<Boolean> blockClusterRendering;
        public final ConfigValue<Boolean> witherSicknessLayer;
        public final ConfigValue<Boolean> playBossThemes;
        public final ConfigValue<Boolean> chromaticAberration;
        public final ConfigValue<Boolean> blindingEffects;
        public final ConfigValue<Boolean> cameraShakeEffects;
        public final ConfigValue<Boolean> distantFog;
        public final ConfigValue<Boolean> blockClusterColouring;
        public final ConfigValue<Boolean> earRingingEffects;
        public final ConfigValue<Boolean> renderTractorBeamOverlay;
        public final ConfigValue<Boolean> renderSkyAmbienceEffects;
        public final ConfigValue<Boolean> tractorBeamParticles;
        public final ConfigValue<Boolean> flywheelCompatEnabled;
        public final ConfigValue<Boolean> blockClusterInstancing;
        public final ConfigValue<Boolean> witherStormDeathInstancing;
        public final ConfigValue<Boolean> distantRendererInstancing;
        public final ConfigPreset highPreset;
        public final ConfigPreset lowPreset;
        public final ConfigPreset mediumPreset;

        private ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Client options").push("client");
            this.renderDebrisCloud = this.createValue(builder, true, "renderDebrisCloud", ConfigValue.ReloadType.NONE, "Toggles the rendering of the debris cloud", "surrounding the Wither Storm");
            this.renderDebrisRings = this.createValue(builder, true, "renderDebrisRings", ConfigValue.ReloadType.NONE, "Toggles the rendering of debris rings", "that surround the Wither Storm (much more performant", "than the debris cloud)");
            this.renderDebrisTwoDimensional = this.createValue(builder, false, "renderDebrisTwoDimensional", ConfigValue.ReloadType.NONE, "Renders the debris in the debris cloud", "as 2D objects instead of 3D");
            this.renderDistantDebris = this.createValue(builder, true, "renderDistantDebris", ConfigValue.ReloadType.NONE, "Setting this value to false will disable the debris", "cloud when rendering the Wither Storm from large", "distances");
            this.renderSegmentDebris = this.createValue(builder, false, "renderSegmentDebris", ConfigValue.ReloadType.NONE, "Specifies if the debris particles orbiting segments", "should be rendered");
            this.lowerDebrisResWithPhase = this.createValue(builder, true, "lowerDebrisResWithPhase", ConfigValue.ReloadType.NONE, "Specifies if debris should render as 2D objects", "during phase 6 and above");
            this.witherStormLOD = this.createValue(builder, false, "witherStormLOD", ConfigValue.ReloadType.NONE, "Specifies if the low res models should", "be used when being rendered via the distant", "renderer");
            this.lowResModels = this.createValue(builder, false, "lowResModels", ConfigValue.ReloadType.NONE, "Uses larger cubes to make up the the phase 4 and up models.", "Should result in a performance increase");
            this.renderTractorBeams = this.createValue(builder, true, "renderTractorBeams", ConfigValue.ReloadType.NONE, "Toggles the rendering of the tractor beams");
            this.renderPulse = this.createValue(builder, true, "renderPulse", ConfigValue.ReloadType.NONE, "Specifies if a pulsating effect, mimicking endermen pulling", "the Wither Storm apart, should be rendered once its", "evolution is complete");
            this.distantRenderer = this.createValue(builder, true, "distantRenderer", ConfigValue.ReloadType.NONE, "The distant renderer allows for the Wither Storm", "to be rendered from much greater distances", "than what vanilla allows. Disable if you're", "facing issues with it");
            this.blockClusterRendering = this.createValue(builder, true, "blockClusterRendering", ConfigValue.ReloadType.NONE, "Toggles the rendering of Block Clusters");
            this.witherSicknessLayer = this.createValue(builder, true, "witherSicknessLayer", ConfigValue.ReloadType.GAME, "Specifies if an overlay should be applied to entities", "that renders wither sickness");
            this.playBossThemes = this.createValue(builder, false, "playBossThemes", ConfigValue.ReloadType.NONE, "Specifies if the boss themes should be played.", "Useful if you want to disable only the themes", "without also turning off music discs");
            this.chromaticAberration = this.createValue(builder, true, "chromaticAberration", ConfigValue.ReloadType.NONE, "Toggle to enable/disable the chromatic aberration effect");
            this.blindingEffects = this.createValue(builder, true, "blindingEffects", ConfigValue.ReloadType.NONE, "Specifies whether or not a white overlay should cover", "the screen during certain events");
            this.cameraShakeEffects = this.createValue(builder, true, "cameraShakeEffects", ConfigValue.ReloadType.NONE, "Specifies whether or not camera shake effects", "should be used");
            this.distantFog = this.createValue(builder, true, "distantFog", ConfigValue.ReloadType.NONE, "Specifies if fog should be applied to", "Wither Storms being rendered from a distance");
            this.blockClusterColouring = this.createValue(builder, true, "blockClusterColouring", ConfigValue.ReloadType.NONE, "Specifies if block clusters should be able to have", "special colouring and alpha applied to them.", "NOTE: DISABLE IF FACING CRASHES WHEN USING SHADERS WITH OPTIFINE");
            this.earRingingEffects = this.createValue(builder, true, "earRingingEffects", ConfigValue.ReloadType.NONE, "Turn off to disable the ear ringing", "effects used in the mod");
            this.renderTractorBeamOverlay = this.createValue(builder, true, "renderTractorBeamOverlay", ConfigValue.ReloadType.NONE, "Turn off to disable the overlay that", "appears when inside a tractor beam");
            this.renderSkyAmbienceEffects = this.createValue(builder, true, "renderSkyAmbienceEffects", ConfigValue.ReloadType.NONE, "Specifies if sky ambience affects (sky darkening)", "should render when a Wither Storm is nearby");
            this.tractorBeamParticles = this.createValue(builder, true, "tractorBeamParticles", ConfigValue.ReloadType.NONE, "Specifies if particles inside the tractor", "beams of the Wither Storm should render");
            builder.comment("Flywheel compat").push("flywheel compat");
            this.flywheelCompatEnabled = this.createValue(builder, true, "flywheelCompatEnabled", ConfigValue.ReloadType.GAME, "Specifies if CWSM compat with Flywheel", "should be enabled or not. NOTE: disabling", "will prevent the performance boosts from", "taking effect. Only disable if facing issues");
            this.blockClusterInstancing = this.createValue(builder, false, "blockClusterInstancing", ConfigValue.ReloadType.GAME, "Specifies if block clusters should be instanced.", "NOTE: Block biome colors do not work with block clusters (e.x. leaves/grass will be white)");
            this.witherStormDeathInstancing = this.createValue(builder, false, "witherStormDeathInstancing", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm's death animation", "should be instanced. NOTE: The fade away animation will", "NOT work with this option enabled");
            this.distantRendererInstancing = this.createValue(builder, false, "distantRendererInstancing", ConfigValue.ReloadType.WORLD, "Specifies if the distant renderer should be", "instanced. NOTE: The distant renderer does not", "render properly with this option enabled");
            builder.pop();
            this.excludeFromPresets(this.playBossThemes);
            this.excludeFromPresets(this.chromaticAberration);
            this.excludeFromPresets(this.blindingEffects);
            this.excludeFromPresets(this.cameraShakeEffects);
            this.excludeFromPresets(this.distantFog);
            this.excludeFromPresets(this.blockClusterColouring);
            this.excludeFromPresets(this.earRingingEffects);
            this.excludeFromPresets(this.renderTractorBeamOverlay);
            this.excludeFromPresets(this.renderSkyAmbienceEffects);
            this.excludeFromPresets(this.tractorBeamParticles);
            this.excludeFromPresets(this.flywheelCompatEnabled);
            this.excludeFromPresets(this.blockClusterInstancing);
            this.excludeFromPresets(this.witherStormDeathInstancing);
            this.excludeFromPresets(this.distantRendererInstancing);
            this.highPreset = ConfigPreset.Builder.of(this).build(Component.m_237115_((String)"config.witherstormmod.preset.client.high.title"), new ResourceLocation("witherstormmod", "high_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.high.description"));
            this.mediumPreset = ConfigPreset.Builder.of(this).setConfigPreset(this.renderDebrisTwoDimensional, true).setConfigPreset(this.renderDistantDebris, false).setConfigPreset(this.blockClusterRendering, false).build(Component.m_237115_((String)"config.witherstormmod.preset.client.medium.title"), new ResourceLocation("witherstormmod", "medium_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.medium.description"));
            this.lowPreset = ConfigPreset.Builder.of(this).setConfigPreset(this.renderDebrisTwoDimensional, true).setConfigPreset(this.lowResModels, true).setConfigPreset(this.blockClusterRendering, false).setConfigPreset(this.renderDebrisCloud, false).setConfigPreset(this.renderDistantDebris, false).build(Component.m_237115_((String)"config.witherstormmod.preset.client.low.title"), new ResourceLocation("witherstormmod", "low_client")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.client.low.description"));
            this.putPresets(this.highPreset, this.mediumPreset, this.lowPreset);
            builder.pop();
        }
    }

    public static class CommonConfig
    extends AbstractConfig {
        public final ConfigValue<Boolean> playerFavorability;
        public final ConfigValue<Boolean> blockClustersDropItems;
        public final ConfigValue<Boolean> shouldPickUpVehicles;
        public final ConfigValue<Boolean> phantomsOrbitWitherStorm;
        public final SyncableConfigValue<Boolean> crossbowsSupportEnderPearls;
        public final ConfigValue<Boolean> playerCannotDismountTentacles;
        public final ConfigValue<Boolean> injectCustomAiBehavior;
        public final ConfigPreset defaultPreset;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Common options").push("common");
            this.playerFavorability = this.createValue(builder, true, "playerFavorability", ConfigValue.ReloadType.NONE, "This feature makes the Wither Storm more likely", "to choose nearby players as targets", "instead of other mobs");
            this.blockClustersDropItems = this.createValue(builder, false, "blockClustersDropItems", ConfigValue.ReloadType.WORLD, "Toggle to enable/disable drops from Block Clusters.", "NOTE: Enabling this feature can cause world lag");
            this.shouldPickUpVehicles = this.createValue(builder, true, "shouldPickUpVehicles", ConfigValue.ReloadType.NONE, "Specifies if the current entity the Wither Storm", "is picking up has a vehicle, that it should", "pick it up as well. Ex: Should pick up a player riding a boat");
            this.phantomsOrbitWitherStorm = this.createValue(builder, true, "phantomsOrbitWitherStorm", ConfigValue.ReloadType.WORLD, "Specifies if phantoms AI should be overriden to", "allow circling above any nearby Wither Storms.", "Disable if you wish for default behaviour and/or if issues arise");
            this.crossbowsSupportEnderPearls = this.createSyncValue(builder, true, "crossbowsSupportEnderPearls", ConfigValue.ReloadType.NONE, new ResourceLocation("witherstormmod", "crossbows_shoot_ender_pearls"), (buffer, value) -> buffer.writeBoolean(value.booleanValue()), buffer -> buffer.readBoolean(), "Specifies if crossbows should be able to", "also shoot ender pearls. Disable if facing", "compatibility issues");
            this.playerCannotDismountTentacles = this.createValue(builder, true, "playerCannotDismountTentacles", ConfigValue.ReloadType.NONE, "Specifies if players should not be able", "to dismount a tentacle entity. Disable", "if facing compatibility issues");
            this.injectCustomAiBehavior = this.createValue(builder, true, "injectCustomAiBehavior", ConfigValue.ReloadType.WORLD, "Specifies if custom AI behavior should be injected", "into certain entities (such as mobs running away", "from the Wither Storm). Disable if facing compatibility", "issues");
            this.defaultPreset = ConfigPreset.Builder.of(this).build(Component.m_237115_((String)"config.witherstormmod.preset.default.title"), new ResourceLocation("witherstormmod", "default_common")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.default.description"));
            this.putPresets(this.defaultPreset);
            builder.pop();
        }
    }

    public static class ServerConfig
    extends AbstractConfig {
        private static final String EVOLUTION_MODIFIER_UUID = "A95E1FBA-3DC1-40B0-A8E3-01C81B540444";
        private static final String TARGET_STATIONARY_FLYING_MODIFIER_UUID = "FB8F759A-7025-4684-AF6B-4B67A7E1422A";
        private static final String SLOW_FLYING_MODIFIER_UUID = "0d94f8c8-355c-44db-b75a-9823e5516ce5";
        public final ConfigValue<Boolean> shouldChunkLoadWhenNoPlayers;
        public final ConfigValue<Boolean> shouldAccelerateWhenTargetStopped;
        public final ConfigValue<Integer> targetStationaryChunkRadius;
        public final ConfigValue<Integer> playerPickupChance;
        public final ConfigValue<Double> evolutionAttributeModifier;
        public final ConfigValue<Integer> targetStationaryMinutes;
        public final ConfigValue<Integer> targetRunawayMinutes;
        public final ConfigValue<Integer> invulnerabilityTime;
        public final ConfigValue<Double> targetStationaryFlyingSpeed;
        public final ConfigValue<Double> slowFlyingSpeed;
        public final ConfigValue<Boolean> usePhaseAsDistanceMultiplier;
        public final ConfigValue<Double> distanceMultiplier;
        public final ConfigValue<Boolean> accelerateOnPhaseChange;
        public final ConfigValue<Boolean> targetRunawayAttempts;
        public final ConfigValue<Integer> targetRunawayAttemptMinutes;
        public final ConfigValue<Integer> targetRunawayAttemptsRequired;
        public final ConfigValue<Integer> minutesTillRunawayAttemptDiminish;
        public final ConfigValue<Boolean> targettingDistractionsEnabled;
        public final ConfigValue<Integer> distractionTimeMinutes;
        public final ConfigValue<Integer> maximumDistractionDistance;
        public final ConfigValue<Integer> minimumDistractionDistance;
        public final ConfigValue<Boolean> randomDistractionChances;
        public final ConfigValue<Integer> searchRangeMultiplier;
        public final ConfigValue<Integer> distractionWaitTime;
        public final ConfigValue<Boolean> clustersRemoveItems;
        public final ConfigValue<Boolean> squashHitbox;
        public final ConfigValue<Integer> hunchbackClusterPickupInterval;
        public final ConfigValue<Integer> clusterPickupInterval;
        public final ConfigValue<Integer> devourerClusterPickupInterval;
        public final ConfigValue<Integer> flyingHeight;
        public final ConfigValue<Integer> tillShouldShowHole;
        public final ConfigValue<Double> rotationSpeed;
        public final ConfigValue<Boolean> canPickupMobClusters;
        public final ConfigValue<Boolean> witherStormInvulnerability;
        public final ConfigValue<UltimateTargetManager.TargetingType> ultimateTargetingType;
        public final ConfigValue<Boolean> witherSicknessEnabled;
        public final ConfigValue<Boolean> sickenedMobConversions;
        public final ConfigValue<Boolean> increaseAmplifier;
        public final ConfigValue<Integer> requiredContacts;
        public final ConfigValue<Integer> requiredProximitySeconds;
        public final ConfigValue<Integer> applicationDelay;
        public final ConfigValue<Integer> cureDelay;
        public final ConfigValue<Integer> lowImmuneRequiredProximitySeconds;
        public final ConfigValue<Integer> lowImmuneApplicationDelay;
        public final ConfigValue<Integer> lowImmuneCureDelay;
        public final ConfigValue<Integer> proximitySecondsModifierMax;
        public final ConfigValue<Integer> applicationDelayModifierMax;
        public final ConfigValue<Integer> cureDelayModifierMax;
        public final ConfigValue<Integer> lowImmuneProximityModifierMax;
        public final ConfigValue<Integer> lowImmuneApplicationModifierMax;
        public final ConfigValue<Integer> lowImmuneCureDelayModifierMax;
        public final ConfigValue<Boolean> keepSicknessAfterRespawn;
        public final ConfigValue<Integer> craftFuseTicks;
        public final ConfigValue<Integer> catchFireFuseTicks;
        public final ConfigValue<Integer> dropInterval;
        public final ConfigValue<Boolean> shouldDropFromInventory;
        public final ConfigValue<Boolean> lowerBlockResistance;
        public final ConfigValue<Boolean> revivalTimer;
        public final ConfigValue<Integer> revivalTimeMinutes;
        public final ConfigValue<Integer> revivalPlayerProtection;
        public final ConfigValue<Boolean> canSummonSymbiont;
        public final ConfigValue<Integer> minimumSpawnCheckInterval;
        public final ConfigValue<Integer> witherStormSummoningDelay;
        public final ConfigValue<Integer> playerInvulnerableTime;
        public final ConfigValue<Integer> playerSummoningDelay;
        public final ConfigValue<Integer> playerSummoningDelayOnKill;
        public final ConfigPreset defaultPreset;

        protected ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Server options").push("server");
            this.shouldChunkLoadWhenNoPlayers = this.createValue(builder, false, "shouldChunkLoadWhenNoPlayers", ConfigValue.ReloadType.NONE, "Toggle to enable/disable Wither Storm chunk loading", "when no players are online");
            this.shouldAccelerateWhenTargetStopped = this.createValue(builder, true, "shouldAccelerateWhenTargetStopped", ConfigValue.ReloadType.NONE, "If the target is stationary for a specific amount of time,", "the Wither Storm will begin to move towards it", "at a faster rate.", "Toggle to enable/disable this feature");
            this.targetStationaryChunkRadius = this.createRangedIntValue(builder, 8, 0, 16, "targetStationaryChunkRadius", ConfigValue.ReloadType.WORLD, "If the player remains in a radius of chunks specified by", "this value for a specific amount of time,", "the Wither Storm will begin to move towards the player", "at a faster rate");
            this.playerPickupChance = this.createRangedIntValue(builder, 4, 0, 10, "playerPickupChance", ConfigValue.ReloadType.NONE, "The chance for the Wither Storm to choose a player", "instead of another entity, out of 10");
            this.evolutionAttributeModifier = this.createRangedDoubleValue(builder, 1.0, 0.01, 32.0, "evolutionAttributeModifier", ConfigValue.ReloadType.NONE, "Specifies a modifier value of the evolution rate attribute.", "The higher the value, the longer it takes for", "the Wither Storm to make a complete evolution", "(from phases 0 to 7), and vice versa.", "Cannot be lower than 0");
            this.addAttributeConfigValue((Supplier<Attribute>)WitherStormModAttributes.EVOLUTION_SPEED, EVOLUTION_MODIFIER_UUID, "Config defined evolution modifier", AttributeModifier.Operation.ADDITION, this.evolutionAttributeModifier);
            this.targetStationaryMinutes = this.createRangedIntValue(builder, 30, 1, 120, "targetStationaryMinutes", ConfigValue.ReloadType.WORLD, "Specifies the amount of time in minutes that", "the Wither Storm's ultimate target must", "be stationary in order for it to accelerate");
            this.targetRunawayMinutes = this.createRangedIntValue(builder, 10, 1, 90, "targetRunawayMinutes", ConfigValue.ReloadType.NONE, "Specifies the amount of time in minutes that", "the Wither Storm's ultimate target has begun", "to run away in order to slow back down again");
            this.invulnerabilityTime = this.createRangedIntValue(builder, 50, 1, 320, "invulnerabilityTime", ConfigValue.ReloadType.NONE, "Specifies the invulnerability time when the Wither Storm", "has been summoned, in seconds. When invulnerable,", "the Wither Storm doesn't move and can't be attacked");
            this.targetStationaryFlyingSpeed = this.createRangedDoubleValue(builder, 0.4, 0.01, 1.0, "targetStationaryFlyingSpeed", ConfigValue.ReloadType.WORLD, "Specifies a modifier value of Target Stationary Flying Speed attribute.", "The higher the value, the faster the Wither Storm will go when", "its ultimate target is stationary");
            this.addAttributeConfigValue((Supplier<Attribute>)WitherStormModAttributes.TARGET_STATIONARY_FLYING_SPEED, TARGET_STATIONARY_FLYING_MODIFIER_UUID, "Config defined stationary flight speed modifier", AttributeModifier.Operation.ADDITION, this.targetStationaryFlyingSpeed);
            this.slowFlyingSpeed = this.createRangedDoubleValue(builder, 0.02, 0.01, 1.0, "slowFlyingSpeed", ConfigValue.ReloadType.WORLD, "Specifies a modifier value of Slow Flying Speed attribute.", "The higher the value, the faster the Wither Storm will go when", "it's ultimate target is not stationary");
            this.addAttributeConfigValue((Supplier<Attribute>)WitherStormModAttributes.SLOW_FLYING_SPEED, SLOW_FLYING_MODIFIER_UUID, "Config defined slow flight speed modifier", AttributeModifier.Operation.ADDITION, this.slowFlyingSpeed);
            this.usePhaseAsDistanceMultiplier = this.createValue(builder, true, "usePhaseAsDistanceMultiplier", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm should use the phase as a", "multiplier when calculating the time in ticks it takes for it", "to start accelerating, when its ultimate target is stationary");
            this.distanceMultiplier = this.createRangedDoubleValue(builder, 1.0, 0.1, 24.0, "distanceMultiplier", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm should use this value as a", "multiplier when calculating the time in ticks it takes for it", "to start accelerating, when its ultimate target is stationary");
            this.accelerateOnPhaseChange = this.createValue(builder, true, "accelerateOnPhaseChange", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm should accelerate when it", "evolves into the next phase.");
            this.targetRunawayAttempts = this.createValue(builder, true, "targetRunawayAttempts", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm should count the times", "its ultimate target leaves the stationary chunk radius.", "After a specified amount of attempts has been reached,", "the Wither Storm will accelerate to its Target Stationary Speed");
            this.targetRunawayAttemptMinutes = this.createRangedIntValue(builder, 2, 1, 20, "targetRunawayAttemptMinutes", ConfigValue.ReloadType.NONE, "Specifies the required time, in minutes, the Wither Storms ultimate", "target must be stationary in order to be able to count", "a runaway attempt when it tries to leave the stationary", "chunk radius");
            this.targetRunawayAttemptsRequired = this.createRangedIntValue(builder, 5, 1, 32, "targetRunawayAttemptsRequired", ConfigValue.ReloadType.NONE, "Specifies the amount of runaway attempts made", "by the Wither Storms ultimate target that must be", "met for it to accelerate to its Target Stationary Speed");
            this.minutesTillRunawayAttemptDiminish = this.createRangedIntValue(builder, 16, 1, 48, "minutesTillRunawayAttemptDiminish", ConfigValue.ReloadType.NONE, "Specifies the required time that must pass (in minutes)", "in order to decrease the runaway attempt amount.", "This timer only counts if the Wither Storms ultimate", "target remains in the stationary chunk radius");
            this.targettingDistractionsEnabled = this.createValue(builder, true, "targettingDistractionsEnabled", ConfigValue.ReloadType.NONE, "Specifies when the Wither Storm is done chasing", "its ultimate target if it should become", "'distracted' and go to a random nearby area");
            this.distractionTimeMinutes = this.createRangedIntValue(builder, 25, 1, 25, "distractionTimeMinutes", ConfigValue.ReloadType.NONE, "Specifies the time in minutes that", "the Wither Storm should be distracted", "for, plus some random modifying and more");
            this.maximumDistractionDistance = this.createRangedIntValue(builder, 1000, 100, 3000, "maximumDistractionDistance", ConfigValue.ReloadType.NONE, "Distractions will not occur if the Wither Storm's", "ultimate target is outside the radius determined", "by this value + its target range.", "Although, if the ultimate target is inside the radius,", "but then leaves, a distraction can then later occur");
            this.minimumDistractionDistance = this.createRangedIntValue(builder, 50, 10, 500, "minimumDistractionDistance", ConfigValue.ReloadType.NONE, "Distractions will not occur IMMEDIATELY if the", "Wither Storm's ultimate target is INSIDE the", "radius determined by this value + its target range.", "If the target is inside this radius, the", "Wither Storm will wait before becoming distracted,", "to see if the target is outside the radius.", "If not, a distraction will not occur. Set to 0 to disable");
            this.randomDistractionChances = this.createValue(builder, true, "randomDistractionChances", ConfigValue.ReloadType.NONE, "Distractions may or may not occur if the", "conditions are met/unmet based off of a random chance.", "Toggle to enable/disable");
            this.searchRangeMultiplier = this.createRangedIntValue(builder, 1, 1, 8, "searchableRangeMultiplier", ConfigValue.ReloadType.NONE, "Specifies the search radius multiplier", "for when searching for a random location to", "go to");
            this.distractionWaitTime = this.createRangedIntValue(builder, 2, 1, 20, "distractionWaitTime", ConfigValue.ReloadType.NONE, "For when the Wither Storm needs to wait", "to become distracted, this value (in minutes)", "will specifiy the wait time, plus a random", "modifier");
            this.clustersRemoveItems = this.createValue(builder, true, "clustersRemoveItems", ConfigValue.ReloadType.NONE, "Specifies if Block Clusters should remove non-important", "items in its path. NOTE: Disabling can cause major lag");
            this.squashHitbox = this.createValue(builder, false, "squashHitbox", ConfigValue.ReloadType.WORLD, "If true, the hitbox of the Wither Storm", "and Wither Storm Segment's will be shrunk", "vertically to one block. Enable if facing major server lag in", "the bigger Wither Storm phases");
            this.hunchbackClusterPickupInterval = this.createRangedIntValue(builder, 20, 10, 80, "hunchbackClusterPickupInterval", ConfigValue.ReloadType.NONE, "Alters the interval (in ticks) of picking up block clusters", "for the hunchback phases (phase 0 - 3). NOTE: This value", "changes the evolution speed of the Wither Storm significantly");
            this.clusterPickupInterval = this.createRangedIntValue(builder, 40, 10, 80, "clusterPickupInterval", ConfigValue.ReloadType.NONE, "Alters the interval (in ticks) of picking up block clusters", "for the destroyer phases (phase 4 - 5). NOTE: This value", "changes the evolution speed of the Wither Storm significantly");
            this.devourerClusterPickupInterval = this.createRangedIntValue(builder, 40, 10, 80, "devourerClusterPickupInterval", ConfigValue.ReloadType.NONE, "Alters the interval (in ticks) of picking up block clusters", "for the devourer phases (phase 6+). NOTE: This value", "changes the evolution speed of the Wither Storm significantly");
            this.flyingHeight = this.createRangedIntValue(builder, 75, 10, 150, "flyingHeight", ConfigValue.ReloadType.NONE, "Specifies the height the Wither Storm", "will fly at during phase 4 and up");
            this.tillShouldShowHole = this.createRangedIntValue(builder, 6, 1, 30, "tillShouldShowHole", ConfigValue.ReloadType.NONE, "If the Wither Storm's ultimate target has", "a command block tool and the Wither Storm is", "at phase 7, a timer specified by this value (in minutes)", "+ random will countdown until the hole will automatically appear");
            this.ultimateTargetingType = this.createEnumValue(builder, UltimateTargetManager.TargetingType.NEAREST, "ultimateTargetingType", ConfigValue.ReloadType.NONE, "Specifies the targeting type the Wither Storm", "should use to determine it's ultimate target");
            this.rotationSpeed = this.createRangedDoubleValue(builder, 0.1, 0.1, 1.0, "rotationSpeed", ConfigValue.ReloadType.NONE, "Specifies the rotation speed of the Wither Storm");
            this.canPickupMobClusters = this.createValue(builder, true, "canPickupMobClusters", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm's tractor beams", "can pull in multiple mobs at once that interesect", "the beam");
            this.witherStormInvulnerability = this.createValue(builder, true, "witherStormInvulnerability", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm should", "regenerate its health and be melee attackable");
            builder.comment("Wither sickness").push("wither sickness");
            this.witherSicknessEnabled = this.createValue(builder, true, "witherSicknessEnabled", ConfigValue.ReloadType.WORLD, "Specifies if mobs should be able to receive", "wither sickness");
            this.sickenedMobConversions = this.createValue(builder, true, "sickenedMobConversions", ConfigValue.ReloadType.NONE, "Specifies if mobs should convert to sickened mobs", "once they die from wither sickness");
            this.increaseAmplifier = this.createValue(builder, true, "increaseAmplifier", ConfigValue.ReloadType.NONE, "Specifies if entities who are reinfected over a short", "period of time should receive wither sickness with a greater strength");
            this.requiredContacts = this.createRangedIntValue(builder, 6, 1, 40, "requiredContacts", ConfigValue.ReloadType.WORLD, "After a mob has been targetted by the Wither Storm", "a set maximum of times, the mob will become infected");
            this.requiredProximitySeconds = this.createRangedIntValue(builder, 600, 12, 1200, "requiredProximitySeconds", ConfigValue.ReloadType.WORLD, "Specifies the amount of time in seconds high immunity mobs", "(players) must be near the Wither Storm in order to", "to begin infection");
            this.applicationDelay = this.createRangedIntValue(builder, 720, 12, 1200, "applicationDelay", ConfigValue.ReloadType.WORLD, "Specifies the amount of time in seconds high immunity mobs", "(players) must be infected in order to", "be applied the wither sickness effect");
            this.cureDelay = this.createRangedIntValue(builder, 480, 12, 1200, "cureDelay", ConfigValue.ReloadType.WORLD, "Specifies the delay, in seconds, before high immunity mobs", "(players) are cured of wither sickness");
            this.lowImmuneRequiredProximitySeconds = this.createRangedIntValue(builder, 360, 12, 1200, "lowImmuneRequiredProximitySeconds", ConfigValue.ReloadType.WORLD, "Specifies the amount of time in seconds that low immunity mobs", "must be near the Wither Storm in order to begin infection");
            this.lowImmuneApplicationDelay = this.createRangedIntValue(builder, 410, 12, 1200, "lowImmuneApplicationDelay", ConfigValue.ReloadType.WORLD, "Specifies the amount of time in seconds low immunity mobs", "must be infected in order to be applied the", "wither sickness effect");
            this.lowImmuneCureDelay = this.createRangedIntValue(builder, 480, 12, 1200, "lowImmuneCureDelay", ConfigValue.ReloadType.WORLD, "Specifies the delay, in seconds, before low immunity mobs", "are cured of wither sickness");
            this.proximitySecondsModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "proximitySecondsModifierMax", ConfigValue.ReloadType.NONE, "High immunity mobs (players) will be assigned a random proximity", "seconds modifier that will change the proximity seconds time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.applicationDelayModifierMax = this.createRangedIntValue(builder, 300, 12, 1200, "applicationDelayModifierMax", ConfigValue.ReloadType.NONE, "High immunity mobs (players) will be assigned a random application", "delay modifier that will change the application delay.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.cureDelayModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "cureDelayModifierMax", ConfigValue.ReloadType.NONE, "High immunity mobs (players) will be assigned a random cure", "delay modifier that will change the cure delay.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.lowImmuneProximityModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "lowImmuneProximityModifierMax", ConfigValue.ReloadType.NONE, "Low immunity mobs will be assigned a random proximity seconds", "delay modifier that will change the proximity seconds time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.lowImmuneApplicationModifierMax = this.createRangedIntValue(builder, 140, 12, 1200, "lowImmuneApplicationModifierMax", ConfigValue.ReloadType.NONE, "Low immunity mobs will be assigned a random application", "delay modifier that will change the proximity seconds time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.lowImmuneCureDelayModifierMax = this.createRangedIntValue(builder, 180, 12, 1200, "lowImmuneCureDelayModifierMax", ConfigValue.ReloadType.NONE, "Low immunity mobs will be assigned a random cure", "delay modifier that will change the cure delay time.", "This value will set the maximum potential limit for that modifier,", "in seconds");
            this.keepSicknessAfterRespawn = this.createValue(builder, true, "keepSicknessAfterRespawn", ConfigValue.ReloadType.NONE, "Specifies if Wither Sickness should be", "removed after a player respawns");
            builder.pop();
            builder.comment("Formidibomb").push("formidibomb");
            this.craftFuseTicks = this.createRangedIntValue(builder, 12000, 1, 12000, "craftFuseTicks", ConfigValue.ReloadType.NONE, "Specifies the fuse in ticks that count down", "to the formidibomb's explosion.", "The fuse is set when the block is crafted");
            this.catchFireFuseTicks = this.createRangedIntValue(builder, 1200, 1, 12000, "catchFireFuseTicks", ConfigValue.ReloadType.NONE, "If the formidibomb is manually set on fire", "the fuse tick count will be set to this", "value, if the original fuse is greater than", "this value");
            this.shouldDropFromInventory = this.createValue(builder, true, "shouldDropFromInventory", ConfigValue.ReloadType.NONE, "Specifies if after a set amount of time", "the formidibomb item should drop out of", "whatever inventory is holding it", "and should spawn as the entity");
            this.dropInterval = this.createRangedIntValue(builder, 4, 1, 8, "dropInterval", ConfigValue.ReloadType.NONE, "Specifies the interval for when the", "formidibomb will drop out of its inventory", "(if enabled). This value divides the crafted fuse ticks", "to get the interval (e.x. 12000 / 4 = 3000)");
            this.lowerBlockResistance = this.createValue(builder, true, "lowerBlockResistance", ConfigValue.ReloadType.NONE, "Lowers the resistance of blocks in", "the path of the explosion, effectively", "increasing the strength of the explosion", "which allows for obsidian, etc. to be destroyed");
            builder.pop();
            builder.comment("Playing dead").push("playing dead");
            this.revivalTimer = this.createValue(builder, true, "revivalTimer", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm should", "automatically revive if not found", "after a period of time");
            this.revivalTimeMinutes = this.createRangedIntValue(builder, 60, 1, 120, "revivalTimeMinutes", ConfigValue.ReloadType.NONE, "Specifies when (in minutes) the Wither Storm", "will automatically revive when playing dead");
            this.revivalPlayerProtection = this.createRangedIntValue(builder, 3, 1, 40, "revivalPlayerProtection", ConfigValue.ReloadType.NONE, "Specifies the time (in minutes) after being", "revived that the Wither Storm should ignore", "players");
            builder.pop();
            builder.comment("Withered Symbiont").push("withered symbiont");
            this.canSummonSymbiont = this.createValue(builder, true, "canSummonSmybiont", ConfigValue.ReloadType.NONE, "Specifies if the Wither Storm can summon", "the Withered Symbiont");
            this.minimumSpawnCheckInterval = this.createRangedIntValue(builder, 60, 1, 240, "minimumSpawnCheckInterval", ConfigValue.ReloadType.NONE, "Specifies the minimum interval (+random) in seconds", "that the Wither Storm should check for", "Withered Symbiont spawn conditions");
            this.witherStormSummoningDelay = this.createRangedIntValue(builder, 10, 1, 20, "witherStormSummingDelay", ConfigValue.ReloadType.NONE, "Specifies the delay in minutes (+random) that the", "Wither Storm will be able to summon a", "Withered Symbiont");
            this.playerInvulnerableTime = this.createRangedIntValue(builder, 5, 1, 10, "playerInvulnerableTime", ConfigValue.ReloadType.NONE, "Specifies the time in minutes (+random) that the", "players who killed a Withered Symbiont", "should be ignored by the Wither Storm for");
            this.playerSummoningDelay = this.createRangedIntValue(builder, 10, 1, 60, "playerSummoningDelay", ConfigValue.ReloadType.NONE, "Specifies the delay in minutes (+random) that the", "Wither Storm should be able summon a", "Withered Symbiont for the player it summoned one for");
            this.playerSummoningDelayOnKill = this.createRangedIntValue(builder, 40, 1, 60, "playerSummoningDelayOnKill", ConfigValue.ReloadType.NONE, "If a player kills a Withered Symbiont, their", "sumoning delay will be increased to this value", "in minutes (+random)");
            builder.pop();
            this.defaultPreset = ConfigPreset.Builder.of(this).build(Component.m_237115_((String)"config.witherstormmod.preset.default.title"), new ResourceLocation("witherstormmod", "default_common")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.default.description"));
            this.putPresets(this.defaultPreset);
            builder.pop();
        }
    }
}

