/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.StringUtils;

public class ConfigValue<T> {
    private final ForgeConfigSpec.ConfigValue<T> value;
    private T nonDirtyValue;
    private final T defaultValue;
    private final List<MutableComponent> comment;
    private final String definition;
    private final ReloadType type;

    public ConfigValue(ForgeConfigSpec.Builder builder, List<MutableComponent> comment, String definition, T value, ReloadType reloadType) {
        this(builder, commented -> commented.define(definition, value), comment, definition, value, reloadType);
    }

    public ConfigValue(ForgeConfigSpec.Builder builder, Function<ForgeConfigSpec.Builder, ForgeConfigSpec.ConfigValue<T>> definitionFunc, List<MutableComponent> comment, String definition, T value, ReloadType reloadType) {
        this.comment = comment;
        this.type = reloadType;
        this.defaultValue = value;
        this.value = definitionFunc.apply(builder.comment(this.join(this.comment)));
        this.definition = definition;
    }

    public String join(List<MutableComponent> comment) {
        ArrayList<String> strings = new ArrayList<String>();
        for (MutableComponent component : comment) {
            strings.add(component.getString());
        }
        return "DEFAULT=" + this.defaultValue + ". " + StringUtils.join(strings, (String)" ") + ". Reload Type: " + this.type.toString();
    }

    public static List<MutableComponent> createComment(String ... components) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        for (int i = 0; i < components.length; ++i) {
            MutableComponent component = Component.m_237113_((String)components[i]);
            list.add(component);
        }
        return list;
    }

    public ForgeConfigSpec.ConfigValue<T> getValue() {
        return this.value;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T get() {
        return (T)this.value.get();
    }

    public boolean isDefault() {
        return this.get().equals(this.getDefault());
    }

    public T getNonDirtyOrDirty() {
        if (this.nonDirtyValue != null) {
            return this.nonDirtyValue;
        }
        return this.get();
    }

    public void set(T t) {
        this.nonDirtyValue = t;
    }

    public void setDirty(T t) {
        this.value.set(t);
    }

    public void markNonDirty() {
        if (this.nonDirtyValue != null) {
            this.setDirty(this.nonDirtyValue);
        }
        this.nonDirtyValue = this.value.get();
    }

    public void resetToDefault() {
        this.nonDirtyValue = this.defaultValue;
    }

    public void reset() {
        this.nonDirtyValue = this.value.get();
    }

    public List<MutableComponent> getComment() {
        return this.comment;
    }

    public String getDefinition() {
        return this.definition;
    }

    public ReloadType getReloadType() {
        return this.type;
    }

    public static enum ReloadType {
        NONE,
        WORLD,
        GAME;

    }
}

