/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.config;

import com.electronwill.nightconfig.core.io.WritingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import nonamecrackers2.witherstormmod.common.config.ConfigValue;
import nonamecrackers2.witherstormmod.common.config.SyncableConfigValue;
import nonamecrackers2.witherstormmod.common.config.preset.ConfigPreset;
import nonamecrackers2.witherstormmod.common.util.AttributeModifierSnapshot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final List<ConfigValue<Object>> values = new ArrayList<ConfigValue<Object>>();
    protected final List<AttributeModifierSnapshot> attributeModifiers = new ArrayList<AttributeModifierSnapshot>();
    protected final List<ConfigPreset> presets = new ArrayList<ConfigPreset>();
    protected final List<ConfigValue<Object>> presetExcluded = new ArrayList<ConfigValue<Object>>();
    protected ConfigPreset currentPreset;
    public final ConfigPreset custom = ConfigPreset.Builder.empty().build(Component.m_237115_((String)"config.witherstormmod.preset.custom.title"), new ResourceLocation("witherstormmod", "custom")).withDescription(Component.m_237115_((String)"config.witherstormmod.preset.custom.description"));

    protected AbstractConfig() {
        this.putPresets(this.custom);
    }

    public void saveAllValues() {
        try {
            for (ConfigValue<Object> value : this.values) {
                value.markNonDirty();
            }
        }
        catch (WritingException e) {
            LOGGER.error("An exception occured whilst saving config values: " + e);
        }
    }

    public void resetAllValuesToDefault() {
        for (ConfigValue<Object> value : this.values) {
            value.resetToDefault();
        }
    }

    public void resetAllValues() {
        for (ConfigValue<Object> value : this.values) {
            value.reset();
        }
    }

    public boolean areValuesReset() {
        ConfigValue<Object> value;
        boolean flag = true;
        Iterator<ConfigValue<Object>> iterator = this.values.iterator();
        while (iterator.hasNext() && (flag = (value = iterator.next()).get().equals(value.getNonDirtyOrDirty()))) {
        }
        return flag;
    }

    public Iterable<ConfigValue<Object>> getValues() {
        return Iterables.unmodifiableIterable(this.values);
    }

    protected <T> void addConfigValue(ConfigValue<T> value) {
        if (!this.values.contains(value)) {
            this.values.add(value);
        }
    }

    protected void putPresets(ConfigPreset ... presets) {
        for (int i = 0; i < presets.length; ++i) {
            this.presets.add(presets[i]);
        }
    }

    public List<ConfigPreset> getPresets() {
        return this.presets;
    }

    public ConfigPreset findCurrentPreset() {
        for (int i = 1; i < this.getPresets().size(); ++i) {
            ConfigPreset preset = this.getPresets().get(i);
            if (!preset.doesValuesMatch(this.values)) continue;
            this.currentPreset = preset;
            return this.currentPreset;
        }
        ConfigPreset preset = this.getPresets().get(0);
        if (preset.doesValuesMatch(this.values)) {
            this.currentPreset = preset;
        }
        return this.currentPreset;
    }

    public ConfigPreset getCurrentPreset() {
        return this.currentPreset;
    }

    public void setCurrentPreset(ConfigPreset preset) {
        this.currentPreset = preset;
    }

    public void setValuesBasedOnPreset() {
        for (ConfigValue<Object> config : this.values) {
            config.set(this.currentPreset.getPresetValue(config));
        }
    }

    protected void addAttributeConfigValue(Supplier<Attribute> attribute, String id, String description, AttributeModifier.Operation operation, ConfigValue<Double> value) {
        AttributeModifierSnapshot snapshot = new AttributeModifierSnapshot(attribute, UUID.fromString(id), description, value, operation);
        this.attributeModifiers.add(snapshot);
    }

    public ImmutableList<AttributeModifierSnapshot> getAttributeConfigs() {
        return ImmutableList.copyOf(this.attributeModifiers);
    }

    protected <T> ConfigValue<T> createValue(ForgeConfigSpec.Builder builder, T value, String name, ConfigValue.ReloadType type, String ... description) {
        ConfigValue<T> configValue = new ConfigValue<T>(builder, ConfigValue.createComment(description), name, value, type);
        this.addConfigValue(configValue);
        return configValue;
    }

    protected ConfigValue<Double> createRangedDoubleValue(ForgeConfigSpec.Builder builder, double value, double min, double max, String name, ConfigValue.ReloadType type, String ... description) {
        ConfigValue<Double> configValue = new ConfigValue<Double>(builder, commented -> commented.defineInRange(name, value, min, max), ConfigValue.createComment(description), name, value, type);
        this.addConfigValue(configValue);
        return configValue;
    }

    protected ConfigValue<Integer> createRangedIntValue(ForgeConfigSpec.Builder builder, int value, int min, int max, String name, ConfigValue.ReloadType type, String ... description) {
        ConfigValue<Integer> configValue = new ConfigValue<Integer>(builder, commented -> commented.defineInRange(name, value, min, max), ConfigValue.createComment(description), name, value, type);
        this.addConfigValue(configValue);
        return configValue;
    }

    protected <T extends Enum<T>> ConfigValue<T> createEnumValue(ForgeConfigSpec.Builder builder, T value, String name, ConfigValue.ReloadType type, String ... description) {
        ConfigValue configValue = new ConfigValue(builder, commented -> commented.defineEnum(name, value), ConfigValue.createComment(description), name, value, type);
        this.addConfigValue(configValue);
        return configValue;
    }

    protected <T> SyncableConfigValue<T> createSyncValue(ForgeConfigSpec.Builder builder, T value, String name, ConfigValue.ReloadType type, ResourceLocation id, BiConsumer<FriendlyByteBuf, T> write, Function<FriendlyByteBuf, T> read, String ... description) {
        SyncableConfigValue<T> configValue = new SyncableConfigValue<T>(builder, ConfigValue.createComment(description), name, value, type, id, write, read);
        this.addConfigValue(configValue);
        return configValue;
    }

    protected ConfigValue<Double> createAttributeValue(ForgeConfigSpec.Builder builder, Supplier<Attribute> attribute, String id, String modifierDesc, AttributeModifier.Operation operation, double value, String name, ConfigValue.ReloadType type, String ... description) {
        ConfigValue<Double> configValue = this.createValue(builder, value, name, type, description);
        AttributeModifierSnapshot snapshot = new AttributeModifierSnapshot(attribute, UUID.fromString(id), modifierDesc, configValue, operation);
        this.attributeModifiers.add(snapshot);
        return configValue;
    }

    protected <T> void excludeFromPresets(ConfigValue<T> value) {
        if (!this.presetExcluded.contains(value)) {
            this.presetExcluded.add(value);
        }
    }

    public boolean shouldExclude(ConfigValue<Object> value) {
        return this.presetExcluded.contains(value);
    }
}

