/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.util.UltimateTargetManager;

public class UltimateTargetCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder setPhaseCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"witherstormmod").requires(commandSource -> commandSource.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ultimateTarget").then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"storm", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(UltimateTargetCommands::setPlayer))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(UltimateTargetCommands::setPos))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"storm", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82127_((String)"player").executes(UltimateTargetCommands::clearPlayer))).then(Commands.m_82127_((String)"pos").executes(UltimateTargetCommands::clearPos)))));
        dispatcher.register(setPhaseCommand);
    }

    private static int setPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        Entity entity = EntityArgument.m_91452_(context, (String)"storm");
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            UltimateTargetManager manager = storm.getUltimateTargetManager();
            if (player.m_20148_().equals(manager.getTargetOverride())) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.ultimateTarget.set.duplicate"));
            } else {
                manager.setTargetOverride(player.m_20148_());
                source.m_81354_((Component)Component.m_237110_((String)"commands.witherstormmod.ultimateTarget.set.success", (Object[])new Object[]{player.m_5446_()}), true);
            }
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
        }
        return player.m_19879_();
    }

    private static int setPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        Entity entity = EntityArgument.m_91452_(context, (String)"storm");
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            UltimateTargetManager manager = storm.getUltimateTargetManager();
            if (pos.equals((Object)manager.getBlockTargetOverride())) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.ultimateTarget.set.duplicate"));
            } else {
                manager.setBlockTargetOverride(pos);
                source.m_81354_((Component)Component.m_237110_((String)"commands.witherstormmod.ultimateTarget.set.success", (Object[])new Object[]{pos}), true);
            }
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
        }
        return 0;
    }

    private static int clearPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"storm");
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            storm.getUltimateTargetManager().setTargetOverride(null);
            source.m_81354_((Component)Component.m_237115_((String)"commands.witherstormmod.ultimateTarget.clear.success"), true);
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
        }
        return 0;
    }

    private static int clearPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"storm");
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            storm.getUltimateTargetManager().setBlockTargetOverride(null);
            source.m_81354_((Component)Component.m_237115_((String)"commands.witherstormmod.ultimateTarget.clear.success"), true);
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
        }
        return 0;
    }
}

