/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import nonamecrackers2.witherstormmod.common.capability.WitherSicknessTracker;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;
import nonamecrackers2.witherstormmod.common.tags.WitherStormModEntityTags;

public class StartCureCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder setPhaseCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"witherstormmod").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"sickness").then(Commands.m_82127_((String)"cure").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(StartCureCommand::startCure))));
        dispatcher.register(setPhaseCommand);
    }

    private static int startCure(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = EntityArgument.m_91452_(context, (String)"entity");
        int timeTillCured = 0;
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!living.m_6095_().m_204039_(WitherStormModEntityTags.WITHER_SICKNESS_IMMUNE)) {
                    Optional optional = living.getCapability(WitherStormModCapabilities.WITHER_SICKNESS_TRACKER).resolve();
                    if (optional.isPresent()) {
                        WitherSicknessTracker tracker = (WitherSicknessTracker)optional.get();
                        timeTillCured = tracker.getCureDelay();
                        if (!tracker.isBeingCured()) {
                            if (tracker.isInfected()) {
                                MutableComponent component = Component.m_237110_((String)"commands.witherstormmod.sickness.startCure", (Object[])new Object[]{living.m_5446_()});
                                source.m_81354_((Component)component, true);
                                tracker.beginCure();
                            } else {
                                MutableComponent component = Component.m_237115_((String)"commands.witherstormmod.sickness.cureNotInfected");
                                source.m_81352_((Component)component);
                            }
                        } else {
                            MutableComponent component = Component.m_237110_((String)"commands.witherstormmod.sickness.alreadyBeingCured", (Object[])new Object[]{living.m_5446_()});
                            source.m_81352_((Component)component);
                        }
                    }
                } else {
                    MutableComponent component = Component.m_237110_((String)"commands.witherstormmod.sickness.immune", (Object[])new Object[]{entity.m_5446_()});
                    source.m_81352_((Component)component);
                }
            } else {
                MutableComponent component = Component.m_237115_((String)"commands.witherstormmod.entity.arg.notLiving");
                source.m_81352_((Component)component);
            }
        }
        return timeTillCured;
    }
}

