/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import nonamecrackers2.witherstormmod.common.capability.WitherStormChunkHolder;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.init.WitherStormModCapabilities;

public class LoadedChunksCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder checkLoadedChunks = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"witherstormmod").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"chunks").then(Commands.m_82127_((String)"get").executes(LoadedChunksCommands::checkChunks)));
        dispatcher.register(checkLoadedChunks);
        LiteralArgumentBuilder refreshLoadedChunks = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"witherstormmod").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"chunks").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refresh").then(Commands.m_82129_((String)"witherstorm", (ArgumentType)EntityArgument.m_91449_()).executes(LoadedChunksCommands::refreshChunksSpecified))).executes(LoadedChunksCommands::refreshChunks)));
        dispatcher.register(refreshLoadedChunks);
    }

    private static int checkChunks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.m_81372_();
        int loadedChunks = 0;
        Optional optional = world.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).resolve();
        if (optional.isPresent()) {
            WitherStormChunkHolder stormChunks = (WitherStormChunkHolder)optional.get();
            for (Map.Entry<UUID, List<ChunkPos>> entry : stormChunks.getLoadedChunks().entrySet()) {
                UUID uuid = entry.getKey();
                List<ChunkPos> loaded = entry.getValue();
                BlockPos pos = stormChunks.getStormPositions().get(uuid);
                Queue<ChunkPos> toLoad = stormChunks.getChunksToLoad().get(uuid);
                loadedChunks = loaded.size();
                source.m_81354_((Component)Component.m_237110_((String)"commands.witherstormmod.chunks.get", (Object[])new Object[]{uuid, loaded.size(), pos, toLoad.size()}).m_130940_(ChatFormatting.GRAY), false);
            }
            source.m_81354_((Component)Component.m_237110_((String)"commands.witherstormmod.chunks.get.summary", (Object[])new Object[]{stormChunks.getAllLoadedChunks().size(), world.m_8902_().size()}).m_130940_(ChatFormatting.GOLD), false);
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.chunks.error"));
        }
        return loadedChunks;
    }

    private static int refreshChunks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.m_81372_();
        int toRefresh = 0;
        Optional optional = world.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).resolve();
        if (optional.isPresent()) {
            WitherStormChunkHolder stormChunks = (WitherStormChunkHolder)optional.get();
            toRefresh = stormChunks.getAllLoadedChunks().size();
            source.m_81354_((Component)Component.m_237110_((String)"commands.witherstormmod.chunks.refresh", (Object[])new Object[]{toRefresh}), false);
            stormChunks.refresh();
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.chunks.error"));
        }
        return toRefresh;
    }

    private static int refreshChunksSpecified(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel world = source.m_81372_();
        Entity entity = EntityArgument.m_91452_(context, (String)"witherstorm");
        int toRefresh = 0;
        if (entity instanceof WitherStormEntity) {
            WitherStormEntity storm = (WitherStormEntity)entity;
            Optional optional = world.getCapability(WitherStormModCapabilities.WITHER_STORM_CHUNKS_CAPABILITY).resolve();
            if (optional.isPresent()) {
                WitherStormChunkHolder stormChunks = (WitherStormChunkHolder)optional.get();
                toRefresh = stormChunks.getLoadedChunks().get(storm.m_20148_()).size();
                stormChunks.refresh(storm);
                source.m_81354_((Component)Component.m_237110_((String)"commands.witherstormmod.chunks.refresh.specified", (Object[])new Object[]{toRefresh, storm.m_20148_()}), false);
            } else {
                source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.chunks.error"));
            }
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"commands.witherstormmod.entity.arg.invalid"));
        }
        return toRefresh;
    }
}

